/*
 * Decompiled with CFR 0.152.
 */
package lmt;

import java.sql.SQLException;
import java.util.Vector;
import lmt.Comment;
import lmt.Debug;
import lmt.Definition;
import lmt.Morphology;
import lmt.NCRI;
import lmt.SQLConnection;
import lmt.SemanticVerb;
import lmt.Syntax;
import lmt.Term;
import lmt.Util;

public class Concept {
    String concept_id;
    String term_id;
    String concept_symbol;
    String cte_entry;
    String capitalization;
    String irr_capitalization;
    String ambiguity;
    String date_created;
    String author_creating;
    String date_updated;
    String author_updating;
    String source;
    String active;
    String pos;
    Vector comment;
    Vector definition;
    Vector ncri;
    Morphology morph;
    Syntax syntax;
    SemanticVerb semanticVerb;
    SQLConnection con;

    public Concept(SQLConnection sQLConnection) {
        this.con = sQLConnection;
        this.term_id = "";
        this.concept_id = "";
        this.concept_symbol = "";
        this.cte_entry = "";
        this.ambiguity = "";
        this.capitalization = "";
        this.irr_capitalization = "";
        this.date_created = "";
        this.author_creating = "";
        this.date_updated = "";
        this.author_updating = "";
        this.source = "";
        this.active = "T";
        this.pos = "";
        this.comment = null;
        this.definition = null;
        this.ncri = null;
        this.semanticVerb = null;
        this.morph = null;
        this.syntax = null;
    }

    public Concept(SQLConnection sQLConnection, String string) {
        this(sQLConnection);
        this.pos = string;
    }

    public String getTermID() {
        return this.term_id;
    }

    public void setTermID(String string) {
        if (string == null) {
            string = "";
        }
        this.term_id = string;
    }

    public String getConceptID() {
        return this.concept_id;
    }

    public void setConceptID(String string) {
        if (string == null) {
            string = "";
        }
        this.concept_id = string;
    }

    public String getConceptSymbol() {
        return this.concept_symbol;
    }

    public void setConceptSymbol(String string) {
        if (string == null) {
            string = "";
        }
        this.concept_symbol = string;
    }

    public void setCteEntry(String string) {
        if (string == null) {
            string = "";
        }
        this.cte_entry = string;
    }

    public String getCteEntry() {
        return this.cte_entry;
    }

    public void setAmbiguity(String string) {
        if (string == null) {
            string = "";
        }
        this.ambiguity = string;
    }

    public String getAmbiguity() {
        return this.ambiguity;
    }

    public void setCapitalization(String string) {
        if (string == null) {
            string = "";
        }
        this.capitalization = string;
    }

    public String getCapitalization() {
        return this.capitalization;
    }

    public void setIrrCapitalization(String string) {
        if (string == null) {
            string = "";
        }
        this.irr_capitalization = string;
    }

    public String getIrrCapitalization() {
        return this.irr_capitalization;
    }

    public void setDateCreated(String string) {
        if (this.date_created == null) {
            this.date_created = "";
        }
        this.date_created = string;
    }

    public String getDateCreated() {
        return this.date_created;
    }

    public void setAuthorCreating(String string) {
        if (this.author_creating == null) {
            this.author_creating = "";
        }
        this.author_creating = string;
    }

    public String getAuthorCreating() {
        return this.author_creating;
    }

    public void setDateUpdated(String string) {
        if (this.date_updated == null) {
            this.date_updated = "";
        }
        this.date_updated = string;
    }

    public String getDateUpdated() {
        return this.date_updated;
    }

    public void setAuthorUpdating(String string) {
        if (this.author_updating == null) {
            this.author_updating = "";
        }
        this.author_updating = string;
    }

    public String getAuthorUpdating() {
        return this.author_updating;
    }

    public void setSource(String string) {
        if (string == null) {
            string = "";
        }
        this.source = string;
    }

    public String getSource() {
        return this.source;
    }

    public void setActive(String string) {
        if (string == null) {
            string = "";
        }
        this.active = string;
    }

    public void setPos(String string) {
        this.pos = string;
    }

    public String getPos() {
        return this.pos;
    }

    public Vector getComments() {
        if (this.comment == null) {
            this.comment = Comment.fetchComments(this.con, this.concept_id);
        }
        return this.comment;
    }

    public Vector getNCRI() {
        if (this.ncri == null) {
            this.ncri = NCRI.fetchNCRI(this.con, this.concept_id);
        }
        return this.ncri;
    }

    public Vector getDefinitions() {
        if (this.definition == null) {
            this.definition = Definition.fetchDefinitions(this.con, this.concept_id);
        }
        return this.definition;
    }

    public Definition getDefinition(int n) {
        if (n >= 0 && n < this.definition.size()) {
            return (Definition)this.definition.elementAt(n);
        }
        return null;
    }

    public SemanticVerb getSemanticVerb() {
        if (this.semanticVerb == null) {
            this.semanticVerb = SemanticVerb.fetchSemanticVerb(this.con, this.concept_id);
        }
        return this.semanticVerb;
    }

    public Morphology getMorphology() {
        if (this.morph == null) {
            this.morph = Morphology.fetchMorph(this.con, this.pos, this.concept_id);
        }
        return this.morph;
    }

    public Syntax getSyntax() {
        if (this.syntax == null) {
            this.syntax = Syntax.fetchSyntax(this.con, this.pos, this.concept_id);
        }
        return this.syntax;
    }

    public void changePos(String string) {
        this.pos = string;
        this.morph = null;
        this.syntax = null;
        this.syntax = null;
    }

    public static Vector fetchConcepts(Term term) {
        Vector<Concept> vector = new Vector<Concept>();
        String string = "SELECT * FROM LMT_CONCEPTS WHERE ";
        string = string + " TERM_ID = '" + term.getTermID() + "'";
        string = string + " ORDER BY CONCEPT_ID";
        Debug.debug("-- fetchconcept: " + string);
        SQLConnection sQLConnection = term.getConn();
        try {
            SQLConnection.Result result = sQLConnection.query(string);
            while (result != null && result.hasData()) {
                Concept concept = new Concept(sQLConnection, term.getPos());
                concept.setConceptID(result.rs.getString(1));
                concept.setTermID(result.rs.getString(2));
                concept.setConceptSymbol(result.rs.getString(3));
                concept.setCteEntry(result.rs.getString(4));
                concept.setCapitalization(Concept.changeCapForUI(result.rs.getString(5)));
                concept.setIrrCapitalization(result.rs.getString(6));
                concept.setAmbiguity(result.rs.getString(7));
                concept.setDateCreated(result.rs.getString(8));
                concept.setAuthorCreating(result.rs.getString(9));
                concept.setDateUpdated(result.rs.getString(10));
                concept.setAuthorUpdating(result.rs.getString(11));
                concept.setSource(result.rs.getString(12));
                concept.setActive(result.rs.getString(13));
                concept.getComments();
                concept.getDefinitions();
                concept.getSyntax();
                concept.getMorphology();
                concept.getNCRI();
                concept.getSemanticVerb();
                vector.addElement(concept);
            }
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException sQLException) {
            Debug.debug("SQLException: " + sQLException.getMessage());
        }
        return vector;
    }

    public static Vector fetchConcepts(SQLConnection sQLConnection, String string) {
        Vector vector = new Vector();
        String string2 = "SELECT CONCEPT_SYMBOL, TERM_STRING, POS, LMT_TERMS.TERM_ID";
        string2 = string2 + " FROM LMT_CONCEPTS, LMT_TERMS";
        string2 = string2 + " WHERE LMT_CONCEPTS.TERM_ID = LMT_TERMS.TERM_ID AND ";
        string2 = (string = Util.replaceSingleQuote(string)).indexOf("%%") >= 0 ? string2 + " CONCEPT_SYMBOL LIKE '%\\%%' escape '\\'" : (string.indexOf("%") >= 0 || string.indexOf("_") >= 0 ? string2 + " CONCEPT_SYMBOL LIKE '" + string + "'" : string2 + " CONCEPT_SYMBOL = '" + string + "'");
        string2 = string2 + " ORDER BY CONCEPT_SYMBOL";
        Debug.debug("-- fetchconcept: " + string2);
        try {
            SQLConnection.Result result = sQLConnection.query(string2);
            while (result != null && result.hasData()) {
                Vector<String> vector2 = new Vector<String>();
                vector2.addElement(result.rs.getString(1));
                vector2.addElement(result.rs.getString(2));
                vector2.addElement(Term.changePosForUI(result.rs.getString(3)));
                vector2.addElement(result.rs.getString(4));
                vector.addElement(vector2);
            }
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException sQLException) {
            Debug.debug("SQLException: " + sQLException.getMessage());
        }
        return vector;
    }

    public static String changeCapForDB(String string) {
        String string2 = "";
        if (string != null) {
            if (string.equals("All")) {
                string2 = "A";
            } else if (string.equals("Each")) {
                string2 = "E";
            } else if (string.equals("First")) {
                string2 = "F";
            } else if (string.equals("Any")) {
                string2 = "N";
            } else if (string.equals("Irr")) {
                string2 = "I";
            }
        }
        return string2;
    }

    public static String changeCapForUI(String string) {
        String string2 = "";
        if (string != null) {
            if (string.equals("A")) {
                string2 = "All";
            } else if (string.equals("E")) {
                string2 = "Each";
            } else if (string.equals("F")) {
                string2 = "First";
            } else if (string.equals("N")) {
                string2 = "Any";
            } else if (string.equals("I")) {
                string2 = "Irr";
            }
        }
        return string2;
    }

    public int insert() {
        if (this.isDuplicate()) {
            return 3;
        }
        this.concept_id = this.con.getNewID("CONCEPT_ID");
        String string = this.makeInsertQuery();
        Debug.debug("-- Concept inserted : " + string);
        return this.con.insert(string);
    }

    public int delete() {
        boolean bl = this.con.callProcedure("DeleteConcept", this.concept_id);
        Debug.debug("-- delete concept result: " + bl);
        if (bl) {
            return 1;
        }
        return 2;
    }

    public static int update(SQLConnection sQLConnection, Vector vector) {
        Vector vector2 = new Vector();
        Concept.makeQuery(vector2, vector);
        return sQLConnection.update(vector2);
    }

    public int update() {
        String string = "";
        string = "UPDATE LMT_CONCEPTS SET";
        string = string + " concept_symbol = '" + Util.replaceSingleQuote(this.getConceptSymbol()) + "',";
        string = string + " cte_entry = '" + this.getCteEntry() + "',";
        string = string + " capitalization = '" + Concept.changeCapForDB(this.getCapitalization()) + "',";
        string = string + " ambiguity = '" + this.getAmbiguity() + "',";
        string = string + " irr_capitalization = '" + Util.replaceSingleQuote(this.getIrrCapitalization()) + "',";
        string = string + " date_updated = '" + this.getDateUpdated() + "',";
        string = string + " author_updating = '" + this.getAuthorUpdating() + "',";
        string = string + " source = '" + Util.replaceSingleQuote(this.getSource()) + "'";
        string = string + " WHERE concept_id = '" + this.getConceptID() + "'";
        return this.con.update(string);
    }

    public boolean isDuplicate() {
        String string = "SELECT * FROM LMT_CONCEPTS WHERE ";
        string = string + " concept_symbol = '" + Util.replaceSingleQuote(this.concept_symbol) + "'";
        string = string + " AND term_id = '" + this.term_id + "'";
        return this.con.isExistent(string);
    }

    public boolean isOneConcept() {
        String string = "SELECT COUNT(*) AS cnt FROM LMT_CONCEPTS WHERE TERM_ID IN ";
        string = string + " (SELECT TERM_ID FROM LMT_CONCEPTS WHERE CONCEPT_ID = '" + this.concept_id + "')";
        Debug.debug("-- isOneConcept : " + string);
        try {
            int n = 0;
            SQLConnection.Result result = this.con.query(string);
            if (result != null && result.hasData()) {
                n = result.rs.getInt("cnt");
            }
            if (result != null) {
                result.close();
            }
            return n == 1;
        }
        catch (SQLException sQLException) {
            Debug.debug("SQLException: " + sQLException.getMessage());
            return false;
        }
    }

    public boolean isExistent() {
        String string = "SELECT * FROM LMT_CONCEPTS WHERE ";
        string = string + " concept_id = '" + this.concept_id + "'";
        return this.con.isExistent(string);
    }

    public static void makeQuery(Vector vector, Vector vector2) {
        if (vector2 == null) {
            return;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            Concept concept = (Concept)vector2.elementAt(i);
            String string = "UPDATE LMT_CONCEPTS SET";
            string = string + " concept_symbol = '" + Util.replaceSingleQuote(concept.getConceptSymbol()) + "',";
            string = string + " cte_entry = '" + concept.getCteEntry() + "',";
            string = string + " capitalization = '" + Concept.changeCapForDB(concept.getCapitalization()) + "',";
            string = string + " ambiguity = '" + concept.getAmbiguity() + "',";
            string = string + " irr_capitalization = '" + Util.replaceSingleQuote(concept.getIrrCapitalization()) + "',";
            string = string + " date_updated = '" + concept.getDateUpdated() + "',";
            string = string + " author_updating = '" + concept.getAuthorUpdating() + "',";
            string = string + " source = '" + Util.replaceSingleQuote(concept.getSource()) + "'";
            string = string + " WHERE concept_id = '" + concept.getConceptID() + "'";
            vector.addElement(string);
        }
    }

    public String makeInsertQuery() {
        String string = "INSERT INTO LMT_CONCEPTS VALUES (";
        string = string + "'" + this.concept_id + "',";
        string = string + "'" + this.term_id + "',";
        string = string + "'" + Util.replaceSingleQuote(this.concept_symbol) + "',";
        string = string + "'" + this.cte_entry + "',";
        string = string + "'" + Concept.changeCapForDB(this.capitalization) + "',";
        string = string + "'" + Util.replaceSingleQuote(this.irr_capitalization) + "',";
        string = string + "'" + this.ambiguity + "',";
        string = string + "'" + this.date_created + "',";
        string = string + "'" + this.author_creating + "',";
        string = string + "'" + this.date_updated + "',";
        string = string + "'" + this.author_updating + "',";
        string = string + "'" + Util.replaceSingleQuote(this.source) + "',";
        string = string + "'" + this.active + "')";
        return string;
    }

    public static String generateConceptSymbol(Term term) {
        String string = "";
        String string2 = term.getPos();
        String string3 = term.getTermString().replace(' ', '-');
        if (string2.equals("VERB")) {
            string = "*A-" + string3;
        } else if (string2.equals("ADVERB")) {
            string = "*M-" + string3;
        } else if (string2.equals("NOUN")) {
            string = "*O-" + string3;
        } else if (string2.equals("ADJ")) {
            string = "*P-" + string3;
        } else if (string2.equals("PREP")) {
            string = "*K-" + string3;
        } else if (string2.equals("UNIT")) {
            string = "*U-" + string3;
        } else if (string2.equals("MOD") || string2.equals("AUX") || string2.equals("DET") || string2.equals("INF") || string2.equals("SP")) {
            string = "*SP-" + string3;
        } else if (string2.equals("CARD") || string2.equals("CONJ") || string2.equals("INT") || string2.equals("PRON") || string2.equals("PROP") || string2.equals("QUANT") || string2.equals("SYM") || string2.equals("ORD")) {
            string = "*" + string2 + "-" + string3;
        }
        return string.toUpperCase();
    }
}

