/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.Properties;

public class PropertyManager {
    private static final String UserResourceDir = new String(".kantoo");
    private static final File User;
    private static final String ResourceFileSuffix;
    private final Class myClass;
    private Properties myProperties;
    public static final String PropertyArg = "-D";
    public static final String ArgEndArg = "--";

    private String getClassName() {
        String string = this.myClass.getName();
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(n + 1);
    }

    public PropertyManager(Object object) {
        this(object.getClass());
    }

    public PropertyManager(Class clazz) {
        this.myClass = clazz;
        this.load();
    }

    private void load() {
        Object object;
        Properties properties = new Properties();
        try {
            object = this.myClass.getResourceAsStream(this.getClassName() + ResourceFileSuffix);
            if (object == null) {
                throw new IOException("Missing resource file for " + this.getClassName());
            }
            properties.load((InputStream)object);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        this.myProperties = new Properties(properties);
        if (User != null) {
            object = new File(User, this.myClass.getName() + ResourceFileSuffix);
            try {
                this.myProperties.load(new FileInputStream((File)object));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String get(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty(this.myClass.getName() + "." + string);
            if (string2 != null) {
                return string2;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (this.myProperties != null) {
            string2 = this.myProperties.getProperty(string);
        }
        if (string2 != null) {
            return string2;
        }
        throw new MissingResourceException("Property not found: " + this.myClass.getName() + "." + string, this.myClass.getName(), string);
    }

    public int getInt(String string) {
        return Integer.parseInt(this.get(string));
    }

    public URL getResource(String string) {
        return this.myClass.getResource(string);
    }

    public boolean set(String string, String string2) {
        String string3 = null;
        try {
            string3 = this.get(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (string2 == string3) {
            return false;
        }
        if (string2 != null && string3 != null && string2.equals(string3)) {
            return false;
        }
        this.myProperties.setProperty(string, string2);
        return true;
    }

    public void store() {
        if (this.myProperties.size() == 0) {
            return;
        }
        if (User != null) {
            try {
                if (!User.exists()) {
                    User.mkdir();
                }
                String string = this.myClass.getName() + ResourceFileSuffix;
                this.myProperties.store(new FileOutputStream(new File(User, string)), string);
            }
            catch (IOException iOException) {
                System.out.println("Can not save properties for class: " + this.getClassName());
            }
        }
    }

    public static String getArgs(String[] stringArray) {
        int n;
        int n2;
        boolean bl = false;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2] == null) continue;
            if (stringArray[n2].startsWith(PropertyArg)) {
                n = stringArray[n2].indexOf(61);
                String string = n == -1 ? stringArray[n2].substring(PropertyArg.length()) : stringArray[n2].substring(PropertyArg.length(), n);
                String string2 = n == -1 ? "" : stringArray[n2].substring(n + 1);
                System.setProperty(PropertyManager.loadConvert(string), PropertyManager.loadConvert(string2));
                stringArray[n2] = null;
                continue;
            }
            if (!stringArray[n2].equals(ArgEndArg)) continue;
            stringArray[n2] = null;
            break;
        }
        for (n2 = 0; stringArray.length > n2 && stringArray[n2] != null; ++n2) {
        }
        for (n = n2; n < stringArray.length; ++n) {
            if (stringArray[n] == null || n <= n2) continue;
            stringArray[n2] = stringArray[n];
            ++n2;
            stringArray[n] = null;
        }
        if (stringArray.length == 0) {
            return null;
        }
        return stringArray[0];
    }

    private static String loadConvert(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) == 92) {
                if ((n3 = string.charAt(n2++)) == 117) {
                    int n4 = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        n3 = string.charAt(n2++);
                        switch (n3) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n4 = (n4 << 4) + n3 - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                n4 = (n4 << 4) + 10 + n3 - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                n4 = (n4 << 4) + 10 + n3 - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    stringBuffer.append((char)n4);
                    continue;
                }
                if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 110) {
                    n3 = 10;
                } else if (n3 == 102) {
                    n3 = 12;
                }
                stringBuffer.append((char)n3);
                continue;
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    static {
        String string = null;
        try {
            string = System.getProperty("user.home");
        }
        catch (SecurityException securityException) {
            string = null;
        }
        User = string == null ? null : new File(string, UserResourceDir);
        ResourceFileSuffix = new String(".properties");
    }
}

