/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import lmt.Debug;

public class LmtTableModel
extends AbstractTableModel {
    public boolean AllDisabled = false;
    Vector columnNames = new Vector();
    Vector rowData;
    int notEditableCol;

    LmtTableModel(String[] stringArray, Vector vector, int n) {
        int n2;
        if (stringArray != null) {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                this.columnNames.addElement(stringArray[n2]);
            }
        }
        this.rowData = new Vector();
        if (vector != null) {
            for (n2 = 0; n2 < vector.size(); ++n2) {
                this.rowData.addElement(vector.elementAt(n2));
            }
        }
        this.notEditableCol = n;
    }

    LmtTableModel(String[] stringArray, Vector vector) {
        this(stringArray, vector, -1);
        this.AllDisabled = true;
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public int getRowCount() {
        return this.rowData.size();
    }

    public String getColumnName(int n) {
        if (n >= this.columnNames.size()) {
            Debug.debug("getColumnName: col: " + n + " size: " + this.rowData.size());
            return "";
        }
        return (String)this.columnNames.elementAt(n);
    }

    public Object getValueAt(int n, int n2) {
        boolean bl;
        boolean bl2 = n < 0 || n >= this.rowData.size();
        boolean bl3 = bl = n2 < 0 || n2 >= this.columnNames.size();
        if (bl2 || bl) {
            Debug.debug("getValueAt: row: " + n + " col: " + n2 + " size: " + this.rowData.size());
            return "";
        }
        Vector vector = (Vector)this.rowData.elementAt(n);
        return vector.elementAt(n2);
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.AllDisabled) {
            return false;
        }
        return n2 != this.notEditableCol;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n >= this.rowData.size() || n2 >= this.columnNames.size()) {
            Debug.debug("setValueAt: row: " + n + " col: " + n2 + " size: " + this.rowData.size());
            return;
        }
        Vector vector = (Vector)this.rowData.elementAt(n);
        vector.setElementAt(object, n2);
        this.fireTableCellUpdated(n, n2);
    }

    public void clear() {
        int n = this.rowData.size();
        this.rowData.removeAllElements();
        this.fireTableRowsDeleted(0, n);
    }

    public void replaceData(Vector vector) {
        this.rowData.removeAllElements();
        for (int i = 0; i < vector.size(); ++i) {
            this.rowData.addElement(vector.elementAt(i));
        }
        this.fireTableRowsInserted(0, this.rowData.size());
    }

    public void doInsertion(Vector vector) {
        this.rowData.addElement(vector);
        this.fireTableRowsInserted(this.rowData.size() - 1, this.rowData.size());
    }

    public void doDeletion(int n) {
        if (n < this.rowData.size()) {
            this.rowData.removeElement(this.rowData.elementAt(n));
            this.fireTableRowsDeleted(n, n);
        }
    }

    public void doUpdate(int n) {
        if (n < this.rowData.size()) {
            this.fireTableRowsUpdated(n, n);
        }
    }
}

