// ======================================================================
// valTst.cpp - Testing code for value.*
// 
// 122502: Benjamin Han <benhdj@cs.cmu.edu> using namespace std.
// 120601: Benjamin Han <benhdj@cs.cmu.edu> Added missing va_end() in 
//         insertVDaughters(); namespace added.
// 091701: Benjamin Han <benhdj@cs.cmu.edu> Added compaction tests for
//         embedded *OR* inside a *MULTIPLE*, and embedded *MULTIPLE* inside
//         an *OR*.
// 090601: Benjamin Han <benhdj@cs.cmu.edu> Renamed all equal() to test();
//         revised comments: changed "=c" to "=t".
// 081901: Benjamin Han <benhdj@cs.cmu.edu> Used insertVDaughters() to go
//         easy on the compiler.
// 080201: Benjamin Han <benhdj@cs.cmu.edu> Renamed dBegin() and dEnd() to 
//         begin() and end() in _TreeIteratorBase<>.
// 072001: Benjamin Han <benhdj@cs.cmu.edu> Revised using the new ways to
//         declare tree iterators.
// 071701: Benjamin Han <benhdj@cs.cmu.edu> Started using the global symNot,
//         symOr and symMultiple.
// 071301: Benjamin Han <benhdj@cs.cmu.edu> Minor header dependency change.
// 070901: Benjamin Han <benhdj@cs.cmu.edu> Revised tests involving *MULTIPLE*
//         values to see if the implementation accurately models the behaviors
//         of the 1988 GenKit.
// 070601: Benjamin Han <benhdj@cs.cmu.edu> Changed Value::append() to
//         Value::push().
// 070501: Benjamin Han <benhdj@cs.cmu.edu> Added tests for Value::mergeOr().
// 070101: Benjamin Han <benhdj@cs.cmu.edu> Added tests for *OR* vs. *NOT*
//         and vice versa.
// 062401: Benjamin Han <benhdj@cs.cmu.edu> Added one test for recursive
//         value compaction (the last of the value compaction tests).
// 062301: Benjamin Han <benhdj@cs.cmu.edu> Revised '=' into '=c' for equality
//         tests.
// 061201: Benjamin Han <benhdj@cs.cmu.edu> Changed from "void main()" to
//         "int main ()".
// 050801: Benjamin Han <benhdj@cs.cmu.edu> Modified since the individual
//         tree nodes in a Value now carry Symbol rather than int.
// 042101: Benjamin Han <benhdj@cs.cmu.edu> Created.
// ======================================================================

//    Copyright (C) 2000-2004 Benjamin Han <benhdj@cs.cmu.edu>
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "value.hpp"

#include <stdarg.h>

using namespace UKernel;
using namespace std;

// this function is provided to make this program easier to compile
// otherwise g++ will make your system crawl (like a turtle) due to
// inline functions
void insertVDaughters (Value &v, Value::DIterator iter, char *first, ...) {
  va_list argp;
  char *ptr;

  if (first==NULL) return;
  else v.insert(iter,Symbol(first));

  for (va_start(argp,first);(ptr=va_arg(argp,char*))!=NULL;
       v.insert(iter,Symbol(ptr)));
  va_end(argp);
}

int main () {
  Value v1,v2;
  Value::Iterator iter1,iter2,iter3;

  cout<<"========== Value compaction tests =========="<<endl;

  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"0","0","1",NULL);
  cout<<v1<<" is "<<flush;
  v1.compact();
  cout<<v1<<endl;
  v1.clear();

  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"0","0","0",NULL);
  cout<<v1<<" is "<<flush;
  v1.compact();
  cout<<v1<<endl;
  v1.clear();

  iter1=v1.insert(v1.begin(),symNot);
  insertVDaughters(v1,iter1.end(),"0","0","1",NULL);
  cout<<v1<<" is "<<flush;
  v1.compact();
  cout<<v1<<endl;
  v1.clear();

  iter1=v1.insert(v1.begin(),symNot);
  insertVDaughters(v1,iter1.end(),"0","0","0",NULL);
  cout<<v1<<" is "<<flush;
  v1.compact();
  cout<<v1<<endl;
  v1.clear();

  iter1=v1.insert(v1.begin(),symMultiple);
  insertVDaughters(v1,iter1.end(),"0","0","1",NULL);
  cout<<v1<<" is "<<flush;
  v1.compact();
  cout<<v1<<endl;
  v1.clear();

  iter1=v1.insert(v1.begin(),symOr);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"0","1",NULL);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"1","0",NULL);
  cout<<v1<<" is "<<flush;
  v1.compact();
  cout<<v1<<endl;
  v1.clear();

  iter1=v1.insert(v1.begin(),symOr);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"0",NULL);
  iter3=v1.insert(iter2.end(),symOr);
  insertVDaughters(v1,iter3.end(),"1","2",NULL);
  iter2=v1.insert(iter1.end(),symOr);
  iter3=v1.insert(iter2.end(),symOr);
  insertVDaughters(v1,iter3.end(),"2","1",NULL);
  insertVDaughters(v1,iter2.end(),"0",NULL);
  cout<<v1<<" is "<<flush;
  v1.compact();
  cout<<v1<<endl;
  v1.clear();

  iter1=v1.insert(v1.begin(),symOr);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"0",NULL);
  iter3=v1.insert(iter2.end(),symOr);
  insertVDaughters(v1,iter3.end(),"1","2",NULL);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"0",NULL);
  iter3=v1.insert(iter2.end(),symOr);
  insertVDaughters(v1,iter3.end(),"1","3",NULL);
  cout<<v1<<" is "<<flush;
  v1.compact();
  cout<<v1<<endl;
  v1.clear();

  iter1=v1.insert(v1.begin(),symOr);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"0","1",NULL);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"0","2",NULL);
  cout<<v1<<" is "<<flush;
  v1.compact();
  cout<<v1<<endl;
  v1.clear();

  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"0","0",NULL);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"0","1",NULL);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"0","1",NULL);
  cout<<v1<<" is "<<flush;
  v1.compact();
  cout<<v1<<endl;
  v1.clear();

  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"0","0",NULL);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"0","1",NULL);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"0","2",NULL);
  cout<<v1<<" is "<<flush;
  v1.compact();
  cout<<v1<<endl;
  v1.clear();

  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"0","0",NULL);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"0",NULL);
  iter3=v1.insert(iter2.end(),symOr);
  insertVDaughters(v1,iter3.end(),"1","2",NULL);
  iter2=v1.insert(iter1.end(),symOr);
  iter3=v1.insert(iter2.end(),symOr);
  insertVDaughters(v1,iter3.end(),"2","1",NULL);
  insertVDaughters(v1,iter2.end(),"0",NULL);
  cout<<v1<<" is "<<flush;
  v1.compact();
  cout<<v1<<endl;
  v1.clear();

  iter1=v1.insert(v1.begin(),symOr);
  iter2=v1.insert(iter1.end(),symMultiple);
  insertVDaughters(v1,iter2.end(),"0","1",NULL);
  iter2=v1.insert(iter1.end(),symMultiple);
  insertVDaughters(v1,iter2.end(),"0","1",NULL);
  cout<<v1<<" is "<<flush;
  v1.compact();
  cout<<v1<<endl;
  v1.clear();

  iter1=v1.insert(v1.begin(),symOr);
  iter2=v1.insert(iter1.end(),symMultiple);
  insertVDaughters(v1,iter2.end(),"0","1",NULL);
  iter2=v1.insert(iter1.end(),symMultiple);
  insertVDaughters(v1,iter2.end(),"1","0",NULL);
  cout<<v1<<" is "<<flush;
  v1.compact();
  cout<<v1<<endl;
  v1.clear();

  iter1=v1.insert(v1.begin(),symOr);
  iter2=v1.insert(iter1.end(),symMultiple);
  insertVDaughters(v1,iter2.end(),"0",NULL);
  iter3=v1.insert(iter2.end(),symOr);
  insertVDaughters(v1,iter3.end(),"0","1",NULL);
  iter2=v1.insert(iter1.end(),symMultiple);
  insertVDaughters(v1,iter2.end(),"0",NULL);
  iter3=v1.insert(iter2.end(),symOr);
  insertVDaughters(v1,iter3.end(),"1","0",NULL);
  cout<<v1<<" is "<<flush;
  v1.compact();
  cout<<v1<<endl;
  v1.clear();

  iter1=v1.insert(v1.begin(),symOr);
  iter2=v1.insert(iter1.end(),symMultiple);
  insertVDaughters(v1,iter2.end(),"0",NULL);
  iter3=v1.insert(iter2.end(),symOr);
  insertVDaughters(v1,iter3.end(),"0","1",NULL);
  iter3=v1.insert(iter3.end(),symMultiple);
  insertVDaughters(v1,iter3.end(),"0","1",NULL);
  iter2=v1.insert(iter1.end(),symMultiple);
  insertVDaughters(v1,iter2.end(),"0",NULL);
  iter3=v1.insert(iter2.end(),symOr);
  insertVDaughters(v1,iter3.end(),"1","0",NULL);
  iter3=v1.insert(iter3.end(),symMultiple);
  insertVDaughters(v1,iter3.end(),"0","1",NULL);
  cout<<v1<<" is "<<flush;
  v1.compact();
  cout<<v1<<endl;
  v1.clear();

  iter1=v1.insert(v1.begin(),symOr);
  iter2=v1.insert(iter1.end(),symMultiple);
  insertVDaughters(v1,iter2.end(),"0",NULL);
  iter3=v1.insert(iter2.end(),symOr);
  insertVDaughters(v1,iter3.end(),"0","1",NULL);
  iter3=v1.insert(iter3.end(),symMultiple);
  insertVDaughters(v1,iter3.end(),"0","1",NULL);
  iter2=v1.insert(iter1.end(),symMultiple);
  insertVDaughters(v1,iter2.end(),"0",NULL);
  iter3=v1.insert(iter2.end(),symOr);
  insertVDaughters(v1,iter3.end(),"1","0",NULL);
  iter3=v1.insert(iter3.end(),symMultiple);
  insertVDaughters(v1,iter3.end(),"1","0",NULL);
  cout<<v1<<" is "<<flush;
  v1.compact();
  cout<<v1<<endl;
  v1.clear();

  iter1=v1.insert(v1.begin(),symOr);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"0",NULL);
  iter3=v1.insert(iter2.end(),symMultiple);
  insertVDaughters(v1,iter3.end(),"0","1",NULL);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"0",NULL);
  iter3=v1.insert(iter2.end(),symMultiple);
  insertVDaughters(v1,iter3.end(),"1","0",NULL);
  cout<<v1<<" is "<<flush;
  v1.compact();
  cout<<v1<<endl;
  v1.clear();

  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"0","0",NULL);
  iter2=v1.insert(iter1.end(),symNot);
  insertVDaughters(v1,iter2.end(),"0","1","1","0",NULL);
  iter3=v1.insert(iter2.end(),symOr);
  insertVDaughters(v1,iter3.end(),"2","3","3",NULL);
  iter3=v1.insert(iter2.end(),symMultiple);
  insertVDaughters(v1,iter3.end(),"1","1","2","3","1","2",NULL);
  cout<<v1<<" is "<<flush;
  v1.compact();
  cout<<v1<<endl;
  v1.clear();

  cout<<endl<<"========== Value unification tests =========="<<endl;

  // -------------------- LHS is Atom --------------------

  // 0 = 0
  v1.insert(v1.begin(),Symbol("0"));
  v2.insert(v2.begin(),Symbol("0"));
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // 0 = (*NOT* 1 2 3)
  v1.insert(v1.begin(),Symbol("0"));
  iter1=v2.insert(v2.begin(),symNot);
  insertVDaughters(v2,iter1.end(),"1","2","3",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // 0 = (*OR* 0 1 2)
  v1.insert(v1.begin(),Symbol("0"));
  iter1=v2.insert(v2.begin(),symOr);
  insertVDaughters(v2,iter1.end(),"0","1","2",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // 0 = (*MULTIPLE* 0 1 2 0)
  v1.insert(v1.begin(),Symbol("0"));
  iter1=v2.insert(v2.begin(),symMultiple);
  insertVDaughters(v2,iter1.end(),"0","1","2","0",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // 1 = (*MULTIPLE* 1 1)
  v1.insert(v1.begin(),Symbol("1"));
  iter1=v2.insert(v2.begin(),symMultiple);
  insertVDaughters(v2,iter1.end(),"1","1",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // -------------------- LHS is *NOT* --------------------

  // (*NOT* 1 2 3) = 0
  iter1=v1.insert(v1.begin(),symNot);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  v2.insert(v2.begin(),Symbol("0"));
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*NOT* 1 2 3) = (*NOT* 1 4 5 0)
  iter1=v1.insert(v1.begin(),symNot);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  iter1=v2.insert(v2.begin(),symNot);
  insertVDaughters(v2,iter1.end(),"1","4","5","0",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*NOT* (*OR* 0 1) 2 3) = (*NOT* 1 4 5 0)
  iter1=v1.insert(v1.begin(),symNot);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"0","1",NULL);
  insertVDaughters(v1,iter1.end(),"2","3",NULL);
  iter1=v2.insert(v2.begin(),symNot);
  insertVDaughters(v2,iter1.end(),"1","4","5","0",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*NOT* (*OR* 0 1) 2 3) = (*NOT* 1 (*OR* 0 1 1) 5 0)
  iter1=v1.insert(v1.begin(),symNot);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"0","1",NULL);
  insertVDaughters(v1,iter1.end(),"2","3",NULL);
  iter1=v2.insert(v2.begin(),symNot);
  v2.insert(iter1.end(),Symbol("1"));
  iter2=v2.insert(iter1.end(),symOr);
  insertVDaughters(v2,iter2.end(),"0","1","1",NULL);
  insertVDaughters(v2,iter1.end(),"5","0",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*NOT* 1 2 3) = (*OR* 1 4 5 0)
  iter1=v1.insert(v1.begin(),symNot);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  iter1=v2.insert(v2.begin(),symOr);
  insertVDaughters(v2,iter1.end(),"1","4","5","0",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*NOT* 1 (*OR* 2 3) 3) = (*OR* (*OR* 1 2) 2 3)
  iter1=v1.insert(v1.begin(),symNot);
  v1.insert(iter1.end(),Symbol("1"));
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"2","3",NULL);
  insertVDaughters(v1,iter1.end(),"3",NULL);
  iter1=v2.insert(v2.begin(),symOr);
  iter2=v2.insert(iter1.end(),symOr);
  insertVDaughters(v2,iter2.end(),"1","2",NULL);
  insertVDaughters(v2,iter1.end(),"2","3",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*NOT* (*OR* 2 3) 3) = (*OR* (*OR* 1 2) 2 3)
  iter1=v1.insert(v1.begin(),symNot);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"2","3",NULL);
  insertVDaughters(v1,iter1.end(),"3",NULL);
  iter1=v2.insert(v2.begin(),symOr);
  iter2=v2.insert(iter1.end(),symOr);
  insertVDaughters(v2,iter2.end(),"1","2",NULL);
  insertVDaughters(v2,iter1.end(),"2","3",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*NOT* 1 (*OR* 2 3) 3) = (*OR* (*OR* 1 2) 2 4)
  iter1=v1.insert(v1.begin(),symNot);
  v1.insert(iter1.end(),Symbol("1"));
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"2","3",NULL);
  insertVDaughters(v1,iter1.end(),"3",NULL);
  iter1=v2.insert(v2.begin(),symOr);
  iter2=v2.insert(iter1.end(),symOr);
  insertVDaughters(v2,iter2.end(),"1","2",NULL);
  insertVDaughters(v2,iter1.end(),"2","4",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*NOT* 1 2 3) = (*MULTIPLE* 1 4 5 0)
  iter1=v1.insert(v1.begin(),symNot);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  iter1=v2.insert(v2.begin(),symMultiple);
  insertVDaughters(v2,iter1.end(),"1","4","5","0",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*NOT* 1 2 3) = (*MULTIPLE* 4 5 0)
  iter1=v1.insert(v1.begin(),symNot);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  iter1=v2.insert(v2.begin(),symMultiple);
  insertVDaughters(v2,iter1.end(),"4","5","0",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // -------------------- LHS is *OR* --------------------

  // (*OR* 0 1 2) = 0
  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"0","1","2",NULL);
  v2.insert(v2.begin(),Symbol("0"));
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*OR* 1 4 5 0) = (*NOT* 1 2 3)
  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"1","4","5","0",NULL);
  iter1=v2.insert(v2.begin(),symNot);
  insertVDaughters(v2,iter1.end(),"1","2","3",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*OR* (*OR* 1 2) 2 3) = (*NOT* 1 (*OR* 2 3) 3)
  iter1=v1.insert(v1.begin(),symOr);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"1","2",NULL);
  insertVDaughters(v1,iter1.end(),"2","3",NULL);
  iter1=v2.insert(v2.begin(),symNot);
  v2.insert(iter1.end(),Symbol("1"));
  iter2=v2.insert(iter1.end(),symOr);
  insertVDaughters(v2,iter2.end(),"2","3",NULL);
  v2.insert(iter1.end(),Symbol("3"));
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*OR* (*OR* 1 2) 2 3) = (*NOT* (*OR* 2 3) 3)
  iter1=v1.insert(v1.begin(),symOr);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"1","2",NULL);
  insertVDaughters(v1,iter1.end(),"2","3",NULL);
  iter1=v2.insert(v2.begin(),symNot);
  iter2=v2.insert(iter1.end(),symOr);
  insertVDaughters(v2,iter2.end(),"2","3",NULL);
  v2.insert(iter1.end(),Symbol("3"));
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*OR* (*OR* 1 2) 2 4) = (*NOT* 1 (*OR* 2 3) 3)
  iter1=v1.insert(v1.begin(),symOr);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"1","2",NULL);
  insertVDaughters(v1,iter1.end(),"2","4",NULL);
  iter1=v2.insert(v2.begin(),symNot);
  v2.insert(iter1.end(),Symbol("1"));
  iter2=v2.insert(iter1.end(),symOr);
  insertVDaughters(v2,iter2.end(),"2","3",NULL);
  v2.insert(iter1.end(),Symbol("3"));
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*OR* 1 2 3) = (*OR* 1 4 5 0)
  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  iter1=v2.insert(v2.begin(),symOr);
  insertVDaughters(v2,iter1.end(),"1","4","5","0",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*OR* 1 2 3) = (*OR* 4 5 0)
  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  iter1=v2.insert(v2.begin(),symOr);
  insertVDaughters(v2,iter1.end(),"4","5","0",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*OR* (*OR* 0 1) 1 3) = (*OR* 1 4 5 0)
  iter1=v1.insert(v1.begin(),symOr);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"0","1",NULL);
  insertVDaughters(v1,iter1.end(),"1","3",NULL);
  iter1=v2.insert(v2.begin(),symOr);
  insertVDaughters(v2,iter1.end(),"1","4","5","0",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*OR* 1 2 3) = (*MULTIPLE* 3 1 2 1)
  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  iter1=v2.insert(v2.begin(),symMultiple);
  insertVDaughters(v2,iter1.end(),"3","1","2","1",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*OR* 1 3) = (*MULTIPLE* 3 1 2 1)
  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"1","3",NULL);
  iter1=v2.insert(v2.begin(),symMultiple);
  insertVDaughters(v2,iter1.end(),"3","1","2","1",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // -------------------- LHS is *MULTIPLE* --------------------

  // (*MULTIPLE* 0 1 2 0) = 0
  iter1=v1.insert(v1.begin(),symMultiple);
  insertVDaughters(v1,iter1.end(),"0","1","2","0",NULL);
  v2.insert(v2.begin(),Symbol("0"));
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*MULTIPLE* 1 1) = 1
  iter1=v1.insert(v1.begin(),symMultiple);
  insertVDaughters(v1,iter1.end(),"1","1",NULL);
  v2.insert(v2.begin(),Symbol("1"));
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*MULTIPLE* 1 4 5 0) = (*NOT* 1 2 3)
  iter1=v1.insert(v1.begin(),symMultiple);
  insertVDaughters(v1,iter1.end(),"1","4","5","0",NULL);
  iter1=v2.insert(v2.begin(),symNot);
  insertVDaughters(v2,iter1.end(),"1","2","3",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*MULTIPLE* 4 5 0) = (*NOT* 1 2 3)
  iter1=v1.insert(v1.begin(),symMultiple);
  insertVDaughters(v1,iter1.end(),"4","5","0",NULL);
  iter1=v2.insert(v2.begin(),symNot);
  insertVDaughters(v2,iter1.end(),"1","2","3",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*MULTIPLE* 3 1 2 1) = (*OR* 1 2 3)
  iter1=v1.insert(v1.begin(),symMultiple);
  insertVDaughters(v1,iter1.end(),"3","1","2","1",NULL);
  iter1=v2.insert(v2.begin(),symOr);
  insertVDaughters(v2,iter1.end(),"1","2","3",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*MULTIPLE* 3 1 2 1) = (*OR* 1 3)
  iter1=v1.insert(v1.begin(),symMultiple);
  insertVDaughters(v1,iter1.end(),"3","1","2","1",NULL);
  iter1=v2.insert(v2.begin(),symOr);
  insertVDaughters(v2,iter1.end(),"1","3",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*MULTIPLE* 1 2 3) = (*MULTIPLE* (*NOT* 4) (*NOT* 5 6))
  iter1=v1.insert(v1.begin(),symMultiple);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  iter1=v2.insert(v2.begin(),symMultiple);
  iter2=v2.insert(iter1.end(),symNot);
  v2.insert(iter2.end(),Symbol("4"));
  iter2=v2.insert(iter1.end(),symNot);
  insertVDaughters(v2,iter2.end(),"5","6",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*MULTIPLE* (*NOT* 4) (*NOT* 5 6)) = (*MULTIPLE* 1 2 3)
  iter1=v1.insert(v1.begin(),symMultiple);
  iter2=v1.insert(iter1.end(),symNot);
  v1.insert(iter2.end(),Symbol("4"));
  iter2=v1.insert(iter1.end(),symNot);
  insertVDaughters(v1,iter2.end(),"5","6",NULL);
  iter1=v2.insert(v2.begin(),symMultiple);
  insertVDaughters(v2,iter1.end(),"1","2","3",NULL);
  cout<<v1<<" = "<<v2<<" => "<<flush;
  cout<<(v1.pseudoUnify(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  cout<<endl<<"========== Value equality tests =========="<<endl;

  // -------------------- LHS is Atom --------------------

  // 0 =t 0
  v1.insert(v1.begin(),Symbol("0"));
  v2.insert(v2.begin(),Symbol("0"));
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // 0 =t (*NOT* 1 2 3)
  v1.insert(v1.begin(),Symbol("0"));
  iter1=v2.insert(v2.begin(),symNot);
  insertVDaughters(v2,iter1.end(),"1","2","3",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // 0 =t (*OR* 0 1 2)
  v1.insert(v1.begin(),Symbol("0"));
  iter1=v2.insert(v2.begin(),symOr);
  insertVDaughters(v2,iter1.end(),"0","1","2",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // 0 =t (*MULTIPLE* 0 1 2 0)
  v1.insert(v1.begin(),Symbol("0"));
  iter1=v2.insert(v2.begin(),symMultiple);
  insertVDaughters(v2,iter1.end(),"0","1","2","0",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // 1 =t (*MULTIPLE* 1 1)
  v1.insert(v1.begin(),Symbol("1"));
  iter1=v2.insert(v2.begin(),symMultiple);
  insertVDaughters(v2,iter1.end(),"1","1",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // -------------------- LHS is *NOT* --------------------

  // (*NOT* 1 2 3) =t 0
  iter1=v1.insert(v1.begin(),symNot);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  v2.insert(v2.begin(),Symbol("0"));
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*NOT* 1 2 3) =t (*NOT* 1 4 5 0)
  iter1=v1.insert(v1.begin(),symNot);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  iter1=v2.insert(v2.begin(),symNot);
  insertVDaughters(v2,iter1.end(),"1","4","5","0",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*NOT* (*OR* 0 1) 2 3) =t (*NOT* 1 4 5 0)
  iter1=v1.insert(v1.begin(),symNot);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"0","1",NULL);
  insertVDaughters(v1,iter1.end(),"2","3",NULL);
  iter1=v2.insert(v2.begin(),symNot);
  insertVDaughters(v2,iter1.end(),"1","4","5","0",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*NOT* (*OR* 0 1) 2 3) =t (*NOT* 1 (*OR* 0 1 1) 5 0)
  iter1=v1.insert(v1.begin(),symNot);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"0","1",NULL);
  insertVDaughters(v1,iter1.end(),"2","3",NULL);
  iter1=v2.insert(v2.begin(),symNot);
  v2.insert(iter1.end(),Symbol("1"));
  iter2=v2.insert(iter1.end(),symOr);
  insertVDaughters(v2,iter2.end(),"0","1","1",NULL);
  insertVDaughters(v2,iter1.end(),"5","0",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*NOT* 1 2 3) =t (*OR* 1 4 5 0)
  iter1=v1.insert(v1.begin(),symNot);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  iter1=v2.insert(v2.begin(),symOr);
  insertVDaughters(v2,iter1.end(),"1","4","5","0",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*NOT* 1 (*OR* 2 3) 3) =t (*OR* (*OR* 1 2) 2 3)
  iter1=v1.insert(v1.begin(),symNot);
  v1.insert(iter1.end(),Symbol("1"));
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"2","3",NULL);
  insertVDaughters(v1,iter1.end(),"3",NULL);
  iter1=v2.insert(v2.begin(),symOr);
  iter2=v2.insert(iter1.end(),symOr);
  insertVDaughters(v2,iter2.end(),"1","2",NULL);
  insertVDaughters(v2,iter1.end(),"2","3",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*NOT* (*OR* 2 3) 3) =t (*OR* (*OR* 1 2) 2 3)
  iter1=v1.insert(v1.begin(),symNot);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"2","3",NULL);
  insertVDaughters(v1,iter1.end(),"3",NULL);
  iter1=v2.insert(v2.begin(),symOr);
  iter2=v2.insert(iter1.end(),symOr);
  insertVDaughters(v2,iter2.end(),"1","2",NULL);
  insertVDaughters(v2,iter1.end(),"2","3",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*NOT* 1 (*OR* 2 3) 3) =t (*OR* (*OR* 1 2) 2 4)
  iter1=v1.insert(v1.begin(),symNot);
  v1.insert(iter1.end(),Symbol("1"));
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"2","3",NULL);
  insertVDaughters(v1,iter1.end(),"3",NULL);
  iter1=v2.insert(v2.begin(),symOr);
  iter2=v2.insert(iter1.end(),symOr);
  insertVDaughters(v2,iter2.end(),"1","2",NULL);
  insertVDaughters(v2,iter1.end(),"2","4",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*NOT* 1 2 3) =t (*MULTIPLE* 1 4 5 0)
  iter1=v1.insert(v1.begin(),symNot);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  iter1=v2.insert(v2.begin(),symMultiple);
  insertVDaughters(v2,iter1.end(),"1","4","5","0",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*NOT* 1 2 3) =t (*MULTIPLE* 4 5 0)
  iter1=v1.insert(v1.begin(),symNot);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  iter1=v2.insert(v2.begin(),symMultiple);
  insertVDaughters(v2,iter1.end(),"4","5","0",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // -------------------- LHS is *OR* --------------------

  // (*OR* 0 1 2) =t 0
  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"0","1","2",NULL);
  v2.insert(v2.begin(),Symbol("0"));
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*OR* 1 4 5 0) =t (*NOT* 1 2 3)
  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"1","4","5","0",NULL);
  iter1=v2.insert(v2.begin(),symNot);
  insertVDaughters(v2,iter1.end(),"1","2","3",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*OR* (*OR* 1 2) 2 3) =t (*NOT* 1 (*OR* 2 3) 3)
  iter1=v1.insert(v1.begin(),symOr);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"1","2",NULL);
  insertVDaughters(v1,iter1.end(),"2","3",NULL);
  iter1=v2.insert(v2.begin(),symNot);
  v2.insert(iter1.end(),Symbol("1"));
  iter2=v2.insert(iter1.end(),symOr);
  insertVDaughters(v2,iter2.end(),"2","3",NULL);
  v2.insert(iter1.end(),Symbol("3"));
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*OR* (*OR* 1 2) 2 3) =t (*NOT* (*OR* 2 3) 3)
  iter1=v1.insert(v1.begin(),symOr);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"1","2",NULL);
  insertVDaughters(v1,iter1.end(),"2","3",NULL);
  iter1=v2.insert(v2.begin(),symNot);
  iter2=v2.insert(iter1.end(),symOr);
  insertVDaughters(v2,iter2.end(),"2","3",NULL);
  v2.insert(iter1.end(),Symbol("3"));
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*OR* (*OR* 1 2) 2 4) =t (*NOT* 1 (*OR* 2 3) 3)
  iter1=v1.insert(v1.begin(),symOr);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"1","2",NULL);
  insertVDaughters(v1,iter1.end(),"2","4",NULL);
  iter1=v2.insert(v2.begin(),symNot);
  v2.insert(iter1.end(),Symbol("1"));
  iter2=v2.insert(iter1.end(),symOr);
  insertVDaughters(v2,iter2.end(),"2","3",NULL);
  v2.insert(iter1.end(),Symbol("3"));
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*OR* 1 2 3) =t (*OR* 1 4 5 0)
  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  iter1=v2.insert(v2.begin(),symOr);
  insertVDaughters(v2,iter1.end(),"1","4","5","0",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*OR* 1 2 3) =t (*OR* 4 5 0)
  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  iter1=v2.insert(v2.begin(),symOr);
  insertVDaughters(v2,iter1.end(),"4","5","0",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*OR* (*OR* 0 1) 1 3) =t (*OR* 1 4 5 0)
  iter1=v1.insert(v1.begin(),symOr);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"0","1",NULL);
  insertVDaughters(v1,iter1.end(),"1","3",NULL);
  iter1=v2.insert(v2.begin(),symOr);
  insertVDaughters(v2,iter1.end(),"1","4","5","0",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*OR* 1 2 3) =t (*MULTIPLE* 3 1 2 1)
  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  iter1=v2.insert(v2.begin(),symMultiple);
  insertVDaughters(v2,iter1.end(),"3","1","2","1",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*OR* 1 3) =t (*MULTIPLE* 3 1 2 1)
  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"1","3",NULL);
  iter1=v2.insert(v2.begin(),symMultiple);
  insertVDaughters(v2,iter1.end(),"3","1","2","1",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // -------------------- LHS is *MULTIPLE* --------------------

  // (*MULTIPLE* 0 1 2 0) =t 0
  iter1=v1.insert(v1.begin(),symMultiple);
  insertVDaughters(v1,iter1.end(),"0","1","2","0",NULL);
  v2.insert(v2.begin(),Symbol("0"));
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*MULTIPLE* 1 1) =t 1
  iter1=v1.insert(v1.begin(),symMultiple);
  insertVDaughters(v1,iter1.end(),"1","1",NULL);
  v2.insert(v2.begin(),Symbol("1"));
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*MULTIPLE* 1 4 5 0) =t (*NOT* 1 2 3)
  iter1=v1.insert(v1.begin(),symMultiple);
  insertVDaughters(v1,iter1.end(),"1","4","5","0",NULL);
  iter1=v2.insert(v2.begin(),symNot);
  insertVDaughters(v2,iter1.end(),"1","2","3",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*MULTIPLE* 4 5 0) =t (*NOT* 1 2 3)
  iter1=v1.insert(v1.begin(),symMultiple);
  insertVDaughters(v1,iter1.end(),"4","5","0",NULL);
  iter1=v2.insert(v2.begin(),symNot);
  insertVDaughters(v2,iter1.end(),"1","2","3",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*MULTIPLE* 3 1 2 1) =t (*OR* 1 2 3)
  iter1=v1.insert(v1.begin(),symMultiple);
  insertVDaughters(v1,iter1.end(),"3","1","2","1",NULL);
  iter1=v2.insert(v2.begin(),symOr);
  insertVDaughters(v2,iter1.end(),"1","2","3",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*MULTIPLE* 3 1 2 1) =t (*OR* 1 3)
  iter1=v1.insert(v1.begin(),symMultiple);
  insertVDaughters(v1,iter1.end(),"3","1","2","1",NULL);
  iter1=v2.insert(v2.begin(),symOr);
  insertVDaughters(v2,iter1.end(),"1","3",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*MULTIPLE* 1 2 3) =t (*MULTIPLE* (*NOT* 4) (*NOT* 5 6))
  iter1=v1.insert(v1.begin(),symMultiple);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  iter1=v2.insert(v2.begin(),symMultiple);
  iter2=v2.insert(iter1.end(),symNot);
  v2.insert(iter2.end(),Symbol("4"));
  iter2=v2.insert(iter1.end(),symNot);
  insertVDaughters(v2,iter2.end(),"5","6",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*MULTIPLE* (*NOT* 4) (*NOT* 5 6)) =t (*MULTIPLE* 1 2 3)
  iter1=v1.insert(v1.begin(),symMultiple);
  iter2=v1.insert(iter1.end(),symNot);
  v1.insert(iter2.end(),Symbol("4"));
  iter2=v1.insert(iter1.end(),symNot);
  insertVDaughters(v1,iter2.end(),"5","6",NULL);
  iter1=v2.insert(v2.begin(),symMultiple);
  insertVDaughters(v2,iter1.end(),"1","2","3",NULL);
  cout<<v1<<" =t "<<v2<<" => "<<flush;
  cout<<(v1.test(v2)?"true":"false")<<", "<<v1<<endl;
  v1.clear();
  v2.clear();

  cout<<endl<<"========== Push/pop tests =========="<<endl;

  iter1=v1.insert(v1.begin(),symMultiple);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  v2.insert(v2.begin(),Symbol("4"));
  cout<<v1<<" + "<<v2<<" => "<<flush;
  v1.push(v2);
  cout<<v1<<endl;
  cout<<"TOP "<<v1<<" = "<<flush;
  cout<<(v1.top(v2)?"true":"false")<<"; "<<v2<<endl;
  cout<<"POP "<<v1<<" = "<<flush;
  cout<<(v1.pop()?"true":"false")<<"; "<<v1<<endl;
  v1.clear();
  v2.clear();

  iter1=v1.insert(v1.begin(),symMultiple);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  iter1=v2.insert(v2.begin(),symOr);
  insertVDaughters(v2,iter1.end(),"1","4","5","0",NULL);
  cout<<v1<<" + "<<v2<<" => "<<flush;
  v1.push(v2);
  cout<<v1<<endl;
  cout<<"TOP "<<v1<<" = "<<flush;
  cout<<(v1.top(v2)?"true":"false")<<"; "<<v2<<endl;
  cout<<"POP "<<v1<<" = "<<flush;
  cout<<(v1.pop()?"true":"false")<<"; "<<v1<<endl;
  v1.clear();
  v2.clear();

  iter1=v1.insert(v1.begin(),symMultiple);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  iter1=v2.insert(v2.begin(),symMultiple);
  insertVDaughters(v2,iter1.end(),"1","4","5","0",NULL);
  cout<<v1<<" + "<<v2<<" => "<<flush;
  v1.push(v2);
  cout<<v1<<endl;
  cout<<"TOP "<<v1<<" = "<<flush;
  cout<<(v1.top(v2)?"true":"false")<<"; "<<v2<<endl;
  cout<<"POP "<<v1<<" = "<<flush;
  cout<<(v1.pop()?"true":"false")<<"; "<<v1<<endl;
  v1.clear();
  v2.clear();

  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  v2.insert(v2.begin(),Symbol("4"));
  cout<<v1<<" + "<<v2<<" => "<<flush;
  v1.push(v2);
  cout<<v1<<endl;
  cout<<"TOP "<<v1<<" = "<<flush;
  cout<<(v1.top(v2)?"true":"false")<<"; "<<v2<<endl;
  cout<<"POP "<<v1<<" = "<<flush;
  cout<<(v1.pop()?"true":"false")<<"; "<<v1<<endl;
  v1.clear();
  v2.clear();

  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  iter1=v2.insert(v2.begin(),symOr);
  insertVDaughters(v2,iter1.end(),"1","4","5","0",NULL);
  cout<<v1<<" + "<<v2<<" => "<<flush;
  v1.push(v2);
  cout<<v1<<endl;
  cout<<"TOP "<<v1<<" = "<<flush;
  cout<<(v1.top(v2)?"true":"false")<<"; "<<v2<<endl;
  cout<<"POP "<<v1<<" = "<<flush;
  cout<<(v1.pop()?"true":"false")<<"; "<<v1<<endl;
  v1.clear();
  v2.clear();

  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"1","2","3",NULL);
  iter1=v2.insert(v2.begin(),symMultiple);
  insertVDaughters(v2,iter1.end(),"1","4","5","0",NULL);
  cout<<v1<<" + "<<v2<<" => "<<flush;
  v1.push(v2);
  cout<<v1<<endl;
  cout<<"TOP "<<v1<<" = "<<flush;
  cout<<(v1.top(v2)?"true":"false")<<"; "<<v2<<endl;
  cout<<"POP "<<v1<<" = "<<flush;
  cout<<(v1.pop()?"true":"false")<<"; "<<v1<<endl;
  v1.clear();
  v2.clear();

  cout<<endl<<"========== Merge *OR* tests =========="<<endl;

  // 0 is merged into (*OR* 0 1 2)
  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"0","1","2",NULL);
  v2.insert(v2.begin(),Symbol("0"));
  cout<<v2<<" is merged into "<<v1<<" => "<<flush;
  v1.mergeOr(v2);
  cout<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*NOT* 1 2 3) is merged into (*OR* 1 4 5 0)
  iter1=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter1.end(),"1","4","5","0",NULL);
  iter1=v2.insert(v2.begin(),symNot);
  insertVDaughters(v2,iter1.end(),"1","2","3",NULL);
  cout<<v2<<" is merged into "<<v1<<" => "<<flush;
  v1.mergeOr(v2);
  cout<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*NOT* 1 2 3) is merged into 0
  v1.insert(v1.begin(),Symbol("0"));
  iter1=v2.insert(v2.begin(),symNot);
  insertVDaughters(v2,iter1.end(),"1","2","3",NULL);
  cout<<v2<<" is merged into "<<v1<<" => "<<flush;
  v1.mergeOr(v2);
  cout<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*OR* 0 1 2) is merged into 0
  v1.insert(v1.begin(),Symbol("0"));
  iter1=v2.insert(v2.begin(),symOr);
  insertVDaughters(v2,iter1.end(),"0","1","2",NULL);
  cout<<v2<<" is merged into "<<v1<<" => "<<flush;
  v1.mergeOr(v2);
  cout<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*OR* 1 0) is merged into (*OR* (*OR* 0 1) 1 3)
  iter1=v1.insert(v1.begin(),symOr);
  iter2=v1.insert(iter1.end(),symOr);
  insertVDaughters(v1,iter2.end(),"0","1",NULL);
  insertVDaughters(v1,iter1.end(),"1","3",NULL);
  iter1=v2.insert(v2.begin(),symOr);
  insertVDaughters(v2,iter1.end(),"1","0",NULL);
  cout<<v2<<" is merged into "<<v1<<" => "<<flush;
  v1.mergeOr(v2);
  cout<<v1<<endl;
  v1.clear();
  v2.clear();

  // (*NOT* 1 0) is merged into(*OR* (*NOT* 0 1) 1 3)
  iter1=v1.insert(v1.begin(),symOr);
  iter2=v1.insert(iter1.end(),symNot);
  insertVDaughters(v1,iter2.end(),"0","1",NULL);
  insertVDaughters(v1,iter1.end(),"1","3",NULL);
  iter1=v2.insert(v2.begin(),symNot);
  insertVDaughters(v2,iter1.end(),"1","0",NULL);
  cout<<v2<<" is merged into "<<v1<<" => "<<flush;
  v1.mergeOr(v2);
  cout<<v1<<endl;
  v1.clear();
  v2.clear();

  return 0;
}
