// ======================================================================
// lexTst.cpp - Demonstrating how to install and search lexicons
// 
// 122502: Benjamin Han <benhdj@cs.cmu.edu> using namespace std.
// 102002: Benjamin Han <benhdj@cs.cmu.edu> Added new tests for findFirst()
//         and findNext() for both Lexicon and Lexicons.
// 120601: Benjamin Han <benhdj@cs.cmu.edu> Namespace added.
// 090301: Benjamin Han <benhdj@cs.cmu.edu> Minor revisions to supress warnings
//         under -pedantic -Wall.
// 081601: Benjamin Han <benhdj@cs.cmu.edu> Minor revisions of the comments.
// 071301: Benjamin Han <benhdj@cs.cmu.edu> Revised after changing lexicon.*.
// 062301: Benjamin Han <benhdj@cs.cmu.edu> Revised the way of initializing
//         an FS (calling FStruc::assign() instead of running equations).
// 061401: Benjamin Han <benhdj@cs.cmu.edu> Print the lexicons.
// 061201: Benjamin Han <benhdj@cs.cmu.edu> Created.
// ======================================================================

//    Copyright (C) 2000-2004 Benjamin Han <benhdj@cs.cmu.edu>
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "lexicon.hpp"

using namespace UKernel;
using namespace std;

int main () {
  Lexicon *lexiconPtr;
  Lexicons lexicons;
  Symbol symEng("ENG"),symGer("GER"),
    symCatN("N"),symCatV("V"),symRoot("ROOT"),symClass("CLASS");
  FStruc *fsPtr,fs,result(Symbol("RESULT"));
  Path path;
  Value v;
  int i;

  lexicons.addLexicon(symEng);
  lexicons.addLexicon(symGer);

  // ==================== add to the English lexicon ====================
  lexiconPtr=&lexicons.findLexicon(symEng);

  // (DOG ((CAT N) (ROOT DOG) (CLASS *ANIMAL*)))
  fsPtr=&lexiconPtr->addLex(Symbol("DOG"),symCatN);
  path.clear();
  path.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("DOG"));
  fsPtr->assign(path,v);
  path.clear();
  path.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*ANIMAL*"));
  fsPtr->assign(path,v);

  // (DOG ((CAT N) (ROOT CANINE) (CLASS *ANIMAL*)))
  fsPtr=&lexiconPtr->addLex(Symbol("DOG"),symCatN);
  path.clear();
  path.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("CANINE"));
  fsPtr->assign(path,v);
  path.clear();
  path.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*ANIMAL*"));
  fsPtr->assign(path,v);

  // (DOG ((CAT V) (ROOT DOG)))
  fsPtr=&lexiconPtr->addLex(Symbol("DOG"),symCatV);
  path.clear();
  path.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("DOG"));
  fsPtr->assign(path,v);

  // ==================== add to the German lexicon ====================
  lexiconPtr=&lexicons.findLexicon(symGer);

  // (DOG ((CAT N) (ROOT Hund) (CLASS *ANUMAL*)))
  fsPtr=&lexiconPtr->addLex(Symbol("DOG"),symCatN);
  path.clear();
  path.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("Hund"));
  fsPtr->assign(path,v);
  path.clear();
  path.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*ANIMAL*"));
  fsPtr->assign(path,v);

  // (DOG ((CAT N) (ROOT Schohund) (GEN FEM) (CLASS *ANUMAL*)))
  fsPtr=&lexiconPtr->addLex(Symbol("DOG"),symCatN);
  path.clear();
  path.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("Schohund"));
  fsPtr->assign(path,v);
  path.clear();
  path.push_back(Symbol("GEN"));
  v.clear();
  v.insert(v.begin(),Symbol("FEM"));
  fsPtr->assign(path,v);
  path.clear();
  path.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*ANIMAL*"));
  fsPtr->assign(path,v);

  // (DOG ((CAT V) (ROOT verfolgen)))
  fsPtr=&lexiconPtr->addLex(Symbol("DOG"),symCatV);
  path.clear();
  path.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("verfolgen"));
  fsPtr->assign(path,v);

  cout<<"==================== Installed lexicons ===================="<<endl;
  cout<<lexicons<<endl<<endl;

  // ==================== search tests ====================
  cout<<"==================== get-lex with ID ===================="<<endl;

  lexiconPtr=&lexicons.findLexicon(symEng);
  result.clear();
  lexiconPtr->findLex(Symbol("DOG"),symCatN,result);
  cout<<"* Find the 1st English noun \'DOG\':"<<endl
      <<result<<endl;

  result.clear();
  i=lexiconPtr->findLex(Symbol("DOG"),symCatN,result,true);
  cout<<"* Find all English nouns \'DOG\': "<<i<<" entries found"<<endl
      <<result<<endl;

  result.clear();
  lexiconPtr->findLex(Symbol("CAT"),symCatN,result);
  cout<<"* Find the 1st English noun \'CAT\':"<<endl
      <<result<<endl<<endl;

  lexiconPtr=&lexicons.findLexicon(symGer);
  result.clear();
  lexiconPtr->findLex(Symbol("DOG"),symCatN,result);
  cout<<"* Find the 1st German noun \'DOG\':"<<endl
      <<result<<endl;

  result.clear();
  i=lexiconPtr->findLex(Symbol("DOG"),symCatN,result,true);
  cout<<"* Find all German nouns \'DOG\': "<<i<<" entries found"<<endl
      <<result<<endl;

  result.clear();
  lexiconPtr->findLex(Symbol("CAT"),symCatN,result);
  cout<<"* Find the 1st German noun \'CAT\':"<<endl
      <<result<<endl;

  cout<<endl<<"==================== get-lex without ID ===================="<<endl;

  result.clear();
  lexicons.findLex(Symbol("DOG"),symCatN,result);
  cout<<"* Find the 1st noun \'DOG\':"<<endl<<result<<endl;

  result.clear();
  i=lexicons.findLex(Symbol("DOG"),symCatN,result,true);
  cout<<"* Find all nouns \'DOG\': "<<i<<" entries found"<<endl
      <<result<<endl;

  result.clear();
  lexicons.findLex(Symbol("CAT"),symCatN,result);
  cout<<"* Find the 1st noun \'CAT\':"<<endl<<result<<endl;

  cout<<endl<<"==================== get-lex-fs with cat and ID ===================="<<endl;

  // initialize fs
  fs.setName(Symbol("KEY"));
  path.clear();
  path.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*ANIMAL*"));
  fs.assign(path,v);
  cout<<fs<<endl;

  lexiconPtr=&lexicons.findLexicon(symEng);
  result.clear();
  lexiconPtr->findLex(Symbol("DOG"),symCatN,fs,result);
  cout<<"* Find the 1st English noun \'DOG\' with KEY:"<<endl
      <<result<<endl;

  result.clear();
  i=lexiconPtr->findLex(Symbol("DOG"),symCatN,fs,result,true);
  cout<<"* Find all English nouns \'DOG\' with KEY: "<<i<<" entries found"<<endl
      <<result<<endl;

  // re-initialize fs
  path.clear();
  path.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*PLANT*"));
  fs.assign(path,v);
  cout<<endl<<fs<<endl;

  result.clear();
  lexiconPtr->findLex(Symbol("DOG"),symCatN,fs,result);
  cout<<"* Find the 1st English noun \'DOG\' with KEY:"<<endl
      <<result<<endl;

  cout<<endl<<"==================== get-lex-fs with ID but not cat ===================="<<endl;

  // re-initialize fs
  fs.clear();
  path.clear();
  path.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("DOG"));
  fs.assign(path,v);
  cout<<fs<<endl;

  result.clear();
  lexiconPtr->findLex(Symbol("DOG"),fs,result);
  cout<<"* Find the 1st English word \'DOG\' with KEY:"<<endl
      <<result<<endl;

  result.clear();
  i=lexiconPtr->findLex(Symbol("DOG"),fs,result,true);
  cout<<"* Find all English words \'DOG\' with KEY: "<<i<<" entries found"<<endl
      <<result<<endl;

  cout<<endl<<"==================== get-lex-fs with cat but no ID ===================="<<endl;

  // re-initialize fs
  fs.clear();
  path.clear();
  path.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*ANIMAL*"));
  fs.assign(path,v);
  cout<<fs<<endl;

  result.clear();
  lexicons.findLex(Symbol("DOG"),symCatN,fs,result);
  cout<<"* Find the 1st noun \'DOG\' with KEY:"<<endl<<result<<endl;

  result.clear();
  i=lexicons.findLex(Symbol("DOG"),symCatN,fs,result,true);
  cout<<"* Find all nouns \'DOG\' with KEY: "<<i<<" entries found"<<endl
      <<result<<endl;

  // re-initialize fs
  path.clear();
  path.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*PLANT*"));
  fs.assign(path,v);
  cout<<endl<<fs<<endl;

  result.clear();
  lexicons.findLex(Symbol("DOG"),symCatN,fs,result);
  cout<<"* Find the 1st noun \'DOG\' with KEY:"<<endl<<result<<endl;

  cout<<endl<<"==================== get-lex-fs with no ID and no cat ===================="<<endl;

  // re-initialize fs
  fs.clear();
  path.clear();
  path.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("DOG"));
  fs.assign(path,v);
  cout<<fs<<endl;

  result.clear();
  lexicons.findLex(Symbol("DOG"),fs,result);
  cout<<"* Find the 1st word \'DOG\' with KEY:"<<endl<<result<<endl;

  result.clear();
  i=lexicons.findLex(Symbol("DOG"),fs,result,true);
  cout<<"* Find all words \'DOG\' with KEY: "<<i<<" entries found"<<endl
      <<result<<endl;

  // ==================== findFirst() and findNext() ====================

  cout<<"==================== findFirst/Next with cat and ID ===================="<<endl;

  lexiconPtr=&lexicons.findLexicon(symEng);
  result.clear();
  lexiconPtr->findFirst(Symbol("DOG"),symCatN,result);
  cout<<"* Find the 1st English noun \'DOG\':"<<endl
      <<result<<endl;

  result.clear();
  if (lexiconPtr->findNext(result))
    cout<<"* Find the next English noun \'DOG\':"<<endl
	<<result<<endl;

  result.clear();
  if (lexiconPtr->findNext(result))
    cout<<"* Find the next English noun \'DOG\':"<<endl
	<<result<<endl;

  cout<<"==================== findFirst/Next with cat, ID and fs ===================="<<endl;

  // initialize fs
  fs.clear();
  fs.setName(Symbol("KEY"));
  path.clear();
  path.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*ANIMAL*"));
  fs.assign(path,v);
  cout<<fs<<endl;

  lexiconPtr=&lexicons.findLexicon(symEng);
  result.clear();
  lexiconPtr->findFirst(Symbol("DOG"),symCatN,fs,result);
  cout<<"* Find the 1st English noun \'DOG\' with KEY:"<<endl
      <<result<<endl;

  result.clear();
  if (lexiconPtr->findNext(result))
    cout<<"* Find the next English noun \'DOG\' with KEY:"<<endl
	<<result<<endl;

  result.clear();
  if (lexiconPtr->findNext(result))
    cout<<"* Find the next English noun \'DOG\' with KEY:"<<endl
	<<result<<endl;

  cout<<"==================== findFirst/Next with ID and fs ===================="<<endl;

  // initialize fs
  fs.clear();
  fs.setName(Symbol("KEY"));
  path.clear();
  path.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*ANIMAL*"));
  fs.assign(path,v);
  cout<<fs<<endl;

  lexiconPtr=&lexicons.findLexicon(symEng);
  result.clear();
  lexiconPtr->findFirst(Symbol("DOG"),fs,result);
  cout<<"* Find the 1st English word \'DOG\' with KEY:"<<endl
      <<result<<endl;

  result.clear();
  if (lexiconPtr->findNext(result))
    cout<<"* Find the next English word \'DOG\' with KEY:"<<endl
	<<result<<endl;

  result.clear();
  if (lexiconPtr->findNext(result))
    cout<<"* Find the next English word \'DOG\' with KEY:"<<endl
	<<result<<endl;

  cout<<"==================== findFirst/Next with ID and empty fs ===================="<<endl;

  // initialize fs
  fs.clear();
  cout<<fs<<endl;

  lexiconPtr=&lexicons.findLexicon(symEng);
  result.clear();
  lexiconPtr->findFirst(Symbol("DOG"),fs,result);
  cout<<"* Find the 1st English word \'DOG\' with KEY:"<<endl
      <<result<<endl;

  result.clear();
  if (lexiconPtr->findNext(result))
    cout<<"* Find the next English word \'DOG\' with KEY:"<<endl
	<<result<<endl;

  result.clear();
  if (lexiconPtr->findNext(result))
    cout<<"* Find the next English word \'DOG\' with KEY:"<<endl
	<<result<<endl;

  // Following are tests for lexicons::findFirst() and findNext()

  cout<<"==================== findFirst/Next with cat ===================="<<endl;

  result.clear();
  lexicons.findFirst(Symbol("DOG"),symCatN,result);
  cout<<"* Find the 1st noun \'DOG\':"<<endl
      <<result<<endl;

  result.clear();
  if (lexicons.findNext(result))
    cout<<"* Find the next noun \'DOG\':"<<endl
	<<result<<endl;

  result.clear();
  if (lexicons.findNext(result))
    cout<<"* Find the next noun \'DOG\':"<<endl
	<<result<<endl;

  cout<<"==================== findFirst/Next with cat and fs ===================="<<endl;

  // initialize fs
  fs.clear();
  fs.setName(Symbol("KEY"));
  path.clear();
  path.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*ANIMAL*"));
  fs.assign(path,v);
  cout<<fs<<endl;

  result.clear();
  lexicons.findFirst(Symbol("DOG"),symCatN,fs,result);
  cout<<"* Find the 1st noun \'DOG\' with KEY:"<<endl
      <<result<<endl;

  result.clear();
  if (lexicons.findNext(result))
    cout<<"* Find the next noun \'DOG\' with KEY:"<<endl
	<<result<<endl;

  result.clear();
  if (lexicons.findNext(result))
    cout<<"* Find the next noun \'DOG\' with KEY:"<<endl
	<<result<<endl;

  cout<<"==================== findFirst/Next with fs ===================="<<endl;

  // initialize fs
  fs.clear();
  fs.setName(Symbol("KEY"));
  path.clear();
  path.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*ANIMAL*"));
  fs.assign(path,v);
  cout<<fs<<endl;

  result.clear();
  lexicons.findFirst(Symbol("DOG"),fs,result);
  cout<<"* Find the 1st word \'DOG\' with KEY:"<<endl
      <<result<<endl;

  result.clear();
  if (lexicons.findNext(result))
    cout<<"* Find the next word \'DOG\' with KEY:"<<endl
	<<result<<endl;

  result.clear();
  if (lexicons.findNext(result))
    cout<<"* Find the next word \'DOG\' with KEY:"<<endl
	<<result<<endl;

  cout<<"==================== findFirst/Next with empty fs ===================="<<endl;

  // initialize fs
  fs.clear();
  cout<<fs<<endl;

  result.clear();
  lexicons.findFirst(Symbol("DOG"),fs,result);
  cout<<"* Find the 1st word \'DOG\' with KEY:"<<endl
      <<result<<endl;

  result.clear();
  if (lexicons.findNext(result))
    cout<<"* Find the next word \'DOG\' with KEY:"<<endl
	<<result<<endl;

  result.clear();
  if (lexicons.findNext(result))
    cout<<"* Find the next word \'DOG\' with KEY:"<<endl
	<<result<<endl;

  return 0;
}
