// ======================================================================
// grammar.cpp - A unification-based grammar.
// 
// 081304: Benjamin Han <benhdj@cs.cmu.edu> Now using global arrowLex and
//         arrowNonLex for printing lexical and non-lexical grammar rules.
// 061504: Benjamin Han <benhdj@cs.cmu.edu> bug fixed in operator << for RHS:
//         looping now covers every RHS (missed one before!)
// 011403: Benjamin Han <benhdj@cs.cmu.edu> Revised using yet a new
//         implementation of the CFG module: now it's conditional compilation
//         for either analysis (UK_ANALYSIS) or generation (UK_GENERATION);
//         printing appropriate arrows is now hard coded (conditional compile).
// 120601: Benjamin Han <benhdj@cs.cmu.edu> Major revision to use the new
//         cfg.hpp in Toolbox; changed Literal to RLiteral; namespace added.
// 080501: Benjamin Han <benhdj@cs.cmu.edu> Changed RHS::lexical to 
//         RHS::charLevel.
// 071301: Benjamin Han <benhdj@cs.cmu.edu> Minor revisions after the 
//         implementation of extension functions.
// 062901: Benjamin Han <benhdj@cs.cmu.edu> Moved FSRegisters into equation.*.
// 061901: Benjamin Han <benhdj@cs.cmu.edu> From now on the difference between
//         a lexical and a non-lexical rule is that the former inserts spaces
//         between the RHS literals - both lexical and non-lexical rules can
//         have RHS NT or terminals; revised the RHS printing.
// 061501: Benjamin Han <benhdj@cs.cmu.edu> Now printing a Grmmar will print
//         out the right arrows based on Grammar::dir.
// 061401: Benjamin Han <benhdj@cs.cmu.edu> Non-lexical rules can now have RHS
//         terminals by introducing Literals.
// 061201: Benjamin Han <benhdj@cs.cmu.edu> Moved from Generator to UKernel.
// 052901: Benjamin Han <benhdj@cs.cmu.edu> Created.
// ======================================================================

//    Copyright (C) 2000-2004 Benjamin Han <benhdj@cs.cmu.edu>
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "grammar.hpp"

namespace UKernel {

#ifdef UK_ANALYSIS
  const std::string arrowLex="<--";
  const std::string arrowNonLex="<==";  
#elif defined UK_GEN
  const std::string arrowLex="-->";
  const std::string arrowNonLex="==>";
#endif


// print one single RLiteral
std::ostream &operator << (std::ostream &os, const RLiteral &r) {
  if (r.nt) os<<'<'<<r.sym<<'>';
  else os<<r.sym;
  return os;
}

// print an RHS
std::ostream &operator << (std::ostream &os, const RHS<RLiteral> &rhs) {
  RHS<RLiteral>::const_iterator ri;
  bool notFirst=false;

  for (ri=rhs.begin();ri!=rhs.end();++ri) {
    if (notFirst) os<<' ';
    else notFirst=true;
    os<<*ri;
  }

  return os;
}

// indented printing of the entire grammar
std::ostream &operator << (std::ostream &os, Grammar &g) {
  Grammar::Iterator gi,giEnd;
  Grammar::RuleIterator ri,riFirst,riLast;
  bool notFirst=false;

  giEnd=g.end();
  for (gi=g.begin();gi!=giEnd;++gi) {
    riFirst=gi.first();
    riLast=gi.last();
    for (ri=riFirst;;++ri) {
      if (notFirst) os<<std::endl<<std::endl;
      else notFirst=true;

      os<<"(<"<<gi.readLHS()<<"> "<<(ri->body.charLevel?arrowLex:arrowNonLex)<<" ("
	<<ri->readRHS()<<')'<<std::endl<<indent(2)<<"  "<<ri->body.eBlock<<')'<<indent(-2);

      if (ri==riLast) break;
    }
  }

  return os;
}

};
