// ======================================================================
// graTstSub.cpp - Sub-program for graTst.cpp
// 
// 081304  Benjamin Han <benhdj@cs.cmu.edu> Changed the toy grammar so we can
//         test mixing non-terminals with terminals and the space-adding behavior
//         (see rules <N> --> (<BREED> D O G) and <BREED> ==> (%) ); incidentally
//         this also shows the difference between fork and plain mode in the
//         generator.
// 110602  Benjamin Han <benhdj@cs.cmu.edu> Changed one instance of EBlockMain()
//         call to reflect changes in eBlock.hpp.
// 091602  Benjamin Han <benhdj@cs.cmu.edu> Changed the last equation of rule 
//         "<NP> ==> (<N>)" from "X2=X0" to "X1=X0" (heck X2 doesn't even exist
//         in this rule!).
// 120601: Benjamin Han <benhdj@cs.cmu.edu> Revised to work with the updated
//         grammar API; added makePath(); namespace added.
// 092601: Benjamin Han <benhdj@cs.cmu.edu> Revised to work with the updated
//         grammar API.
// 090601: Benjamin Han <benhdj@cs.cmu.edu> Changed Symbol::OP_EQUAL to
//         Symbol::OP_TEST; changed "=c" to "=t" in the comments.
// 090301: Benjamin Han <benhdj@cs.cmu.edu> Minor revisions to supress warnings
//         under -pedantic -Wall.
// 081601: Benjamin Han <benhdj@cs.cmu.edu> Minor comments revision.
// 080501: Benjamin Han <benhdj@cs.cmu.edu> Changed RHS::lexical to 
//         RHS::charLevel.
// 071301: Benjamin Han <benhdj@cs.cmu.edu> Changed the way the lexical lookup
//         equation is installed.
// 063001: Benjamin Han <benhdj@cs.cmu.edu> Added some never-supposed-to-be-
//         effective equations in *EOR* and *CASE* equation blocks to test
//         if daughter blocks are truly independent.
// 062901: Benjamin Han <benhdj@cs.cmu.edu> Revised after changing the way
//         an FS is addressed in initializing equations.
// 062301: Benjamin Han <benhdj@cs.cmu.edu> Revised the way of initializing
//         an FS (calling FStruc::assign() instead of running equations).
// 062101: Benjamin Han <benhdj@cs.cmu.edu> Revised comments to ensure
//         consistent quoting for get-lex/get-lex-fs.
// 061901: Benjamin Han <benhdj@cs.cmu.edu> From now on the difference between
//         a lexical and a non-lexical rule is that the former inserts spaces
//         between the RHS literals - both lexical and non-lexical rules can
//         have RHS NT or terminals; revised the initialization of a RHS: now
//         even for lexical rules we need to specify Literal::nt=false if the
//         RHS literal is not a NT.
// 061801: Benjamin Han <benhdj@cs.cmu.edu> Revised the grammar to include
//         examples for *CASE* and *EOR* equation blocks.
// 061501: Benjamin Han <benhdj@cs.cmu.edu> Included tests on lexical
//         lookups and wildcard rules.
// 061201: Benjamin Han <benhdj@cs.cmu.edu> Created.
// ======================================================================

//    Copyright (C) 2000-2004 Benjamin Han <benhdj@cs.cmu.edu>
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "grammar.hpp"

#include <stdarg.h>

using namespace UKernel;

void makePath (Path &path, char *first, ...)
{
  va_list argp;
  char *ptr;

  path.clear();
  if (first==NULL) return;

  path.push_back(Symbol(first));

  for (va_start(argp,first);(ptr=va_arg(argp,char*))!=NULL;
       path.push_back(Symbol(ptr)));
  va_end(argp);
}

void installLexicons (Lexicons &lexicons) {
  Symbol symEng("ENG"),
    symCatD("D"),symCatN("N"),symCatV("V"),symCatP("P"),
    symRoot("ROOT");
  Path path;
  FStruc *fsPtr;
  Value v;
  
  // +---------------------------------------------------------+
  // |                Install the toy lexicons                 |
  // +---------------------------------------------------------+
  
  Lexicon &lexiconEng=lexicons.addLexicon(symEng);

  // (A ((CAT D) (ROOT A) (FIN -)))
  fsPtr=&lexiconEng.addLex(Symbol("A"),symCatD);
  path.clear();
  path.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("A"));
  fsPtr->assign(path,v);
  path.clear();
  path.push_back(Symbol("FIN"));
  v.clear();
  v.insert(v.begin(),Symbol("-"));
  fsPtr->assign(path,v);

  // (THE ((CAT D) (ROOT THE) (FIN +)))
  fsPtr=&lexiconEng.addLex(Symbol("THE"),symCatD);
  path.clear();
  path.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("THE"));
  fsPtr->assign(path,v);
  path.clear();
  path.push_back(Symbol("FIN"));
  v.clear();
  v.insert(v.begin(),Symbol("+"));
  fsPtr->assign(path,v);

  // (DOG ((CAT N) (ROOT DOG) (NUM SG)))
  fsPtr=&lexiconEng.addLex(Symbol("DOG"),symCatN);
  path.clear();
  path.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("DOG"));
  fsPtr->assign(path,v);
  path.clear();
  path.push_back(Symbol("NUM"));
  v.clear();
  v.insert(v.begin(),Symbol("SG"));
  fsPtr->assign(path,v);

  // (GIRL ((CAT N) (ROOT GIRL) (NUM SG)))
  fsPtr=&lexiconEng.addLex(Symbol("GIRL"),symCatN);
  path.clear();
  path.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("GIRL"));
  fsPtr->assign(path,v);
  path.clear();
  path.push_back(Symbol("NUM"));
  v.clear();
  v.insert(v.begin(),Symbol("SG"));
  fsPtr->assign(path,v);

  // (TOOTH ((CAT N) (ROOT TOOTH) (NUM SG)))
  fsPtr=&lexiconEng.addLex(Symbol("TOOTH"),symCatN);
  path.clear();
  path.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("TEETH"));
  fsPtr->assign(path,v);
  path.clear();
  path.push_back(Symbol("NUM"));
  v.clear();
  v.insert(v.begin(),Symbol("PL"));
  fsPtr->assign(path,v);

  // (BITE ((CAT N) (ROOT BITES) (NUM SG) (PERS 3) (TENSE PRES)))
  fsPtr=&lexiconEng.addLex(Symbol("BITE"),symCatV);
  path.clear();
  path.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("BITES"));
  fsPtr->assign(path,v);
  path.clear();
  path.push_back(Symbol("NUM"));
  v.clear();
  v.insert(v.begin(),Symbol("SG"));
  fsPtr->assign(path,v);
  path.clear();
  path.push_back(Symbol("PERS"));
  v.clear();
  v.insert(v.begin(),Symbol("3"));
  fsPtr->assign(path,v);
  path.clear();
  path.push_back(Symbol("TENSE"));
  v.clear();
  v.insert(v.begin(),Symbol("PRES"));
  fsPtr->assign(path,v);

  // (WITH ((CAT P) (ROOT WITH)))
  fsPtr=&lexiconEng.addLex(Symbol("WITH"),symCatP);
  path.clear();
  path.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("WITH"));
  fsPtr->assign(path,v);
}

void installGrammar (Grammar &g) {
  Grammar::RHS rhs;
  RuleBody *rbPtr;
  Path lPath,rPath;
  FSPath *fsPathPtr;
  FStruc *fsPtr;
  Value *vPtr;
  Value v;
  EFArgs req,opt;
  Symbol symEng("ENG"),symCatN("N"),symRoot("ROOT");
  FStruc keyFS;
  EBlockCase *ebCasePtr;
  EBlockEor *ebEorPtr;
  EBlockMain *ebMainPtr;

  // +---------------------------------------------------------+
  // |                Install the toy grammar                  |
  // +---------------------------------------------------------+

  // NOTE: enough register space will be implicitly created by
  // Grammar::addRule(), as long as you don't use a bigger register
  // index in creating equations than the number of the RHS non-terminals.

  // ******** Rule: <S> ==> (<NP> <VP>) ********************************
  rhs.clear();
  rhs.push_back(RLiteral(Symbol("NP")));
  rhs.push_back(RLiteral(Symbol("VP")));
  rbPtr=&g.addRule(Symbol("S"),rhs);

  // -------- Equ: X1 == (X0 SUBJ)
  makePath(lPath,NULL);
  makePath(rPath,"SUBJ",NULL);
  rbPtr->
    eBlock.addBlock(new EBlockMain(1,lPath,0,rPath,
				   Symbol::OP_REMOVE_ASSIGN));

  // -------- Equ: (X2 PERS) = (X1 PERS)
  makePath(lPath,"PERS",NULL);
  makePath(rPath,"PERS",NULL);
  rbPtr->
    eBlock.addBlock(new EBlockMain(2,lPath,1,rPath,
				   Symbol::OP_PSEUDO_UNIFY));

  // -------- Equ: (X2 NUM) = (X1 NUM)
  makePath(lPath,"NUM",NULL);
  makePath(rPath,"NUM",NULL);
  rbPtr->
    eBlock.addBlock(new EBlockMain(2,lPath,1,rPath,
				   Symbol::OP_PSEUDO_UNIFY));

  // -------- Equ: X2 = X0
  makePath(lPath,NULL);
  makePath(rPath,NULL);
  rbPtr->
    eBlock.addBlock(new EBlockMain(2,lPath,0,rPath,
				   Symbol::OP_PSEUDO_UNIFY));

  // ******** Rule: <NP> ==> (<DET> <N>) ********************************
  rhs.clear();
  rhs.push_back(RLiteral(Symbol("DET")));
  rhs.push_back(RLiteral(Symbol("N")));
  rbPtr=&g.addRule(Symbol("NP"),rhs);

  // -------- Equ: (X0 FIN) = *DEFINED*
  makePath(lPath,"FIN",NULL);
  makePath(rPath,NULL);
  rbPtr->
    eBlock.addBlock(new EBlockMain(0,lPath,Symbol::DEFINED));

  // -------- Equ: (X1 FIN) == (X0 FIN)
  makePath(lPath,"FIN",NULL);
  makePath(rPath,"FIN",NULL);
  rbPtr->
    eBlock.addBlock(new EBlockMain(1,lPath,0,rPath,
				   Symbol::OP_REMOVE_ASSIGN));

  // -------- Equ: (X1 NUM) <= (X0 NUM)
  makePath(lPath,"NUM",NULL);
  makePath(rPath,"NUM",NULL);
  rbPtr->
    eBlock.addBlock(new EBlockMain(1,lPath,0,rPath,
				   Symbol::OP_ASSIGN));

  // -------- Equ: X2 = X0
  makePath(lPath,NULL);
  makePath(rPath,NULL);
  rbPtr->
    eBlock.addBlock(new EBlockMain(2,lPath,0,rPath,
				   Symbol::OP_PSEUDO_UNIFY));

  // ******** Rule: <NP> ==> (<N>) ********************************
  rhs.clear();
  rhs.push_back(RLiteral(Symbol("N")));
  rbPtr=&g.addRule(Symbol("NP"),rhs);

  // -------- Equ: (X0 FIN) = *UNDEFINED*
  makePath(lPath,"FIN",NULL);
  makePath(rPath,NULL);
  rbPtr->
    eBlock.addBlock(new EBlockMain(0,lPath,Symbol::UNDEFINED));
  
  // -------- Equ: X1 = X0
  makePath(lPath,NULL);
  makePath(rPath,NULL);
  rbPtr->
    eBlock.addBlock(new EBlockMain(1,lPath,0,rPath,
				   Symbol::OP_PSEUDO_UNIFY));

  // ******** Rule: <DET> --> (T H E) ********************************
  rhs.clear();
  rhs.push_back(RLiteral(Symbol("T"),false));
  rhs.push_back(RLiteral(Symbol("H"),false));
  rhs.push_back(RLiteral(Symbol("E"),false));
  rbPtr=&g.addRule(Symbol("DET"),rhs,true);

  // -------- Equ: (X0 FIN) = +
  makePath(lPath,"FIN",NULL);
  makePath(rPath,NULL);
  v.clear();
  v.insert(v.begin(),Symbol("+"));
  rbPtr->
    eBlock.addBlock(new EBlockMain(0,lPath,v,Symbol::OP_PSEUDO_UNIFY));
  
  // ******** Rule: <DET> --> (A) ********************************
  rhs.clear();
  rhs.push_back(RLiteral(Symbol("A"),false));
  rbPtr=&g.addRule(Symbol("DET"),rhs,true);

  // -------- Equ: (X0 FIN) = -
  makePath(lPath,"FIN",NULL);
  makePath(rPath,NULL);
  v.clear();
  v.insert(v.begin(),Symbol("-"));
  rbPtr->
    eBlock.addBlock(new EBlockMain(0,lPath,v,Symbol::OP_PSEUDO_UNIFY));
  
  // -------- Equ: (X0 NUM) = SG
  makePath(lPath,"NUM",NULL);
  makePath(rPath,NULL);
  v.clear();
  v.insert(v.begin(),Symbol("SG"));
  rbPtr->
    eBlock.addBlock(new EBlockMain(0,lPath,v,Symbol::OP_PSEUDO_UNIFY));
  
  // ******** Rule: <N> --> (<BREED> D O G) ********************************
  rhs.clear();
  rhs.push_back(RLiteral(Symbol("BREED")));
  rhs.push_back(RLiteral(Symbol("D"),false));
  rhs.push_back(RLiteral(Symbol("O"),false));
  rhs.push_back(RLiteral(Symbol("G"),false));
  rbPtr=&g.addRule(Symbol("N"),rhs,true);

  // -------- Equ: (X0 PRED) = DOG
  makePath(lPath,"PRED",NULL);
  makePath(rPath,NULL);
  v.clear();
  v.insert(v.begin(),Symbol("DOG"));
  rbPtr->
    eBlock.addBlock(new EBlockMain(0,lPath,v,Symbol::OP_PSEUDO_UNIFY));
  
  // -------- Equ: (X0 NUM) = SG
  makePath(lPath,"NUM",NULL);
  makePath(rPath,NULL);
  v.clear();
  v.insert(v.begin(),Symbol("SG"));
  rbPtr->
    eBlock.addBlock(new EBlockMain(0,lPath,v,Symbol::OP_PSEUDO_UNIFY));

  // -------- Equ: X1 = (X0 BREED)
  makePath(lPath,NULL);
  makePath(rPath,"BREED",NULL);
  rbPtr->
    eBlock.addBlock(new EBlockMain(1,lPath,0,rPath,
				   Symbol::OP_PSEUDO_UNIFY));
  
  // ******** Rule: <BREED> ==> (%) ********************************
  rhs.clear();
  rhs.push_back(RLiteral(Symbol("%"),false));
  rbPtr=&g.addRule(Symbol("BREED"),rhs);

  // -------- Equ: (*CASE* X0
  //                   (PITBULL (((X1 VALUE) <= BIG_)))
  //                   (CHIHUAHUA (((X1 VALUE) <= SMALL_))))
  makePath(lPath,NULL);
  ebCasePtr=new EBlockCase(0,lPath);

  ebMainPtr=new EBlockMain();
  rPath.clear();  lPath.clear();
  lPath.push_back(symValue);
  v.clear();
  v.insert(v.begin(),Symbol("BIG_"));
  ebMainPtr->addBlock(new EBlockMain(1,lPath,v,Symbol::OP_ASSIGN));
  v.clear();
  v.insert(v.begin(),Symbol("PITBULL"));
  ebCasePtr->addCaseBlock(v,ebMainPtr);

  ebMainPtr=new EBlockMain();
  rPath.clear();  lPath.clear();
  lPath.push_back(symValue);
  v.clear();
  v.insert(v.begin(),Symbol("SMALL_"));
  ebMainPtr->addBlock(new EBlockMain(1,lPath,v,Symbol::OP_ASSIGN));
  v.clear();
  v.insert(v.begin(),Symbol("CHIHUAHUA"));
  ebCasePtr->addCaseBlock(v,ebMainPtr);

  rbPtr->eBlock.addBlock(ebCasePtr);

  // ******** Rule: <N> --> (%) ********************************
  rhs.clear();
  rhs.push_back(RLiteral(Symbol("%"),false));
  rbPtr=&g.addRule(Symbol("N"),rhs,true);

  // -------- Equ: X1 == (X0 PRED)
  makePath(lPath,NULL);
  makePath(rPath,"PRED",NULL);
  rbPtr->
    eBlock.addBlock(new EBlockMain(1,lPath,0,rPath,
				   Symbol::OP_REMOVE_ASSIGN));

  // -------- Equ: X0 = (GET-LEX-FS X1 '((CAT N)) :LEX-ID 'ENG)
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=1;
  fsPtr=&req.newFS();
  lPath.clear();
  lPath.push_back(symCat);
  v.clear();
  v.insert(v.begin(),symCatN);
  fsPtr->assign(lPath,v);
  opt.clear();
  vPtr=&opt.newValue(symLexID);
  vPtr->insert(vPtr->begin(),symEng);
  rPath.clear();  lPath.clear();
  rbPtr->
    eBlock.addBlock(new EBlockMain(0,lPath,symGetLexFS,req,opt,
				   Symbol::OP_PSEUDO_UNIFY,g));
  
  // -------- Equ: (X1 VALUE) <= (X0 ROOT)
  rPath.clear();  lPath.clear();
  lPath.push_back(symValue);
  rPath.push_back(symRoot);
  rbPtr->
    eBlock.addBlock(new EBlockMain(1,lPath,0,rPath,
				   Symbol::OP_ASSIGN));

  // ******** Rule: <VP> ==> (SUDDENLY <V> <NP>) ********************************
  rhs.clear();
  rhs.push_back(RLiteral(Symbol("SUDDENLY"),false));
  rhs.push_back(RLiteral(Symbol("V")));
  rhs.push_back(RLiteral(Symbol("NP")));
  rbPtr=&g.addRule(Symbol("VP"),rhs);

  // -------- Equ: (X0 INST) = *UNDEFINED*
  makePath(lPath,"INST",NULL);
  makePath(rPath,NULL);
  rbPtr->
    eBlock.addBlock(new EBlockMain(0,lPath,Symbol::UNDEFINED));
  
  // -------- Equ: X3 == (X0 OBJ)
  makePath(lPath,NULL);
  makePath(rPath,"OBJ",NULL);
  rbPtr->
    eBlock.addBlock(new EBlockMain(3,lPath,0,rPath,
				   Symbol::OP_REMOVE_ASSIGN));

  // -------- Equ: X2 = X0
  rPath.clear();  lPath.clear();
  rbPtr->
    eBlock.addBlock(new EBlockMain(2,lPath,0,rPath,
				   Symbol::OP_PSEUDO_UNIFY));

  // ******** Rule: <VP> ==> (WITHOUT_A_BLINK <V> <NP> <PP'>) ********************************
  rhs.clear();
  rhs.push_back(RLiteral(Symbol("WITHOUT_A_BLINK"),false));
  rhs.push_back(RLiteral(Symbol("V")));
  rhs.push_back(RLiteral(Symbol("NP")));
  rhs.push_back(RLiteral(Symbol("PP\'")));
  rbPtr=&g.addRule(Symbol("VP"),rhs);

  // -------- Equ: X4 == (X0 INST)
  makePath(lPath,NULL);
  makePath(rPath,"INST",NULL);
  rbPtr->
    eBlock.addBlock(new EBlockMain(4,lPath,0,rPath,
				   Symbol::OP_REMOVE_ASSIGN));

  // -------- Equ: X3 == (X0 OBJ)
  makePath(lPath,NULL);
  makePath(rPath,"OBJ",NULL);
  rbPtr->
    eBlock.addBlock(new EBlockMain(3,lPath,0,rPath,
				   Symbol::OP_REMOVE_ASSIGN));

  // -------- Equ: X2 = X0
  makePath(lPath,NULL);
  makePath(rPath,NULL);
  rbPtr->
    eBlock.addBlock(new EBlockMain(2,lPath,0,rPath,
				   Symbol::OP_PSEUDO_UNIFY));

  // ******** Rule: <VP> ==> (% <V> <NP> % <PP>) ********************************
  rhs.clear();
  rhs.push_back(RLiteral(Symbol("%"),false));
  rhs.push_back(RLiteral(Symbol("V")));
  rhs.push_back(RLiteral(Symbol("NP")));
  rhs.push_back(RLiteral(Symbol("%"),false));
  rhs.push_back(RLiteral(Symbol("PP")));
  rbPtr=&g.addRule(Symbol("VP"),rhs);

  // -------- Equ: X5 == (X0 INST)
  makePath(lPath,NULL);
  makePath(rPath,"INST",NULL);
  rbPtr->
    eBlock.addBlock(new EBlockMain(5,lPath,0,rPath,
				   Symbol::OP_REMOVE_ASSIGN));

  // -------- Equ: X3 == (X0 OBJ)
  makePath(lPath,NULL);
  makePath(rPath,"OBJ",NULL);
  rbPtr->
    eBlock.addBlock(new EBlockMain(3,lPath,0,rPath,
				   Symbol::OP_REMOVE_ASSIGN));

  // -------- Equ: X2 = X0
  makePath(lPath,NULL);
  makePath(rPath,NULL);
  rbPtr->
    eBlock.addBlock(new EBlockMain(2,lPath,0,rPath,
				   Symbol::OP_PSEUDO_UNIFY));

  // -------- Equ: (X1 VALUE) <= ALL_OF_A_SUDDEN
  rPath.clear();  lPath.clear();
  lPath.push_back(symValue);
  v.clear();
  v.insert(v.begin(),Symbol("ALL_OF_A_SUDDEN"));
  rbPtr->
    eBlock.addBlock(new EBlockMain(1,lPath,v,Symbol::OP_ASSIGN));
  
  // -------- Equ: (*EOR* (((X1 VALUE) <= *SHOULD_NOT_GENERATE_THIS*)
  //                       ((X3 COAT_COLOR) =t RED)
  //                       ((X4 VALUE) <= IN_RED))
  //                      (((X3 COAT_COLOR) =t WHITE)
  //                       ((X4 VALUE) <= IN_WHITE)))
  ebEorPtr=new EBlockEor();

  ebMainPtr=new EBlockMain();
  rPath.clear();  lPath.clear();
  lPath.push_back(symValue);
  v.clear();
  v.insert(v.begin(),Symbol("*SHOULD_NOT_GENERATE_THIS*"));
  ebMainPtr->addBlock(new EBlockMain(1,lPath,v,Symbol::OP_ASSIGN));
  makePath(lPath,"COAT_COLOR",NULL);
  makePath(rPath,NULL);
  v.clear();
  v.insert(v.begin(),Symbol("RED"));
  ebMainPtr->addBlock(new EBlockMain(3,lPath,v,Symbol::OP_TEST));
  rPath.clear();  lPath.clear();
  lPath.push_back(symValue);
  v.clear();
  v.insert(v.begin(),Symbol("IN_RED"));
  ebMainPtr->addBlock(new EBlockMain(4,lPath,v,Symbol::OP_ASSIGN));
  ebEorPtr->addBlock(ebMainPtr);

  ebMainPtr=new EBlockMain();
  makePath(lPath,"COAT_COLOR",NULL);
  makePath(rPath,NULL);
  v.clear();
  v.insert(v.begin(),Symbol("WHITE"));
  ebMainPtr->addBlock(new EBlockMain(3,lPath,v,Symbol::OP_TEST));
  rPath.clear();  lPath.clear();
  lPath.push_back(symValue);
  v.clear();
  v.insert(v.begin(),Symbol("IN_WHITE"));
  ebMainPtr->addBlock(new EBlockMain(4,lPath,v,Symbol::OP_ASSIGN));
  ebEorPtr->addBlock(ebMainPtr);

  rbPtr->eBlock.addBlock(ebEorPtr);

  // ******** Rule: <V> --> (B I T E S) ********************************
  rhs.clear();
  rhs.push_back(RLiteral(Symbol("B"),false));
  rhs.push_back(RLiteral(Symbol("I"),false));
  rhs.push_back(RLiteral(Symbol("T"),false));
  rhs.push_back(RLiteral(Symbol("E"),false));
  rhs.push_back(RLiteral(Symbol("S"),false));
  rbPtr=&g.addRule(Symbol("V"),rhs,true);

  // -------- Equ: (X0 PRED) = BITE
  makePath(lPath,"PRED",NULL);
  makePath(rPath,NULL);
  v.clear();
  v.insert(v.begin(),Symbol("BITE"));
  rbPtr->
    eBlock.addBlock(new EBlockMain(0,lPath,v,Symbol::OP_PSEUDO_UNIFY));
  
  // -------- Equ: (X0 TENSE) = PRES
  makePath(lPath,"TENSE",NULL);
  makePath(rPath,NULL);
  v.clear();
  v.insert(v.begin(),Symbol("PRES"));
  rbPtr->
    eBlock.addBlock(new EBlockMain(0,lPath,v,Symbol::OP_PSEUDO_UNIFY));
  
  // -------- Equ: (X0 NUM) = SG
  makePath(lPath,"NUM",NULL);
  makePath(rPath,NULL);
  v.clear();
  v.insert(v.begin(),Symbol("SG"));
  rbPtr->
    eBlock.addBlock(new EBlockMain(0,lPath,v,Symbol::OP_PSEUDO_UNIFY));
  
  // -------- Equ: (X0 PERS) = 3
  makePath(lPath,"PERS",NULL);
  makePath(rPath,NULL);
  v.clear();
  v.insert(v.begin(),Symbol("3"));
  rbPtr->
    eBlock.addBlock(new EBlockMain(0,lPath,v,Symbol::OP_PSEUDO_UNIFY));
  
  // ******** Rule: <PP'> ==> (<P'> <NP>) ********************************
  rhs.clear();
  rhs.push_back(RLiteral(Symbol("P\'")));
  rhs.push_back(RLiteral(Symbol("NP")));
  rbPtr=&g.addRule(Symbol("PP\'"),rhs);

  // -------- Equ: (X1 PRED) <= WITH
  makePath(lPath,"PRED",NULL);
  makePath(rPath,NULL);
  v.clear();
  v.insert(v.begin(),Symbol("WITH"));
  rbPtr->
    eBlock.addBlock(new EBlockMain(1,lPath,v,Symbol::OP_ASSIGN));
  
  // -------- Equ: X2 = X0
  makePath(lPath,NULL);
  makePath(rPath,NULL);
  rbPtr->
    eBlock.addBlock(new EBlockMain(2,lPath,0,rPath,
				   Symbol::OP_PSEUDO_UNIFY));

  // ******** Rule: <PP> ==> (<P> <NP>) ********************************
  rhs.clear();
  rhs.push_back(RLiteral(Symbol("P")));
  rhs.push_back(RLiteral(Symbol("NP")));
  rbPtr=&g.addRule(Symbol("PP"),rhs);

  // -------- Equ: (X1 PRED) <= WITH
  makePath(lPath,"PRED",NULL);
  makePath(rPath,NULL);
  v.clear();
  v.insert(v.begin(),Symbol("WITH"));
  rbPtr->
    eBlock.addBlock(new EBlockMain(1,lPath,v,Symbol::OP_ASSIGN));
  
  // -------- Equ: X2 = X0
  makePath(lPath,NULL);
  makePath(rPath,NULL);
  rbPtr->
    eBlock.addBlock(new EBlockMain(2,lPath,0,rPath,
				   Symbol::OP_PSEUDO_UNIFY));

  // ******** Rule: <P'> --> (B Y) ********************************
  rhs.clear();
  rhs.push_back(RLiteral(Symbol("B"),false));
  rhs.push_back(RLiteral(Symbol("Y"),false));
  rbPtr=&g.addRule(Symbol("P\'"),rhs,true);

  // -------- Equ: (X0 PRED) = BY
  makePath(lPath,"PRED",NULL);
  makePath(rPath,NULL);
  v.clear();
  v.insert(v.begin(),Symbol("BY"));
  rbPtr->
    eBlock.addBlock(new EBlockMain(0,lPath,v,Symbol::OP_PSEUDO_UNIFY));
  
  // ******** Rule: <P> --> (W I T H) ********************************
  rhs.clear();
  rhs.push_back(RLiteral(Symbol("W"),false));
  rhs.push_back(RLiteral(Symbol("I"),false));
  rhs.push_back(RLiteral(Symbol("T"),false));
  rhs.push_back(RLiteral(Symbol("H"),false));
  rbPtr=&g.addRule(Symbol("P"),rhs,true);

  // -------- Equ: (X0 PRED) = WITH
  makePath(lPath,"PRED",NULL);
  makePath(rPath,NULL);
  v.clear();
  v.insert(v.begin(),Symbol("WITH"));
  rbPtr->
    eBlock.addBlock(new EBlockMain(0,lPath,v,Symbol::OP_PSEUDO_UNIFY));
}
