// ======================================================================
// graTst.cpp - Demonstrating how to install a unification-based grammar.
// 
// 011403: Benjamin Han <benhdj@cs.cmu.edu> Revised using the new
//         grammar.?pp; added using namespace std.
// 120601: Benjamin Han <benhdj@cs.cmu.edu> Namespace added.
// 061201: Benjamin Han <benhdj@cs.cmu.edu> Created.
// ======================================================================

//    Copyright (C) 2000-2004 Benjamin Han <benhdj@cs.cmu.edu>
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "grammar.hpp"

using namespace UKernel;
using namespace std;

void installLexicons (Lexicons &lexicons);
void installGrammar (Grammar &g);

int main () {
  Lexicons lexicons;
  Grammar g(lexicons,Symbol("S"));

  installLexicons(lexicons);

  // print out the toy lexicons
  cout<<"* The toy lexicons:"<<endl;
  cout<<lexicons<<endl<<endl;

  installGrammar(g);

  // print out the toy grammar
  cout<<"* The toy grammar:"<<endl;
  cout<<g<<endl<<endl;

  return 0;
}
