// ======================================================================
// fsTst.cpp - Testing code for fStruc.*
//
// 122502: Benjamin Han <benhdj@cs.cmu.edu> using namespace std.
// 102102: Benjamin Han <benhdj@cs.cmu.edu> Changed some comments: equivalence
//         tests (=t) should be "unifiability tests" now; added tests for
//         constraint operations with FSs.
// 092102: Benjamin Han <benhdj@cs.cmu.edu> Added tests of constraint and
//         testing equations with penetrating LHS (from Donna Gates' bug
//         report)
// 120601: Benjamin Han <benhdj@cs.cmu.edu> Added missing va_end() in 
//         insertVDaughters() and makePath(); namespace added.
// 092601: Benjamin Han <benhdj@cs.cmu.edu> Added pseudo-unifications,
//         assignments, removal, and popping tests for penetraing paths;
//         also added tests for right-penetrating paths.
// 090601: Benjamin Han <benhdj@cs.cmu.edu> Renamed all equal() to test();
//         revised comments: changed "=c" to "=t".
// 090301: Benjamin Han <benhdj@cs.cmu.edu> Added the missing stdarg.h include;
//         Minor revisions to supress warnings under -pedantic -Wall.
// 081901: Benjamin Han <benhdj@cs.cmu.edu> Used insertVDaughters() and 
//         makePath()to go easy on the compiler.
// 080201: Benjamin Han <benhdj@cs.cmu.edu> Renamed dBegin() and dEnd() to 
//         begin() and end() in _TreeIteratorBase<>.
// 072001: Benjamin Han <benhdj@cs.cmu.edu> Revised using the new ways to
//         declare tree iterators.
// 071701: Benjamin Han <benhdj@cs.cmu.edu> Added tests for unification/
//         equivalence tests between *OR* and the other types of FSs; other
//         minor cleanup.
// 071301: Benjamin Han <benhdj@cs.cmu.edu> Minor revisions of pushing/popping
//         tests; added tests for FS filtering.
// 070601: Benjamin Han <benhdj@cs.cmu.edu> Changed FStruc::append() to
//         FStruc::push().
// 070301: Benjamin Han <benhdj@cs.cmu.edu> Added tests for FStruc::mergeOr().
// 062501: Benjamin Han <benhdj@cs.cmu.edu> Added tests for *MULTIPLE* FS.
// 061201: Benjamin Han <benhdj@cs.cmu.edu> Revised to include equivalence
//         tests between the LHS and the RHS FS; changed emptyFS to nullFS.
// 052801: Benjamin Han <benhdj@cs.cmu.edu> Revised for FStruc indented 
//         printing.
// 052401: Benjamin Han <benhdj@cs.cmu.edu> Called FStruc::setName() for
//         all feature structures.
// 050801: Benjamin Han <benhdj@cs.cmu.edu> Now a feature name is a Symbol
//         instead of an int.
// 042101: Benjamin Han <benhdj@cs.cmu.edu> Created.
// ======================================================================

//    Copyright (C) 2000-2004 Benjamin Han <benhdj@cs.cmu.edu>
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "fStruc.hpp"

#include <stdarg.h>

using namespace UKernel;
using namespace std;

// the following 2 functions are provided to make this program easier to 
// compile; otherwise g++ will make your system crawl (like a turtle) due to
// inline functions
void insertVDaughters (Value &v, Value::DIterator iter, char *first, ...)
{
  va_list argp;
  char *ptr;

  if (first==NULL) return;
  else v.insert(iter,Symbol(first));

  for (va_start(argp,first);(ptr=va_arg(argp,char*))!=NULL;
       v.insert(iter,Symbol(ptr)));
  va_end(argp);
}

void makePath (Path &path, char *first, ...)
{
  va_list argp;
  char *ptr;

  path.clear();
  if (first==NULL) return;

  path.push_back(Symbol(first));

  for (va_start(argp,first);(ptr=va_arg(argp,char*))!=NULL;
       path.push_back(Symbol(ptr)));
  va_end(argp);
}

int main ()
{
  FStruc f1,f2,f3,f4,f5,f6,f7,f8,f9,f10,f11,f12;
  Path lPath,rPath;
  Value v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11;
  Value::Iterator iter;
  FStruc nullFS(symNull);

  f1.setName(Symbol("f1"));
  f2.setName(Symbol("f2"));
  f3.setName(Symbol("f3"));
  f4.setName(Symbol("f4"));
  f5.setName(Symbol("f5"));
  f6.setName(Symbol("f6"));
  f7.setName(Symbol("f7"));
  f8.setName(Symbol("f8"));
  f9.setName(Symbol("f9"));
  f10.setName(Symbol("f10"));
  f11.setName(Symbol("f11"));
  f12.setName(Symbol("f12"));

  iter=v1.insert(v1.begin(),symOr);
  insertVDaughters(v1,iter.end(),"0","1",NULL);
  v1.compact();
  cout<<"v1 is "<<v1<<endl;

  iter=v2.insert(v2.begin(),symNot);
  insertVDaughters(v2,iter.end(),"1","2","3",NULL);
  v2.compact();
  cout<<"v2 is "<<v2<<endl;

  iter=v3.insert(v3.begin(),symMultiple);
  insertVDaughters(v3,iter.end(),"0","1","2","0",NULL);
  v3.compact();
  cout<<"v3 is "<<v3<<endl;

  v4.insert(v4.begin(),Symbol("13"));
  v4.compact();
  cout<<"v4 is "<<v4<<endl;

  v5.insert(v5.begin(),Symbol("14"));
  v5.compact();
  cout<<"v5 is "<<v5<<endl;

  v6.insert(v6.begin(),Symbol("23"));
  v6.compact();
  cout<<"v6 is "<<v6<<endl;

  iter=v7.insert(v7.begin(),symNot);
  insertVDaughters(v7,iter.end(),"0","1","2",NULL);
  v7.compact();
  cout<<"v7 is "<<v7<<endl;

  v8.insert(v8.begin(),Symbol("C"));
  v8.compact();
  cout<<"v8 is "<<v8<<endl;

  v9.insert(v9.begin(),Symbol("E"));
  v9.compact();
  cout<<"v9 is "<<v9<<endl;

  v10.insert(v10.begin(),Symbol("Y"));
  v10.compact();
  cout<<"v10 is "<<v10<<endl;

  cout<<endl<<"============================== Assignment tests =============================="<<endl;

  cout<<endl<<"* (f1 1) <= f2"<<endl;
  makePath(lPath,"1",NULL);
  rPath.clear();
  f1.assign(lPath,f2,rPath);
  cout<<f1<<endl;

  cout<<endl<<"* (f1 1 3 4) <= "<<v1<<endl;
  makePath(lPath,"1","3","4",NULL);
  f1.assign(lPath,v1);
  cout<<f1<<endl;

  cout<<endl<<"* (f1 1 3 6) <= "<<v2<<endl;
  makePath(lPath,"1","3","6",NULL);
  f1.assign(lPath,v2);
  cout<<f1<<endl;

  cout<<endl<<"* (f1 2 4 9 10) <= "<<v3<<endl;
  makePath(lPath,"2","4","9","10",NULL);
  f1.assign(lPath,v3);
  cout<<f1<<endl;

  cout<<endl<<"* (f1 2 5 12) <= "<<v4<<endl;
  makePath(lPath,"2","5","12",NULL);
  f1.assign(lPath,v4);
  cout<<f1<<endl;

  f3=f1;

  cout<<endl<<"* (f1 2 5 12) <= "<<v5<<endl;
  f1.assign(lPath,v5);
  cout<<f1<<endl;

  cout<<endl<<"* (f2 20 21 22) <= "<<v6<<endl;
  makePath(lPath,"20","21","22",NULL);
  f2.assign(lPath,v6);
  cout<<f2<<endl;

  cout<<endl<<"* (f2 20 21 24) <= "<<v1<<endl;
  makePath(lPath,"20","21","24",NULL);
  f2.assign(lPath,v1);
  cout<<f2<<endl;

  cout<<endl<<"* (f1 2 5 12) <= (f2 20 21 22)"<<endl;
  makePath(lPath,"2","5","12",NULL);
  makePath(rPath,"20","21","22",NULL);
  if (f1.assign(lPath,f2,rPath))
    cout<<f1<<endl;
  else cout<<"-> assignment fails"<<endl;

  cout<<endl<<"* (f1 2 5 12) <= (f2 20)"<<endl;
  makePath(lPath,"2","5","12",NULL);
  makePath(rPath,"20",NULL);
  if (f1.assign(lPath,f2,rPath))
    cout<<f1<<endl;
  else cout<<"-> assignment fails"<<endl;

  cout<<endl<<"* (f1 2 5 12) <= (f2 20 21)"<<endl;
  makePath(lPath,"2","5","12",NULL);
  makePath(rPath,"20","21",NULL);
  if (f1.assign(lPath,f2,rPath))
    cout<<f1<<endl;
  else cout<<"-> assignment fails"<<endl;

  cout<<endl<<"* (f1 2 5 12) <= f2"<<endl;
  makePath(lPath,"2","5","12",NULL);
  rPath.clear();
  if (f1.assign(lPath,f2,rPath))
    cout<<f1<<endl;
  else cout<<"-> assignment fails"<<endl;

  cout<<endl<<"* f1 <= (f2 20 21)"<<endl;
  lPath.clear();
  makePath(rPath,"20","21",NULL);
  if (f1.assign(lPath,f2,rPath))
    cout<<f1<<endl;
  else cout<<"-> assignment fails"<<endl;

  cout<<endl<<"* f1 <= f2"<<endl;
  lPath.clear();
  rPath.clear();
  if (f1.assign(lPath,f2,rPath))
    cout<<f1<<endl;
  else cout<<"-> assignment fails"<<endl;

  f4=f1;

  cout<<endl<<"* f1 <= (f2 20 22)"<<endl;
  lPath.clear();
  makePath(rPath,"20","22",NULL);
  if (f1.assign(lPath,f2,rPath))
    cout<<f1<<endl;
  else cout<<"-> assignment fails"<<endl;

  f1=f4;
  cout<<endl<<f1<<endl;

  cout<<endl<<f3<<endl;

  f2=f3;

  cout<<endl<<"* f3 <= "<<v5<<endl;
  lPath.clear();
  if (f3.assign(lPath,v5))
    cout<<f3<<endl;
  else cout<<"-> assignment fails"<<endl;

  f3=f2;
  cout<<endl<<f3<<endl;

  cout<<endl<<"* f3 <= (f1 20 21 22)"<<endl;
  lPath.clear();
  makePath(rPath,"20","21","22",NULL);
  if (f3.assign(lPath,f1,rPath))
    cout<<f3<<endl;
  else cout<<"-> assignment fails"<<endl;

  f3=f2;
  cout<<endl<<f3<<endl;

  cout<<endl<<nullFS<<endl;

  cout<<endl<<"* (f3 1 3 6) <= nullFS"<<endl;
  makePath(lPath,"1","3","6",NULL);
  rPath.clear();
  if (f3.assign(lPath,nullFS,rPath))
    cout<<f3<<endl;
  else cout<<"-> assignment fails"<<endl;

  cout<<endl<<"* (f3 2 4 9 10) <= nullFS"<<endl;
  makePath(lPath,"2","4","9","10",NULL);
  rPath.clear();
  if (f3.assign(lPath,nullFS,rPath))
    cout<<f3<<endl;
  else cout<<"-> assignment fails"<<endl;

  cout<<endl<<"* f3 <= nullFS"<<endl;
  lPath.clear();
  rPath.clear();
  if (f3.assign(lPath,nullFS,rPath))
    cout<<f3<<endl;
  else cout<<"-> assignment fails"<<endl;

  cout<<endl<<"* Assignment tests for *MULTIPLE* FS:"<<endl;

  f4.clear();
  makePath(lPath,"B",NULL);
  f4.assign(lPath,v8);
  f5.clear();

  makePath(lPath,"A",NULL);
  rPath.clear();
  f5.push(lPath,f4,rPath);

  f6.clear();
  makePath(lPath,"D",NULL);
  f6.assign(lPath,v9);

  lPath.clear();
  rPath.clear();
  f4.push(lPath,f6,rPath);

  makePath(lPath,"A",NULL);
  rPath.clear();
  f5.push(lPath,f6,rPath);

  makePath(lPath,"F","G",NULL);
  rPath.clear();
  f5.push(lPath,f6,rPath);

  f7=f4;
  f8=f5;
  cout<<endl<<f4<<endl<<f5<<endl<<f6<<endl;

  cout<<endl<<"* f4 <= f6"<<endl;
  lPath.clear();
  rPath.clear();
  if (f4.assign(lPath,f6,rPath))
    cout<<f4<<endl;
  else cout<<"-> assignment fails"<<endl;

  cout<<endl<<"* (f5 A) <= f6"<<endl;
  makePath(lPath,"A",NULL);
  rPath.clear();
  if (f5.assign(lPath,f6,rPath))
    cout<<f5<<endl;
  else cout<<"-> assignment fails"<<endl;

  f4=f7;
  f5=f8;
  cout<<endl<<f4<<endl<<f5<<endl;

  cout<<endl<<"* f4 <= nullFS"<<endl;
  lPath.clear();
  rPath.clear();
  if (f4.assign(lPath,nullFS,rPath))
    cout<<f4<<endl;
  else cout<<"-> assignment fails"<<endl;

  cout<<endl<<"* (f5 A) <= nullFS"<<endl;
  makePath(lPath,"A",NULL);
  rPath.clear();
  if (f5.assign(lPath,nullFS,rPath))
    cout<<f5<<endl;
  else cout<<"-> assignment fails"<<endl;

  f4=f7;
  f5=f8;
  cout<<endl<<f4<<endl<<f5<<endl;

  cout<<endl<<"* (f4 X) <= f6"<<endl;
  makePath(lPath,"X",NULL);
  rPath.clear();
  if (f4.assign(lPath,f6,rPath))
    cout<<f4<<endl;
  else cout<<"-> assignment fails"<<endl;

  cout<<endl<<"* (f5 A X) <= f6"<<endl;
  makePath(lPath,"A","X",NULL);
  rPath.clear();
  if (f5.assign(lPath,f6,rPath))
    cout<<f5<<endl;
  else cout<<"-> assignment fails"<<endl;

  f4=f7;
  f5=f8;
  cout<<endl<<f4<<endl<<f5<<endl;

  cout<<endl<<"* (f5 F G) <= f4"<<endl;
  makePath(lPath,"F","G",NULL);
  rPath.clear();
  if (f5.assign(lPath,f4,rPath))
    cout<<f5<<endl;
  else cout<<"-> assignment fails"<<endl;

  cout<<endl<<"======================== *DEFINED* / *UNDEFINED* tests ========================"<<endl;

  cout<<endl<<"* (f1 20 21) = *DEFINED*"<<endl;
  makePath(lPath,"20","21",NULL);
  cout<<"-> "<<(f1.isDefined(lPath)?"true":"false")<<endl;

  cout<<endl<<"* (f1 20 22) = *DEFINED*"<<endl;
  makePath(lPath,"20","22",NULL);
  cout<<"-> "<<(f1.isDefined(lPath)?"true":"false")<<endl;

  cout<<endl<<"* (f1 20 21) = *UNDEFINED*"<<endl;
  makePath(lPath,"20","21",NULL);
  cout<<"-> "<<(!f1.isDefined(lPath)?"true":"false")<<endl;

  cout<<endl<<"* f1 = *DEFINED*"<<endl;
  lPath.clear();
  cout<<"-> "<<(f1.isDefined(lPath)?"true":"false")<<endl;

  cout<<endl<<"* *DEFINED* / *UNDEFINED* tests for *MULTIPLE* FS:"<<endl;

  f4=f7;
  cout<<endl<<f4<<endl;

  cout<<endl<<"* f4 = *DEFINED*"<<endl;
  lPath.clear();
  cout<<"-> "<<(f4.isDefined(lPath)?"true":"false")<<endl;

  cout<<endl<<"======================== *REMOVE* tests ========================"<<endl;

  cout<<endl<<"* (f1 20 21 30) = *REMOVE*"<<endl;
  makePath(lPath,"20","21","30",NULL);
  cout<<"-> "<<(f1.remove(lPath)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* (f1 20 21 22) = *REMOVE*"<<endl;
  makePath(lPath,"20","21","22",NULL);
  cout<<"-> "<<(f1.remove(lPath)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* (f1 20 21 24) = *REMOVE*"<<endl;
  makePath(lPath,"20","21","24",NULL);
  cout<<"-> "<<(f1.remove(lPath)?"true":"false")<<endl<<f1<<endl;

  f1=f2;
  cout<<endl<<f1<<endl;

  cout<<endl<<"* (f1 1 3 6) = *REMOVE*"<<endl;
  makePath(lPath,"1","3","6",NULL);
  cout<<"-> "<<(f1.remove(lPath)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* (f1 1 3 4) = *REMOVE*"<<endl;
  makePath(lPath,"1","3","4",NULL);
  cout<<"-> "<<(f1.remove(lPath)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* (f1 2 5) = *REMOVE*"<<endl;
  makePath(lPath,"2","5",NULL);
  cout<<"-> "<<(f1.remove(lPath)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* f1 = *REMOVE*"<<endl;
  lPath.clear();
  cout<<"-> "<<(f1.remove(lPath)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* *REMOVE* tests for *MULTIPLE* FS:"<<endl;

  f4=f7;
  f5=f8;
  cout<<endl<<f4<<endl<<f5<<endl;

  cout<<endl<<"* f4 = *REMOVE*"<<endl;
  lPath.clear();
  cout<<"-> "<<(f4.remove(lPath)?"true":"false")<<endl<<f4<<endl;

  cout<<endl<<"* (f5 A) = *REMOVE*"<<endl;
  makePath(lPath,"A",NULL);
  cout<<"-> "<<(f5.remove(lPath)?"true":"false")<<endl<<f5<<endl;

  cout<<endl<<"=================== Pseudo unification/unifiability tests ==================="<<endl;

  cout<<endl<<"* (f1 1 3 4) =t "<<v1<<endl;
  makePath(lPath,"1","3","4",NULL);
  cout<<"-> result = "<<(f1.test(lPath,v1)?"true":"false")<<endl<<f1<<endl;

  makePath(lPath,"1","3","4",NULL);
  f1.assign(lPath,v1);
  cout<<endl<<f1<<endl;

  cout<<endl<<"* (f1 1 3 4) = "<<v1<<endl;
  cout<<"-> result = "<<(f1.pseudoUnify(lPath,v1)?"true":"false")<<endl<<f1<<endl;

  f1=f2;
  cout<<endl<<f1<<endl;

  cout<<endl<<"* (f1 1 3 4) =t "<<v3<<endl;
  makePath(lPath,"1","3","4",NULL);
  cout<<"-> result = "<<(f1.test(lPath,v3)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* (f1 1 3 4) = "<<v3<<endl;
  makePath(lPath,"1","3","4",NULL);
  cout<<"-> result = "<<(f1.pseudoUnify(lPath,v3)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* (f1 2 4 9 10) =t "<<v3<<endl;
  makePath(lPath,"2","4","9","10",NULL);
  cout<<"-> result = "<<(f1.test(lPath,v3)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* (f1 2 4 9 10) = "<<v3<<endl;
  makePath(lPath,"2","4","9","10",NULL);
  cout<<"-> result = "<<(f1.pseudoUnify(lPath,v3)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* (f1 2 4 9 10) =t "<<v4<<endl;
  makePath(lPath,"2","4","9","10",NULL);
  cout<<"-> result = "<<(f1.test(lPath,v4)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* (f1 2 4 9 10) = "<<v4<<endl;
  makePath(lPath,"2","4","9","10",NULL);
  cout<<"-> result = "<<(f1.pseudoUnify(lPath,v4)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* (f1 2 4) =t "<<v1<<endl;
  makePath(lPath,"2","4",NULL);
  cout<<"-> result = "<<(f1.test(lPath,v1)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* (f1 2 4) = "<<v1<<endl;
  makePath(lPath,"2","4",NULL);
  cout<<"-> result = "<<(f1.pseudoUnify(lPath,v1)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* (f1 1 3 4) =t "<<v1<<endl;
  makePath(lPath,"1","3","4",NULL);
  cout<<"-> result = "<<(f1.test(lPath,v1)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* (f1 1 3 4) = "<<v1<<endl;
  makePath(lPath,"1","3","4",NULL);
  cout<<"-> result = "<<(f1.pseudoUnify(lPath,v1)?"true":"false")<<endl<<f1<<endl;

  f2.clear();
  makePath(lPath,"1","3","6",NULL);
  f2.assign(lPath,v4);
  makePath(lPath,"3","5","7",NULL);
  f2.assign(lPath,v3);
  cout<<endl<<f2<<endl;

  cout<<endl<<"* (f2 1 3 6) =t "<<nullFS<<endl;
  makePath(lPath,"1","3","6",NULL);
  rPath.clear();
  cout<<"-> result = "<<(f2.test(lPath,nullFS,rPath)?"true":"false")<<endl<<f2<<endl;

  cout<<endl<<"* (f2 1 3 6) = "<<nullFS<<endl;
  makePath(lPath,"1","3","6",NULL);
  rPath.clear();
  cout<<"-> result = "<<(f2.pseudoUnify(lPath,nullFS,rPath)?"true":"false")<<endl<<f2<<endl;

  cout<<endl<<"* f1 =t f2"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f1.test(lPath,f2,rPath)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* f1 = f2"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f1.pseudoUnify(lPath,f2,rPath)?"true":"false")<<endl<<f1<<endl;

  makePath(lPath,"3","5","7",NULL);
  f2.assign(lPath,v1);
  makePath(lPath,"10",NULL);
  f3.assign(lPath,f2,rPath);
  cout<<endl<<f3<<endl;

  cout<<endl<<"* f1 =t (f3 10)"<<endl;
  lPath.clear();
  makePath(rPath,"10",NULL);
  cout<<"-> result = "<<(f1.test(lPath,f3,rPath)?"true":"false")<<endl<<f1<<endl;  

  cout<<endl<<"* f1 = (f3 10)"<<endl;
  lPath.clear();
  makePath(rPath,"10",NULL);
  cout<<"-> result = "<<(f1.pseudoUnify(lPath,f3,rPath)?"true":"false")<<endl<<f1<<endl;  

  f2.clear();
  makePath(lPath,"1","3",NULL);
  f2.assign(lPath,v4);
  cout<<endl<<f2<<endl;

  cout<<endl<<"* f1 =t f2"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f1.test(lPath,f2,rPath)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* f1 = f2"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f1.pseudoUnify(lPath,f2,rPath)?"true":"false")<<endl<<f1<<endl;

  f2.clear();
  makePath(lPath,"1","3","4",NULL);
  f2.assign(lPath,v2);
  cout<<endl<<f2<<endl;

  cout<<endl<<"* f1 =t f2"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f1.test(lPath,f2,rPath)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* f1 = f2"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f1.pseudoUnify(lPath,f2,rPath)?"true":"false")<<endl<<f1<<endl;

  f2.clear();
  makePath(lPath,"1","3","4",NULL);
  f2.assign(lPath,v7);
  cout<<endl<<f2<<endl;

  cout<<endl<<"* f1 =t f2"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f1.test(lPath,f2,rPath)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* f1 = f2"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f1.pseudoUnify(lPath,f2,rPath)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* Pseudo unification/unifiability tests for *MULTIPLE* FS:"<<endl;

  f4=f7;
  f5=f8;
  f6.clear();
  makePath(lPath,"D",NULL);
  f6.assign(lPath,v9);
  f9=f6;
  cout<<endl<<f4<<endl<<f5<<endl<<f6<<endl;

  cout<<endl<<"* f6 =t f4"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f6.test(lPath,f4,rPath)?"true":"false")<<endl<<f6<<endl;

  cout<<endl<<"* f6 = f4"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f6.pseudoUnify(lPath,f4,rPath)?"true":"false")<<endl<<f6<<endl;

  f6=f9;
  cout<<endl<<f6<<endl;

  cout<<endl<<"* f4 =t f6"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f4.test(lPath,f6,rPath)?"true":"false")<<endl<<f4<<endl;

  cout<<endl<<"* f4 = f6"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f4.pseudoUnify(lPath,f6,rPath)?"true":"false")<<endl<<f4<<endl;

  cout<<endl<<"* f6 =t (f5 A)"<<endl;
  lPath.clear();
  makePath(rPath,"A",NULL);
  cout<<"-> result = "<<(f6.test(lPath,f5,rPath)?"true":"false")<<endl<<f6<<endl;

  cout<<endl<<"* f6 = (f5 A)"<<endl;
  lPath.clear();
  makePath(rPath,"A",NULL);
  cout<<"-> result = "<<(f6.pseudoUnify(lPath,f5,rPath)?"true":"false")<<endl<<f6<<endl;

  f6=f9;
  cout<<endl<<f6<<endl;

  cout<<endl<<"* (f5 A) =t f6"<<endl;
  makePath(lPath,"A",NULL);
  rPath.clear();
  cout<<"-> result = "<<(f5.test(lPath,f6,rPath)?"true":"false")<<endl<<f5<<endl;

  cout<<endl<<"* (f5 A) = f6"<<endl;
  makePath(lPath,"A",NULL);
  rPath.clear();
  cout<<"-> result = "<<(f5.pseudoUnify(lPath,f6,rPath)?"true":"false")<<endl<<f5<<endl;
  
  f4=f7;
  f5=f8;
  cout<<endl<<f4<<endl<<f5<<endl;

  cout<<endl<<"* f4 =t f5"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f4.test(lPath,f5,rPath)?"true":"false")<<endl<<f4<<endl;

  cout<<endl<<"* f4 = f5"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f4.pseudoUnify(lPath,f5,rPath)?"true":"false")<<endl<<f4<<endl;

  f4=f7;
  f5=f8;
  cout<<endl<<f4<<endl<<f5<<endl;

  cout<<endl<<"* f5 =t f4"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f5.test(lPath,f4,rPath)?"true":"false")<<endl<<f5<<endl;

  cout<<endl<<"* f5 = f4"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f5.pseudoUnify(lPath,f4,rPath)?"true":"false")<<endl<<f5<<endl;

  f4=f7;
  f5=f8;
  cout<<endl<<f4<<endl<<f5<<endl;

  cout<<endl<<"* f4 =t (f5 A)"<<endl;
  lPath.clear();
  makePath(rPath,"A",NULL);
  cout<<"-> result = "<<(f4.test(lPath,f5,rPath)?"true":"false")<<endl<<f4<<endl;

  cout<<endl<<"* f4 = (f5 A)"<<endl;
  lPath.clear();
  makePath(rPath,"A",NULL);
  cout<<"-> result = "<<(f4.pseudoUnify(lPath,f5,rPath)?"true":"false")<<endl<<f4<<endl;

  f4=f7;
  f5=f8;
  cout<<endl<<f4<<endl<<f5<<endl;

  cout<<endl<<"* (f5 A) =t f4"<<endl;
  makePath(lPath,"A",NULL);
  rPath.clear();
  cout<<"-> result = "<<(f5.test(lPath,f4,rPath)?"true":"false")<<endl<<f5<<endl;

  cout<<endl<<"* (f5 A) = f4"<<endl;
  makePath(lPath,"A",NULL);
  rPath.clear();
  cout<<"-> result = "<<(f5.pseudoUnify(lPath,f4,rPath)?"true":"false")<<endl<<f5<<endl;

  cout<<endl<<"========================= Removal assignment tests ========================="<<endl;

  cout<<endl<<"* (f1 1 3 4) == (f2 1 3 5)"<<endl;
  makePath(lPath,"1","3","4",NULL);
  makePath(rPath,"1","3","5",NULL);
  cout<<"-> result = "<<(f1.removeAssign(lPath,f2,rPath)?"true":"false")<<endl;
  cout<<f1<<endl;
  cout<<f2<<endl;

  cout<<endl<<"* (f1 2 6) == (f2 1 3 4)"<<endl;
  makePath(lPath,"2","6",NULL);
  makePath(rPath,"1","3","4",NULL);
  cout<<"-> result = "<<(f1.removeAssign(lPath,f2,rPath)?"true":"false")<<endl;
  cout<<f1<<endl;
  cout<<f2<<endl;

  makePath(lPath,"1","3","4",NULL);
  f2.assign(lPath,v2);
  cout<<endl<<f2<<endl;

  cout<<endl<<"* (f1 2 4) == (f2 1 3 4)"<<endl;
  makePath(lPath,"2","4",NULL);
  makePath(rPath,"1","3","4",NULL);
  cout<<"-> result = "<<(f1.removeAssign(lPath,f2,rPath)?"true":"false")<<endl;
  cout<<f1<<endl;
  cout<<f2<<endl;

  cout<<endl<<"* (f1 2 4 9 10) == (f2 1 3 4)"<<endl;
  makePath(lPath,"2","4","9","10",NULL);
  makePath(rPath,"1","3","4",NULL);
  cout<<"-> result = "<<(f1.removeAssign(lPath,f2,rPath)?"true":"false")<<endl;
  cout<<f1<<endl;
  cout<<f2<<endl;

  cout<<endl<<"========================= Unifiability tests ========================="<<endl;

  cout<<endl<<"* (f1 2 6) =t "<<v7<<endl;
  makePath(lPath,"2","6",NULL);
  cout<<"-> result = "<<(f1.test(lPath,v7)?"true":"false")<<endl;

  cout<<endl<<"* (f1 2 6) =t "<<v2<<endl;
  makePath(lPath,"2","6",NULL);
  cout<<"-> result = "<<(f1.test(lPath,v2)?"true":"false")<<endl;

  cout<<endl<<"* (f1 2 6) =t "<<v1<<endl;
  makePath(lPath,"2","6",NULL);
  cout<<"-> result = "<<(f1.test(lPath,v1)?"true":"false")<<endl;

  cout<<endl<<"* (f1 2 3) =t "<<v2<<endl;
  makePath(lPath,"2","3",NULL);
  cout<<"-> result = "<<(f1.test(lPath,v2)?"true":"false")<<endl;

  cout<<endl<<"* (f1 2 4) =t "<<v2<<endl;
  makePath(lPath,"2","4",NULL);
  cout<<"-> result = "<<(f1.test(lPath,v2)?"true":"false")<<endl;

  cout<<endl<<"========================= Pushing/popping tests ========================="<<endl;

  f2.clear();
  makePath(lPath,"1","3","4",NULL);
  f2.assign(lPath,v7);
  cout<<endl<<f2<<endl;

  cout<<endl<<"* (f1 1 3) > (f2 1 3 4)"<<endl;
  makePath(lPath,"1","3",NULL);
  makePath(rPath,"1","3","4",NULL);
  cout<<"-> result = "<<(f1.push(lPath,f2,rPath)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* (f1 1 4) > (f2 1 3 4)"<<endl;
  makePath(lPath,"1","4",NULL);
  makePath(rPath,"1","3","4",NULL);
  cout<<"-> result = "<<(f1.push(lPath,f2,rPath)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* (f1 1 3 4) > (f2 1 3 4)"<<endl;
  makePath(lPath,"1","3","4",NULL);
  makePath(rPath,"1","3","4",NULL);
  cout<<"-> result = "<<(f1.push(lPath,f2,rPath)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* (f1 1 3 4) > (f2 1 3)"<<endl;
  makePath(lPath,"1","3","4",NULL);
  makePath(rPath,"1","3",NULL);
  cout<<"-> result = "<<(f1.push(lPath,f2,rPath)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* (f1 1 3 4) > (f2 1 4)"<<endl;
  makePath(lPath,"1","3","4",NULL);
  makePath(rPath,"1","4",NULL);
  cout<<"-> result = "<<(f1.push(lPath,f2,rPath)?"true":"false")<<endl<<f1<<endl;

  cout<<endl<<"* f2 < (f1 1 3 4)"<<endl;
  lPath.clear();
  makePath(rPath,"1","3","4",NULL);
  cout<<"-> result = "<<(f2.pop(lPath,f1,rPath)?"true":"false")<<endl;
  cout<<f2<<endl;
  cout<<f1<<endl;

  f2.clear();
  cout<<endl<<f2<<endl;

  cout<<endl<<"* f2 < (f1 1 3 4)"<<endl;
  lPath.clear();
  makePath(rPath,"1","3","4",NULL);
  cout<<"-> result = "<<(f2.pop(lPath,f1,rPath)?"true":"false")<<endl;
  cout<<f2<<endl;
  cout<<f1<<endl;

  cout<<endl<<"* f2 < (f1 1 3 4)"<<endl;
  lPath.clear();
  makePath(rPath,"1","3","4",NULL);
  cout<<"-> result = "<<(f2.pop(lPath,f1,rPath)?"true":"false")<<endl;
  cout<<f2<<endl;
  cout<<f1<<endl;

  lPath.clear();
  f2.assign(lPath,v2);
  cout<<endl<<f2<<endl;

  cout<<endl<<"* f2 < (f1 1 3 4)"<<endl;
  lPath.clear();
  makePath(rPath,"1","3","4",NULL);
  cout<<"-> result = "<<(f2.pop(lPath,f1,rPath)?"true":"false")<<endl;
  cout<<f2<<endl;
  cout<<f1<<endl;

  lPath.clear();
  f2.assign(lPath,v2);
  cout<<endl<<f2<<endl;

  cout<<endl<<"* f2 < (f1 1 3 6)"<<endl;
  lPath.clear();
  makePath(rPath,"1","3","6",NULL);
  cout<<"-> result = "<<(f2.pop(lPath,f1,rPath)?"true":"false")<<endl;
  cout<<f2<<endl;
  cout<<f1<<endl;

  lPath.clear();
  f2.assign(lPath,v4);
  cout<<endl<<f2<<endl;

  cout<<endl<<"* f2 < (f1 1 4)"<<endl;
  lPath.clear();
  makePath(rPath,"1","4",NULL);
  cout<<"-> result = "<<(f2.pop(lPath,f1,rPath)?"true":"false")<<endl;
  cout<<f2<<endl;
  cout<<f1<<endl;

  cout<<endl<<"* Pushing/popping tests with *MULTIPLE* FS:"<<endl;

  f4.clear();
  makePath(lPath,"B",NULL);
  f4.assign(lPath,v8);
  f5.clear();
  cout<<endl<<f4<<endl<<f5<<endl;

  cout<<endl<<"* (f5 A) > f4"<<endl;
  makePath(lPath,"A",NULL);
  rPath.clear();
  cout<<"-> result = "<<(f5.push(lPath,f4,rPath)?"true":"false")<<endl<<f5<<endl;

  f6.clear();
  makePath(lPath,"D",NULL);
  f6.assign(lPath,v9);
  cout<<endl<<f6<<endl;

  cout<<endl<<"* f4 > f6"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f4.push(lPath,f6,rPath)?"true":"false")<<endl<<f4<<endl;

  cout<<endl<<"* (f5 A) > f6"<<endl;
  makePath(lPath,"A",NULL);
  rPath.clear();
  cout<<"-> result = "<<(f5.push(lPath,f6,rPath)?"true":"false")<<endl<<f5<<endl;

  cout<<endl<<"* (f4 F G) > f6"<<endl;
  makePath(lPath,"F","G",NULL);
  rPath.clear();
  cout<<"-> result = "<<(f4.push(lPath,f6,rPath)?"true":"false")<<endl<<f4<<endl;

  cout<<endl<<"* (f5 F G) > f6"<<endl;
  makePath(lPath,"F","G",NULL);
  rPath.clear();
  cout<<"-> result = "<<(f5.push(lPath,f6,rPath)?"true":"false")<<endl<<f5<<endl;

  cout<<endl<<"* f5 > f6"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f5.push(lPath,f6,rPath)?"true":"false")<<endl<<f5<<endl;

  f9.clear();
  cout<<endl<<f9<<endl;

  cout<<endl<<"* f9 < f4"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f9.pop(lPath,f4,rPath)?"true":"false")<<endl;
  cout<<f9<<endl;
  cout<<f4<<endl;
  
  cout<<endl<<"* f9 < f4"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f9.pop(lPath,f4,rPath)?"true":"false")<<endl;
  cout<<f9<<endl;
  cout<<f4<<endl;

  cout<<endl<<"* f6 < f4"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f6.pop(lPath,f4,rPath)?"true":"false")<<endl;
  cout<<f6<<endl;
  cout<<f4<<endl;

  f4=f7;
  cout<<endl<<f4<<endl;

  cout<<endl<<"* f6 < f4"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f6.pop(lPath,f4,rPath)?"true":"false")<<endl;
  cout<<f6<<endl;
  cout<<f4<<endl;

  cout<<endl<<"* f6 < f4"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f6.pop(lPath,f4,rPath)?"true":"false")<<endl;
  cout<<f6<<endl;
  cout<<f4<<endl;

  cout<<endl<<"* f6 < f4"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f6.pop(lPath,f4,rPath)?"true":"false")<<endl;
  cout<<f6<<endl;
  cout<<f4<<endl;

  f9.clear();
  cout<<endl<<f9<<endl;

  cout<<endl<<"* f9 < f5"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f9.pop(lPath,f5,rPath)?"true":"false")<<endl;
  cout<<f9<<endl;
  cout<<f5<<endl;

  cout<<endl<<"* f6 < (f9 A)"<<endl;
  lPath.clear();
  makePath(rPath,"A",NULL);
  cout<<"-> result = "<<(f6.pop(lPath,f9,rPath)?"true":"false")<<endl;
  cout<<f6<<endl;
  cout<<f9<<endl;

  cout<<endl<<"* f6 < (f9 A)"<<endl;
  lPath.clear();
  makePath(rPath,"A",NULL);
  cout<<"-> result = "<<(f6.pop(lPath,f9,rPath)?"true":"false")<<endl;
  cout<<f6<<endl;
  cout<<f9<<endl;

  cout<<endl<<"============================== Merge *OR* tests =============================="<<endl;

  f6=f5;
  f5.clear();
  cout<<endl<<f5<<endl<<f6<<endl;

  cout<<endl<<"* f5 is merged into f6"<<endl;
  f6.mergeOr(f5);
  cout<<f6<<endl;

  cout<<endl<<"* f6 is merged into f5"<<endl;
  f5.mergeOr(f6);
  cout<<f5<<endl;

  cout<<endl<<"* f6 is merged into f5"<<endl;
  f5.mergeOr(f6);
  cout<<f5<<endl;

  cout<<endl<<f9<<endl;

  cout<<endl<<"* f9 is merged into f5"<<endl;
  f5.mergeOr(f9);
  cout<<f5<<endl;

  cout<<endl<<f7<<endl;

  f6=f7;

  cout<<endl<<"* f5 is merged into f7"<<endl;
  f7.mergeOr(f5);
  cout<<f7<<endl;

  cout<<endl<<"* f5 is merged into f7"<<endl;
  f7.mergeOr(f5);
  cout<<f7<<endl;

  cout<<endl<<f6<<endl;

  cout<<endl<<"* f6 is merged into f7"<<endl;
  f7.mergeOr(f6);
  cout<<f7<<endl;

  cout<<endl<<"======================== Pseudo unification with *OR* ======================="<<endl;

  f4=f7;
  cout<<endl<<f7<<endl<<f9<<endl;

  cout<<endl<<"* f7 =t f9"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f7.test(lPath,f9,rPath)?"true":"false")<<endl;

  cout<<endl<<"* f7 = f9"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f7.pseudoUnify(lPath,f9,rPath)?"true":"false")<<endl<<f7<<endl;

  f7=f4;
  cout<<endl<<f7<<endl<<f9<<endl;

  cout<<endl<<"* f9 =t f7"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f9.test(lPath,f7,rPath)?"true":"false")<<endl;

  cout<<endl<<"* f9 = f7"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f9.pseudoUnify(lPath,f7,rPath)?"true":"false")<<endl<<f9<<endl;

  f9.clear();
  makePath(lPath,"D",NULL);
  f9.assign(lPath,v8);
  cout<<endl<<f7<<endl<<f9<<endl;

  cout<<endl<<"* f7 =t f9"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f7.test(lPath,f9,rPath)?"true":"false")<<endl;

  cout<<endl<<"* f7 = f9"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f7.pseudoUnify(lPath,f9,rPath)?"true":"false")<<endl<<f7<<endl;

  f7=f4;
  cout<<endl<<f7<<endl<<f5<<endl;

  cout<<endl<<"* f7 =t f5"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f7.test(lPath,f5,rPath)?"true":"false")<<endl;

  cout<<endl<<"* f7 = f5"<<endl;
  lPath.clear();
  rPath.clear();
  cout<<"-> result = "<<(f7.pseudoUnify(lPath,f5,rPath)?"true":"false")<<endl<<f7<<endl;
  
  cout<<endl<<"* Penetration tests:"<<endl;

  f7=f4;
  cout<<endl<<f7<<endl;

  cout<<endl<<"* (f7 X) = Y"<<endl;
  makePath(lPath,"X",NULL);
  cout<<"-> result = "<<(f7.pseudoUnify(lPath,v10)?"true":"false")<<endl<<f7<<endl;

  f7=f4;
  cout<<endl<<f7<<endl;

  cout<<endl<<"* (f7 D) = C"<<endl;
  makePath(lPath,"D",NULL);
  cout<<"-> result = "<<(f7.pseudoUnify(lPath,v8)?"true":"false")<<endl<<f7<<endl;

  f7=f4;
  f9.clear();
  makePath(lPath,"D",NULL);
  f9.assign(lPath,v9);
  cout<<endl<<f7<<endl<<f9<<endl;

  cout<<endl<<"* (f7 X) = f9"<<endl;
  makePath(lPath,"X",NULL);
  rPath.clear();
  cout<<"-> result = "<<(f7.pseudoUnify(lPath,f9,rPath)?"true":"false")<<endl<<f7<<endl;
  
  f7=f4;
  cout<<endl<<f7<<endl<<f9<<endl;

  cout<<endl<<"* (f7 D) = f9"<<endl;
  makePath(lPath,"D",NULL);
  rPath.clear();
  cout<<"-> result = "<<(f7.pseudoUnify(lPath,f9,rPath)?"true":"false")<<endl<<f7<<endl;
  
  // restore for the filter tests
  f7=f4;
  f9.clear();
  makePath(lPath,"D",NULL);
  f9.assign(lPath,v9);

  cout<<endl<<"============================== Filter tests =============================="<<endl;

  f3=f1;
  f2.clear();
  makePath(lPath,"2","5","12",NULL);
  f2.assign(lPath,v4);
  cout<<endl<<f1<<endl<<f2<<endl;

  cout<<endl<<"* f1 is filtered using f2"<<endl;
  cout<<"-> result = "<<(f1.filter(f2)?"true":"false")<<endl;
  cout<<f1<<endl;

  f1=f3;
  f2.clear();
  makePath(lPath,"2","5","13",NULL);
  f2.assign(lPath,v5);
  cout<<endl<<f1<<endl<<f2<<endl;

  cout<<endl<<"* f1 is filtered using f2"<<endl;
  cout<<"-> result = "<<(f1.filter(f2)?"true":"false")<<endl;
  cout<<f1<<endl;

  f1=f3;
  f2.clear();
  makePath(lPath,"2","5","12",NULL);
  f2.assign(lPath,v5);
  cout<<endl<<f1<<endl<<f2<<endl;

  cout<<endl<<"* f1 is filtered using f2"<<endl;
  cout<<"-> result = "<<(f1.filter(f2)?"true":"false")<<endl;
  cout<<f1<<endl;

  f4=f7;
  cout<<endl<<f7<<endl<<f6<<endl;

  cout<<endl<<"* f7 is filtered using f6"<<endl;
  cout<<"-> result = "<<(f7.filter(f6)?"true":"false")<<endl;
  cout<<f7<<endl;

  f7=f4;
  cout<<endl<<f7<<endl<<f9<<endl;

  cout<<endl<<"* f7 is filtered using f9"<<endl;
  cout<<"-> result = "<<(f7.filter(f9)?"true":"false")<<endl;
  cout<<f7<<endl;

  makePath(lPath,"D",NULL);
  f9.assign(lPath,v8);
  cout<<endl<<f9<<endl;

  cout<<endl<<"* f7 is filtered using f9"<<endl;
  cout<<"-> result = "<<(f7.filter(f9)?"true":"false")<<endl;
  cout<<f7<<endl;

  cout<<endl<<"======================= Right penetrating path tests ======================="<<endl;

  // construct a mega-complex FS f7
  f1.clear();
  makePath(lPath,"B","C",NULL);
  f1.assign(lPath,v10);
  f9.clear();
  makePath(lPath,"C",NULL);
  f9.assign(lPath,v9);
  f1.assign(lPath,v10);
  makePath(lPath,"B",NULL);
  rPath.clear();
  f1.push(lPath,f9,rPath);
  f1.push(lPath,f9,rPath);

  f8.clear();
  makePath(lPath,"C",NULL);
  f8.assign(lPath,v9);
  f9.clear();
  makePath(lPath,"D",NULL);
  f9.assign(lPath,v10);
  f8.mergeOr(f9);
  f9.clear();
  makePath(lPath,"C",NULL);
  f9.assign(lPath,v10);
  f8.mergeOr(f9);
  f2.clear();
  makePath(lPath,"B",NULL);
  rPath.clear();
  f2.assign(lPath,f8,rPath);

  f3.clear();
  makePath(lPath,"B","C",NULL);
  f3.assign(lPath,v9);
  makePath(lPath,"B","D",NULL);
  f3.assign(lPath,v10);

  f4.clear();
  makePath(lPath,"C",NULL);
  f4.assign(lPath,v10);

  f1.mergeOr(f2);
  f1.mergeOr(f3);
  f1.mergeOr(f4);
  f7.clear();
  makePath(lPath,"A",NULL);
  rPath.clear();
  f7.assign(lPath,f1,rPath);

  f8.clear();
  cout<<endl<<f7<<endl<<f8<<endl;

  cout<<endl<<"* f8 = (f7 A B C)"<<endl;
  lPath.clear();
  makePath(rPath,"A","B","C",NULL);
  cout<<"-> result = "<<(f8.pseudoUnify(lPath,f7,rPath)?"true":"false")<<endl<<f8<<endl;

  f8.clear();
  cout<<endl<<"* f8 = (f7 A B)"<<endl;
  lPath.clear();
  makePath(rPath,"A","B",NULL);
  cout<<"-> result = "<<(f8.pseudoUnify(lPath,f7,rPath)?"true":"false")<<endl<<f8<<endl;

  f8.clear();
  cout<<endl<<"* f8 = (f7 A)"<<endl;
  lPath.clear();
  makePath(rPath,"A",NULL);
  cout<<"-> result = "<<(f8.pseudoUnify(lPath,f7,rPath)?"true":"false")<<endl<<f8<<endl;

  // construct another mega-complex FS f7
  f9.clear();
  makePath(lPath,"D",NULL);
  f9.assign(lPath,v9);
  f1.clear();
  makePath(lPath,"B","C",NULL);
  rPath.clear();
  f1.assign(lPath,f9,rPath);
  f9.clear();
  makePath(lPath,"C",NULL);
  f9.assign(lPath,v9);
  f1.assign(lPath,v10);
  makePath(lPath,"B",NULL);
  rPath.clear();
  f1.push(lPath,f9,rPath);
  f1.push(lPath,f9,rPath);

  f8.clear();
  makePath(lPath,"C",NULL);
  f8.assign(lPath,v9);
  f9.clear();
  makePath(lPath,"D",NULL);
  f9.assign(lPath,v10);
  f8.mergeOr(f9);
  f9.clear();
  makePath(lPath,"C",NULL);
  f9.assign(lPath,v10);
  f8.mergeOr(f9);
  f2.clear();
  makePath(lPath,"B",NULL);
  rPath.clear();
  f2.assign(lPath,f8,rPath);

  f3.clear();
  makePath(lPath,"B","C",NULL);
  f3.assign(lPath,v9);
  makePath(lPath,"B","D",NULL);
  f3.assign(lPath,v10);

  f4.clear();
  makePath(lPath,"C",NULL);
  f4.assign(lPath,v10);

  f1.mergeOr(f2);
  f1.mergeOr(f3);
  f1.mergeOr(f4);
  f7.clear();
  makePath(lPath,"A",NULL);
  rPath.clear();
  f7.assign(lPath,f1,rPath);

  f8.clear();
  cout<<endl<<f7<<endl<<f8<<endl;  

  cout<<endl<<"* f8 = (f7 A B C)"<<endl;
  lPath.clear();
  makePath(rPath,"A","B","C",NULL);
  cout<<"-> result = "<<(f8.pseudoUnify(lPath,f7,rPath)?"true":"false")<<endl<<f8<<endl;

  // construct another mega-complex FS f7
  f9.clear();
  makePath(lPath,"D",NULL);
  f9.assign(lPath,v9);
  f1.clear();
  makePath(lPath,"B","C",NULL);
  rPath.clear();
  f1.assign(lPath,f9,rPath);
  f9.clear();
  makePath(lPath,"C",NULL);
  f9.assign(lPath,v9);
  f1.assign(lPath,v10);
  makePath(lPath,"B",NULL);
  rPath.clear();
  f1.push(lPath,f9,rPath);
  f1.push(lPath,f9,rPath);

  f8.clear();
  makePath(lPath,"C",NULL);
  f8.assign(lPath,v9);
  f9.clear();
  makePath(lPath,"D",NULL);
  f9.assign(lPath,v10);
  f8.mergeOr(f9);
  f2.clear();
  makePath(lPath,"B",NULL);
  rPath.clear();
  f2.assign(lPath,f8,rPath);

  f3.clear();
  makePath(lPath,"B","C",NULL);
  f3.assign(lPath,v9);
  makePath(lPath,"B","D",NULL);
  f3.assign(lPath,v10);

  f4.clear();
  makePath(lPath,"C",NULL);
  f4.assign(lPath,v10);

  f1.mergeOr(f2);
  f1.mergeOr(f3);
  f1.mergeOr(f4);
  f7.clear();
  makePath(lPath,"A",NULL);
  rPath.clear();
  f7.assign(lPath,f1,rPath);

  f8.clear();
  cout<<endl<<f7<<endl<<f8<<endl;  

  cout<<endl<<"* f8 = (f7 A B C)"<<endl;
  lPath.clear();
  makePath(rPath,"A","B","C",NULL);
  cout<<"-> result = "<<(f8.pseudoUnify(lPath,f7,rPath)?"true":"false")<<endl<<f8<<endl;

  // construct another mega-complex FS f7
  f9.clear();
  makePath(lPath,"D",NULL);
  f9.assign(lPath,v9);
  f1.clear();
  makePath(lPath,"B","C",NULL);
  rPath.clear();
  f1.assign(lPath,f9,rPath);
  f9.clear();
  makePath(lPath,"C",NULL);
  f9.assign(lPath,v9);
  f1.assign(lPath,v10);
  makePath(lPath,"B",NULL);
  rPath.clear();
  f1.push(lPath,f9,rPath);
  f1.push(lPath,f9,rPath);

  f8.clear();
  makePath(lPath,"X",NULL);
  f8.assign(lPath,v9);
  f9.clear();
  makePath(lPath,"D",NULL);
  f9.assign(lPath,v10);
  f8.mergeOr(f9);
  f2.clear();
  makePath(lPath,"B",NULL);
  rPath.clear();
  f2.assign(lPath,f8,rPath);

  f3.clear();
  makePath(lPath,"B","X",NULL);
  f3.assign(lPath,v9);
  makePath(lPath,"B","D",NULL);
  f3.assign(lPath,v10);

  f4.clear();
  makePath(lPath,"C",NULL);
  f4.assign(lPath,v10);

  f1.mergeOr(f2);
  f1.mergeOr(f3);
  f1.mergeOr(f4);
  f7.clear();
  makePath(lPath,"A",NULL);
  rPath.clear();
  f7.assign(lPath,f1,rPath);

  f8.clear();
  cout<<endl<<f7<<endl<<f8<<endl;  

  cout<<endl<<"* f8 = (f7 A B C)"<<endl;
  lPath.clear();
  makePath(rPath,"A","B","C",NULL);
  cout<<"-> result = "<<(f8.pseudoUnify(lPath,f7,rPath)?"true":"false")<<endl<<f8<<endl;

  cout<<endl<<"==================== Constraints with penetrating paths ===================="<<endl;

  // taken from Donna's bug report
  f10.clear();
  makePath(lPath,"ROOT",NULL);
  v11.clear();
  v11.insert(v11.begin(),Symbol("CIRCLE"));
  f10.assign(lPath,v11);
  v11.clear();
  makePath(lPath,"COUNT",NULL);
  v11.insert(v11.begin(),Symbol("YES"));
  f10.assign(lPath,v11);
  v11.clear();
  makePath(lPath,"SEM-VALUE",NULL);
  v11.insert(v11.begin(),Symbol("CIRCLE"));
  f10.assign(lPath,v11);
  v11.clear();
  makePath(lPath,"CAT",NULL);
  v11.insert(v11.begin(),Symbol("N"));
  f10.assign(lPath,v11);
  v11.clear();
  makePath(lPath,"LEX-ID",NULL);
  v11.insert(v11.begin(),Symbol("ENG"));
  f10.assign(lPath,v11);
  v11.clear();

  f11.clear();
  makePath(lPath,"ROOT",NULL);
  v11.insert(v11.begin(),Symbol("CIRCLE"));
  f11.assign(lPath,v11);
  v11.clear();
  makePath(lPath,"SEM-VALUE",NULL);
  v11.insert(v11.begin(),Symbol("CIRCLE"));
  f11.assign(lPath,v11);
  v11.clear();
  makePath(lPath,"CAT",NULL);
  v11.insert(v11.begin(),Symbol("N"));
  f11.assign(lPath,v11);
  v11.clear();
  makePath(lPath,"LEX-ID",NULL);
  v11.insert(v11.begin(),Symbol("ENG"));
  f11.assign(lPath,v11);
  v11.clear();

  f10.mergeOr(f11);
  f11.clear();
  
  cout<<endl<<f10<<endl<<f11<<endl;

  cout<<endl<<"* f11 <= (f10 COUNT)"<<endl;
  lPath.clear();
  makePath(rPath,"COUNT",NULL);
  cout<<"-> result = "<<(f11.assign(lPath,f10,rPath)?"true":"false")<<endl<<f11<<endl;

  cout<<endl<<"* (f10 COUNT) =c NO"<<endl;
  makePath(lPath,"COUNT",NULL);
  v11.insert(v11.begin(),Symbol("NO"));
  cout<<"-> result = "<<(f10.constrain(lPath,v11)?"true":"false")<<endl<<f10<<endl;
  v11.clear();

  f11.clear();
  makePath(lPath,"COUNT",NULL);
  iter=v11.insert(v11.begin(),symOr);
  insertVDaughters(v11,iter.end(),"NO","BOTH",NULL);
  v11.compact();
  f11.assign(lPath,v11);
  v11.clear();

  cout<<endl<<f11<<endl;

  cout<<endl<<"* (f10 COUNT) =c f11"<<endl;
  makePath(lPath,"COUNT",NULL);
  rPath.clear();
  cout<<"-> result = "<<(f10.constrain(lPath,f11,rPath)?"true":"false")<<endl<<f10<<endl;
  v11.clear();

  cout<<endl<<"* (f10 COUNT) =c (f11 COUNT)"<<endl;
  makePath(lPath,"COUNT",NULL);
  makePath(rPath,"COUNT",NULL);
  cout<<"-> result = "<<(f10.constrain(lPath,f11,rPath)?"true":"false")<<endl<<f10<<endl;
  v11.clear();

  cout<<endl<<"* (f10 COUNT) =c YES"<<endl;
  makePath(lPath,"COUNT",NULL);
  v11.insert(v11.begin(),Symbol("YES"));
  cout<<"-> result = "<<(f10.constrain(lPath,v11)?"true":"false")<<endl<<f10<<endl;
  v11.clear();

  cout<<endl<<"==================== Constraints with FSs  ===================="<<endl;
  
  f10.clear();
  makePath(lPath,"A","B",NULL);
  v11.clear();
  v11.insert(v11.begin(),Symbol("1"));
  f10.assign(lPath,v11);
  makePath(lPath,"A","C",NULL);
  v11.clear();
  v11.insert(v11.begin(),Symbol("2"));
  f10.assign(lPath,v11);

  f11.clear();
  makePath(lPath,"D","B",NULL);
  v11.clear();
  v11.insert(v11.begin(),Symbol("1"));
  f11.assign(lPath,v11);
  makePath(lPath,"D","C",NULL);
  v11.clear();
  v11.insert(v11.begin(),Symbol("2"));
  f11.assign(lPath,v11);

  cout<<endl<<f10<<endl<<f11<<endl;

  cout<<endl<<"* (f10 A) =c (f11 D)"<<endl;
  makePath(lPath,"A",NULL);
  makePath(rPath,"D",NULL);
  cout<<"-> result = "<<(f10.constrain(lPath,f11,rPath)?"true":"false")<<endl<<f10<<endl;

  f11.clear();
  makePath(lPath,"D","B",NULL);
  v11.clear();
  v11.insert(v11.begin(),Symbol("1"));
  f11.assign(lPath,v11);
  makePath(lPath,"D","C",NULL);
  v11.clear();
  v11.insert(v11.begin(),Symbol("3"));
  f11.assign(lPath,v11);

  cout<<endl<<f11<<endl;

  cout<<endl<<"* (f10 A) =c (f11 D)"<<endl;
  makePath(lPath,"A",NULL);
  makePath(rPath,"D",NULL);
  cout<<"-> result = "<<(f10.constrain(lPath,f11,rPath)?"true":"false")<<endl<<f10<<endl;

  f11.clear();
  makePath(lPath,"D","C",NULL);
  v11.clear();
  iter=v11.insert(v11.begin(),symOr);
  insertVDaughters(v1,iter.end(),"2","3",NULL);
  f11.assign(lPath,v11);
  makePath(lPath,"D","B",NULL);
  v11.clear();
  v11.insert(v11.begin(),Symbol("1"));
  f11.assign(lPath,v11);

  cout<<endl<<f11<<endl;

  cout<<endl<<"* (f10 A) =c (f11 D)"<<endl;
  makePath(lPath,"A",NULL);
  makePath(rPath,"D",NULL);
  cout<<"-> result = "<<(f10.constrain(lPath,f11,rPath)?"true":"false")<<endl<<f10<<endl;

  f11.clear();
  makePath(lPath,"D","B",NULL);
  v11.clear();
  v11.insert(v11.begin(),Symbol("1"));
  f11.assign(lPath,v11);
  makePath(lPath,"D","C",NULL);
  v11.clear();
  v11.insert(v11.begin(),Symbol("3"));
  f11.assign(lPath,v11);

  f12.clear();
  makePath(lPath,"D","B",NULL);
  v11.clear();
  v11.insert(v11.begin(),Symbol("1"));
  f12.assign(lPath,v11);
  makePath(lPath,"D","C",NULL);
  v11.clear();
  iter=v11.insert(v11.begin(),symOr);
  insertVDaughters(v1,iter.end(),"2","3",NULL);
  f12.assign(lPath,v11);

  f11.mergeOr(f12);

  cout<<endl<<f11<<endl;

  cout<<endl<<"* (f10 A) =c (f11 D)"<<endl;
  makePath(lPath,"A",NULL);
  makePath(rPath,"D",NULL);
  cout<<"-> result = "<<(f10.constrain(lPath,f11,rPath)?"true":"false")<<endl<<f10<<endl;

  f11.clear();
  makePath(lPath,"D","B",NULL);
  v11.clear();
  v11.insert(v11.begin(),Symbol("1"));
  f11.assign(lPath,v11);
  makePath(lPath,"D","C",NULL);
  v11.clear();
  v11.insert(v11.begin(),Symbol("3"));
  f11.assign(lPath,v11);

  f12.clear();
  makePath(lPath,"D","B",NULL);
  v11.clear();
  v11.insert(v11.begin(),Symbol("1"));
  f12.assign(lPath,v11);
  makePath(lPath,"D","C",NULL);
  v11.clear();
  iter=v11.insert(v11.begin(),symOr);
  insertVDaughters(v1,iter.end(),"2","3",NULL);
  f12.assign(lPath,v11);

  lPath.clear();
  rPath.clear();
  f11.push(lPath,f12,rPath);

  cout<<endl<<f11<<endl;

  cout<<endl<<"* (f10 A) =c (f11 D)"<<endl;
  makePath(lPath,"A",NULL);
  makePath(rPath,"D",NULL);
  cout<<"-> result = "<<(f10.constrain(lPath,f11,rPath)?"true":"false")<<endl<<f10<<endl;

  f11.clear();
  makePath(lPath,"D","B",NULL);
  v11.clear();
  v11.insert(v11.begin(),Symbol("1"));
  f11.assign(lPath,v11);
  makePath(lPath,"D","C",NULL);
  v11.clear();
  v11.insert(v11.begin(),Symbol("3"));
  f11.assign(lPath,v11);

  f12.clear();
  makePath(lPath,"D","B",NULL);
  v11.clear();
  v11.insert(v11.begin(),Symbol("1"));
  f12.assign(lPath,v11);
  makePath(lPath,"D","C",NULL);
  v11.clear();
  iter=v11.insert(v11.begin(),symOr);
  insertVDaughters(v1,iter.end(),"2","3",NULL);
  f12.assign(lPath,v11);

  f11.mergeOr(f12);

  f12.clear();
  makePath(lPath,"D","B",NULL);
  v11.clear();
  v11.insert(v11.begin(),Symbol("1"));
  f12.assign(lPath,v11);
  makePath(lPath,"D","C",NULL);
  v11.clear();
  v11.insert(v11.begin(),Symbol("2"));
  f12.assign(lPath,v11);

  lPath.clear();
  rPath.clear();
  f11.push(lPath,f12,rPath);

  cout<<endl<<f11<<endl;

  cout<<endl<<"* (f10 A) =c (f11 D)"<<endl;
  makePath(lPath,"A",NULL);
  makePath(rPath,"D",NULL);
  cout<<"-> result = "<<(f10.constrain(lPath,f11,rPath)?"true":"false")<<endl<<f10<<endl;

  

  cout<<endl<<"==================== Tests with penetrating paths ===================="<<endl;

  // taken from Donna's bug report
  f10.clear();
  makePath(lPath,"ROOT",NULL);
  v11.clear();
  v11.insert(v11.begin(),Symbol("CIRCLE"));
  f10.assign(lPath,v11);
  v11.clear();
  makePath(lPath,"COUNT",NULL);
  v11.insert(v11.begin(),Symbol("YES"));
  f10.assign(lPath,v11);
  v11.clear();
  makePath(lPath,"SEM-VALUE",NULL);
  v11.insert(v11.begin(),Symbol("CIRCLE"));
  f10.assign(lPath,v11);
  v11.clear();
  makePath(lPath,"CAT",NULL);
  v11.insert(v11.begin(),Symbol("N"));
  f10.assign(lPath,v11);
  v11.clear();
  makePath(lPath,"LEX-ID",NULL);
  v11.insert(v11.begin(),Symbol("ENG"));
  f10.assign(lPath,v11);
  v11.clear();

  f11.clear();
  makePath(lPath,"ROOT",NULL);
  v11.insert(v11.begin(),Symbol("CIRCLE"));
  f11.assign(lPath,v11);
  v11.clear();
  makePath(lPath,"SEM-VALUE",NULL);
  v11.insert(v11.begin(),Symbol("CIRCLE"));
  f11.assign(lPath,v11);
  v11.clear();
  makePath(lPath,"CAT",NULL);
  v11.insert(v11.begin(),Symbol("N"));
  f11.assign(lPath,v11);
  v11.clear();
  makePath(lPath,"LEX-ID",NULL);
  v11.insert(v11.begin(),Symbol("ENG"));
  f11.assign(lPath,v11);
  v11.clear();

  f10.mergeOr(f11);
  f11.clear();
  
  cout<<endl<<f10<<endl<<f11<<endl;

  cout<<endl<<"* (f10 COUNT) =t NO"<<endl;
  makePath(lPath,"COUNT",NULL);
  v11.insert(v11.begin(),Symbol("NO"));
  cout<<"-> result = "<<(f10.test(lPath,v11)?"true":"false")<<endl<<f10<<endl;
  v11.clear();

  f11.clear();
  makePath(lPath,"COUNT",NULL);
  iter=v11.insert(v11.begin(),symOr);
  insertVDaughters(v11,iter.end(),"NO","BOTH",NULL);
  v11.compact();
  f11.assign(lPath,v11);
  v11.clear();

  cout<<endl<<f11<<endl;

  cout<<endl<<"* (f10 COUNT) =t f11"<<endl;
  makePath(lPath,"COUNT",NULL);
  rPath.clear();
  cout<<"-> result = "<<(f10.test(lPath,f11,rPath)?"true":"false")<<endl<<f10<<endl;
  v11.clear();

  cout<<endl<<"* (f10 COUNT) =t (f11 COUNT)"<<endl;
  makePath(lPath,"COUNT",NULL);
  makePath(rPath,"COUNT",NULL);
  cout<<"-> result = "<<(f10.test(lPath,f11,rPath)?"true":"false")<<endl<<f10<<endl;
  v11.clear();

  cout<<endl<<"* (f10 COUNT) =t YES"<<endl;
  makePath(lPath,"COUNT",NULL);
  v11.insert(v11.begin(),Symbol("YES"));
  cout<<"-> result = "<<(f10.test(lPath,v11)?"true":"false")<<endl<<f10<<endl;
  v11.clear();

  cout<<endl<<"==================== Assignments with penetrating paths ===================="<<endl;

  // construct a mega-complex FS f7
  f1.clear();
  makePath(lPath,"B","C",NULL);
  f1.assign(lPath,v10);
  f9.clear();
  makePath(lPath,"C",NULL);
  f9.assign(lPath,v9);
  f1.assign(lPath,v10);
  makePath(lPath,"B",NULL);
  rPath.clear();
  f1.push(lPath,f9,rPath);
  f1.push(lPath,f9,rPath);

  f8.clear();
  makePath(lPath,"C",NULL);
  f8.assign(lPath,v9);
  f9.clear();
  makePath(lPath,"D",NULL);
  f9.assign(lPath,v10);
  f8.mergeOr(f9);
  f9.clear();
  makePath(lPath,"C",NULL);
  f9.assign(lPath,v10);
  f8.mergeOr(f9);
  f2.clear();
  makePath(lPath,"B",NULL);
  rPath.clear();
  f2.assign(lPath,f8,rPath);

  f3.clear();
  makePath(lPath,"B","C",NULL);
  f3.assign(lPath,v9);
  makePath(lPath,"B","D",NULL);
  f3.assign(lPath,v10);

  f4.clear();
  makePath(lPath,"C",NULL);
  f4.assign(lPath,v10);

  f1.mergeOr(f2);
  f1.mergeOr(f3);
  f1.mergeOr(f4);
  f7.clear();
  makePath(lPath,"A",NULL);
  rPath.clear();
  f7.assign(lPath,f1,rPath);

  f5=f7;
  cout<<endl<<f7<<endl;

  cout<<endl<<"* (f7 A B C) <= Y"<<endl;
  makePath(lPath,"A","B","C",NULL);
  f7.assign(lPath,v10);
  cout<<f7<<endl;

  f7=f5;
  cout<<endl<<f7<<endl;

  cout<<endl<<"* (f7 A B) <= Y"<<endl;
  makePath(lPath,"A","B",NULL);
  f7.assign(lPath,v10);
  cout<<f7<<endl;

  // construct another mega-complex FS f7
  f1.clear();
  makePath(lPath,"B","C",NULL);
  f1.assign(lPath,v10);
  f9.clear();
  makePath(lPath,"C",NULL);
  f9.assign(lPath,v9);
  makePath(lPath,"B",NULL);
  rPath.clear();
  f1.push(lPath,f9,rPath);
  f1.push(lPath,f9,rPath);

  f8.clear();
  makePath(lPath,"C",NULL);
  f8.assign(lPath,v9);
  f9.clear();
  makePath(lPath,"D",NULL);
  f9.assign(lPath,v10);
  f8.mergeOr(f9);
  f9.clear();
  makePath(lPath,"C",NULL);
  f9.assign(lPath,v10);
  f8.mergeOr(f9);
  f2.clear();
  makePath(lPath,"B",NULL);
  rPath.clear();
  f2.assign(lPath,f8,rPath);

  f3.clear();
  makePath(lPath,"B","C",NULL);
  f3.assign(lPath,v9);
  makePath(lPath,"B","D",NULL);
  f3.assign(lPath,v10);

  f1.mergeOr(f2);
  f1.mergeOr(f3);
  f7.clear();
  makePath(lPath,"A",NULL);
  rPath.clear();
  f7.assign(lPath,f1,rPath);

  cout<<endl<<f7<<endl;

  cout<<endl<<"* (f7 A B) <= Y"<<endl;
  makePath(lPath,"A","B",NULL);
  f7.assign(lPath,v10);
  cout<<f7<<endl;

  cout<<endl<<"================ Pseudo-unification with penetrating paths ================"<<endl;

  // construct a mega-complex FS f7
  f1.clear();
  makePath(lPath,"B","C",NULL);
  f1.assign(lPath,v10);
  f9.clear();
  makePath(lPath,"C",NULL);
  f9.assign(lPath,v9);
  f1.assign(lPath,v10);
  makePath(lPath,"B",NULL);
  rPath.clear();
  f1.push(lPath,f9,rPath);

  f8.clear();
  makePath(lPath,"C",NULL);
  f8.assign(lPath,v9);
  f9.clear();
  makePath(lPath,"D",NULL);
  f9.assign(lPath,v10);
  f8.mergeOr(f9);
  f9.clear();
  makePath(lPath,"C",NULL);
  f9.assign(lPath,v10);
  f8.mergeOr(f9);
  f2.clear();
  makePath(lPath,"B",NULL);
  rPath.clear();
  f2.assign(lPath,f8,rPath);

  f3.clear();
  makePath(lPath,"B","C",NULL);
  f3.assign(lPath,v9);
  makePath(lPath,"B","D",NULL);
  f3.assign(lPath,v10);

  f4.clear();
  makePath(lPath,"C",NULL);
  f4.assign(lPath,v10);

  f1.mergeOr(f2);
  f1.mergeOr(f3);
  f1.mergeOr(f4);
  f7.clear();
  makePath(lPath,"A",NULL);
  rPath.clear();
  f7.assign(lPath,f1,rPath);

  cout<<endl<<f7<<endl;

  cout<<endl<<"* (f7 A B C) = Y"<<endl;
  makePath(lPath,"A","B","C",NULL);
  f7.pseudoUnify(lPath,v10);
  cout<<f7<<endl;

  cout<<endl<<"==================== Removal with penetrating paths ===================="<<endl;

  f7=f5;
  cout<<endl<<f7<<endl;

  cout<<endl<<"* (f7 A B C) = *REMOVE*"<<endl;
  makePath(lPath,"A","B","C",NULL);
  f7.remove(lPath);
  cout<<f7<<endl;

  f7=f5;
  cout<<endl<<f7<<endl;

  cout<<endl<<"* (f7 A B) = *REMOVE*"<<endl;
  makePath(lPath,"A","B",NULL);
  f7.remove(lPath);
  cout<<f7<<endl;

  f7=f5;
  cout<<endl<<f7<<endl;

  cout<<endl<<"* (f7 A B D) = *REMOVE*"<<endl;
  makePath(lPath,"A","B","D",NULL);
  f7.remove(lPath);
  cout<<f7<<endl;

  cout<<endl<<"* (f7 A C) = *REMOVE*"<<endl;
  makePath(lPath,"A","C",NULL);
  f7.remove(lPath);
  cout<<f7<<endl;

  cout<<endl<<"* (f7 A B C) = *REMOVE*"<<endl;
  makePath(lPath,"A","B","C",NULL);
  f7.remove(lPath);
  cout<<f7<<endl;

  cout<<endl<<"==================== Popping with penetrating paths ===================="<<endl;

  f8.clear();
  f7=f5;
  cout<<endl<<f8<<endl<<f7<<endl;

  cout<<endl<<"* f8 < (f7 A B)"<<endl;
  lPath.clear();
  makePath(rPath,"A","B",NULL);
  cout<<"-> result = "<<(f8.pop(lPath,f7,rPath)?"true":"false")<<endl;
  cout<<f8<<endl;
  cout<<f7<<endl;

  cout<<endl<<"* f8 < (f7 A B)"<<endl;
  lPath.clear();
  makePath(rPath,"A","B",NULL);
  cout<<"-> result = "<<(f8.pop(lPath,f7,rPath)?"true":"false")<<endl;
  cout<<f8<<endl;
  cout<<f7<<endl;

  f8.clear();
  cout<<endl<<f8<<endl;

  cout<<endl<<"* f8 < (f7 A B)"<<endl;
  lPath.clear();
  makePath(rPath,"A","B",NULL);
  cout<<"-> result = "<<(f8.pop(lPath,f7,rPath)?"true":"false")<<endl;
  cout<<f8<<endl;
  cout<<f7<<endl;

  f8.clear();
  cout<<endl<<f8<<endl;

  cout<<endl<<"* f8 < (f7 A C)"<<endl;
  lPath.clear();
  makePath(rPath,"A","C",NULL);
  cout<<"-> result = "<<(f8.pop(lPath,f7,rPath)?"true":"false")<<endl;
  cout<<f8<<endl;
  cout<<f7<<endl;

  return 0;
}
