// ======================================================================
// fsRegs.cpp - Feature Structure Registers.
// 
// 122502: Benjamin Han <benhdj@cs.cmu.edu> removed "using namespace std;" 
//         and inserted std:: prefix where needed; use FSRegisters::_Parent.
// 071301: Benjamin Han <benhdj@cs.cmu.edu> Created (moved from equation.*).
// 120601: Benjamin Han <benhdj@cs.cmu.edu> FSIdxSet is now a nested class
//         of FSRegisters; changed several int declarations into size_type;
//         namespace added.
// ======================================================================

//    Copyright (C) 2000-2004 Benjamin Han <benhdj@cs.cmu.edu>
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "fsRegs.hpp"

namespace UKernel {

FSRegisters::FSIdxSet &
FSRegisters::FSIdxSet::operator += (const FSIdxSet &fsIdxSet) {
  const_iterator fi;
  
  for (fi=fsIdxSet.begin();fi!=fsIdxSet.end();++fi)
    if (find(*fi)==end()) insert(*fi);

  return *this;
}

FSRegisters::FSRegisters (size_type s):_Parent(s) {
  size_type i;
  std::string idStr,name="X";
  FStruc emptyFS;

  for (i=0;i<s;++i) {
    intToString(i,idStr);
    emptyFS.setName(name+idStr);
    fsList.push_back(emptyFS);
    _Parent::operator[](i)=(--fsList.end());
  }
}

void FSRegisters::add (size_type newFSIdx) {
  size_type i,s=size();

  if (newFSIdx>=s) {
    FStruc emptyFS;
    std::string idStr,name="X";
    
    _Parent::resize(newFSIdx+1);
    for (i=s;i<=newFSIdx;++i) {
      intToString(i,idStr);
      emptyFS.setName(name+idStr);
      fsList.push_back(emptyFS);
      _Parent::operator[](i)=(--fsList.end());
    }
  }
}

void FSRegisters::resize (size_type s) {
  size_type i,j=size();
  
  if (j<s) {
    FStruc emptyFS;
    std::string idStr,name="X";
    
    _Parent::resize(s);
    for (i=j;i<s;++i) {
      intToString(i,idStr);
      emptyFS.setName(name+idStr);
      fsList.push_back(emptyFS);
      _Parent::operator[](i)=(--fsList.end());
    }
  }
  else if (s<j) {
    for (i=s;i<j;++i)
      fsList.erase(_Parent::operator[](i));
    _Parent::resize(s);
  }
}

std::ostream &operator << (std::ostream &os, const FSRegisters &fsRegs) {
  FSRegisters::size_type i,s=fsRegs.size();
  for (i=0;i<s;++i)
    if (i==0) {
      if (!FStruc::indentPrint) os<<fsRegs[0].readName()<<": ";
      os<<fsRegs[0];
    }
    else {
      os<<std::endl;
      indent::print(os);
      if (!FStruc::indentPrint) os<<fsRegs[i].readName()<<": ";
      os<<fsRegs[i];
    }
  return os;
}

};
