// ======================================================================
// fsBoxTst.cpp - Testing code for RHS penetrating paths with undefined 
//                branches (boxes).
//
// 122502: Benjamin Han <benhdj@cs.cmu.edu> using namespace std.
// 101102: Benjamin Han <benhdj@cs.cmu.edu> Created.
// 120202: Benjamin Han <benhdj@cs.cmu.edu> Added missing return in main().
// ======================================================================

//    Copyright (C) 2000-2004 Benjamin Han <benhdj@cs.cmu.edu>
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "fStruc.hpp"

#include <stdarg.h>

using namespace UKernel;
using namespace std;

void makePath (Path &path, char *first, ...)
{
  va_list argp;
  char *ptr;

  path.clear();
  if (first==NULL) return;

  path.push_back(Symbol(first));

  for (va_start(argp,first);(ptr=va_arg(argp,char*))!=NULL;
       path.push_back(Symbol(ptr)));
  va_end(argp);
}

int main () {
  FStruc f1,f2,f3;
  Path lPath,rPath;
  Value v;

  f1.setName(Symbol("f1"));
  f2.setName(Symbol("f2"));
  f3.setName(Symbol("f3"));
  
  // ---------- case 1 ----------
  cout<<"---------- case 1 ----------"<<endl;

  f1.clear();
  makePath(lPath,"ARG",NULL);
  v.clear();
  v.insert(v.begin(),Symbol("A"));
  f1.assign(lPath,v);
  
  f2.clear();
  makePath(lPath,"FOO",NULL);
  v.clear();
  v.insert(v.begin(),Symbol("BAR"));
  f2.assign(lPath,v);

  f2.mergeOr(f1);
  f1.clear();
  makePath(lPath,"TEMP",NULL);
  rPath.clear();
  f1.assign(lPath,f2,rPath);

  cout<<f1<<endl;

  v.clear();
  makePath(lPath,"TEMP","ARG",NULL);
  f1.getValueBox(lPath,v);
  cout<<endl<<"-> (f1 TEMP ARG) is "<<v<<endl;

  v.removeBox();
  v.compact();
  cout<<endl<<"after removeBox(): "<<v<<endl;

  // ---------- case 2 ----------
  cout<<"---------- case 2 ----------"<<endl;

  f1.clear();
  makePath(lPath,"TEMP","ARG",NULL);
  v.clear();
  v.insert(v.begin(),Symbol("A"));
  f1.assign(lPath,v);
  
  f2.clear();
  makePath(lPath,"FOO",NULL);
  v.clear();
  v.insert(v.begin(),Symbol("BAR"));
  f2.assign(lPath,v);

  makePath(lPath,"TEMP",NULL);
  rPath.clear();
  f1.push(lPath,f2,rPath);

  cout<<endl<<f1<<endl;
  
  v.clear();
  makePath(lPath,"TEMP","ARG",NULL);
  f1.getValueBox(lPath,v);
  cout<<endl<<"-> (f1 TEMP ARG) is "<<v<<endl;

  // ---------- case 3 ----------
  cout<<"---------- case 3 ----------"<<endl;

  f1.clear();
  makePath(lPath,"B","D",NULL);
  v.clear();
  v.insert(v.begin(),Symbol("1"));
  f1.assign(lPath,v);
  
  f2.clear();
  makePath(lPath,"C","D",NULL);
  v.clear();
  v.insert(v.begin(),Symbol("2"));
  f2.assign(lPath,v);
  
  f1.mergeOr(f2);

  f2.clear();
  makePath(lPath,"B","D",NULL);
  v.clear();
  v.insert(v.begin(),Symbol("3"));
  f2.assign(lPath,v);

  f1.mergeOr(f2);

  f2.clear();
  makePath(lPath,"A",NULL);
  rPath.clear();
  f2.assign(lPath,f1,rPath);

  cout<<endl<<f2<<endl;

  f1.clear();
  makePath(lPath,"A","B",NULL);
  f2.getFSBox(lPath,f1);
  cout<<endl<<"-> (f2 A B) is "<<endl<<f1<<endl;

  f1.removeBox();
  f1.compact();
  cout<<endl<<"after removeBox(): "<<f1<<endl;

  // ---------- case 4 ----------
  cout<<"---------- case 4 ----------"<<endl;

  f1.clear();
  makePath(lPath,"A","B","D",NULL);
  v.clear();
  v.insert(v.begin(),Symbol("1"));
  f1.assign(lPath,v);
  
  f2.clear();
  makePath(lPath,"C","D",NULL);
  v.clear();
  v.insert(v.begin(),Symbol("2"));
  f2.assign(lPath,v);
  
  makePath(lPath,"A",NULL);
  rPath.clear();
  f1.push(lPath,f2,rPath);

  f2.clear();
  makePath(lPath,"B","D",NULL);
  v.clear();
  v.insert(v.begin(),Symbol("3"));
  f2.assign(lPath,v);

  makePath(lPath,"A",NULL);
  rPath.clear();
  f1.push(lPath,f2,rPath);

  cout<<endl<<f1<<endl;

  f2.clear();
  makePath(lPath,"A","B",NULL);
  f1.getFSBox(lPath,f2);
  cout<<endl<<"-> (f1 A B) is "<<endl<<f2<<endl;

  // ---------- case 5 ----------
  cout<<"---------- case 5 ----------"<<endl;

  f1.clear();
  makePath(lPath,"B","D",NULL);
  v.clear();
  v.insert(v.begin(),Symbol("1"));
  f1.assign(lPath,v);
  
  f2.clear();
  makePath(lPath,"C","D",NULL);
  v.clear();
  v.insert(v.begin(),Symbol("2"));
  f2.assign(lPath,v);
  
  f1.mergeOr(f2);

  f2.clear();
  makePath(lPath,"E",NULL);
  v.clear();
  v.insert(v.begin(),Symbol("3"));
  f2.assign(lPath,v);

  f3.clear();
  makePath(lPath,"D",NULL);
  v.clear();
  v.insert(v.begin(),Symbol("4"));
  f3.assign(lPath,v);

  f2.mergeOr(f3);

  f3.clear();
  makePath(lPath,"B",NULL);
  rPath.clear();
  f3.assign(lPath,f2,rPath);

  f1.mergeOr(f3);
  
  f2.clear();
  makePath(lPath,"A",NULL);
  rPath.clear();
  f2.assign(lPath,f1,rPath);

  cout<<endl<<f2<<endl;

  f1.clear();
  makePath(lPath,"A","B","D",NULL);
  f2.getValueBox(lPath,v);
  cout<<endl<<"-> (f2 A B D) is "<<v<<endl;

  v.removeBox();
  v.compact();
  cout<<endl<<"after removeBox(): "<<v<<endl;

  // ---------- case 6 ----------
  cout<<"---------- case 6 ----------"<<endl;

  f1.clear();
  makePath(lPath,"B","D",NULL);
  v.clear();
  v.insert(v.begin(),Symbol("1"));
  f1.assign(lPath,v);
  
  f2.clear();
  makePath(lPath,"C","D",NULL);
  v.clear();
  v.insert(v.begin(),Symbol("2"));
  f2.assign(lPath,v);
  
  f1.mergeOr(f2);

  f2.clear();
  makePath(lPath,"D",NULL);
  v.clear();
  v.insert(v.begin(),Symbol("3"));
  f2.assign(lPath,v);

  f3.clear();
  makePath(lPath,"E",NULL);
  v.clear();
  v.insert(v.begin(),Symbol("4"));
  f3.assign(lPath,v);

  lPath.clear();
  rPath.clear();
  f2.push(lPath,f3,rPath);

  f3.clear();
  makePath(lPath,"B",NULL);
  rPath.clear();
  f3.assign(lPath,f2,rPath);

  f1.mergeOr(f3);
  
  f2.clear();
  makePath(lPath,"A",NULL);
  rPath.clear();
  f2.assign(lPath,f1,rPath);

  cout<<endl<<f2<<endl;

  f1.clear();
  makePath(lPath,"A","B","D",NULL);
  f2.getValueBox(lPath,v);
  cout<<endl<<"-> (f2 A B D) is "<<v<<endl;

  v.removeBox();
  v.compact();
  cout<<endl<<"after removeBox(): "<<v<<endl;
  
 // ---------- case 7 ----------
  cout<<"---------- case 7 ----------"<<endl;

  f1.clear();
  makePath(lPath,"A","B",NULL);
  v.clear();
  v.insert(v.begin(),Symbol("1"));
  f1.assign(lPath,v);
  
  f2.clear();
  makePath(lPath,"A","C",NULL);
  v.clear();
  v.insert(v.begin(),Symbol("2"));
  f2.assign(lPath,v);
  
  f1.mergeOr(f2);

  f2.clear();
  makePath(lPath,"B",NULL);
  v.clear();
  v.insert(v.begin(),Symbol("3"));
  f2.assign(lPath,v);

  lPath.clear();
  rPath.clear();
  f1.push(lPath,f2,rPath);

  f2.clear();
  makePath(lPath,"A","B",NULL);
  v.clear();
  v.insert(v.begin(),Symbol("4"));
  f2.assign(lPath,v);

  lPath.clear();
  rPath.clear();
  f1.push(lPath,f2,rPath);
  
  cout<<endl<<f1<<endl;
  
  v.clear();
  makePath(lPath,"A","B",NULL);
  f1.getValueBox(lPath,v);
  cout<<endl<<"-> (f1 A B) is "<<v<<endl;  

  v.removeBox();
  v.compact();
  cout<<endl<<"after removeBox(): "<<v<<endl;

  return 0;
}
