// ======================================================================
// fStrucFunc.cpp - Collecting all mp-, rp- and cb- series functions used
//                  in fStruc.?pp, together with some supporting code.
// 
// 122502: Benjamin Han <benhdj@cs.cmu.edu> removed "using namespace std;" 
//         and inserted std:: prefix where needed.
// 112002: Benjamin Han <benhdj@cs.cmu.edu> nullTI -> nullTI().
// 102102: Benjamin Han <benhdj@cs.cmu.edu> Changed code with Feature::vFlag
//         to use Feature::isValue() and Feature::setValue(); bugs fixed
//         in mpConstrainFSPathExistFunc() and rpConstrainFSFunc(): the 
//         names of the starting LHS and RHS iterators need not be the same.
// 092802: Benjamin Han <benhdj@cs.cmu.edu> Created (pulled out from 
//         fStruc.hpp); added FStruc::isomorphicSameRootRelaxed() and the 
//         supporting code to testisomorphism up to the unifiability of 
//         values.
// ======================================================================

//    Copyright (C) 2000-2004 Benjamin Han <benhdj@cs.cmu.edu>
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "fStruc.hpp"

namespace UKernel {

// used by FStruc::isomorphicSameRoot() and FStruc::isomorphicSameRootRelaxed()
struct StrictOp {
  typedef _TreeNode<Feature,std::less<Feature> > TNode;

  bool operator () (TreeConstIteratorBase(Feature,TNode,std::less<Feature> ) &ti) const {
    return (ti.size() && ti.begin()->name.isSpecial(Symbol::MULTIPLE));
  }
};

// used by FStruc::isomorphicSameRoot()
struct FEqVIsomorphism {
  bool operator () (const FStruc::ConstIterator &iter1, 
		    const FStruc::ConstIterator &iter2) const {
    if (iter1->isValue()==iter2->isValue())
      if (iter1->isValue()) return (*(iter1->vi)==*(iter2->vi));
      else return true;
    else return false;
  }
};

// used by FStruc::isomorphicSameRootRelaxed()
struct FEqVUnifiable {
  bool operator () (const FStruc::ConstIterator &iter1, 
		    const FStruc::ConstIterator &iter2) const {
    if (iter1->isValue()==iter2->isValue())
      if (iter1->isValue()) return (iter1->vi->test(*(iter2->vi)));
      else return true;
    else return false;
  }
};

bool FStruc::isomorphicSameRoot (ConstIterator iter1, ConstIterator iter2) const {
  ConstIterator::size_type s;

  static TIsomorphismMixed<Feature,StrictOp,std::less<Feature>,
    _DefaultTIsomorphismOp<Tree<Feature> >,
    FEqVIsomorphism> isoMFunc;

  if ((s=iter1.size())!=iter2.size()) return false;
  else if (s)
    if (iter1.begin()->name.isSpecial(Symbol::MULTIPLE)) {
      ConstDIterator dIter1,dIter2;
	
      // strict test
      for (dIter1=iter1.begin(),dIter2=iter2.begin();
	   dIter1!=iter1.end() && dIter2!=iter2.end();
	   ++dIter1,++dIter2)
	if (!isoMFunc(dIter1,dIter2)) return false;
      return true;
    }
    else return isoMFunc(iter1,iter2,false);  // relaxed test
  else return true;  // "same-root" assumption
}

bool FStruc::isomorphicSameRootRelaxed (ConstIterator iter1, ConstIterator iter2) const {
  ConstIterator::size_type s;

  static TIsomorphismMixed<Feature,StrictOp,std::less<Feature>,
    _DefaultTIsomorphismOp<Tree<Feature> >,
    FEqVUnifiable> isoMFunc;

  if ((s=iter1.size())!=iter2.size()) return false;
  else if (s)
    if (iter1.begin()->name.isSpecial(Symbol::MULTIPLE)) {
      ConstDIterator dIter1,dIter2;
	
      // strict test
      for (dIter1=iter1.begin(),dIter2=iter2.begin();
	   dIter1!=iter1.end() && dIter2!=iter2.end();
	   ++dIter1,++dIter2)
	if (!isoMFunc(dIter1,dIter2)) return false;
      return true;
    }
    else return isoMFunc(iter1,iter2,false);  // relaxed test
  else return true;  // "same-root" assumption
}

bool FStruc::mpPUVPathNotExistFunc (PathIterator &pIter) {
  assert(vPtr);
  
  extendPath(pIter);

  Feature &f=pIter.get();
  
  f.setValue(true);
  f.vi=vList.add(*vPtr);
  if (f.vi->removeBox()) f.vi->compact();
  return true;
}

bool FStruc::mpPUVPathExistFunc (PathIterator &pIter) {
  assert(vPtr);
  return (pIter->isValue() && pIter->vi->pseudoUnify(*vPtr));
}

bool FStruc::mpPUFSPathNotExistFunc (PathIterator &lPIter) {
  FStruc::FrontIterator fIter;
  FStruc::ConstDIterator dIter;
  
  extendPath(lPIter);
  
  // default vFlag is false
  for (dIter=rIter.begin();dIter!=rIter.end();++dIter)
    insert(lPIter.end(),dIter);

  if (removeBox(lPIter)) compact(lPIter);
  
  // var duplication
  for (fIter=lPIter;fIter!=fIter.nullTI();++fIter) {
    assert(fIter->isValue());
    fIter.get().vi=vList.add(fIter->vi);
  }

  return true;
}

bool FStruc::mpPUFSPathExistFunc (PathIterator &lPIter) {
  return (!lPIter->isValue() && pseudoUnify(lPIter,rIter));
}

// for constraint equations with values: just testing the unifiaibility, 
// not really doing it
bool FStruc::mpConstrainVPathExistFunc (PathIterator &lPIter) {
  return (lPIter->isValue() && lPIter->vi->test(*vPtr));
}

// for constraint equations with FS: just testing the isomorphism, up to the
// unifiability of values
// NOTE: will return false if RHS has boxes
bool FStruc::mpConstrainFSPathExistFunc (PathIterator &lPIter) {
  return (!lPIter->isValue() && isomorphicSameRootRelaxed(lPIter,rIter));
}

// NOTE: boxes in RHS is dealt with in FStruc::test()
bool FStruc::mpTestFSPathExistFunc (PathIterator &lPIter) {
  ConstIterator tmpIter=lPIter;
  return (!lPIter->isValue() && test(tmpIter,rIter));
}

bool FStruc::mpIsoVPathExistFunc (PathIterator &lPIter) {
  return (lPIter->isValue() && *(lPIter->vi)==(*vPtr));
}

// NOTE: will return false if RHS has boxes
bool FStruc::mpIsoFSPathExistFunc (PathIterator &lPIter) {
  return (!lPIter->isValue() && isomorphicSameRoot(lPIter,rIter));
}

bool FStruc::mpNumberPathExistFunc (PathIterator &pIter) {
  return (pIter->isValue() && pIter->vi->isNumber());
}

bool FStruc::mpIntegerPathExistFunc (PathIterator &pIter) {
  return (pIter->isValue() && pIter->vi->isInteger());
}
  
bool FStruc::mpPositivePathExistFunc (PathIterator &pIter) {
  return (pIter->isValue() && pIter->vi->isPositive());
}

bool FStruc::mpAssignVFunc (PathIterator &pIter) {
  assert(vPtr);
  
  if (pIter.pathDist()) {
    if (pIter->isValue()) {
      // destroy the value that is in the way
      pIter.get().setValue(false);
      vList.erase(pIter->vi);
    }
    extendPath(pIter);
  }
  else clear(pIter);

  Feature &f=pIter.get();

  // ASSUMPTION: *vPtr has no box
  f.setValue(true);
  f.vi=vList.add(*vPtr);
  
  return true;
}

bool FStruc::mpAssignFSFunc (PathIterator &pIter) {
  ConstDIterator dIter;
  FrontIterator fIter;

  if (pIter.pathDist()) {
    if (pIter->isValue()) {
      // destroy the value that is in the way
      pIter.get().setValue(false);
      vList.erase(pIter->vi);
    }
    extendPath(pIter);
  }
  else {
    clear(pIter);
    pIter.get().setValue(false);
  }
   
  // ASSUMPTION: rIter has no box in any of its descendants
  for (dIter=rIter.begin();dIter!=rIter.end();++dIter)
    for (fIter=insert(pIter.end(),dIter);fIter!=fIter.nullTI();++fIter) {
      assert(fIter->isValue());
      fIter.get().vi=vList.add(fIter->vi);
    }

  return true;
}

// ASSUMPTION: 1. *this must not be empty
//             2. *vPtr has no box
bool FStruc::mpPushVFunc (PathIterator &pIter) {
  assert(vPtr);

  // ASSUMPTION: 1. no value is in the way
  //             2. *vPtr has no box
  if (pIter.pathDist()) {
    extendPath(pIter);

    Feature &f=pIter.get();
    f.setValue(true);
    f.vi=vList.add(*vPtr);
    return true;
  }
  else if (pIter->isValue()) {
    pIter->vi->push(*vPtr);
    return true;
  }
  
  return false;
}

// ASSUMPTION: rIter has no box in any of its descendants
bool FStruc::mpPushFSFunc (PathIterator &lPIter) {
  FrontIterator fIter;

  if (lPIter.pathDist()) {
    ConstDIterator rDIter;
    
    extendPath(lPIter);
    for (rDIter=rIter.begin();rDIter!=rIter.end();++rDIter)	    
      for (fIter=insert(lPIter.end(),rDIter);fIter!=fIter.nullTI();++fIter) {
	assert(fIter->isValue());
	fIter.get().vi=vList.add(fIter->vi);
      }      
    return true;
  }
  else if (!lPIter->isValue()) {
    Feature f;
    DIterator lDIter=lPIter;
    
    // if LHS is not a *MULTIPLE* FS, make it so
    if (!lDIter.begin()->name.isSpecial(Symbol::MULTIPLE)) {
      // default Feature is a non-value node
      demote(lDIter,Feature(lDIter->name));
      
      // change the name of *lDIter via _TreeIteratorBase<>::update()
      // must do this way to ensure correct indexing
      f=*lDIter;
      f.name.setSpecial(Symbol::MULTIPLE);
      lDIter.update(f);
      
      lDIter.up();
    }
      
    // lDIter points to the 'top' LHS node
    if (rIter.begin()->name.isSpecial(Symbol::MULTIPLE)) {
      ConstDIterator rDIter;
      size_type i;
	  
      // RHS is a *MULTIPLE* FS
      for (i=rIter.size(),rDIter=rIter.end();i;--i)
	for (fIter=insert(lDIter.begin(),--rDIter);fIter!=fIter.nullTI();++fIter) {
	  assert(fIter->isValue());
	  fIter.get().vi=vList.add(fIter->vi);
	}
    }
    else {
      // RHS is a non-*MULTIPLE* FS
      Iterator iter=insert(lDIter.begin(),rIter);
      
      // change the name of *iter via _TreeIteratorBase<>::update()
      // must do this way to ensure correct indexing
      f=*iter;
      f.name.setSpecial(Symbol::MULTIPLE);
      iter.update(f);
      
      for (fIter=iter;fIter!=fIter.nullTI();++fIter) {
	assert(fIter->isValue());
	fIter.get().vi=vList.add(fIter->vi);
      }
    }

    return true;
  }

  return false;
}

bool FStruc::rpConstrainVFunc (ConstIterator &iter) const {
  return (iter->isValue() && iter->vi->test(*vPtr));
}

// NOTE: will return false if RHS has boxes
bool FStruc::rpConstrainFSFunc (ConstIterator &iter) const {
  return (!iter->isValue() && isomorphicSameRootRelaxed(iter,rIter));
}

// NOTE: boxes in RHS is dealt with in FStruc::test()
bool FStruc::rpTestFSFunc (ConstIterator &iter) const {
  return (!iter->isValue() && test(iter,rIter));
}

bool FStruc::rpIsoVFunc (ConstIterator &iter) const {
  return (iter->isValue() && *(iter->vi)==*vPtr);
}

// NOTE: will return false if RHS has boxes
bool FStruc::rpIsoFSFunc (ConstIterator &iter) const {
  return (!iter->isValue() && isomorphicSameRoot(iter,rIter));
}

void FStruc::cbPopFunc (ConstIterator &iter) const {
  ConstIterator dIter;

  if (iter.size() && (dIter=iter.begin())->name.isSpecial(Symbol::MULTIPLE))
    iter=dIter;
}

}
