// ======================================================================
// equation.cpp - This models a single equation.
// 
// 011403: Benjamin Han <benhdj@cs.cmu.edu> removed "using namespace std;" 
//         and inserted std:: prefix where needed.
// 110602: Benjamin Han <benhdj@cs.cmu.edu> _EquType4 has a new reference member
//         g of type Grammar: extension functions now know where to get the
//         global resource from the corresponding grammar.
// 103002: Benjamin Han <benhdj@cs.cmu.edu> Added _EquType5 (type 5 equations)
//         to deal with "(lFS lPath) op QFS" (QFS = quoted FS).
// 092802: Benjamin Han <benhdj@cs.cmu.edu> Changed the _EquType3::run():
//         for "LHS = *UNDEFINED*" now a function call FStruc::isUndefined()
//         is made instead of !FStruc::isDefined(); added the no-filter version
//         of constrain, test and isomorphism operators (=c', =t' and =i').
// 091802: Benjamin Han <benhdj@cs.cmu.edu> Changed the behavior of type 4
//         equations: in _EquType4::run() if the execution of the extension
//         function returns false, the resultFS is cleared to empty and
//         is used in the following operation specified by opCode (before
//         this would fail the entire equation) - per Donna Gates' request.
// 072102: Benjamin Han <benhdj@cs.cmu.edu> Added "default:" statement to
//         several switch statements to suppress gcc 3.1 warnings (about
//         some enum values not handled).
// 120601: Benjamin Han <benhdj@cs.cmu.edu> Changed several int declarations
//         into the FSRegisters::size_type; namespace added.
// 092601: Benjamin Han <benhdj@cs.cmu.edu> Added new isomorphism operator
//         ("=i") to equation type 1, 2 & 4.
// 090601: Benjamin Han <benhdj@cs.cmu.edu> Changed Symbol::OP_EQUAL to 
//         Symbol::OP_TEST; changed calls to FStruc()::equal() to 
//         FStruc()::test(); added new constraint operator ("=c") to equation
//         type 1, 2 & 4.
// 090301: Benjamin Han <benhdj@cs.cmu.edu> Minor revisions to supress warnings
//         under -pedantic -Wall.
// 071301: Benjamin Han <benhdj@cs.cmu.edu> Revised the equation type 4 to be
//         the interface to the extension functions, via which the lexicon
//         facility is now implemented; removed equation type 5-10 (no more
//         next-lex but much more flexible get-lex/get-lex-fs); moved
//         FSRegisters code to fsRegs.*.
// 070601: Benjamin Han <benhdj@cs.cmu.edu> Changed FStruc::append() to
//         FStruc::push().
// 063001: Benjamin Han <benhdj@cs.cmu.edu> Added class FSIdxSet; 
//         FSRegisters::add() now returns nothing.
// 062901: Benjamin Han <benhdj@cs.cmu.edu> Changed the way an FS is addressed -
//         now at compile time only the index of an FS in FSRegisters is kept,
//         and when running one needs to suppy a copy of FSRegisters; moved
//         FSRegsiters from grammar.* to here.
// 062401: Benjamin Han <benhdj@cs.cmu.edu> Revised to use FStruc::removeAtom()
//         in the constructors for _EquType9 and _EquType10.
// 062101: Benjamin Han <benhdj@cs.cmu.edu> Revised comments and printing
//         routines to ensure consistent quoting for get-lex/get-lex-fs; added
//         equation type 9 and 10 (for get-lex-fs equations with unquoted
//         (FS PATH)); augmented _EquType4 accordingly.
// 061401: Benjamin Han <benhdj@cs.cmu.edu> Added all lexical equations
//         (type 4 to 8); changed type 3 EBlockMain constructor prototype
//         - the ending argument is changed from const Symbol& to
//         Symbol::SymCode.
// 061201: Benjamin Han <benhdj@cs.cmu.edu> Now type 1 equations can use
//         Symbol::OP_EQUAL operator (removed the assertiong in 
//         _EquType1::run() ).
// 052001: Benjamin Han <benhdj@cs.cmu.edu> Removed Equations and added
//         eBlock.* for "equation blocks" (and, or, eor, case) - now
//         equation.* models a single equation.
// 051801: Benjamin Han <benhdj@cs.cmu.edu> Now each type has its own run()
//         and print(), which are two virtual functions (today's compilers
//         should make this as efficient as using switch statements).
// 051701: Benjamin Han <benhdj@cs.cmu.edu> Changed Equations::run() into
//         a const method.
// 051501: Benjamin Han <benhdj@cs.cmu.edu> Created.
// ======================================================================

//    Copyright (C) 2000-2004 Benjamin Han <benhdj@cs.cmu.edu>
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "equation.hpp"

namespace UKernel {

std::ostream &operator << (std::ostream &os, const _Equation &e) {
  e.print(os);
  return os;
}

bool _EquType1::run (FSRegisters &fsRegs) const {
  switch (opCode) {
  case Symbol::OP_PSEUDO_UNIFY:
    return fsRegs[lFSPath.fsIdx].pseudoUnify(lFSPath.path,fsRegs[rFSPath.fsIdx],rFSPath.path);
  case Symbol::OP_CONSTRAIN:
    return fsRegs[lFSPath.fsIdx].constrain(lFSPath.path,fsRegs[rFSPath.fsIdx],rFSPath.path);
  case Symbol::OP_CONSTRAIN_NOFILTER:
    return fsRegs[lFSPath.fsIdx].constrainNoFilter(lFSPath.path,fsRegs[rFSPath.fsIdx],rFSPath.path);
  case Symbol::OP_TEST:
    return fsRegs[lFSPath.fsIdx].test(lFSPath.path,fsRegs[rFSPath.fsIdx],rFSPath.path);
  case Symbol::OP_TEST_NOFILTER:
    return fsRegs[lFSPath.fsIdx].testNoFilter(lFSPath.path,fsRegs[rFSPath.fsIdx],rFSPath.path);
  case Symbol::OP_ISO:
    return fsRegs[lFSPath.fsIdx].isomorphism(lFSPath.path,fsRegs[rFSPath.fsIdx],rFSPath.path);
  case Symbol::OP_ISO_NOFILTER:
    return fsRegs[lFSPath.fsIdx].isomorphismNoFilter(lFSPath.path,fsRegs[rFSPath.fsIdx],rFSPath.path);
  case Symbol::OP_ASSIGN:
    return fsRegs[lFSPath.fsIdx].assign(lFSPath.path,fsRegs[rFSPath.fsIdx],rFSPath.path);
  case Symbol::OP_REMOVE_ASSIGN:
    return fsRegs[lFSPath.fsIdx].removeAssign(lFSPath.path,fsRegs[rFSPath.fsIdx],rFSPath.path);
  case Symbol::OP_PUSH:
    return fsRegs[lFSPath.fsIdx].push(lFSPath.path,fsRegs[rFSPath.fsIdx],rFSPath.path);
  case Symbol::OP_POP:
    return fsRegs[lFSPath.fsIdx].pop(lFSPath.path,fsRegs[rFSPath.fsIdx],rFSPath.path);
  default: throw;  // just to suppress compiler warnings
  }

  return false;
}

void _EquType1::print (std::ostream &os) const {
  os<<lFSPath<<' '<<Symbol(opCode)<<' '<<rFSPath;
}

bool _EquType2::run (FSRegisters &fsRegs) const {
  assert(opCode!=Symbol::OP_REMOVE_ASSIGN && opCode!=Symbol::OP_PUSH && 
	 opCode!=Symbol::OP_POP);
  
  switch (opCode) {
  case Symbol::OP_PSEUDO_UNIFY:
    return fsRegs[lFSPath.fsIdx].pseudoUnify(lFSPath.path,v);
  case Symbol::OP_CONSTRAIN:
    return fsRegs[lFSPath.fsIdx].constrain(lFSPath.path,v);
  case Symbol::OP_CONSTRAIN_NOFILTER:
    return fsRegs[lFSPath.fsIdx].constrainNoFilter(lFSPath.path,v);
  case Symbol::OP_TEST:
    return fsRegs[lFSPath.fsIdx].test(lFSPath.path,v);
  case Symbol::OP_TEST_NOFILTER:
    return fsRegs[lFSPath.fsIdx].testNoFilter(lFSPath.path,v);
  case Symbol::OP_ISO:
    return fsRegs[lFSPath.fsIdx].isomorphism(lFSPath.path,v);
  case Symbol::OP_ISO_NOFILTER:
    return fsRegs[lFSPath.fsIdx].isomorphismNoFilter(lFSPath.path,v);
  case Symbol::OP_ASSIGN:
    return fsRegs[lFSPath.fsIdx].assign(lFSPath.path,v);
  default: throw;  // just to suppress compiler warnings
  }
  
  return false;
}

void _EquType2::print (std::ostream &os) const {
  os<<lFSPath<<' '<<Symbol(opCode)<<' '<<v;
}

bool _EquType3::run (FSRegisters &fsRegs) const {
  switch (symCode) {
  case Symbol::REMOVE:
    return fsRegs[lFSPath.fsIdx].remove(lFSPath.path);
  case Symbol::DEFINED:
    return fsRegs[lFSPath.fsIdx].isDefined(lFSPath.path);
  case Symbol::UNDEFINED:
    return fsRegs[lFSPath.fsIdx].isUndefined(lFSPath.path);
  case Symbol::POSITIVE:
    return fsRegs[lFSPath.fsIdx].isPositive(lFSPath.path);
  case Symbol::INTEGER:
    return fsRegs[lFSPath.fsIdx].isInteger(lFSPath.path);
  case Symbol::NUMBER:
    return fsRegs[lFSPath.fsIdx].isNumber(lFSPath.path);
  default: throw;  // just to suppress compiler warnings
  }
  
  return false;
}

void _EquType3::print (std::ostream &os) const {
  Symbol sym(symCode);

  os<<lFSPath<<' '<<Symbol(Symbol::OP_PSEUDO_UNIFY)<<' '<<sym;
}

_EFTable _EquType4::efTable;
Path _EquType4::emptyPath;

_EquType4::_EquType4 (FSRegisters::size_type lFSIdx, const Path &lPath, const Symbol &funcName, 
		      const EFArgs &req, const EFArgs &opt,
		      Symbol::SymCode opCode, Grammar &g)
  :_Equation(lFSIdx,lPath),req(req),opt(opt),opCode(opCode),g(g) {
  if (!efTable.isInit()) efTable.init();
  efPtr=efTable.find(funcName,_EquType4::req,_EquType4::opt);

  assert(efPtr);
}

bool _EquType4::run (FSRegisters &fsRegs) const {
  assert(opCode!=Symbol::OP_REMOVE_ASSIGN && opCode!=Symbol::OP_POP);

  FStruc resultFS;

  // if the extension function returns false, the resultFS is cleared to empty
  if (!(*efPtr)(g,fsRegs,req,opt,resultFS)) resultFS.clear();

  switch (opCode) {
    case Symbol::OP_PSEUDO_UNIFY:
      return fsRegs[lFSPath.fsIdx].pseudoUnify(lFSPath.path,resultFS,emptyPath);
    case Symbol::OP_CONSTRAIN:
      return fsRegs[lFSPath.fsIdx].constrain(lFSPath.path,resultFS,emptyPath);
    case Symbol::OP_CONSTRAIN_NOFILTER:
      return fsRegs[lFSPath.fsIdx].constrainNoFilter(lFSPath.path,resultFS,emptyPath);
    case Symbol::OP_TEST:
      return fsRegs[lFSPath.fsIdx].test(lFSPath.path,resultFS,emptyPath);
    case Symbol::OP_TEST_NOFILTER:
      return fsRegs[lFSPath.fsIdx].testNoFilter(lFSPath.path,resultFS,emptyPath);
    case Symbol::OP_ISO:
      return fsRegs[lFSPath.fsIdx].isomorphism(lFSPath.path,resultFS,emptyPath);
    case Symbol::OP_ISO_NOFILTER:
      return fsRegs[lFSPath.fsIdx].isomorphismNoFilter(lFSPath.path,resultFS,emptyPath);
    case Symbol::OP_ASSIGN:
      return fsRegs[lFSPath.fsIdx].assign(lFSPath.path,resultFS,emptyPath);
    case Symbol::OP_PUSH:
      return fsRegs[lFSPath.fsIdx].push(lFSPath.path,resultFS,emptyPath);
    default: throw;  // just to suppress compiler warnings
  }
}

void _EquType4::print (std::ostream &os) const {
  os<<lFSPath<<' '<<Symbol(opCode)<<" (";
  efPtr->print(os,req,opt);
  os<<')';
}

bool _EquType5::run (FSRegisters &fsRegs) const {
  Path rPath;  // empty RHS path

  switch (opCode) {
  case Symbol::OP_PSEUDO_UNIFY:
    return fsRegs[lFSPath.fsIdx].pseudoUnify(lFSPath.path,fs,rPath);
  case Symbol::OP_CONSTRAIN:
    return fsRegs[lFSPath.fsIdx].constrain(lFSPath.path,fs,rPath);
  case Symbol::OP_CONSTRAIN_NOFILTER:
    return fsRegs[lFSPath.fsIdx].constrainNoFilter(lFSPath.path,fs,rPath);
  case Symbol::OP_TEST:
    return fsRegs[lFSPath.fsIdx].test(lFSPath.path,fs,rPath);
  case Symbol::OP_TEST_NOFILTER:
    return fsRegs[lFSPath.fsIdx].testNoFilter(lFSPath.path,fs,rPath);
  case Symbol::OP_ISO:
    return fsRegs[lFSPath.fsIdx].isomorphism(lFSPath.path,fs,rPath);
  case Symbol::OP_ISO_NOFILTER:
    return fsRegs[lFSPath.fsIdx].isomorphismNoFilter(lFSPath.path,fs,rPath);
  case Symbol::OP_ASSIGN:
    return fsRegs[lFSPath.fsIdx].assign(lFSPath.path,fs,rPath);
  case Symbol::OP_PUSH:
    return fsRegs[lFSPath.fsIdx].push(lFSPath.path,fs,rPath);
  default: throw;  // just to suppress compiler warnings
  }

  return false;
}

void _EquType5::print (std::ostream &os) const {
  bool backup=FStruc::indentPrint;

  FStruc::indentPrint=false;
  os<<lFSPath<<' '<<Symbol(opCode)<<" \'"<<fs;
  FStruc::indentPrint=backup;
}

};
