// ======================================================================
// equTst.cpp - Testing and demonstrating the use of eBlock.*; also showing
//             how to do indented printing right.
// 
// 061904: Benjamin Han <benhdj@cs.cmu.edu> Declaration of Grammar g no longer
//         specifies direction (compile-time option now).
// 103002: Benjamin Han <benhdj@cs.cmu.edu> Added a test for type 5 equations.
// 091802: Benjamin Han <benhdj@cs.cmu.edu> Added one GET-LEX example where
//         the 1st arg (a path) is undefined, to illustrate the new behavior
//         of type 4 equations.
// 120601: Benjamin Han <benhdj@cs.cmu.edu> Namespace added.
// 090601: Benjamin Han <benhdj@cs.cmu.edu> Changed Symbol::OP_EQUAL to
//         Symbol::OP_TEST.
// 081601: Benjamin Han <benhdj@cs.cmu.edu> Convert some lowercase identifiers
//         in the comments to uppercase, to emphasize that case is significant
//         in UKernel.
// 072001: Benjamin Han <benhdj@cs.cmu.edu> Revised using the new ways to
//         declare tree iterators.
// 071301: Benjamin Han <benhdj@cs.cmu.edu> Revised all lexical lookup tests
//         after changing the lexicon facility implementation.
// 070501: Benjamin Han <benhdj@cs.cmu.edu> Add tests for *OR* blocks.
// 062901: Benjamin Han <benhdj@cs.cmu.edu> Revised after the change of FS
//         addressing.
// 062301: Benjamin Han <benhdj@cs.cmu.edu> Revised the way of initializing
//         an FS (calling FStruc::assign() instead of running equations).
// 062101: Benjamin Han <benhdj@cs.cmu.edu> Revised comments to ensure
//         consistent quoting for GET-LEX/GET-LEX-fs; added tests for
//         GET-LEX-fs equations with unquoted (FS PATH).
// 061401: Benjamin Han <benhdj@cs.cmu.edu> Added tests for lexicon*.
// 052001: Benjamin Han <benhdj@cs.cmu.edu> eBlock.* are used instead of
//         equation.*.
// 051501: Benjamin Han <benhdj@cs.cmu.edu> Created.
// ======================================================================

//    Copyright (C) 2000-2004 Benjamin Han <benhdj@cs.cmu.edu>
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "eBlock.hpp"
#include "grammar.hpp"

using namespace UKernel;
using namespace std;

int main () {
  Value::Iterator vIter;
  FSRegisters fsRegs(3);
  FStruc keyFS(Symbol("KEY")),*fsPtr;
  FStruc oldX0,oldX1,oldX2;
  Symbol symEng("ENG"),symGer("GER"),symCatN("N"),symCatV("V"),
    symRoot("ROOT"),symClass("CLASS");
  EBlockMain mainEB,*mainEBPtr;
  EBlockOr orEB;
  Path lPath,rPath;
  Value v;
  Lexicons lexicons;  // this by default becomes the active Lexicons

  // ==================== initialize Lexicons ====================

  Lexicon &lexiconGer=lexicons.addLexicon(symGer);

  // (YOU ((CAT N) (ROOT SIE)))
  fsPtr=&lexiconGer.addLex(Symbol("YOU"),symCatN);
  lPath.clear();
  lPath.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("SIE"));
  fsPtr->assign(lPath,v);
  lPath.clear();
  lPath.push_back(Symbol("PERS"));
  v.clear();
  v.insert(v.begin(),Symbol("2"));
  fsPtr->assign(lPath,v);

  // (RUN ((CAT V) (ROOT LAUFEN) (CLASS *PROCESS*)))
  fsPtr=&lexiconGer.addLex(Symbol("RUN"),symCatV);
  lPath.clear();
  lPath.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("LAUFEN"));
  fsPtr->assign(lPath,v);
  lPath.clear();
  lPath.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*PROCESS*"));
  fsPtr->assign(lPath,v);

  // (RUN ((CAT V) (ROOT LAUFEN) (CLASS *MOVEMENT*)))
  fsPtr=&lexiconGer.addLex(Symbol("RUN"),symCatV);
  lPath.clear();
  lPath.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("LAUFEN"));
  fsPtr->assign(lPath,v);
  lPath.clear();
  lPath.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*MOVEMENT*"));
  fsPtr->assign(lPath,v);

  Lexicon &lexiconEng=lexicons.addLexicon(symEng);

  // (YOU ((CAT N) (ROOT YOU) (PERS 2) (NUM SG)))
  fsPtr=&lexiconEng.addLex(Symbol("YOU"),symCatN);
  lPath.clear();
  lPath.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("YOU"));
  fsPtr->assign(lPath,v);
  lPath.clear();
  lPath.push_back(Symbol("PERS"));
  v.clear();
  v.insert(v.begin(),Symbol("2"));
  fsPtr->assign(lPath,v);
  lPath.clear();
  lPath.push_back(Symbol("NUM"));
  v.clear();
  v.insert(v.begin(),Symbol("SG"));
  fsPtr->assign(lPath,v);

  // (YOU ((CAT N) (ROOT YOU) (PERS 2) (NUM PL)))
  fsPtr=&lexiconEng.addLex(Symbol("YOU"),symCatN);
  lPath.clear();
  lPath.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("YOU"));
  fsPtr->assign(lPath,v);
  lPath.clear();
  lPath.push_back(Symbol("PERS"));
  v.clear();
  v.insert(v.begin(),Symbol("2"));
  fsPtr->assign(lPath,v);
  lPath.clear();
  lPath.push_back(Symbol("NUM"));
  v.clear();
  v.insert(v.begin(),Symbol("PL"));
  fsPtr->assign(lPath,v);

  // (RUN ((CAT V) (ROOT RUN) (CLASS *PROCESS*)))
  fsPtr=&lexiconEng.addLex(Symbol("RUN"),symCatV);
  lPath.clear();
  lPath.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("RUN"));
  fsPtr->assign(lPath,v);
  lPath.clear();
  lPath.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*PROCESS*"));
  fsPtr->assign(lPath,v);

  // (RUN ((CAT V) (ROOT RUN) (CLASS *MOVEMENT*)))
  fsPtr=&lexiconEng.addLex(Symbol("RUN"),symCatV);
  lPath.clear();
  lPath.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("RUN"));
  fsPtr->assign(lPath,v);
  lPath.clear();
  lPath.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*MOVEMENT*"));
  fsPtr->assign(lPath,v);

  cout<<"============ test non-lexical equations ============"<<endl;

  // ==================== initialize X0 ====================
  // (X0 SUBJ PRED) <= YOU
  lPath.clear();
  lPath.push_back(Symbol("SUBJ"));
  lPath.push_back(Symbol("PRED"));
  v.clear();
  v.insert(v.begin(),Symbol("YOU"));
  fsRegs[0].assign(lPath,v);

  // (X0 SUBJ PERS) <= 2
  lPath.clear();
  lPath.push_back(Symbol("SUBJ"));
  lPath.push_back(Symbol("PERS"));
  v.clear();
  v.insert(v.begin(),Symbol("2"));
  fsRegs[0].assign(lPath,v);

  // (X0 SUBJ NUM) <= (*OR* SG PL)
  lPath.clear();
  lPath.push_back(Symbol("SUBJ"));
  lPath.push_back(Symbol("NUM"));
  v.clear();
  vIter=v.insert(v.begin(),symOr);
  v.insert(vIter.end(),Symbol("SG"));
  v.insert(vIter.end(),Symbol("PL"));
  fsRegs[0].assign(lPath,v);

  // (X0 PRED) <= RUN
  lPath.clear();
  lPath.push_back(Symbol("PRED"));
  v.clear();
  v.insert(v.begin(),Symbol("RUN"));
  fsRegs[0].assign(lPath,v);

  oldX0=fsRegs[0];

  // ==================== RUN equations ====================

  cout<<"* Testing an AND block on "<<indent(26)<<fsRegs[0]<<indent(-26)<<endl<<endl;

  mainEB.clearBlocks();

  // X1 == (X0 SUBJ)
  lPath.clear();
  rPath.clear();
  rPath.push_back(Symbol("SUBJ"));
  mainEB.addBlock(new EBlockMain(1,lPath,0,rPath,Symbol::OP_REMOVE_ASSIGN));

  // X2 <= X0
  lPath.clear();
  rPath.clear();
  mainEB.addBlock(new EBlockMain(2,lPath,0,rPath,Symbol::OP_ASSIGN));

  // (X2 PERS) = (X1 PERS)
  lPath.clear();
  lPath.push_back(Symbol("PERS"));
  mainEB.addBlock(new EBlockMain(2,lPath,1,lPath,Symbol::OP_PSEUDO_UNIFY));

  // (X2 NUM) = (X1 NUM)
  lPath.clear();
  lPath.push_back(Symbol("NUM"));
  mainEB.addBlock(new EBlockMain(2,lPath,1,lPath,Symbol::OP_PSEUDO_UNIFY));
  
  cout<<"* The block: "<<indent(13)<<mainEB<<endl<<endl<<indent(-13);

  cout<<"-> "<<(mainEB.run(fsRegs)?"TRUE":"FALSE")<<endl;  
  oldX1=fsRegs[1];
  oldX2=fsRegs[2];

  cout<<fsRegs<<endl<<endl;

  fsRegs[0]=oldX0;
  fsRegs[1].clear();
  fsRegs[2].clear();
  cout<<"* Testing an *OR* block on "<<indent(27)<<fsRegs[0]<<indent(-27)<<endl;
  cout<<"* X1 and X2 are cleared."<<endl<<endl;
  orEB.clearBlocks();

  // the 1st block: (((X0 SUBJ NUM) =t SG)
  //                 ((X1 NUM) = SG)
  //                 ((X2 NUM) = (X1 NUM)))
  mainEBPtr=new EBlockMain();
  lPath.clear();
  rPath.clear();
  lPath.push_back(Symbol("SUBJ"));
  lPath.push_back(Symbol("NUM"));
  v.clear();
  v.insert(v.begin(),Symbol("SG"));
  mainEBPtr->addBlock(new EBlockMain(0,lPath,v,Symbol::OP_TEST));
  lPath.clear();
  rPath.clear();
  lPath.push_back(Symbol("NUM"));
  v.clear();
  v.insert(v.begin(),Symbol("SG"));
  mainEBPtr->addBlock(new EBlockMain(1,lPath,v,Symbol::OP_PSEUDO_UNIFY));
  lPath.clear();
  rPath.clear();
  lPath.push_back(Symbol("NUM"));
  rPath.push_back(Symbol("NUM"));
  mainEBPtr->addBlock(new EBlockMain(2,lPath,1,rPath,Symbol::OP_PSEUDO_UNIFY));
  orEB.addBlock(mainEBPtr);

  // the 2nd block: (((X0 SUBJ NUM) =t PL)
  //                 ((X1 NUM) = PL)
  //                 ((X2 NUM) = (X1 NUM)))
  mainEBPtr=new EBlockMain();
  lPath.clear();
  rPath.clear();
  lPath.push_back(Symbol("SUBJ"));
  lPath.push_back(Symbol("NUM"));
  v.clear();
  v.insert(v.begin(),Symbol("PL"));
  mainEBPtr->addBlock(new EBlockMain(0,lPath,v,Symbol::OP_TEST));
  lPath.clear();
  rPath.clear();
  lPath.push_back(Symbol("NUM"));
  v.clear();
  v.insert(v.begin(),Symbol("PL"));
  mainEBPtr->addBlock(new EBlockMain(1,lPath,v,Symbol::OP_PSEUDO_UNIFY));
  lPath.clear();
  rPath.clear();
  lPath.push_back(Symbol("NUM"));
  rPath.push_back(Symbol("NUM"));
  mainEBPtr->addBlock(new EBlockMain(2,lPath,1,rPath,Symbol::OP_PSEUDO_UNIFY));
  orEB.addBlock(mainEBPtr);
  
  cout<<"* The block: "<<indent(13)<<orEB<<endl<<endl<<indent(-13);

  cout<<"-> "<<(orEB.run(fsRegs)?"TRUE":"FALSE")<<endl;  
  cout<<fsRegs<<endl<<endl;

  fsRegs[0]=oldX0;
  fsRegs[1].clear();
  fsRegs[2].clear();
  cout<<"* Testing an *OR* block on "<<indent(27)<<fsRegs[0]<<indent(-27)<<endl;
  cout<<"* X1 and X2 are cleared."<<endl<<endl;
  orEB.clearBlocks();

  // the 1st block: (((X0 SUBJ NUM) =t SG)
  //                 ((X1 NUM) = SG)
  //                 (X2 = FOO))
  mainEBPtr=new EBlockMain();
  lPath.clear();
  rPath.clear();
  lPath.push_back(Symbol("SUBJ"));
  lPath.push_back(Symbol("NUM"));
  v.clear();
  v.insert(v.begin(),Symbol("SG"));
  mainEBPtr->addBlock(new EBlockMain(0,lPath,v,Symbol::OP_TEST));
  lPath.clear();
  rPath.clear();
  lPath.push_back(Symbol("NUM"));
  v.clear();
  v.insert(v.begin(),Symbol("SG"));
  mainEBPtr->addBlock(new EBlockMain(1,lPath,v,Symbol::OP_PSEUDO_UNIFY));
  lPath.clear();
  rPath.clear();
  v.clear();
  v.insert(v.begin(),Symbol("FOO"));
  mainEBPtr->addBlock(new EBlockMain(2,lPath,v,Symbol::OP_PSEUDO_UNIFY));
  orEB.addBlock(mainEBPtr);

  // the 2nd block: (((X0 SUBJ NUM) =t PL)
  //                 ((X1 NUM) = PL)
  //                 ((X2 FOO) = BAR))
  mainEBPtr=new EBlockMain();
  lPath.clear();
  rPath.clear();
  lPath.push_back(Symbol("SUBJ"));
  lPath.push_back(Symbol("NUM"));
  v.clear();
  v.insert(v.begin(),Symbol("PL"));
  mainEBPtr->addBlock(new EBlockMain(0,lPath,v,Symbol::OP_TEST));
  lPath.clear();
  rPath.clear();
  lPath.push_back(Symbol("NUM"));
  v.clear();
  v.insert(v.begin(),Symbol("PL"));
  mainEBPtr->addBlock(new EBlockMain(1,lPath,v,Symbol::OP_PSEUDO_UNIFY));
  lPath.clear();
  rPath.clear();
  lPath.push_back(Symbol("FOO"));
  v.clear();
  v.insert(v.begin(),Symbol("BAR"));
  mainEBPtr->addBlock(new EBlockMain(2,lPath,v,Symbol::OP_PSEUDO_UNIFY));
  orEB.addBlock(mainEBPtr);
  
  cout<<"* The block: "<<indent(13)<<orEB<<endl<<endl<<indent(-13);

  cout<<"-> "<<(orEB.run(fsRegs)?"TRUE":"FALSE")<<endl;  
  cout<<fsRegs<<endl<<endl;

  cout<<"* Testing a single type 5 equation:"<<endl;
  cout<<"* all registers are cleared."<<endl<<endl;
  
  fsRegs[0].clear();  
  fsRegs[1].clear();  
  fsRegs[2].clear();  
  mainEB.clearBlocks();

  // X0 <= '((SUBJ
  //          ((PRED YOU)
  //           (PERS 2)
  //           (NUM (*OR* SG PL))))
  //         (PRED RUN))
  lPath.clear();
  mainEB.addBlock(new EBlockMain(0,lPath,oldX0,Symbol::OP_ASSIGN));

  cout<<"* The block (containing only 1 equation): "<<endl<<mainEB<<endl<<endl;

  cout<<"-> "<<(mainEB.run(fsRegs)?"TRUE":"FALSE")<<endl;
  cout<<fsRegs<<endl<<endl;

  // ==================== Lexical equations ====================
  Grammar g(lexicons,Symbol("START"));   // an empty grammar

  cout<<endl<<"============ test lexical equations ============"<<endl;
  cout<<"* Lexicons:"<<endl<<endl<<lexicons<<endl<<endl;

  mainEB.clearBlocks();

  EFArgs req,opt;
  FSPath *fsPathPtr;
  Value *vPtr;
  Symbol symPred("PRED");

  // ------ GET-LEX with no opt args, and with a undefined 1st arg
  fsRegs[0]=oldX1;
  cout<<endl<<"------ GET-LEX with no opt args, and with a undefined 1st arg ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX (X0 FOO) 'N)
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(Symbol("Foo"));
  vPtr=&req.newValue();
  vPtr->insert(vPtr->begin(),symCatN);
  opt.clear();
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLex,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);


  // ------ GET-LEX with no opt args
  fsRegs[0]=oldX1;
  cout<<endl<<"------ GET-LEX with no opt args ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX (X0 PRED) 'N)
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  vPtr=&req.newValue();
  vPtr->insert(vPtr->begin(),symCatN);
  opt.clear();
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLex,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX with ID
  fsRegs[0]=oldX1;
  cout<<endl<<"------ GET-LEX with ID ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX (X0 PRED) 'N :LEX-ID 'ENG)
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  vPtr=&req.newValue();
  vPtr->insert(vPtr->begin(),symCatN);
  opt.clear();
  vPtr=&opt.newValue(symLexID);
  vPtr->insert(vPtr->begin(),symEng);
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLex,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX with check
  fsRegs[0]=oldX1;
  cout<<endl<<"------ GET-LEX with check ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX (X0 PRED) 'N :CHECK '((ROOT SIE)))
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  vPtr=&req.newValue();
  vPtr->insert(vPtr->begin(),symCatN);
  opt.clear();
  fsPtr=&opt.newFS(symCheck);
  lPath.clear();
  lPath.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("SIE"));
  fsPtr->assign(lPath,v);
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLex,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX with check
  fsRegs[0]=oldX1;
  cout<<endl<<"------ GET-LEX with check ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX (X0 PRED) 'N :CHECK '((ROOT YOU)))
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  vPtr=&req.newValue();
  vPtr->insert(vPtr->begin(),symCatN);
  opt.clear();
  fsPtr=&opt.newFS(symCheck);
  lPath.clear();
  lPath.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("YOU"));
  fsPtr->assign(lPath,v);
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLex,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX with check
  fsRegs[0]=oldX1;
  fsRegs[2].clear();
  lPath.clear();
  lPath.push_back(Symbol("FOO"));
  lPath.push_back(Symbol("PERS"));
  v.clear();
  vIter=v.insert(v.begin(),symNot);
  v.insert(vIter.end(),Symbol("3"));
  fsRegs[2].assign(lPath,v);
  cout<<endl<<"------ GET-LEX with check ------"<<endl;
  cout<<fsRegs[0]<<endl<<fsRegs[2]<<endl<<endl;

  // X1 <= (GET-LEX (X0 PRED) 'N :CHECK (X2 FOO))
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  vPtr=&req.newValue();
  vPtr->insert(vPtr->begin(),symCatN);
  opt.clear();
  fsPathPtr=&opt.newFSPath(symCheck);
  fsPathPtr->fsIdx=2;
  fsPathPtr->path.push_back(Symbol("FOO"));
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLex,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX with check
  fsRegs[0]=oldX1;
  fsRegs[2].clear();
  lPath.clear();
  lPath.push_back(Symbol("FOO"));
  lPath.push_back(Symbol("PERS"));
  v.clear();
  v.insert(v.begin(),Symbol("3"));
  fsRegs[2].assign(lPath,v);
  cout<<endl<<"------ GET-LEX with check ------"<<endl;
  cout<<fsRegs[0]<<endl<<fsRegs[2]<<endl<<endl;

  // X1 <= (GET-LEX (X0 PRED) 'N :CHECK (X2 FOO))
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  vPtr=&req.newValue();
  vPtr->insert(vPtr->begin(),symCatN);
  opt.clear();
  fsPathPtr=&opt.newFSPath(symCheck);
  fsPathPtr->fsIdx=2;
  fsPathPtr->path.push_back(Symbol("FOO"));
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLex,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX with ambiguity on
  fsRegs[0]=oldX1;
  cout<<endl<<"------ GET-LEX with ambiguity on ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX (X0 PRED) 'N :AMBIGUITY T)
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  vPtr=&req.newValue();
  vPtr->insert(vPtr->begin(),symCatN);
  opt.clear();
  opt.newBool(symAmbiguity,true);
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLex,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX with ambiguity off
  fsRegs[0]=oldX1;
  cout<<endl<<"------ GET-LEX with ambiguity off ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX (X0 PRED) 'N :AMBIGUITY NIL)
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  vPtr=&req.newValue();
  vPtr->insert(vPtr->begin(),symCatN);
  opt.clear();
  opt.newBool(symAmbiguity,false);
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLex,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX with ID and check
  fsRegs[0]=oldX1;
  cout<<endl<<"------ GET-LEX with ID and check ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX (X0 PRED) 'N :CHECK '((ROOT SIE)) :LEX-ID 'GER)
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  vPtr=&req.newValue();
  vPtr->insert(vPtr->begin(),symCatN);
  opt.clear();
  fsPtr=&opt.newFS(symCheck);
  lPath.clear();
  lPath.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("SIE"));
  fsPtr->assign(lPath,v);
  vPtr=&opt.newValue(symLexID);
  vPtr->insert(vPtr->begin(),symGer);
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLex,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX with ID and check
  fsRegs[0]=oldX1;
  cout<<endl<<"------ GET-LEX with ID and check ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX (X0 PRED) 'N :CHECK '((ROOT YOU)) :LEX-ID 'ENG)
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  vPtr=&req.newValue();
  vPtr->insert(vPtr->begin(),symCatN);
  opt.clear();
  fsPtr=&opt.newFS(symCheck);
  lPath.clear();
  lPath.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("YOU"));
  fsPtr->assign(lPath,v);
  vPtr=&opt.newValue(symLexID);
  vPtr->insert(vPtr->begin(),symEng);
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLex,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX with ID and check
  fsRegs[0]=oldX1;
  cout<<endl<<"------ GET-LEX with ID and check ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX (X0 PRED) 'N :CHECK '((ROOT SIE)) :LEX-ID 'ENG)
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  vPtr=&req.newValue();
  vPtr->insert(vPtr->begin(),symCatN);
  opt.clear();
  fsPtr=&opt.newFS(symCheck);
  lPath.clear();
  lPath.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("SIE"));
  fsPtr->assign(lPath,v);
  vPtr=&opt.newValue(symLexID);
  vPtr->insert(vPtr->begin(),symEng);
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLex,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX with ID and ambiguity on
  fsRegs[0]=oldX1;
  cout<<endl<<"------ GET-LEX with ID and ambiguity on ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX (X0 PRED) 'N :AMBIGUITY T :LEX-ID 'ENG)
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  vPtr=&req.newValue();
  vPtr->insert(vPtr->begin(),symCatN);
  opt.clear();
  opt.newBool(symAmbiguity,true);
  vPtr=&opt.newValue(symLexID);
  vPtr->insert(vPtr->begin(),symEng);
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLex,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX with check and ambiguity on
  fsRegs[0]=oldX2;
  fsRegs[2].clear();
  lPath.clear();
  lPath.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*MOVEMENT*"));
  fsRegs[2].assign(lPath,v);
  cout<<endl<<"------ GET-LEX with check and ambiguity on ------"<<endl;
  cout<<fsRegs[0]<<endl<<fsRegs[2]<<endl<<endl;

  // X1 <= (GET-LEX (X0 PRED) 'V :AMBIGUITY T :CHECK X2)
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  vPtr=&req.newValue();
  vPtr->insert(vPtr->begin(),symCatV);
  opt.clear();
  opt.newBool(symAmbiguity,true);
  fsPathPtr=&opt.newFSPath(symCheck);
  fsPathPtr->fsIdx=2;
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLex,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX with ID, check and ambiguity on
  fsRegs[0]=oldX1;
  fsRegs[2].clear();
  lPath.clear();
  lPath.push_back(Symbol("NUM"));
  v.clear();
  v.insert(v.begin(),Symbol("PL"));
  fsRegs[2].assign(lPath,v);
  cout<<endl<<"------ GET-LEX with ID, check and ambiguity on ------"<<endl;
  cout<<fsRegs[0]<<endl<<fsRegs[2]<<endl<<endl;

  // X1 <= (GET-LEX (X0 PRED) 'N :AMBIGUITY T :CHECK X2 :LEX-ID 'ENG)
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  vPtr=&req.newValue();
  vPtr->insert(vPtr->begin(),symCatN);
  opt.clear();
  opt.newBool(symAmbiguity,true);
  fsPathPtr=&opt.newFSPath(symCheck);
  fsPathPtr->fsIdx=2;
  vPtr=&opt.newValue(symLexID);
  vPtr->insert(vPtr->begin(),symEng);
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLex,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX-FS with no opt args: the FS has CAT feature
  fsRegs[0]=oldX2;
  cout<<endl<<"------ GET-LEX-FS with no opt args: the FS has CAT feature ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX-FS (X0 PRED) '((CAT V) (CLASS *MOVEMENT*)))
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  fsPtr=&req.newFS();
  lPath.clear();
  lPath.push_back(symCat);
  v.clear();
  v.insert(v.begin(),symCatV);
  fsPtr->assign(lPath,v);
  lPath.clear();
  lPath.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*MOVEMENT*"));
  fsPtr->assign(lPath,v);
  opt.clear();
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLexFS,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX-FS with no opt args: the FS has no CAT feature
  fsRegs[0]=oldX2;
  cout<<endl<<"------ GET-LEX-FS with no opt args: the FS has no CAT feature ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX-FS (X0 PRED) '((CLASS *MOVEMENT*)))
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  fsPtr=&req.newFS();
  lPath.clear();
  lPath.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*MOVEMENT*"));
  fsPtr->assign(lPath,v);
  opt.clear();
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLexFS,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX-FS with ID: the FS has CAT feature
  fsRegs[0]=oldX2;
  cout<<endl<<"------ GET-LEX-FS with ID: the FS has CAT feature ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX-FS (X0 PRED) '((CAT V) (CLASS *MOVEMENT*)) :LEX-ID 'ENG)
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  fsPtr=&req.newFS();
  lPath.clear();
  lPath.push_back(symCat);
  v.clear();
  v.insert(v.begin(),symCatV);
  fsPtr->assign(lPath,v);
  lPath.clear();
  lPath.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*MOVEMENT*"));
  fsPtr->assign(lPath,v);
  opt.clear();
  vPtr=&opt.newValue(symLexID);
  vPtr->insert(vPtr->begin(),symEng);
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLexFS,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX-FS with ID: the FS has no CAT feature
  fsRegs[0]=oldX2;
  cout<<endl<<"------ GET-LEX-FS with ID: the FS has no CAT feature ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX-FS (X0 PRED) '((CLASS *MOVEMENT*)) :LEX-ID 'ENG)
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  fsPtr=&req.newFS();
  lPath.clear();
  lPath.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*MOVEMENT*"));
  fsPtr->assign(lPath,v);
  opt.clear();
  vPtr=&opt.newValue(symLexID);
  vPtr->insert(vPtr->begin(),symEng);
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLexFS,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX-FS with check: the FS has CAT feature
  fsRegs[0]=oldX2;
  cout<<endl<<"------ GET-LEX-FS with check: the FS has CAT feature ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX-FS (X0 PRED) '((CAT V) (CLASS *MOVEMENT*)) :CHECK '((ROOT LAUFEN)))
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  fsPtr=&req.newFS();
  lPath.clear();
  lPath.push_back(symCat);
  v.clear();
  v.insert(v.begin(),symCatV);
  fsPtr->assign(lPath,v);
  lPath.clear();
  lPath.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*MOVEMENT*"));
  fsPtr->assign(lPath,v);
  opt.clear();
  fsPtr=&opt.newFS(symCheck);
  lPath.clear();
  lPath.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("LAUFEN"));
  fsPtr->assign(lPath,v);
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLexFS,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX-FS with check: the FS has no CAT feature
  fsRegs[0]=oldX2;
  cout<<endl<<"------ GET-LEX-FS with check: the FS has no CAT feature ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX-FS (X0 PRED) '((CLASS *MOVEMENT*)) :CHECK '((ROOT LAUFEN)))
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  fsPtr=&req.newFS();
  lPath.clear();
  lPath.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*MOVEMENT*"));
  fsPtr->assign(lPath,v);
  opt.clear();
  fsPtr=&opt.newFS(symCheck);
  lPath.clear();
  lPath.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("LAUFEN"));
  fsPtr->assign(lPath,v);
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLexFS,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX-FS with ambiguity on: the FS has CAT feature
  fsRegs[0]=oldX2;
  cout<<endl<<"------ GET-LEX-FS with ambiguity on: the FS has CAT feature ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX-FS (X0 PRED) '((CAT V) (CLASS *MOVEMENT*)) :AMBIGUITY T)
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  fsPtr=&req.newFS();
  lPath.clear();
  lPath.push_back(symCat);
  v.clear();
  v.insert(v.begin(),symCatV);
  fsPtr->assign(lPath,v);
  lPath.clear();
  lPath.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*MOVEMENT*"));
  fsPtr->assign(lPath,v);
  opt.clear();
  opt.newBool(symAmbiguity,true);
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLexFS,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX-FS with ambiguity on: the FS has no CAT feature
  fsRegs[0]=oldX2;
  cout<<endl<<"------ GET-LEX-FS with ambiguity on: the FS has no CAT feature ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX-FS (X0 PRED) '((CLASS *MOVEMENT*)) :AMBIGUITY T)
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  fsPtr=&req.newFS();
  lPath.clear();
  lPath.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*MOVEMENT*"));
  fsPtr->assign(lPath,v);
  opt.clear();
  opt.newBool(symAmbiguity,true);
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLexFS,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX-FS with ID and check: the FS has CAT feature
  fsRegs[0]=oldX2;
  cout<<endl<<"------ GET-LEX-FS with ID and check: the FS has CAT feature ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX-FS (X0 PRED) '((CAT V) (CLASS *MOVEMENT*)) :CHECK '((ROOT RUN)) :LEX-ID 'ENG)
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  fsPtr=&req.newFS();
  lPath.clear();
  lPath.push_back(symCat);
  v.clear();
  v.insert(v.begin(),symCatV);
  fsPtr->assign(lPath,v);
  lPath.clear();
  lPath.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*MOVEMENT*"));
  fsPtr->assign(lPath,v);
  opt.clear();
  fsPtr=&opt.newFS(symCheck);
  lPath.clear();
  lPath.push_back(symRoot);
  v.clear();
  v.insert(v.begin(),Symbol("RUN"));
  fsPtr->assign(lPath,v);  
  vPtr=&opt.newValue(symLexID);
  vPtr->insert(vPtr->begin(),symEng);
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLexFS,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX-FS with ID and ambiguity on: the FS has CAT feature
  fsRegs[0]=oldX2;
  cout<<endl<<"------ GET-LEX-FS with ID and ambiguity on: the FS has CAT feature ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX-FS (X0 PRED) '((CAT V) (CLASS *MOVEMENT*)) :AMBIGUITY T :LEX-ID 'ENG)
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  fsPtr=&req.newFS();
  lPath.clear();
  lPath.push_back(symCat);
  v.clear();
  v.insert(v.begin(),symCatV);
  fsPtr->assign(lPath,v);
  lPath.clear();
  lPath.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*MOVEMENT*"));
  fsPtr->assign(lPath,v);
  opt.clear();
  opt.newBool(symAmbiguity,true);
  vPtr=&opt.newValue(symLexID);
  vPtr->insert(vPtr->begin(),symEng);
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLexFS,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX-FS with check and ambiguity on: the FS has no CAT feature
  fsRegs[0]=oldX2;
  cout<<endl<<"------ GET-LEX-FS with check and ambiguity on: the FS has no CAT feature ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX-FS (X0 PRED) '((CLASS *MOVEMENT*)) :AMBIGUITY T :CHECK '((CAT V)))
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  fsPtr=&req.newFS();
  lPath.clear();
  lPath.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*MOVEMENT*"));
  fsPtr->assign(lPath,v);
  opt.clear();
  opt.newBool(symAmbiguity,true);
  fsPtr=&opt.newFS(symCheck);
  lPath.clear();
  lPath.push_back(symCat);
  v.clear();
  v.insert(v.begin(),symCatV);
  fsPtr->assign(lPath,v);  
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLexFS,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  // ------ GET-LEX-FS with ID, check and ambiguity on: the FS has CAT feature
  fsRegs[0]=oldX2;
  cout<<endl<<"------ GET-LEX-FS with ID, check and ambiguity on: the FS has CAT feature ------"<<endl;
  cout<<fsRegs[0]<<endl<<endl;

  // X1 <= (GET-LEX-FS (X0 PRED) '((CAT V)) :AMBIGUITY T :CHECK '((CLASS *MOVEMENT*)) :LEX-ID 'ENG)
  mainEB.clearBlocks();
  req.clear();
  fsPathPtr=&req.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(symPred);
  fsPtr=&req.newFS();
  lPath.clear();
  lPath.push_back(symCat);
  v.clear();
  v.insert(v.begin(),symCatV);
  fsPtr->assign(lPath,v);
  opt.clear();
  opt.newBool(symAmbiguity,true);
  fsPtr=&opt.newFS(symCheck);
  lPath.clear();
  lPath.push_back(symClass);
  v.clear();
  v.insert(v.begin(),Symbol("*MOVEMENT*"));
  fsPtr->assign(lPath,v);
  vPtr=&opt.newValue(symLexID);
  vPtr->insert(vPtr->begin(),symEng);
  lPath.clear();
  mainEB.addBlock(new EBlockMain(1,lPath,symGetLexFS,req,opt,Symbol::OP_ASSIGN,g));
  cout<<"* The equation: "<<indent(16)<<mainEB<<endl<<indent(-16);
  mainEB.run(fsRegs);
  cout<<"* After running the equation: "<<indent(30);
  cout<<fsRegs[1]<<endl<<indent(-30);

  return 0;
}
