// ======================================================================
// efArgs.cpp - Arguments of Extension Functions.
// 
// 122502: Benjamin Han <benhdj@cs.cmu.edu> removed "using namespace std;" 
//         and inserted std:: prefix where needed.
// 120202: Benjamin Han <benhdj@cs.cmu.edu> Changed calls to !bitset::count()
//         to bitset::none() - M$ VC6 with STLport has problems linking.
// 120601: Benjamin Han <benhdj@cs.cmu.edu> Changed several int declarations
//         into the rightful size_type; namespace added.
// 090501: Benjamin Han <benhdj@cs.cmu.edu> Minor revisions to supress warnings
//         under -pedantic -Wall.
// 071101: Benjamin Han <benhdj@cs.cmu.edu> Created.
// ======================================================================

//    Copyright (C) 2000-2004 Benjamin Han <benhdj@cs.cmu.edu>
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "eFArgs.hpp"

namespace UKernel {

void EFArgConvTable::insert (const Symbol &sym, size_type idx) {
  if (maxIdx<idx) maxIdx=idx;
  _Parent::insert(make_pair(sym,idx));
}

void EFArgConvTable::clear () {
  maxIdx=0;
  _Parent::clear();
}

std::ostream &operator << (std::ostream &os, const FSPath &fsPath) {
  if (fsPath.path.size()) os<<"(X"<<fsPath.fsIdx<<' '<<fsPath.path<<')';
  else os<<'X'<<fsPath.fsIdx;

  return os;
}

void EFArgs::copy (size_type i, const EFArg &arg) {
  assert(i>=0 && i<_Parent::size());

  EFArg &newArg=operator[](i);

  clear(i);
  newArg=arg;
  if (arg.flags[EFArg::isSet])
    if (newArg.ptr) {
      assert(newArg.flags[EFArg::isSet] && !newArg.flags[EFArg::tBool]);
      
      if (newArg.flags[EFArg::tValue])
	newArg.ptr=(void*)new Value(*((Value*)newArg.ptr));
      else if (newArg.flags[EFArg::tFS])
	newArg.ptr=(void*)new FStruc(*((FStruc*)newArg.ptr));
      else {
	assert(newArg.flags[EFArg::tFSPath]);
	newArg.ptr=(void*)new FSPath(*((FSPath*)newArg.ptr));
      }
    }
#ifndef NDEBUG
    else assert(newArg.flags[EFArg::tBool]);
  else {
    assert(arg.flags.none());
    assert(arg.name.isSpecial(Symbol::UNKNOWN));
    assert(!arg.ptr);
  }
#endif
}

Value &EFArgs::newValue () {
  EFArg arg;
  Value *ptr=new Value();

  arg.flags[EFArg::isSet]=true;
  arg.flags[EFArg::tValue]=true;
  arg.ptr=(void*)ptr;
  push_back(arg);
  return *ptr;
}

FStruc &EFArgs::newFS () {
  EFArg arg;
  FStruc *ptr=new FStruc();

  arg.flags[EFArg::isSet]=true;
  arg.flags[EFArg::tFS]=true;
  arg.ptr=(void*)ptr;
  push_back(arg);
  return *ptr;
}

FSPath &EFArgs::newFSPath () {
  EFArg arg;
  FSPath *ptr=new FSPath();

  arg.flags[EFArg::isSet]=true;
  arg.flags[EFArg::tFSPath]=true;
  arg.ptr=(void*)ptr;
  push_back(arg);
  return *ptr;
}

void EFArgs::newBool (bool t) {
  EFArg arg;

  arg.flags[EFArg::isSet]=true;
  arg.flags[EFArg::tBool]=true;
  arg.flags[EFArg::vBool]=t;
  push_back(arg);
}

Value &EFArgs::newValue (const Symbol &name) {
  EFArg arg;
  Value *ptr=new Value();

  arg.name=name;
  arg.flags[EFArg::isSet]=true;
  arg.flags[EFArg::tValue]=true;
  arg.ptr=(void*)ptr;
  push_back(arg);
  return *ptr;
}

FStruc &EFArgs::newFS (const Symbol &name) {
  EFArg arg;
  FStruc *ptr=new FStruc();

  arg.name=name;
  arg.flags[EFArg::isSet]=true;
  arg.flags[EFArg::tFS]=true;
  arg.ptr=(void*)ptr;
  push_back(arg);
  return *ptr;
}

FSPath &EFArgs::newFSPath (const Symbol &name) {
  EFArg arg;
  FSPath *ptr=new FSPath();

  arg.name=name;
  arg.flags[EFArg::isSet]=true;
  arg.flags[EFArg::tFSPath]=true;
  arg.ptr=(void*)ptr;
  push_back(arg);
  return *ptr;
}

void EFArgs::newBool (const Symbol &name, bool t) {
  EFArg arg;

  arg.name=name;
  arg.flags[EFArg::isSet]=true;
  arg.flags[EFArg::tBool]=true;
  arg.flags[EFArg::vBool]=t;
  push_back(arg);
}

void EFArgs::clear (size_type i) {
  assert(i>=0 && i<_Parent::size());

  EFArg &arg=operator[](i);

  if (arg.flags[EFArg::isSet]) {
    if (arg.ptr) {
      assert(arg.flags[EFArg::isSet] && !arg.flags[EFArg::tBool]);
	  
      if (arg.flags[EFArg::tValue]) delete (Value*)arg.ptr;
      else if (arg.flags[EFArg::tFS]) delete (FStruc*)arg.ptr;
      else {
	assert(arg.flags[EFArg::tFSPath]);
	delete (FSPath*)arg.ptr;
      }
      
      arg.ptr=NULL;
    }
    
#ifndef NDEBUG
      else assert(arg.flags[EFArg::tBool]);
#endif

    arg.flags.reset();
      arg.name.setSpecial(Symbol::UNKNOWN);
    }

#ifndef NDEBUG
  else {
    assert(arg.flags.none());
    assert(arg.name.isSpecial(Symbol::UNKNOWN));
    assert(!arg.ptr);
  }
#endif
}

void EFArgs::convert (const EFArgConvTable &table) {
  EFArgs newArgs;
  EFArgConvTable::const_iterator ti;
  const_iterator i;

  newArgs.resize(table.readMaxIdx()+1);
  for (i=begin();i!=end();++i) {
    ti=table.find(i->name);
    
    assert(ti!=table.end());
    assert(!newArgs[ti->second].flags[EFArg::isSet]);
    
    newArgs.copy(ti->second,*i);
  }
  
  *this=newArgs;
}

std::ostream &operator << (std::ostream &os, const EFArgs &args) {
  EFArgs::size_type i,s=args.size();
  bool backup=FStruc::indentPrint;
  bool notFirst;

  FStruc::indentPrint=false;
  for (i=0,notFirst=false;i<s;++i) {
    const EFArg::Flags &flags=args.readFlags(i);
    
    if (flags[EFArg::isSet]) {
      const Symbol &name=args.readName(i);
      
      if (notFirst) os<<' ';
      else notFirst=true;
      if (!name.isSpecial(Symbol::UNKNOWN)) os<<name<<' ';
      if (flags[EFArg::tValue]) os<<"\'"<<args.readValue(i);
      else if (flags[EFArg::tFS]) os<<"\'"<<args.readFS(i);
      else if (flags[EFArg::tFSPath]) os<<args.readFSPath(i);
      else {
	assert(flags[EFArg::tBool]);
	os<<(flags[EFArg::vBool]?"T":"NIL");
      }
    }
  }
  
  FStruc::indentPrint=backup;
  return os;
}

};
