// ======================================================================
// eFATst.cpp - Tetsing the code for the Arguments of Extension Functions.
// 
// 122502: Benjamin Han <benhdj@cs.cmu.edu> using namespace std.
// 120302: Benjamin Han <benhdj@cs.cmu.edu> Added the missing resturn in main().
// 120601: Benjamin Han <benhdj@cs.cmu.edu> Namespace added.
// 071101: Benjamin Han <benhdj@cs.cmu.edu> Created.
// ======================================================================

//    Copyright (C) 2000-2004 Benjamin Han <benhdj@cs.cmu.edu>
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "eFArgs.hpp"

using namespace UKernel;
using namespace std;

int main () {
  Value *vPtr;
  FStruc *fsPtr;
  FSPath *fsPathPtr;
  Value v;
  Path path;
  EFArgConvTable table;
  EFArgs req1,req2;
  EFArgs opt1,opt2;

  fsPathPtr=&req1.newFSPath();
  fsPathPtr->fsIdx=0;
  fsPathPtr->path.push_back(Symbol("SEM-VALUE"));

  vPtr=&req1.newValue();
  vPtr->insert(vPtr->begin(),Symbol("N"));

  fsPtr=&opt1.newFS(Symbol(":CHECK"));
  path.clear();
  path.push_back(Symbol("ARG"));
  v.clear();
  v.insert(v.begin(),Symbol("OBJECT-SPEC"));
  fsPtr->assign(path,v);

  opt1.newBool(Symbol(":AMBIGUITY"),true);

  cout<<req1<<endl;
  cout<<opt1<<endl;

  req2=req1;
  opt2=opt1;
  cout<<"------------------------------"<<endl;
  cout<<req2<<endl;
  cout<<opt2<<endl;

  table.insert(Symbol(":CHECK"),2);
  table.insert(Symbol(":AMBIGUITY"),1);
  table.insert(Symbol(":LEX-ID"),0);

  opt2.convert(table);
  cout<<"------------------------------"<<endl;
  cout<<opt2<<endl;

  opt2=opt1;
  vPtr=&opt2.newValue(Symbol(":LEX-ID"));
  vPtr->insert(vPtr->begin(),Symbol("E"));

  opt2.convert(table);
  cout<<"------------------------------"<<endl;
  cout<<opt2<<endl;

  return 0;
}
