header {
#include "grammar.hpp"
#include "gen.hpp"
#include <ctype.h>
#include <iostream.h>
#include <deque>
#include <string>

using namespace std;
using namespace UKernel;
using namespace Gen;
}

options { language="Cpp"; }

class FStructParser extends Parser;
options { 
    k=4; 
    buildAST = false;
}

{

  Path lPath;
  Value v;
  bool result;  
  deque<string> featurepath;

  Generator *gen;
  deque<FStruc*> fstructstack;
//  FStruc x0;
    //EBlockMain eb;
  vector<string> *genstrings;
  string *utt;
  string tracetype, modetype, generated;
  bool debug;

  public:

  void setGrammar(Grammar *g) {
    gen = new Generator(*g, (ostream&)cout);
  }

  void setReturn(vector<string> &str) {
    genstrings = &str;
    //utt = &str;
  }

  void setDebug(bool mydebug) {
     debug = mydebug;
  }

  void setTracing(string mytracetype) {
    debug = false;
    tracetype = mytracetype;
    if (tracetype == "debug") {
      debug = true;
    }
    if (tracetype == "off") {
      debug = false;
    }
  }

  void setMode(string mymode) {
    modetype = mymode;
    if (mymode == "plain") {
       modetype = "plain";
    }
    else if (mymode == "fork") {
       modetype = "fork";
    } else {
       modetype = "fork";
    }
  }

}

fstructs {  }
    : (
      { fstructstack.push_back(new FStruc(Symbol("X0")));
        //x0.clear(); x0.setName(Symbol("X0"));   
        if (debug) cout << "Initing New feature structure\n"; utt = new string();
      } 
        
      fstruct { 

        if (debug) cout<<"* The starting FS (X0):"<<endl;
        
        if (debug) cout<< "x0 name is " << fstructstack.back()->readName() << "\n";

        if (debug) cout<<*(fstructstack.back())<<endl<<endl;  // print out the starting FS

	    utt->erase();

        if (modetype == "plain") {
           gen->setExecMode(Generator::modePlain);
        } else if (modetype == "fork") {
           gen->setExecMode(Generator::modeFork);
        }

        if (tracetype == "rule") {
            if (debug) cout<<"* Running the generator with tracing (verbosity=showRule):"<<endl;
            result=gen->runTracing(*(fstructstack.back()),*utt,Generator::showRule);
        } else if (tracetype == "eq") {
            if (debug) cout<<"* Running the generator with tracing (verbosity=showEq):"<<endl;
            result=gen->runTracing(*(fstructstack.back()),*utt,Generator::showEq);
        } else if (tracetype == "fs") {
            if (debug) cout<<"* Running the generator with tracing (verbosity=showFS):"<<endl;
            result=gen->runTracing(*(fstructstack.back()),*utt,Generator::showFS);
        } else {
            if (debug) cout<<"* Running the generator with no tracing:"<<endl;
            result=gen->run(*(fstructstack.back()),*utt);
        }

  	    if (debug) cout<<"-> "<<(result?"TRUE":"FALSE")<<": \""<<*utt<<"\"."<<endl; 

        if (result) {
          genstrings->push_back(string(*utt));
          if (debug) cout << "pushed back generated string" << endl;
        }

        fstructstack.pop_back();
       } 
    )+
	
	EOF!
;

fstruct
    : LPAREN fvpairs RPAREN
    ;

fvpairs
    : (fvpair)+
    ;

fvpair
    : LPAREN feature value RPAREN               { featurepath.pop_back(); // remove feature from path
                                                }
    ;

feature
    : f:TOKEN { 
        // Push onto stack
        featurepath.push_back(f->getText());
        if (debug) cout << "Stacking Feature " << f->getText() << "\n"; 
        } 
    ;

value { int i; }
    : LPAREN (fvpair)+ RPAREN
    | orgroup
    | multiplegroup 
    | t:TOKEN {    

                lPath.clear(); if (debug) cout << "Clearing lpath\n";
                for (i = 0; i < featurepath.size(); i++) {
                    if (debug) cout << "Pushing back " << featurepath[i] << "\n";
                    lPath.push_back(Symbol(featurepath[i]));
                }     

                v.clear();
                v.insert(v.begin(),Symbol(t->getText()));
                v.compact();
                fstructstack.back()->assign(lPath,v);

                if (debug) cout << "Adding Value " << t->getText() << "\n\n"; }
    ;


orgroup
    : LPAREN OR (value)+ RPAREN
	;

multiplegroup { FStruc* multstruct; deque<string> featurestorage; deque<FStruc*> multstack; int i;   Path mPath, rpath; }
    : LPAREN { if (debug) cout << endl << "Start MULTIPLE block"<< endl; }
      MULTIPLE 

       {
         mPath.clear(); if (debug) cout << "Clearing mult path\n";

         for (i = 0; i < featurepath.size(); i++) {
             if (debug) cout << "Pushing back " << featurepath[i] << " i " << i << " of " << featurepath.size() << endl;
             mPath.push_back(Symbol(featurepath[i]));
         }

         for (i = 0; i < featurepath.size(); i++) {
            featurestorage.push_back(featurepath[i]);
         }
         featurepath.clear();
       }

      (

       { 
         fstructstack.push_back(new FStruc(Symbol("X1")));
       }

       LPAREN (fvpair)+ RPAREN

       {
          if (debug) cout << "Appending MULTIPLE Value \n\n"; 
          
          multstruct = fstructstack.back();
          fstructstack.pop_back();
    	  multstack.push_front(multstruct);
       }

      )+    
      RPAREN 
        { 
	  for (i = 0; i < multstack.size(); i++) {
	     multstruct = multstack[i];
             fstructstack.back()->push(mPath,*multstruct,rpath);
	  } 
          multstack.clear();		

          featurepath.clear();
          for (i = 0; i < featurestorage.size(); i++) {
             featurepath.push_back(featurestorage[i]);
          }
        
        }
	;


class FStructLexer extends Lexer;
options {
    k=3;
    charVocabulary = '\03'..'\377';
    caseSensitive=false;
    caseSensitiveLiterals=false;
}

{

#include <string>
   string letter; 
   int i;
}

/* ignore comments */
SL_COMMENT
	:	';'
		(~('\n'|'\r'))* ('\n'|'\r'('\n')?)
		{$setType(_token->SKIP); newline();} 
    ;

/* ignore comments */
// multiple-line comments
ML_COMMENT
	:	"#|"
		(	/*	'\r' '\n' can be matched in one alternative or by matching
				'\r' in one iteration and '\n' in another.  I am trying to
				handle any flavor of newline that comes in, but the language
				that allows both "\r\n" and "\r" and "\n" to all be valid
				newline is ambiguous.  Consequently, the resulting grammar
				must be ambiguous.  I'm shutting this warning off.
			 */
			options {
				generateAmbigWarnings=false;
			}
		:
			{ LA(2)!='#' }? '|'
		|	'\r' '\n'		{newline();}
		|	'\r'			{newline();}
		|	'\n'			{newline();}
		|	~('|'|'\n'|'\r')
		)*
		"|#"
		{$setType(_token->SKIP);}
	;



// Whitespace -- ignored
WS	:	(	' '
		|	'\t'
		|	'\f'
		// handle newlines
		|	(	"\r\n"  // Evil DOS
			|	'\r'    // Macintosh
			|	'\n'    // Unix (the right way)
			)
			{ newline(); }
		)
		{ $setType(_token->SKIP); }
	;


LPAREN : "("                              { /*cout << "left paren\n"; */ }   ;
RPAREN : ")"                             { /*cout << "right paren\n"; */  }   ;
MULTIPLE : "*multiple*"                          { } ;
OR     : "*or*"                              { } ;

TOKEN : ~('\r'|'\n'|'\t'|'\f'|' '|'('|')'|';'|'#'|'|'|'%'|'*') (~('\n'|'\r'|'\t'|' '|'\f'|'('|')'|'='|';'|'#'|'|'|'%') )*   
        { letter = getText();  
          for (i = 0; i < letter.length(); i++) {
                letter[i] = toupper(letter[i]);
            }  
          setText(letter) ;} ;
