header {
#include "lexicon.hpp"
#include "grammar.hpp"
#include <ctype.h>
#include <iostream.h>
#include <deque>

using namespace std;
using namespace UKernel;
}

options { language="Cpp"; }

class LexiconParser extends Parser;
options { 
    k=3; 
    buildAST = false;
}

{
  Lexicon *lexiconPtr;
  Path path;
  Value v;
  deque<string> featurepath;
  string lexhead;
  string lexcat;

  EBlockMain eb;
  FStruc *fsPtr,fs;
  FStruc result;

  vector<string> *genstrings;
  string *utt;
  string tracetype, generated;
  bool debug;

  public:

  void setLexicons(Lexicons &l, Symbol langsymbol) { // and symbol
    lexiconPtr=&l.findLexicon(langsymbol);
  }

  void setDebug(bool mydebug) {
     debug = mydebug;
  }

}

lexentries 
    : (
      { if (debug) cout << "Reading new lexicon entry" << endl; }
      lexentry { 
        result = FStruc(Symbol("RESULT"));
        result.clear();
        if (debug) cout << "Just added " << endl << lexiconPtr->findLex(Symbol(lexhead), Symbol(lexcat), result) << endl << endl;
       }
    )+
	
	EOF!
;

lexentry
    : LPAREN head:TOKEN
       LPAREN 
        LPAREN cattoken:TOKEN catvalue:TOKEN RPAREN     {
          if (cattoken->getText() != "CAT") {
                cerr << "Expecting CAT, found " << cattoken->getText() << endl;
                exit(1);
            }
          lexhead = head->getText();
          lexcat = catvalue->getText();
          if (debug) cout << "Adding lex entry with head " << head->getText() << " and CAT " << catvalue->getText() << endl;
          fsPtr=&lexiconPtr->addLex(Symbol(head->getText()),Symbol(catvalue->getText()));
          //eb.clearBlocks(); 
        }

        (fvpair)+ 

       RPAREN 
      RPAREN
    ;

fvpair
    : LPAREN feature value RPAREN     { featurepath.pop_back(); // remove feature from path
                                                }
    ;

feature
    : f:TOKEN { 
        // Push onto stack
        featurepath.push_back(f->getText());
        if (debug) cout << "Stacking Feature " << f->getText() << "\n"; 
        } 
    ;


value  { int i; }
    : LPAREN (fvpair)+ RPAREN

    | orgroup  {
        
          path.clear(); if (debug) cout << "Clearing path\n";

          for (i = 0; i < featurepath.size(); i++) {
             if (debug) cout << "Pushing back " << featurepath[i] << " i " << i << " of " << featurepath.size() << endl;
             path.push_back(Symbol(featurepath[i]));
          }     
          
          if (debug) cout << "Adding OR Value \n\n"; 

         fsPtr->assign(path,v);

       }

    | t:TOKEN  {
        
          path.clear(); if (debug) cout << "Clearing path\n";

          for (i = 0; i < featurepath.size(); i++) {
             if (debug) cout << "Pushing back " << featurepath[i] << "\n";
             path.push_back(Symbol(featurepath[i]));
          }     

          v.clear();
          v.insert(v.begin(),Symbol(t->getText()));
          v.compact();
          fsPtr->assign(path,v);

          if (debug) cout << "Adding Value " << t->getText() << "\n\n"; 
       } 

     | str:STRING_TOKEN {
        
          path.clear(); if (debug) cout << "Clearing path\n";

          for (i = 0; i < featurepath.size(); i++) {
             if (debug) cout << "Pushing back " << featurepath[i] << "\n";
             path.push_back(Symbol(featurepath[i]));
          }     

          v.clear();
          v.insert(v.begin(),Symbol(str->getText()));
          v.compact();
          fsPtr->assign(path,v);

          if (debug) cout << "Adding Value " << str->getText() << "\n\n"; 
       } 

    ;


orgroup {  Value::Iterator iter; }
    : LPAREN OR { v.clear(); iter=v.insert(v.begin(),Symbol(Symbol::OR)); if (debug) cout << "In OR group" << endl; }
       (ortok:TOKEN { v.insert(iter.end(),Symbol(ortok->getText())); if (debug) cout << "Adding " << ortok->getText() << " to OR group" << endl;} )+  
      RPAREN  { v.compact(); }
    ;

class LexiconLexer extends Lexer;
options {
    k=3;
    charVocabulary = '\03'..'\377';
    caseSensitive=false;
    caseSensitiveLiterals=false;
}

{
   string letter; 
   int i;
}

/* ignore comments */
SL_COMMENT
	:	';'
		(~('\n'|'\r'))* ('\n'|'\r'('\n')?)
		{$setType(_token->SKIP); newline();} 
    ;

// Whitespace -- ignored
WS	:	(	' '
		|	'\t'
		|	'\f'
		// handle newlines
		|	(	"\r\n"  // Evil DOS
			|	'\r'    // Macintosh
			|	'\n'    // Unix (the right way)
			)
			{ newline(); }
		)
		{ $setType(_token->SKIP); }
	;


LPAREN : "("                              { /*cout << "left paren\n"; */ }   ;
RPAREN : ")"                             { /*cout << "right paren\n"; */  }   ;

OR : "*or*";

//CAT: "cat " ; 

TOKEN : (~('\r'|'\n'|'\t'|'\f'|' '|'"'|'('|')'|';'|'#'|'|'|'%') (~('\n'|'\r'|'\t'|' '|'\f'|'<'|'>'|'('|')'|'='|';'|'#'|'|'|'%'|'"') )* 
        |
        '"'! (ESC|' '|~('"'|'\\'))* '"'!
      )
        { letter = getText();  
          for (i = 0; i < letter.length(); i++) {
                letter[i] = toupper(letter[i]);
            }  
          setText(letter) ;
        } 
      ;

ESC : '\\' ('"' | '\\');




