#ifndef _GenKit
#define _GenKit

//#include "grammar.hh"
#include "gen.hpp"
#include "GenKitLexer.hpp"
#include "GenKitParser.hpp"
#include "FStructLexer.hpp"
#include "FStructParser.hpp"
#include "LexiconLexer.hpp"
#include "LexiconParser.hpp"

class GenKit {
 private:
  Grammar* g;
  Lexicons lexicons;
  string encoding;
  string tracetype;
  string genlang;
  bool debug;

 public:

  GenKit() {
    g =  new Grammar(Symbol("START"), Grammar::generation);
    lexicons.addLexicon(Symbol("ENG"));
    debug = false;
  }

  void setEncoding(string newencoding) {
    encoding = newencoding;
  }

  void setGenerateLanguage(string newgenlang) {
    genlang = newgenlang;
  }

  void initFromFile(string initfile);

  // Can be called multiple times, order is important
  int loadGrammarFile(string filename);

  // Can be called multiple times, order is important
  int loadLexiconFile(string filename, Symbol language);


  int generateFromFStructure(string fstruct, vector<string> &genstrings, string tracing);

  // Takes a char array of the fstruct as input, returns
  // the generated language string
  int generateFromFStructure(string fstruct, vector<string> &genstrings);
  

  // Allows program to generate from a list of f-structures in a file,
  // writing the output sentences to another file
  int generateFromFStructureFile(string filename, vector<string> &genstrings, string tracing);

  void runCommandLine();

  int runBatch(string infile, string outfile);

  void runServer(int serverport);

  void runInteractive();

  void setGrammarLoadDebug(bool mydebug);

};

#endif
