import GenKitParser;
import GenKitLexer;
import java.io.*;
import antlr.collections.AST;
import antlr.collections.impl.*;
import antlr.debug.misc.*;
import antlr.*;
import java.awt.event.*;

class GenKitTest {

    static boolean showTree = false;
    public static void main(String[] args) {
	// Use a try/catch block for parser exceptions
	try {
	    // if we have at least one command-line argument
	    if (args.length > 0 ) {
		System.err.println("Parsing...");
		
                // for each directory/file specified on the command line
		for(int i=0; i< args.length;i++) {
		    if ( args[i].equals("-showtree") ) {
			showTree = true;
		    }
		    else {
			doFile(new File(args[i])); // parse it
		    }
		} }
	    else
		System.err.println("Usage: java GenKitTest [-showtree] "+
                                   "<directory or file name>");
	}
	catch(Exception e) {
	    System.err.println("exception: "+e);
	    e.printStackTrace(System.err);   // so we can get stack trace
	}
    }
    
    
    // This method decides what action to take based on the type of
    //   file we are looking at
    public static void doFile(File f)
	throws Exception {
	// If this is a directory, walk each file/dir in that directory
	System.out.println("doing file " + f);
	if (f.isDirectory()) {
	    String files[] = f.list();
	    for(int i=0; i < files.length; i++)
		doFile(new File(f, files[i]));
	}
	
	// otherwise, if this is a java file, parse it!
	else if ((f.getName().length()>4) &&
		 f.getName().substring(f.getName().length()-4).equals(".gra")) {
	    System.err.println("   "+f.getAbsolutePath());
	    parseFile(f.getName(), new FileInputStream(f));
	}
    }
    
    // Here's where we do the real work...
    public static void parseFile(String f, InputStream s)
	throws Exception {
	System.out.println("parsing file");
	try {
	    // Create a scanner that reads from the input stream passed to us
	    GenKitLexer lexer = new GenKitLexer(s);
	    lexer.setFilename(f);

	    // Create a parser that reads from the scanner
	    GenKitParser parser = new GenKitParser(lexer);
	    parser.setFilename(f);

	    // start parsing at the compilationUnit rule
	    parser.rules();
                        
	    // do something with the tree
	    CommonAST t = (CommonAST)parser.getAST();
	    // Print the resulting tree out in LISP notation
	    //	    System.out.println(t.toStringList());

	    DumpASTVisitor visitor = new DumpASTVisitor();
	    visitor.visit(t);
	    //System.out.println(t.toLispString());

	    doTreeAction(f, parser.getAST(), parser.getTokenNames());
	}
	catch (Exception e) {
	    System.err.println("parser exception: "+e.toString());
	    e.printStackTrace();   // so we can get stack trace             
	}
    }

    public static void doTreeAction(String f, AST t, String[] tokenNames) {
	if ( t==null ) return;
	if ( showTree ) {
	    ((CommonAST)t).setVerboseStringConversion(true, tokenNames);
	    ASTFactory factory = new ASTFactory();
	    CommonAST r = (CommonAST)factory.create(0,"GenKit ROOT");
	    r.setFirstChild(t);

	    //r.addChild((CommonAST)factory.create(0, "C1"));
	    //r.addChild((CommonAST)factory.create(0, "C2"));
	    //r.addChild((CommonAST)factory.create(0, "C3"));

	    final ASTFrame frame = new ASTFrame("GenKit AST", r);
	    frame.setVisible(true);
	    frame.addWindowListener(
				    new WindowAdapter() {
					    public void windowClosing (WindowEvent e) {
						frame.setVisible(false); // hide the Frame
						frame.dispose();
						System.exit(0);
					    }
					}
				    );
	    // System.out.println(t.toStringList());
	}

	/*
	GenKitTreeParser tparse = new GenKitTreeParser();
	try {
	    tparse.compilationUnit(t);
	    // System.out.println("successful walk of result AST for "+f);
	}
	catch (RecognitionException e) {
	    System.err.println(e.getMessage());
	    e.printStackTrace();
	}
	*/
	
	}
}


