/* Chart Parser
   Erik Peterson
   CMU LTI
   March 2, 2001
*/

#ifndef __PARSE_H
#define __PARSE_H

#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include <string>
#include <vector.h>
#include <deque.h>
#include <set>
#include <map>
#include <algorithm>
#include "eBlock.hpp"

using namespace std;


class Word {
 public:
  string token; // representation of word
  vector<string> pos;  // possible parts of speech for word (index of non-terminal)
};


class Arc {
public:
  int rule;   // the index of the rule the arc is based on
  int start;  // the index of first word this arc covers (0 to N-1)
  int end;    // the index of the last word in the completed portion of the arc
  int dot_position;  // index of position of completed constituents in rule
  enum statuses {ACTIVE, INACTIVE, COMPLETED} status; // completed or active arc

  vector<int> indices; // the indices of the constituents that form the LHS of arc
};


class Constituent {
public:
  
  string type;   // the non-terminal this constituent represents
  int start;  // the index of first word this constituent covers
  int end;    // the index of the last word this constituent covers
  enum statuses {AGENDA, KEY, CHART, INSERT} status; // constituent is in agenda, key, or chart
  bool nt;

  vector<int> arcs;  // the arcs that this constituent is the RHS of

  // feature_struct features; // the feature struct associated with this constituent
  vector<FStruc> fss;

  //int index;  // unique identifier 
};


class PRule {
    public:
    string lhs;        // Index to non-terminal on left hand side of rule
    int rhs_total;     // Total number of elements on right hand side
    vector<string> rhs;       // Array of indices to non-terminals on right hand side of rule
    vector<bool> nt;
    bool spaced;
    
  // Unification Equation block for rule
    EBlockMain eb;

  PRule() {
    rhs_total = 0;
  }

};


class ChartParser {

private:
  typedef set<string> stringset;
  map<string, stringset*> curfirst;
  vector<Word*> lexicon;
  vector<PRule*> *rules;
  map<string, set<string> > first;
  int totalrules;
  set<string> nonterms;

  void computeNonterms();
  void computeFirst();
  
public:
  
  ChartParser(vector<PRule*> &myrules);
  ~ChartParser();

  int debug;
  string parse(char* inputSent);
  int transfer(char* inputSent);
  void init();

};

#endif
