#include "parsekit.hpp"
#include <fstream.h>
#include <iostream.h>
#include <string.h>

int main(int argc, char** argv) {
  char input[512];
  bool finished = false;
  ParseKit* pk = new ParseKit();
  cout << "Parse Kit initialized" << endl;
  pk->loadGrammarFile("project.gra");
  pk->init();

  if (argc > 1) {
      pk->parseString(argv[1]);
  } else {
    cout << "Grammar Loaded" << endl;
    do {
      cout << "> ";
      cin.getline(input, 512);
      if (strcmp(input, "quit") == 0 ||
	  strcmp(input, "q") == 0 ||
	  strcmp(input, "exit") == 0 ||
	  strcmp(input, "bye") == 0) {
	finished = true;
	break;
      }
      pk->parseString(input);
    } while (!finished);
  }
}
