#include "genkit.hpp"
#include <fstream.h>
#include <iostream.h>
#include <string.h>

int main(int argc, char** argv) {
  cout << "Starting parameter processing.1" << endl;
  vector<string> genstrings;
  int i, argi;
  int newserverport;
  bool isInteractive = false;
  bool isServer = false;
  bool isBatch = false;
  string inputfile, outputfile;

  cout << "Starting parameter processing.2" << endl;
  GenKit gk;
  gk.setEncoding("ASCII");
  gk.setGrammarLoadDebug(false);

  for (argi = 1; argi < argc; argi++) {
    if (strcmp("-i", argv[argi]) == 0) {
      isInteractive = true;

    } else if (strcmp("-if", argv[argi]) == 0) {
      isBatch = true;
      if (argi+1 < argc) {
	inputfile = argv[argi+1];
	argi++;
      }
    } else if (strcmp("-of", argv[argi]) == 0) {
      isBatch = true;
      if (argi+1 < argc) {
	outputfile = argv[argi+1];
	argi++;
      }
    } else if (strcmp("-f", argv[argi]) == 0) { // init file
      if (argi+1 < argc) {
	gk.initFromFile(argv[argi+1]);
	argi++;
      }
    } else if (strcmp("-sp", argv[argi]) == 0) {
      if (argi+1 < argc) 
	newserverport = atoi(argv[argi+1]);
      isServer = true;
      argi++;
      
    } else if (strcmp("-l", argv[argi]) == 0) { // generation language
      if (argi+1 < argc) 
	gk.setGenerateLanguage(argv[argi+1]);

    } else if (strcmp("-gd", argv[argi]) == 0) { // load grammar debug
      gk.setGrammarLoadDebug(true);

    } else if (strcmp("-h", argv[argi]) == 0) {
      cout << "Usage: GenKit [options]\n";
      cout << "OPTIONS:\n\n";
      cout << "-f init_file		: Specifies initialization file describing\n"; 
      cout << "                	   what grammars and lexicons to load.\n";
      cout << "                          Necessary unless running program in\n";
      cout << "                          interactive mode.\n\n";
	
      cout << "-l language		: Specify generation language (e.g. ENG for\n"; 
      cout << "			  English).\n\n";
	
      cout << "-if input_fstruct_file	: Specifies file containing f-structures from\n";
      cout << "			  which to generate surface forms.  Starts\n";
      cout << "			  program in batch mode.\n\n";
	
      cout << "-of output_gen_file	: Specifies file where to write generated\n";
      cout << "			  sentences.  Starts program in batch mode.\n\n";
	
      cout << "-sp server_port	        : Specifies the port number for the genkit\n";
      cout << "			  server to use.  Starts program in server mode.\n\n";
	
      cout << "-i			: Start program in interactive mode.\n\n";

      cout << "-gd			: Turn on grammar loading debugging.\n\n";
	
      cout << "-h			: Print help.\n";
      exit(0);
    }
  }   


  if (isInteractive == true) {
    gk.runInteractive();
  } else if (isServer == true) {
    gk.runServer(newserverport);
  } else if (isBatch == true) {
    cout << "Processing f-structures in " << inputfile << endl;
    gk.runBatch(inputfile, outputfile);
  }


  return 0;
}
