/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.Stack;
import java.util.Vector;

public class TreeReorder {
    Vector<Rule> rules = new Vector();
    boolean debug = false;

    TreeReorder() {
    }

    void readRules(String string) {
        try {
            String string2;
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "GBK"));
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray;
                string2.trim();
                if (string2.length() == 0 || (stringArray = string2.split("\\s+")).length < 3) continue;
                Rule rule = new Rule();
                rule.nodetype = stringArray[0];
                for (int i = 1; i < stringArray.length; ++i) {
                    rule.subs.add(stringArray[i]);
                }
                this.rules.add(rule);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("Rule count: " + this.rules.size());
    }

    pTreeNode buildTree(String string) {
        StringReader stringReader = new StringReader(string);
        ParseTreeLexer parseTreeLexer = new ParseTreeLexer(stringReader);
        ParseTreeParser parseTreeParser = new ParseTreeParser(parseTreeLexer);
        pTreeNode pTreeNode2 = new pTreeNode();
        parseTreeParser.setTopNode(pTreeNode2);
        try {
            parseTreeParser.tree();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return pTreeNode2;
    }

    void applyRules(pTreeNode pTreeNode2) {
        Stack<pTreeNode> stack = new Stack<pTreeNode>();
        stack.push(pTreeNode2);
        while (stack.size() > 0) {
            int n;
            pTreeNode pTreeNode3 = (pTreeNode)stack.pop();
            String string = pTreeNode3.nodetype;
            if (pTreeNode3.subs.size() <= 0) continue;
            for (int i = 0; i < this.rules.size(); ++i) {
                if (!string.equals(this.rules.elementAt((int)i).nodetype)) continue;
                int n2 = -1;
                if (this.rules.elementAt((int)i).subs.elementAt(0).indexOf("/") > 0) {
                    String[] stringArray = this.rules.elementAt((int)i).subs.elementAt(0).split("/");
                    for (n = 0; n < pTreeNode3.subs.size(); ++n) {
                        if (!pTreeNode3.subs.elementAt((int)n).nodetype.equals(stringArray[0])) continue;
                        n2 = n;
                        boolean bl = false;
                        for (int j = 0; j < pTreeNode3.subs.elementAt((int)n).subs.size(); ++j) {
                            if (!pTreeNode3.subs.elementAt((int)n).subs.elementAt((int)j).nodetype.equals(stringArray[1])) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            n2 = -1;
                            continue;
                        }
                        break;
                    }
                } else {
                    for (n = 0; n < pTreeNode3.subs.size(); ++n) {
                        if (!pTreeNode3.subs.elementAt((int)n).nodetype.equals(this.rules.elementAt((int)i).subs.elementAt(0))) continue;
                        n2 = n;
                        break;
                    }
                }
                if (n2 == -1) continue;
                int n3 = -1;
                for (n = pTreeNode3.subs.size() - 1; n >= 0; --n) {
                    if (!pTreeNode3.subs.elementAt((int)n).nodetype.equals(this.rules.elementAt((int)i).subs.elementAt(1))) continue;
                    n3 = n;
                }
                if (n3 == -1 || n3 <= n2) continue;
                if (this.debug) {
                    System.out.println("Rule applied " + i);
                }
                pTreeNode3.subs.add(n3 + 1, pTreeNode3.subs.elementAt(n2));
                pTreeNode3.subs.remove(n2);
            }
            for (n = pTreeNode3.subs.size() - 1; n >= 0; --n) {
                stack.push(pTreeNode3.subs.elementAt(n));
            }
        }
    }

    void readParses(String string, String string2) {
        int n = 0;
        String string3 = "GBK";
        try {
            String string4;
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, string3));
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, string3));
            while ((string4 = bufferedReader.readLine()) != null) {
                string4.trim();
                if (string4.length() == 0) continue;
                if (string4.charAt(0) != '(') {
                    bufferedWriter.write(string4 + "\n");
                    ++n;
                    continue;
                }
                pTreeNode pTreeNode2 = this.buildTree(string4);
                this.applyRules(pTreeNode2);
                String string5 = this.getSentence(pTreeNode2);
                bufferedWriter.write(string5 + "\n");
                if (this.debug) {
                    System.out.println("topnode type: " + pTreeNode2.nodetype);
                }
                ++n;
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("Parse count: " + n);
    }

    String getSentence(pTreeNode pTreeNode2) {
        StringBuffer stringBuffer = new StringBuffer();
        Stack<pTreeNode> stack = new Stack<pTreeNode>();
        stack.push(pTreeNode2);
        while (stack.size() > 0) {
            if (this.debug) {
                System.out.println("Node stack size: " + stack.size());
            }
            pTreeNode pTreeNode3 = (pTreeNode)stack.pop();
            if (pTreeNode3.subs.size() > 0) {
                for (int i = pTreeNode3.subs.size() - 1; i >= 0; --i) {
                    stack.push(pTreeNode3.subs.elementAt(i));
                }
                continue;
            }
            stringBuffer.append(pTreeNode3.word + " ");
        }
        return stringBuffer.toString().trim();
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (stringArray.length < 2) {
            System.out.println("Need at least rule file name and parse tree file");
            System.exit(1);
        } else if (stringArray.length == 2) {
            string = stringArray[0];
            string2 = stringArray[1];
            string3 = stringArray[1] + ".map";
        } else if (stringArray.length == 3) {
            string = stringArray[0];
            string2 = stringArray[1];
            string3 = stringArray[2];
        } else {
            System.out.println("Too many arguments");
            System.exit(1);
        }
        if (string == null) {
            System.out.println("Need to specify rule file name");
            System.exit(1);
        }
        if (string2 == null) {
            System.out.println("Need to specify file with parses");
            System.exit(1);
        }
        if (string3 == null) {
            System.out.println("Need to specify file to write reordered sentences.");
            System.exit(1);
        }
        TreeReorder treeReorder = new TreeReorder();
        treeReorder.readRules(string);
        treeReorder.readParses(string2, string3);
    }
}

