#!/usr/local/bin/perl -w

$byteorder = "le";

 @iscii = (' ','','','',' ','','','','','','','',' ',''
 ,'','','','','','','','','','','','','','','','','',''
 ,'','','','','','','','','','','','','','','','','','',''
 ,'','','','','','','',' ',' ','',' ','','','','','',''
 ,' ','','','','','','','','','',' ',' ',' ',' ',' ',' ',' '
 ,' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','',' ',' ',' ',' ','',' ','',''
 ,'','','','','','','','');

$| = 1;

while ($line = <STDIN>) {
    print &uni2iscii($line);
}

sub uni2iscii {
    my($unistr) = shift;
    my($i, $iscstr);

    for ($i = 0; $i < length($unistr); $i+=2) {
	$byte1 = substr($unistr, $i, 1);
	$byte2 = substr($unistr, $i+1, 1);
	if (vec($byte1, 0, 8) == 0xfe and
	    vec($byte2, 0, 8) == 0xff) 
	{
	    $byteorder = "le";
	    next;
	} elsif (vec($byte1, 0, 8) == 0xff and
		 vec($byte2, 0, 8) == 0xfe) 
	{
	    $byteorder = "be";
	    next;
	}

	if ($byteorder eq "le") {
	    if (vec($byte1, 0, 8) == 0x09) {
		$iscstr .= uni_to_iscii($byte2);
	    } elsif (vec($byte1, 0, 8) == 0x0) {
		$iscstr .= $byte2;
	    } else {
		$iscstr .= "?";
	    }
	} else { # Big-endian
	    if (vec($byte2, 0, 8) == 0x09) {
		$iscstr .= uni_to_iscii($byte1);
	    } elsif (vec($byte2, 0, 8) == 0x0) {
		$iscstr .= $byte1;
	    } else {
		$iscstr .= "?";
	    }

	}
    }

    return $iscstr;
}

#  isciipage [	]
#  %x BE
#  %x LE 
#  %%
#   {BEGIN BE;}
#   {BEGIN LE;}

#  <BE>{isciipage}.   {uni_to_iscii(yytext[1],ans);printf("%s",ans);}
#  <BE>{isciipage}\n  {uni_to_iscii(yytext[1],ans);printf("%s",ans);}
#  <BE> .            {printf("%c",yytext[1]);}
#  <BE> \n           {printf("%c",yytext[1]);}

#  <LE>.{isciipage}   {uni_to_iscii(yytext[0],ans);printf("%s",ans);}
#  <LE>\n{isciipage}  {uni_to_iscii(yytext[0],ans);printf("%s",ans);}
#  <LE>.             {printf("%c",yytext[0]);}
#  <LE>\n            {printf("%c",yytext[0]);}
#  %%   

 
sub uni_to_iscii {
    my($ch) = shift;
    my($chval) = vec($ch, 0, 8);
    my($out) = "";
    
    if ($chval == 12) {
	$out = pack("CC", $chval + 154, 233);
    } elsif ($chval == 61) {
	$out = pack("CC", $chval + 173, 233);
    } elsif ($chval == 68) {
	$out = pack("CC", $chval + 155, 233);
    } elsif ($chval == 80) {
	$out = pack("CC", $chval + 81, 233);
    } elsif ($chval == 88) {
	$out = pack("CC", $chval + 91, 233);
    } elsif ($chval == 89) {
	$out = pack("CC", $chval + 91, 233);
    } elsif ($chval == 90) {
	$out = pack("CC", $chval + 90, 233);
    } elsif ($chval == 91) {
	$out = pack("CC", $chval + 95, 233);
    } elsif ($chval == 92) {
	$out = pack("CC", $chval + 99, 233);
    } elsif ($chval == 93) {
	$out = pack("CC", $chval + 99, 233);
    } elsif ($chval == 94) {
	$out = pack("CC", $chval + 107, 233);
    } elsif ($chval == 96) {
	$out = pack("CC", $chval + 74, 233);
    } elsif ($chval == 97) {
	$out = pack("CC", $chval + 70, 233);
    } elsif ($chval == 98) {
	$out = pack("CC", $chval + 121, 233);
    } elsif ($chval == 99) {
	$out = pack("CC", $chval + 121, 233);
    } else {
        $out = $iscii[$chval];
    }
    return $out;
} 
