/*
 * Decompiled with CFR 0.152.
 */
package snaq.util;

import snaq.util.Cacheable;

public class TimeWrapper
implements Cacheable {
    private Object id;
    private Object obj;
    private long death = 0L;
    private long accessed = System.currentTimeMillis();

    public TimeWrapper(Object id, Object obj, long expiryTime) {
        this.id = id;
        this.obj = obj;
        if (expiryTime > 0L) {
            this.death = System.currentTimeMillis() + expiryTime;
        }
    }

    public Object getId() {
        return this.id;
    }

    public Object getObject() {
        return this.obj;
    }

    synchronized void setLiveTime(long expiryTime) {
        if (expiryTime < 0L) {
            throw new IllegalArgumentException("Invalid expiry time");
        }
        this.death = expiryTime > 0L ? System.currentTimeMillis() + expiryTime : 0L;
    }

    public synchronized boolean isExpired() {
        return this.death > 0L && System.currentTimeMillis() > this.death;
    }

    synchronized void updateAccessed() {
        this.accessed = System.currentTimeMillis();
    }

    long getAccessed() {
        return this.accessed;
    }
}

