/*
 * Decompiled with CFR 0.152.
 */
package snaq.util;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import snaq.util.LogUtil;
import snaq.util.ObjectPoolEvent;
import snaq.util.ObjectPoolListener;
import snaq.util.Reusable;
import snaq.util.TimeWrapper;

public abstract class ObjectPool
extends LogUtil {
    private String name;
    private List free;
    private List used;
    private int poolSize;
    private int maxSize;
    private long expiryTime;
    private long requests;
    private long hits;
    private boolean released = false;
    private boolean asyncDestroy = false;
    private DateFormat dateFormat;
    private Cleaner cleaner;
    private static int cleanerCount = 0;
    private List listeners = new ArrayList();

    protected ObjectPool(String name, int poolSize, int maxSize, long expiryTime) {
        Class type = this.getPoolClass();
        if (!List.class.isAssignableFrom(type)) {
            throw new RuntimeException("Invalid pool class type specified: " + type.getName() + " (must implement List)");
        }
        try {
            this.free = (List)type.newInstance();
            this.used = (List)type.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate pool class type: " + type.getName());
        }
        this.name = name;
        this.setParameters(poolSize, maxSize, expiryTime);
    }

    protected ObjectPool(String name, int poolSize, int maxSize, int expiryTime) {
        this(name, poolSize, maxSize, (long)expiryTime);
    }

    protected final synchronized Reusable checkOut() throws Exception {
        boolean hit;
        if (this.released) {
            throw new RuntimeException("Pool no longer valid for use");
        }
        int oldTotalConns = this.used.size() + this.free.size();
        TimeWrapper tw = null;
        Reusable o = null;
        if (this.free.size() > 0) {
            tw = (TimeWrapper)this.free.remove(0);
            o = (Reusable)tw.getObject();
            boolean valid = this.isValid(o);
            while (!valid && this.free.size() > 0) {
                this.destroyObject(o);
                this.log("Removed invalid item from pool");
                tw = (TimeWrapper)this.free.remove(0);
                o = (Reusable)tw.getObject();
                valid = this.isValid(o);
            }
            if (this.free.size() == 0 && !valid) {
                o = null;
            }
        }
        boolean bl = hit = o != null;
        if (o == null) {
            if (this.maxSize > 0 && this.used.size() == this.maxSize) {
                this.fireMaxSizeLimitErrorEvent();
            } else if (!(this.used.size() >= this.maxSize && this.maxSize != 0 || this.isValid(o = this.create()))) {
                throw new RuntimeException("Unable to create a valid connection");
            }
        }
        if (o != null) {
            this.used.add(o);
            ++this.requests;
            if (hit) {
                ++this.hits;
            }
            this.firePoolCheckOutEvent();
            int totalConns = this.used.size() + this.free.size();
            if (totalConns == this.poolSize && totalConns > oldTotalConns) {
                this.fireMaxPoolLimitReachedEvent();
            } else if (totalConns == this.poolSize + 1 && totalConns > oldTotalConns) {
                this.fireMaxPoolLimitExceededEvent();
            }
            if (totalConns == this.maxSize && totalConns > oldTotalConns) {
                this.fireMaxSizeLimitReachedEvent();
            }
        }
        if (this.debug) {
            String ratio = this.used.size() + "/" + (this.used.size() + this.free.size());
            String hitRate = " (HitRate=" + this.getHitRate() + "%)";
            this.log("Checkout - " + ratio + hitRate + (o == null ? " - null returned" : ""));
        }
        return o;
    }

    protected final synchronized Reusable checkOut(long timeout) throws Exception {
        long time = System.currentTimeMillis();
        Reusable o = null;
        o = this.checkOut();
        while (o == null && System.currentTimeMillis() - time < timeout) {
            try {
                if (this.debug) {
                    this.log("No pooled items spare...waiting for up to " + timeout + "ms");
                }
                this.wait(timeout);
                o = this.checkOut();
            }
            catch (InterruptedException e) {
                this.log(e, "Connection checkout interrupted");
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void checkIn(Reusable o) {
        if (o == null) {
            this.log("Attempt to return null item");
            return;
        }
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            this.firePoolCheckInEvent();
            if (!this.used.remove(o)) {
                this.log("Attempt to return item not belonging to pool");
                throw new RuntimeException("Attempt to return item not belonging to pool " + this.name);
            }
            boolean kill = this.maxSize > 0 && this.free.size() + this.used.size() >= this.poolSize;
            boolean bl = kill = kill || this.maxSize == 0 && this.free.size() >= this.poolSize;
            if (kill) {
                this.destroyObject(o);
                if (this.debug) {
                    this.log("Checkin* - " + this.used.size() + "/" + (this.used.size() + this.free.size()));
                }
            } else {
                try {
                    o.recycle();
                    this.free.add(new TimeWrapper(null, o, this.expiryTime));
                    if (this.debug) {
                        this.log("Checkin  - " + this.used.size() + "/" + (this.used.size() + this.free.size()));
                    }
                    this.notifyAll();
                }
                catch (Exception e) {
                    this.destroyObject(o);
                    this.log("Unable to recycle item - destroyed");
                }
            }
        }
    }

    public final void release() {
        this.release(false);
    }

    public final synchronized void releaseAsync() {
        this.releaseAsync(false);
    }

    public final void releaseForcibly() {
        this.release(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void release(boolean forced) {
        if (this.released) {
            return;
        }
        this.released = true;
        if (this.cleaner != null) {
            this.cleaner.halt();
            try {
                this.cleaner.join();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            this.cleaner = null;
        }
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            Iterator iter;
            int rel = 0;
            int failed = 0;
            TimeWrapper tw = null;
            Reusable o = null;
            if (forced) {
                iter = this.used.iterator();
                while (iter.hasNext()) {
                    o = (Reusable)iter.next();
                    try {
                        this.destroy(o);
                        ++rel;
                    }
                    catch (Exception ex) {
                        ++failed;
                        this.log(ex, "Unable to release item in pool");
                    }
                }
                this.used.clear();
            } else {
                if (this.debug && this.used.size() > 0) {
                    this.log("Waiting for used items to be checked-in...");
                }
                while (this.used.size() > 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
            iter = this.free.iterator();
            while (iter.hasNext()) {
                tw = (TimeWrapper)iter.next();
                o = (Reusable)tw.getObject();
                try {
                    this.destroy(o);
                    ++rel;
                }
                catch (Exception ex) {
                    ++failed;
                    this.log(ex, "Unable to release item in pool");
                }
            }
            this.free.clear();
            if (this.debug) {
                String s = "Released " + rel + (rel > 1 ? " items" : " item");
                if (failed > 0) {
                    s = s + " (failed to release " + failed + (failed > 1 ? " items)" : " item)");
                }
                this.log(s);
            }
            this.firePoolReleasedEvent();
            this.listeners.clear();
            super.close();
        }
    }

    private final void releaseAsync(final boolean forced) {
        Thread t = new Thread(new Runnable(){

            public void run() {
                ObjectPool.this.release(forced);
            }
        });
        t.start();
    }

    protected abstract Reusable create() throws Exception;

    protected abstract boolean isValid(Reusable var1);

    protected abstract void destroy(Reusable var1);

    private final void destroyObject(final Reusable o) {
        if (o == null) {
            return;
        }
        if (this.asyncDestroy) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    ObjectPool.this.destroy(o);
                }
            });
            t.start();
        } else {
            this.destroy(o);
        }
    }

    public final void setAsyncDestroy(boolean b) {
        this.asyncDestroy = b;
    }

    public final boolean isAsyncDestroy() {
        return this.asyncDestroy;
    }

    public void log(String logEntry) {
        this.log(this.name + ": ", logEntry);
    }

    public void log(Throwable e, String logEntry) {
        this.log(e, this.name + ": ", logEntry);
    }

    public final String getName() {
        return this.name;
    }

    public final int getPoolSize() {
        return this.poolSize;
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    public final long getExpiryTime() {
        return this.expiryTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setParameters(int poolSize, int maxSize, long expiryTime) {
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            if (this.cleaner != null) {
                this.cleaner.halt();
            }
            this.poolSize = Math.max(poolSize, 0);
            this.maxSize = Math.max(maxSize, 0);
            this.expiryTime = Math.max(expiryTime, 0L);
            if (this.maxSize > 0 && this.maxSize < this.poolSize) {
                this.maxSize = this.poolSize;
            }
            this.resetHitCounter();
            Iterator iter = this.free.iterator();
            TimeWrapper tw = null;
            while (iter.hasNext()) {
                tw = (TimeWrapper)iter.next();
                tw.setLiveTime(expiryTime);
            }
            if (this.expiryTime > 0L) {
                long iVal = Math.min(5000L, this.expiryTime / 5L);
                this.cleaner = new Cleaner(this, iVal);
                this.cleaner.start();
            }
        }
        if (this.debug) {
            String info = "pool=" + this.poolSize + ",max=" + this.maxSize + ",expiry=";
            info = info + (this.expiryTime == 0L ? "none" : this.expiryTime + "ms");
            this.log("Parameters changed (" + info + ")");
        }
        if (this.listeners != null) {
            this.fireParametersChangedEvent();
        }
    }

    public final synchronized int getSize() {
        return this.free.size() + this.used.size();
    }

    public final synchronized int getCheckedOut() {
        return this.used.size();
    }

    public final synchronized int getFreeCount() {
        return this.free.size();
    }

    public final float getHitRate() {
        return this.requests == 0L ? 0.0f : (float)this.hits / (float)this.requests * 100.0f;
    }

    protected final void resetHitCounter() {
        this.hits = 0L;
        this.requests = 0L;
    }

    protected Class getPoolClass() {
        return ArrayList.class;
    }

    public void finalize() {
        if (this.cleaner != null) {
            this.cleaner.halt();
            this.cleaner = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        int count = 0;
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            Iterator iter = this.free.iterator();
            TimeWrapper tw = null;
            while (iter.hasNext()) {
                tw = (TimeWrapper)iter.next();
                iter.remove();
                this.destroyObject((Reusable)tw.getObject());
                ++count;
            }
        }
        if (count > 0 && this.debug) {
            this.log("Flushed all spare items from pool");
        }
    }

    final synchronized boolean purge() {
        if (this.debug) {
            this.log("Checking for expired items");
        }
        int count = 0;
        Iterator iter = this.free.iterator();
        TimeWrapper tw = null;
        while (iter.hasNext()) {
            tw = (TimeWrapper)iter.next();
            if (!tw.isExpired()) continue;
            iter.remove();
            this.destroyObject((Reusable)tw.getObject());
            ++count;
        }
        return this.free.size() > 0 || count > 0;
    }

    public final void addObjectPoolListener(ObjectPoolListener x) {
        this.listeners.add(x);
    }

    public final void removeObjectPoolListener(ObjectPoolListener x) {
        this.listeners.remove(x);
    }

    private final void firePoolCheckOutEvent() {
        ObjectPoolEvent poolEvent = new ObjectPoolEvent(this, 1);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ObjectPoolListener)iter.next()).poolCheckOut(poolEvent);
        }
    }

    private final void firePoolCheckInEvent() {
        ObjectPoolEvent poolEvent = new ObjectPoolEvent(this, 2);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ObjectPoolListener)iter.next()).poolCheckIn(poolEvent);
        }
    }

    private final void fireMaxPoolLimitReachedEvent() {
        ObjectPoolEvent poolEvent = new ObjectPoolEvent(this, 3);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ObjectPoolListener)iter.next()).maxPoolLimitReached(poolEvent);
        }
    }

    private final void fireMaxPoolLimitExceededEvent() {
        ObjectPoolEvent poolEvent = new ObjectPoolEvent(this, 4);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ObjectPoolListener)iter.next()).maxPoolLimitExceeded(poolEvent);
        }
    }

    private final void fireMaxSizeLimitReachedEvent() {
        ObjectPoolEvent poolEvent = new ObjectPoolEvent(this, 5);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ObjectPoolListener)iter.next()).maxSizeLimitReached(poolEvent);
        }
    }

    private final void fireMaxSizeLimitErrorEvent() {
        ObjectPoolEvent poolEvent = new ObjectPoolEvent(this, 6);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ObjectPoolListener)iter.next()).maxSizeLimitError(poolEvent);
        }
    }

    private final void fireParametersChangedEvent() {
        ObjectPoolEvent poolEvent = new ObjectPoolEvent(this, 7);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ObjectPoolListener)iter.next()).poolParametersChanged(poolEvent);
        }
    }

    private final void firePoolReleasedEvent() {
        ObjectPoolEvent poolEvent = new ObjectPoolEvent(this, 8);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ObjectPoolListener)iter.next()).poolReleased(poolEvent);
        }
    }

    final class Cleaner
    extends Thread {
        private ObjectPool pool;
        private long interval;
        private boolean stopped;

        Cleaner(ObjectPool pool, long interval) {
            this.setName("CleanerThread" + Integer.toString(cleanerCount++));
            this.pool = pool;
            this.interval = interval;
        }

        public void start() {
            this.stopped = false;
            super.start();
        }

        public void halt() {
            if (!this.isHalted()) {
                this.stopped = true;
                this.interrupt();
            }
        }

        public boolean isHalted() {
            return this.stopped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.pool.cleaner == Thread.currentThread() && !this.stopped) {
                ObjectPool objectPool = this.pool;
                synchronized (objectPool) {
                    if (!this.pool.purge()) {
                        try {
                            this.pool.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (this.stopped) continue;
                try {
                    Cleaner.sleep(this.interval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

