/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import snaq.db.ConnectionPoolManager;

public class SQLUpdate {
    private ConnectionPoolManager cpm;
    private Connection con;
    private Statement statement;
    private String dbName;
    private ByteArrayOutputStream logBuffer;
    private PrintWriter log;

    public SQLUpdate(String db) throws IOException {
        this.dbName = db;
        this.cpm = ConnectionPoolManager.getInstance();
    }

    private void openConnection(String s) throws SQLException {
        if (s == null || s.equals("")) {
            System.out.println("Please specify a database name");
            System.exit(1);
        }
        this.con = this.cpm.getConnection(s);
        try {
            this.statement = this.con.createStatement();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.logBuffer = new ByteArrayOutputStream();
        this.log = new PrintWriter(this.logBuffer);
    }

    private void closeConnection() {
        try {
            this.statement.close();
            this.con.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        this.log.flush();
        this.log.close();
        if (this.logBuffer.size() > 0) {
            try {
                FileOutputStream fos = new FileOutputStream("SQLUpdate.log", true);
                fos.write(this.logBuffer.toByteArray());
                fos.flush();
                fos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.cpm.release();
    }

    private void doStatement(String sql) {
        int count = 0;
        try {
            count = this.statement.executeUpdate(sql);
            System.out.print(".");
        }
        catch (SQLException sqle) {
            System.out.print("x");
            this.log.println();
            this.log.println(sql);
            this.log.println(sqle.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length < 2) {
            System.out.println("Usage: java snaq.db.SQLUpdate <database> <text file> [<separator>]");
            System.exit(0);
        }
        String db = args[0];
        String file = args[1];
        String separator = args.length < 3 ? null : args[2];
        String contents = null;
        try {
            int n;
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            FileInputStream fis = new FileInputStream(file);
            byte[] b = new byte[4096];
            while ((n = fis.read(b)) != -1) {
                bao.write(b, 0, n);
            }
            fis.close();
            contents = new String(bao.toByteArray());
        }
        catch (IOException ioe) {
            System.out.println("I/O error with file " + file);
            System.exit(1);
        }
        SQLUpdate sql = null;
        try {
            sql = new SQLUpdate(db);
        }
        catch (IOException ioe) {
            System.err.println("Unable to create instance of SQLUpdate");
            ioe.printStackTrace();
            System.exit(1);
        }
        sql.openConnection(db);
        if (separator == null) {
            StringTokenizer st = new StringTokenizer(contents, "\n\r");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token.startsWith("#") || token.equals("")) continue;
                sql.doStatement(token);
            }
        } else {
            System.out.println("Separator: " + separator);
            StringBuffer sb = new StringBuffer();
            StringTokenizer st = new StringTokenizer(contents, "\n\r");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                if (line.startsWith("#") || line.startsWith("--")) {
                    sb.setLength(0);
                    continue;
                }
                int pos = line.indexOf(separator);
                if (pos >= 0) {
                    sb.append(line.substring(0, pos));
                    sql.doStatement(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                sb.append(line);
            }
        }
        sql.closeConnection();
        System.out.println();
    }
}

