/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import snaq.db.ConnectionPool;
import snaq.db.ConnectionValidator;
import snaq.db.PasswordDecoder;
import snaq.util.LogUtil;

public final class ConnectionPoolManager
extends LogUtil {
    private static final String PROPERTIES_INSTANCE_KEY = "PROPERTIES_INSTANCE";
    private static final String DEFAULT_PROPERTIES_FILE = "/dbpool.properties";
    private static Hashtable managers = new Hashtable();
    private static Vector drivers = new Vector();
    private boolean released = false;
    private Hashtable pools = new Hashtable();
    protected int clients;
    private Object source;

    private ConnectionPoolManager(Properties props, Object src) {
        this.source = src;
        this.init(props);
    }

    public String toString() {
        if (this.source instanceof String) {
            return "ConnectionPoolManager [CLASSPATH resource:" + this.source + "]";
        }
        if (this.source instanceof File) {
            return "ConnectionPoolManager [File:" + ((File)this.source).getAbsolutePath() + "]";
        }
        if (this.source instanceof Properties) {
            return "ConnectionPoolManager [Properties]";
        }
        return "ConnectionPoolManager [Unknown]";
    }

    public static synchronized ConnectionPoolManager getInstance(String propsFile) throws IOException {
        ConnectionPoolManager cpm;
        String s = propsFile.startsWith("/") ? propsFile : "/" + propsFile;
        Object o = managers.get(s);
        ConnectionPoolManager connectionPoolManager = cpm = o != null ? (ConnectionPoolManager)o : null;
        if (cpm == null || cpm.isReleased()) {
            cpm = new ConnectionPoolManager(ConnectionPoolManager.loadProperties(s), propsFile);
            managers.put(s, cpm);
        }
        ++cpm.clients;
        return cpm;
    }

    public static synchronized ConnectionPoolManager getInstance(File propsFile) throws IOException {
        ConnectionPoolManager cpm;
        Object o = managers.get(propsFile);
        ConnectionPoolManager connectionPoolManager = cpm = o != null ? (ConnectionPoolManager)o : null;
        if (cpm == null || cpm.isReleased()) {
            try {
                cpm = new ConnectionPoolManager(ConnectionPoolManager.loadProperties(propsFile), propsFile);
                managers.put(propsFile, cpm);
            }
            catch (IOException ioe) {
                if (ioe instanceof FileNotFoundException) {
                    System.err.println("Unable to find the properties file " + propsFile.getAbsolutePath());
                } else {
                    System.err.println("Error loading the properties file " + propsFile.getAbsolutePath());
                }
                ioe.printStackTrace();
                return null;
            }
        }
        ++cpm.clients;
        return cpm;
    }

    public static synchronized ConnectionPoolManager getInstance() throws IOException {
        ConnectionPoolManager cpm;
        Object o = managers.get(PROPERTIES_INSTANCE_KEY);
        ConnectionPoolManager connectionPoolManager = cpm = o != null ? (ConnectionPoolManager)o : null;
        if (cpm != null && !cpm.released) {
            ++cpm.clients;
        } else {
            cpm = ConnectionPoolManager.getInstance(DEFAULT_PROPERTIES_FILE);
        }
        return cpm;
    }

    public static synchronized void createInstance(Properties props) {
        ConnectionPoolManager cpm;
        Object o = managers.get(DEFAULT_PROPERTIES_FILE);
        ConnectionPoolManager connectionPoolManager = cpm = o != null ? (ConnectionPoolManager)o : null;
        if (cpm != null && !cpm.isReleased()) {
            throw new RuntimeException("Default properties file instance already exists");
        }
        cpm = new ConnectionPoolManager(props, props);
        managers.put(PROPERTIES_INSTANCE_KEY, cpm);
    }

    private static Properties loadProperties(File propsFile) throws IOException {
        if (!propsFile.exists()) {
            throw new FileNotFoundException(propsFile.getAbsolutePath() + " does not exist");
        }
        if (propsFile.isDirectory()) {
            throw new IOException("Error accessing properties file - " + propsFile.getAbsolutePath() + " is a directory");
        }
        FileInputStream is = new FileInputStream(propsFile);
        Properties props = new Properties();
        props.load(is);
        ((InputStream)is).close();
        return props;
    }

    private static Properties loadProperties(String propsResource) throws IOException {
        InputStream is = ConnectionPoolManager.class.getResourceAsStream(propsResource);
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException ioe) {
            System.err.println("Unable to load the properties file. Make sure " + propsResource + " is in the CLASSPATH.");
            ioe.printStackTrace();
            throw ioe;
        }
        return props;
    }

    private void init(Properties props) {
        String logFile = props.getProperty("logfile", "ConnectionPoolManager.log");
        String df = props.getProperty("dateformat", "EEE MMM dd hh:mm:ss.SSS ZZZ yyyy");
        try {
            this.setDateFormat(new SimpleDateFormat(df));
            this.setLog(new FileOutputStream(logFile, true));
        }
        catch (IOException e) {
            System.err.println("Can't open the log file: " + logFile);
        }
        this.loadDrivers(props);
        this.createPools(props);
    }

    private void loadDrivers(Properties props) {
        String driverClasses = props.getProperty("drivers");
        StringTokenizer st = new StringTokenizer(driverClasses, ",: \t\n\r\f");
        Enumeration<Driver> current = DriverManager.getDrivers();
        while (st.hasMoreElements()) {
            String driverClassName = st.nextToken().trim();
            try {
                boolean using = false;
                while (current.hasMoreElements()) {
                    String cName = current.nextElement().getClass().getName();
                    if (!cName.equals(driverClassName)) continue;
                    using = true;
                }
                if (using) continue;
                Driver driver = (Driver)Class.forName(driverClassName).newInstance();
                DriverManager.registerDriver(driver);
                drivers.addElement(driver);
                this.log("Registered JDBC driver " + driverClassName);
            }
            catch (Exception e) {
                this.log("Unable to register JDBC driver: " + driverClassName + ", Exception: " + e);
            }
        }
    }

    private void createPools(Properties props) {
        Iterator<Object> iter = props.keySet().iterator();
        while (iter.hasNext()) {
            Object o;
            int exp;
            int iSize;
            int mSize;
            int pSize;
            String name = (String)iter.next();
            if (!name.endsWith(".url")) continue;
            String poolName = name.substring(0, name.lastIndexOf("."));
            String url = props.getProperty(poolName + ".url");
            if (url == null) {
                this.log("No URL specified for " + poolName);
                continue;
            }
            String user = props.getProperty(poolName + ".user");
            user = user != null ? user.trim() : user;
            String pass = props.getProperty(poolName + ".password");
            pass = pass != null ? pass.trim() : pass;
            String poolSize = props.getProperty(poolName + ".maxpool", "0").trim();
            String maxSize = props.getProperty(poolName + ".maxconn", "0").trim();
            String init = props.getProperty(poolName + ".init", "0").trim();
            String expiry = props.getProperty(poolName + ".expiry", "0").trim();
            String validator = props.getProperty(poolName + ".validator");
            String decoder = props.getProperty(poolName + ".decoder");
            validator = validator != null ? validator.trim() : validator;
            boolean noCache = props.getProperty(poolName + ".cache", "true").trim().equalsIgnoreCase("false");
            boolean async = props.getProperty(poolName + ".async", "false").trim().equalsIgnoreCase("true");
            boolean poolDebug = props.getProperty(poolName + ".debug", "false").trim().equalsIgnoreCase("true");
            Properties poolProps = new Properties();
            String prefix = poolName + ".prop.";
            Iterator<Object> it = props.keySet().iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                if (!s.startsWith(prefix)) continue;
                poolProps.setProperty(s.substring(prefix.length()), props.getProperty(s));
            }
            if (!poolProps.isEmpty() && user != null && !user.equals("")) {
                poolProps.setProperty("user", user);
                poolProps.setProperty("password", pass);
            } else {
                poolProps = null;
            }
            try {
                pSize = Integer.valueOf(poolSize);
            }
            catch (NumberFormatException nfe) {
                this.log("Invalid maxpool value " + poolSize + " for " + poolName);
                pSize = 0;
            }
            try {
                mSize = Integer.valueOf(maxSize);
            }
            catch (NumberFormatException nfe) {
                this.log("Invalid maxconn value " + maxSize + " for " + poolName);
                mSize = 0;
            }
            try {
                iSize = Integer.valueOf(init);
            }
            catch (NumberFormatException nfe) {
                this.log("Invalid initsize value " + init + " for " + poolName);
                iSize = 0;
            }
            try {
                exp = Integer.valueOf(expiry);
            }
            catch (NumberFormatException nfe) {
                this.log("Invalid expiry value " + expiry + " for " + poolName);
                exp = 0;
            }
            if (pSize < 0) {
                pSize = 0;
            }
            if (mSize > 0 && mSize < pSize) {
                mSize = pSize;
            }
            if (iSize < 0) {
                iSize = 0;
            } else if (iSize > pSize) {
                iSize = pSize;
            }
            if (exp < 0 || mSize == pSize) {
                exp = 0;
            }
            ConnectionPool pool = null;
            pool = poolProps != null ? new ConnectionPool(poolName, pSize, mSize, exp * 1000, url, poolProps) : new ConnectionPool(poolName, pSize, mSize, exp * 1000, url, user, pass);
            pool.setDateFormat(this.dateFormat);
            pool.setLog(this.getLogStream());
            if (poolDebug) {
                this.log("Enabling debug info on pool " + poolName);
            }
            pool.setDebug(poolDebug);
            if (noCache) {
                this.log("Disabling caching on pool " + poolName);
            }
            pool.setCaching(!noCache);
            if (async) {
                this.log("Enabling asynchronous destruction on pool " + poolName);
            }
            pool.setAsyncDestroy(async);
            if (validator != null && !validator.equals("")) {
                try {
                    o = Class.forName(validator).newInstance();
                    if (o instanceof ConnectionValidator) {
                        pool.setValidator((ConnectionValidator)o);
                    }
                }
                catch (Exception ex) {
                    this.log("Unable to instantiate validator class for pool " + poolName + ": " + validator);
                }
            }
            if (decoder != null && !decoder.equals("")) {
                try {
                    o = Class.forName(decoder).newInstance();
                    if (o instanceof PasswordDecoder) {
                        pool.setPasswordDecoder((PasswordDecoder)o);
                    }
                }
                catch (Exception ex) {
                    this.log("Unable to instantiate password decoder class for pool " + poolName + ": " + decoder);
                }
            }
            this.pools.put(poolName, pool);
            String info = "pool=" + pool.getPoolSize() + ",max=" + pool.getMaxSize() + ",expiry=";
            info = info + (pool.getExpiryTime() == 0L ? "none" : pool.getExpiryTime() + "ms");
            this.log("Initialized pool " + poolName + " (" + info + ")");
            if (iSize <= 0) continue;
            pool.init(iSize);
        }
    }

    public ConnectionPool getPool(String name) {
        if (this.released) {
            throw new RuntimeException("Pool manager no longer valid for use");
        }
        return (ConnectionPool)this.pools.get(name);
    }

    public Connection getConnection(String name) throws SQLException {
        if (this.released) {
            throw new RuntimeException("Pool manager no longer valid for use");
        }
        ConnectionPool pool = (ConnectionPool)this.pools.get(name);
        if (pool != null) {
            return pool.getConnection();
        }
        return null;
    }

    public Connection getConnection(String name, long time) throws SQLException {
        if (this.released) {
            throw new RuntimeException("Pool manager no longer valid for use");
        }
        ConnectionPool pool = (ConnectionPool)this.pools.get(name);
        if (pool != null) {
            return pool.getConnection(time);
        }
        return null;
    }

    public synchronized void release() {
        if (--this.clients != 0) {
            return;
        }
        this.released = true;
        Enumeration<Object> e = this.pools.elements();
        while (e.hasMoreElements()) {
            ConnectionPool pool = (ConnectionPool)e.nextElement();
            pool.releaseForcibly();
        }
        if (managers.size() == 1) {
            e = drivers.elements();
            while (e.hasMoreElements()) {
                Driver driver = (Driver)e.nextElement();
                try {
                    DriverManager.deregisterDriver(driver);
                    this.log("Deregistered JDBC driver " + driver.getClass().getName());
                }
                catch (SQLException sqle) {
                    this.log(sqle, "Can't deregister JDBC driver: " + driver.getClass().getName());
                }
            }
        }
        super.close();
    }

    public synchronized boolean isReleased() {
        return this.released;
    }

    public synchronized void setValidator(ConnectionValidator cv) {
        if (this.pools != null) {
            Enumeration e = this.pools.elements();
            while (e.hasMoreElements()) {
                ((ConnectionPool)e.nextElement()).setValidator(cv);
            }
        }
    }

    public void setLog(OutputStream out) {
        super.setLog(out);
        if (this.pools != null) {
            Enumeration e = this.pools.elements();
            while (e.hasMoreElements()) {
                ((ConnectionPool)e.nextElement()).setLog(out);
            }
        }
    }

    public void setLog(PrintStream ps) {
        super.setLog(ps);
        if (this.pools != null) {
            Enumeration e = this.pools.elements();
            while (e.hasMoreElements()) {
                ((ConnectionPool)e.nextElement()).setLog(ps);
            }
        }
    }
}

