/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import snaq.db.CacheConnection;
import snaq.db.ConnectionPoolEvent;
import snaq.db.ConnectionPoolListener;
import snaq.db.ConnectionValidator;
import snaq.db.PasswordDecoder;
import snaq.util.ObjectPool;
import snaq.util.ObjectPoolEvent;
import snaq.util.ObjectPoolEventAdapter;
import snaq.util.Reusable;

public class ConnectionPool
extends ObjectPool {
    private String url;
    private String user;
    private String pass;
    private Properties props;
    private ConnectionValidator validator = new DefaultValidator();
    private PasswordDecoder decoder;
    private boolean cacheSS;
    private boolean cachePS;
    private boolean cacheCS;
    private InitThread initer;
    private List listeners = new ArrayList();

    public ConnectionPool(String name, int poolSize, int maxSize, long expiryTime, String url, String username, String password) {
        super(name, poolSize, maxSize, expiryTime);
        this.url = url;
        this.user = username;
        this.pass = password;
        this.props = null;
        this.setCaching(true);
        this.addObjectPoolListener(new EventRelay());
    }

    public ConnectionPool(String name, int poolSize, int maxSize, long expiryTime, String url, Properties props) {
        this(name, poolSize, maxSize, expiryTime, url, null, null);
        this.props = props;
        this.pass = props.getProperty("password");
        this.addObjectPoolListener(new EventRelay());
    }

    public void init(int num) {
        if (num == 0) {
            return;
        }
        if (num <= 0 || num > this.getPoolSize()) {
            throw new IllegalArgumentException("Invalid number of connections specifiec");
        }
        this.initer = new InitThread(num);
        this.initer.start();
    }

    protected Reusable create() throws SQLException {
        Connection con = null;
        CacheConnection ccon = null;
        try {
            block11: {
                if (this.props != null) {
                    if (this.decoder != null) {
                        this.props.setProperty("password", new String(this.decoder.decode(this.pass)));
                    }
                    con = DriverManager.getConnection(this.url, this.props);
                } else if (this.user != null) {
                    try {
                        if (this.decoder != null) {
                            con = DriverManager.getConnection(this.url, this.user, new String(this.decoder.decode(this.pass)));
                            break block11;
                        }
                        con = DriverManager.getConnection(this.url, this.user, this.pass);
                    }
                    catch (SQLException sqle) {
                        this.log("Failed to connect with standard authentication...trying with just JDBC URL");
                        con = DriverManager.getConnection(this.url);
                    }
                } else {
                    con = DriverManager.getConnection(this.url);
                }
            }
            ccon = new CacheConnection(this, con);
            ccon.setCacheStatements(this.cacheSS);
            ccon.setCachePreparedStatements(this.cachePS);
            ccon.setCacheCallableStatements(this.cacheCS);
            this.log("Created a new connection");
            for (SQLWarning warn = con.getWarnings(); warn != null; warn = warn.getNextWarning()) {
                this.log("Warning - " + warn.getMessage());
            }
        }
        catch (SQLException e) {
            this.log(e, "Can't create a new connection for " + this.url);
            throw e;
        }
        return ccon;
    }

    protected boolean isValid(Reusable o) {
        if (o == null) {
            return false;
        }
        if (this.validator == null) {
            return true;
        }
        try {
            boolean valid = this.validator.isValid((Connection)((Object)o));
            if (!valid) {
                this.fireValidationErrorEvent();
            }
            return valid;
        }
        catch (Exception e) {
            this.log(e, "Exception during validation");
            return false;
        }
    }

    public void setValidator(ConnectionValidator cv) {
        this.validator = cv;
    }

    public ConnectionValidator getValidator() {
        return this.validator;
    }

    public void setPasswordDecoder(PasswordDecoder pd) {
        this.decoder = pd;
    }

    public PasswordDecoder getPasswordDecoder() {
        return this.decoder;
    }

    protected void destroy(Reusable o) {
        if (o == null) {
            return;
        }
        try {
            ((CacheConnection)o).release();
            this.log("Destroyed connection");
        }
        catch (SQLException e) {
            this.log(e, "Can't destroy connection");
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            Reusable o = super.checkOut();
            if (o != null) {
                CacheConnection cc = (CacheConnection)o;
                cc.setOpen();
                return cc;
            }
            return null;
        }
        catch (Exception e) {
            this.log(e, "Error getting connection");
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            for (Throwable t = e.getCause(); t != null; t = t.getCause()) {
                this.log(e, "Error getting connection");
            }
            throw new SQLException(e.getMessage());
        }
    }

    public Connection getConnection(long timeout) throws SQLException {
        try {
            Reusable o = super.checkOut(timeout);
            if (o != null) {
                CacheConnection cc = (CacheConnection)o;
                cc.setOpen();
                return cc;
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            this.log(e, "Error getting connection");
            throw new SQLException(e.getMessage());
        }
    }

    protected void freeConnection(Connection c) throws SQLException {
        if (c == null || !CacheConnection.class.isInstance(c)) {
            this.log("Attempt to return invalid item");
        } else {
            CacheConnection cc = (CacheConnection)c;
            super.checkIn((Reusable)((Object)c));
        }
    }

    public void setCaching(boolean b) {
        this.cachePS = this.cacheCS = b;
        this.cacheSS = this.cacheCS;
    }

    public void setCaching(boolean ss, boolean ps, boolean cs) {
        this.cacheSS = ss;
        this.cachePS = ps;
        this.cacheCS = cs;
    }

    public void finalize() {
        super.finalize();
        if (this.initer != null) {
            this.initer.halt();
        }
    }

    public final void addConnectionPoolListener(ConnectionPoolListener x) {
        this.listeners.add(x);
    }

    public final void removeConnectionPoolListener(ConnectionPoolListener x) {
        this.listeners.remove(x);
    }

    private final void fireValidationErrorEvent() {
        ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, 9);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ConnectionPoolListener)iter.next()).validationError(poolEvent);
        }
    }

    private final void firePoolCheckOutEvent() {
        ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, 1);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ConnectionPoolListener)iter.next()).poolCheckOut(poolEvent);
        }
    }

    private final void firePoolCheckInEvent() {
        ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, 2);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ConnectionPoolListener)iter.next()).poolCheckIn(poolEvent);
        }
    }

    private final void fireMaxPoolLimitReachedEvent() {
        ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, 3);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ConnectionPoolListener)iter.next()).maxPoolLimitReached(poolEvent);
        }
    }

    private final void fireMaxPoolLimitExceededEvent() {
        ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, 4);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ConnectionPoolListener)iter.next()).maxPoolLimitExceeded(poolEvent);
        }
    }

    private final void fireMaxSizeLimitReachedEvent() {
        ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, 5);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ConnectionPoolListener)iter.next()).maxSizeLimitReached(poolEvent);
        }
    }

    private final void fireMaxSizeLimitErrorEvent() {
        ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, 6);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ConnectionPoolListener)iter.next()).maxSizeLimitError(poolEvent);
        }
    }

    private final void fireParametersChangedEvent() {
        ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, 7);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ConnectionPoolListener)iter.next()).poolParametersChanged(poolEvent);
        }
    }

    private final void firePoolReleasedEvent() {
        ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, 8);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ConnectionPoolListener)iter.next()).poolReleased(poolEvent);
        }
    }

    private class InitThread
    extends Thread {
        private int num;
        private boolean stopped = false;

        private InitThread(int num) {
            this.num = num;
        }

        public void halt() {
            this.stopped = true;
        }

        public void run() {
            if (this.num > 0 && this.num <= ConnectionPool.this.getPoolSize() && ConnectionPool.this.getSize() < this.num) {
                ConnectionPool.this.log("Populating pool with " + this.num + " connection" + (this.num > 1 ? "s" : ""));
                ArrayList<Connection> list = new ArrayList<Connection>();
                Connection con = null;
                boolean badCon = false;
                while (!this.stopped && ConnectionPool.this.getSize() < this.num && this.num <= ConnectionPool.this.getPoolSize() && !badCon) {
                    try {
                        con = ConnectionPool.this.getConnection(3000L);
                        if (con == null) {
                            throw new SQLException();
                        }
                        list.add(con);
                        if (!ConnectionPool.this.debug) continue;
                        ConnectionPool.this.log("Created connection " + list.size() + " of " + this.num);
                    }
                    catch (SQLException sqle) {
                        ConnectionPool.this.log(sqle, "Unable to initialize database connections");
                        badCon = true;
                    }
                }
                this.num = list.size();
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    try {
                        ((Connection)iter.next()).close();
                    }
                    catch (NullPointerException npe) {
                    }
                    catch (Exception e) {
                        ConnectionPool.this.log(e, "Problem closing connection while populating pool");
                    }
                }
                if (ConnectionPool.this.debug) {
                    ConnectionPool.this.log("Populated pool with " + this.num + " connection" + (this.num > 1 ? "s" : ""));
                }
            }
            ConnectionPool.this.initer = null;
        }
    }

    static class DefaultValidator
    implements ConnectionValidator {
        DefaultValidator() {
        }

        public boolean isValid(Connection con) {
            try {
                return !con.isClosed();
            }
            catch (SQLException e) {
                return false;
            }
        }
    }

    private final class EventRelay
    extends ObjectPoolEventAdapter {
        private EventRelay() {
        }

        public void poolCheckOut(ObjectPoolEvent evt) {
            ConnectionPool.this.firePoolCheckOutEvent();
        }

        public void poolCheckIn(ObjectPoolEvent evt) {
            ConnectionPool.this.firePoolCheckInEvent();
        }

        public void maxPoolLimitReached(ObjectPoolEvent evt) {
            ConnectionPool.this.fireMaxPoolLimitReachedEvent();
        }

        public void maxPoolLimitExceeded(ObjectPoolEvent evt) {
            ConnectionPool.this.fireMaxPoolLimitExceededEvent();
        }

        public void maxSizeLimitReached(ObjectPoolEvent evt) {
            ConnectionPool.this.fireMaxSizeLimitReachedEvent();
        }

        public void maxSizeLimitError(ObjectPoolEvent evt) {
            ConnectionPool.this.fireMaxSizeLimitErrorEvent();
        }

        public void poolParametersChanged(ObjectPoolEvent evt) {
            ConnectionPool.this.fireParametersChangedEvent();
        }

        public void poolReleased(ObjectPoolEvent evt) {
            ConnectionPool.this.firePoolReleasedEvent();
            ConnectionPool.this.listeners.clear();
        }
    }
}

