/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import snaq.db.StatementListener;
import snaq.util.Reusable;

public class CachedStatement
implements Statement,
Reusable {
    protected StatementListener listener;
    protected Statement st;
    protected boolean open = true;

    public CachedStatement(Statement st) {
        this.st = st;
    }

    public void recycle() throws SQLException {
        ResultSet rs = this.st.getResultSet();
        if (rs != null) {
            rs.close();
        }
        try {
            this.st.clearWarnings();
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        try {
            this.st.clearBatch();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void close() throws SQLException {
        if (!this.open) {
            return;
        }
        this.open = false;
        if (this.listener != null) {
            this.listener.statementClosed(this);
        }
    }

    public void release() throws SQLException {
        this.st.close();
    }

    void setOpen() {
        this.open = true;
    }

    void setStatementListener(StatementListener x) {
        this.listener = x;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return this.st.executeQuery(sql);
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.st.executeUpdate(sql);
    }

    public int getMaxFieldSize() throws SQLException {
        return this.st.getMaxFieldSize();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.st.setMaxFieldSize(max);
    }

    public int getMaxRows() throws SQLException {
        return this.st.getMaxRows();
    }

    public void setMaxRows(int max) throws SQLException {
        this.st.setMaxRows(max);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.st.setEscapeProcessing(enable);
    }

    public int getQueryTimeout() throws SQLException {
        return this.st.getQueryTimeout();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.st.setQueryTimeout(seconds);
    }

    public void cancel() throws SQLException {
        this.st.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.st.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.st.clearWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.st.setCursorName(name);
    }

    public boolean execute(String sql) throws SQLException {
        return this.st.execute(sql);
    }

    public ResultSet getResultSet() throws SQLException {
        return this.st.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        return this.st.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.st.getMoreResults();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.st.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        return this.st.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.st.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        return this.st.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.st.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.st.getResultSetType();
    }

    public void addBatch(String sql) throws SQLException {
        this.st.addBatch(sql);
    }

    public void clearBatch() throws SQLException {
        this.st.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        return this.st.executeBatch();
    }

    public Connection getConnection() throws SQLException {
        return this.st.getConnection();
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.st.getMoreResults(current);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.st.getGeneratedKeys();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.st.executeUpdate(sql, autoGeneratedKeys);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.st.executeUpdate(sql, columnIndexes);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.st.executeUpdate(sql, columnNames);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.st.execute(sql, autoGeneratedKeys);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.st.execute(sql, columnIndexes);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.st.execute(sql, columnNames);
    }

    public int getResultSetHoldability() throws SQLException {
        return this.st.getResultSetHoldability();
    }
}

