/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import snaq.db.CachedCallableStatement;
import snaq.db.CachedPreparedStatement;
import snaq.db.CachedStatement;
import snaq.db.ConnectionPool;
import snaq.db.StatementListener;
import snaq.util.Reusable;

public final class CacheConnection
implements Connection,
StatementListener,
Reusable {
    protected ConnectionPool pool;
    protected Connection con;
    protected ArrayList ss;
    protected ArrayList ssUsed;
    protected HashMap ps;
    protected HashMap psUsed;
    protected HashMap cs;
    protected HashMap csUsed;
    private boolean cacheS;
    private boolean cacheP;
    private boolean cacheC;
    private int ssReq;
    private int ssHit;
    private int psReq;
    private int psHit;
    private int csReq;
    private int csHit;
    private boolean open = true;

    public CacheConnection(ConnectionPool pool, Connection con) {
        this.pool = pool;
        this.con = con;
        this.setCacheAll(true);
        this.csHit = 0;
        this.csReq = 0;
        this.psHit = 0;
        this.psReq = 0;
        this.ssHit = 0;
        this.ssReq = 0;
    }

    void setOpen() {
        this.open = true;
    }

    boolean isOpen() {
        return this.open;
    }

    public void setCacheStatements(boolean cache) {
        this.cacheS = cache;
        if (this.ss == null) {
            this.ss = new ArrayList();
            this.ssUsed = new ArrayList();
        }
    }

    public void setCachePreparedStatements(boolean cache) {
        this.cacheP = cache;
        if (this.ps == null) {
            this.ps = new HashMap();
            this.psUsed = new HashMap();
        }
    }

    public void setCacheCallableStatements(boolean cache) {
        this.cacheC = cache;
        if (this.cs == null) {
            this.cs = new HashMap();
            this.csUsed = new HashMap();
        }
    }

    public void setCacheAll(boolean cache) {
        this.setCacheStatements(cache);
        this.setCachePreparedStatements(cache);
        this.setCacheCallableStatements(cache);
    }

    public Connection getRawConnection() {
        return this.con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement createStatement() throws SQLException {
        if (!this.cacheS) {
            return this.con.createStatement();
        }
        CachedStatement cs = null;
        ArrayList arrayList = this.ss;
        synchronized (arrayList) {
            ++this.ssReq;
            if (!this.ss.isEmpty()) {
                cs = (CachedStatement)this.ss.remove(0);
                cs.setOpen();
                ++this.ssHit;
                if (this.pool.isDebug()) {
                    this.pool.log("Statement cache hit - " + this.calcHitRate(this.ssHit, this.ssReq));
                }
            } else {
                cs = new CachedStatement(this.con.createStatement());
                cs.setStatementListener(this);
                cs.setOpen();
                if (this.pool.isDebug()) {
                    this.pool.log("Statement cache miss - " + this.calcHitRate(this.ssHit, this.ssReq));
                }
            }
        }
        this.ssUsed.add(cs);
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (!this.cacheP) {
            return this.con.prepareStatement(sql);
        }
        HashMap hashMap = this.ps;
        synchronized (hashMap) {
            Object o = this.ps.get(sql);
            ++this.psReq;
            if (o != null) {
                this.ps.remove(sql);
                CachedPreparedStatement cps = (CachedPreparedStatement)o;
                cps.setOpen();
                this.psUsed.put(sql, cps);
                ++this.psHit;
                if (this.pool.isDebug()) {
                    this.pool.log("PreparedStatement cache hit [" + sql + "] - " + this.calcHitRate(this.psHit, this.psReq));
                }
                return cps;
            }
            CachedPreparedStatement cps = new CachedPreparedStatement(sql, this.con.prepareStatement(sql));
            cps.setStatementListener(this);
            cps.setOpen();
            this.ps.put(sql, cps);
            if (this.pool.isDebug()) {
                this.pool.log("PreparedStatement cache miss [" + sql + "] - " + this.calcHitRate(this.psHit, this.psReq));
            }
            return cps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallableStatement prepareCall(String sql) throws SQLException {
        if (!this.cacheC) {
            return this.con.prepareCall(sql);
        }
        HashMap hashMap = this.cs;
        synchronized (hashMap) {
            Object o = this.cs.get(sql);
            ++this.csReq;
            if (o != null) {
                this.cs.remove(sql);
                CachedCallableStatement ccs = (CachedCallableStatement)o;
                ccs.setOpen();
                this.csUsed.put(sql, ccs);
                ++this.csHit;
                if (this.pool.isDebug()) {
                    this.pool.log("CallableStatement cache hit [" + sql + "] - " + this.calcHitRate(this.csHit, this.csReq));
                }
                return ccs;
            }
            CallableStatement st = this.con.prepareCall(sql);
            CachedCallableStatement ccs = new CachedCallableStatement(sql, st);
            ccs.setStatementListener(this);
            ccs.setOpen();
            this.cs.put(sql, ccs);
            if (this.pool.isDebug()) {
                this.pool.log("CallableStatement cache miss [" + sql + "] - " + this.calcHitRate(this.csHit, this.csReq));
            }
            return ccs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statementClosed(CachedStatement s) throws SQLException {
        if (s instanceof PreparedStatement) {
            HashMap hashMap = this.ps;
            synchronized (hashMap) {
                String key = ((CachedPreparedStatement)s).getQueryString();
                this.psUsed.remove(key);
                if (!this.cacheP) {
                    s.release();
                } else {
                    try {
                        s.recycle();
                        this.ps.put(key, s);
                    }
                    catch (SQLException sqle) {
                        s.release();
                    }
                }
            }
        }
        if (s instanceof CallableStatement) {
            HashMap hashMap = this.cs;
            synchronized (hashMap) {
                String key = ((CachedCallableStatement)s).getQueryString();
                this.csUsed.remove(key);
                if (!this.cacheC) {
                    s.release();
                } else {
                    try {
                        s.recycle();
                        this.cs.put(key, s);
                    }
                    catch (SQLException sqle) {
                        s.release();
                    }
                }
            }
        }
        ArrayList arrayList = this.ss;
        synchronized (arrayList) {
            this.ssUsed.remove(s);
            if (!this.cacheS) {
                s.release();
            } else {
                try {
                    s.recycle();
                    this.ss.add(s);
                }
                catch (SQLException sqle) {
                    s.release();
                }
            }
        }
    }

    private String calcHitRate(int hits, int reqs) {
        return reqs == 0 ? "" : (float)hits / (float)reqs * 100.0f + "% hit rate";
    }

    public String nativeSQL(String sql) throws SQLException {
        return this.con.nativeSQL(sql);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.con.setAutoCommit(autoCommit);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.con.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.con.commit();
    }

    public void rollback() throws SQLException {
        this.con.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() throws SQLException {
        Iterator<Object> iter;
        Cloneable cloneable;
        int count;
        if (this.cacheS) {
            int n = count = this.ss != null ? this.ssUsed.size() : 0;
            if (count > 0) {
                if (this.pool.isDebug()) {
                    this.pool.log("Cleaning " + count + " cached Statement" + (count > 1 ? "s" : ""));
                }
                cloneable = this.ss;
                synchronized (cloneable) {
                    iter = this.ss.iterator();
                    while (iter.hasNext()) {
                        ((Statement)iter.next()).close();
                    }
                }
            }
        } else {
            this.flushStatements();
        }
        if (this.cacheP) {
            int n = count = this.ps != null ? this.psUsed.size() : 0;
            if (count > 0) {
                if (this.pool.isDebug()) {
                    this.pool.log("Cleaning " + count + " cached PreparedStatement" + (count > 1 ? "s" : ""));
                }
                cloneable = this.ps;
                synchronized (cloneable) {
                    iter = this.ps.values().iterator();
                    while (iter.hasNext()) {
                        ((CachedPreparedStatement)iter.next()).close();
                    }
                }
            }
        } else {
            this.flushPreparedStatements();
        }
        if (this.cacheC) {
            int n = count = this.cs != null ? this.csUsed.size() : 0;
            if (count > 0) {
                if (this.pool.isDebug()) {
                    this.pool.log("Cleaning " + count + " cached CallableStatement" + (count > 1 ? "s" : ""));
                }
                cloneable = this.cs;
                synchronized (cloneable) {
                    iter = this.cs.values().iterator();
                    while (iter.hasNext()) {
                        ((CachedCallableStatement)iter.next()).close();
                    }
                }
            }
        } else {
            this.flushCallableStatements();
        }
        if (!this.getAutoCommit()) {
            try {
                this.rollback();
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
            }
            this.setAutoCommit(true);
        }
        this.clearWarnings();
    }

    public void close() throws SQLException {
        if (!this.open) {
            throw new SQLException("Connection already closed");
        }
        this.open = false;
        this.pool.freeConnection(this);
    }

    protected void flushStatements() throws SQLException {
        int count;
        int n = count = this.ss != null ? this.ss.size() : 0;
        if (count > 0) {
            if (this.pool.isDebug()) {
                this.pool.log("Closing " + count + " cached Statement" + (count > 1 ? "s" : ""));
            }
            Iterator iter = this.ss.iterator();
            while (iter.hasNext()) {
                ((CachedStatement)iter.next()).release();
            }
            this.ss.clear();
        }
    }

    protected void flushPreparedStatements() throws SQLException {
        int count;
        int n = count = this.ps != null ? this.ps.size() : 0;
        if (count > 0) {
            if (this.pool.isDebug()) {
                this.pool.log("Closing " + count + " cached PreparedStatement" + (count > 1 ? "s" : ""));
            }
            Iterator iter = this.ps.values().iterator();
            while (iter.hasNext()) {
                ((CachedPreparedStatement)iter.next()).release();
            }
            this.ps.clear();
        }
    }

    protected void flushCallableStatements() throws SQLException {
        int count;
        int n = count = this.cs != null ? this.cs.size() : 0;
        if (count > 0) {
            if (this.pool.isDebug()) {
                this.pool.log("Closing " + count + " cached CallableStatement" + (count > 1 ? "s" : ""));
            }
            Iterator iter = this.cs.values().iterator();
            while (iter.hasNext()) {
                ((CachedCallableStatement)iter.next()).release();
            }
            this.cs.clear();
        }
    }

    public void release() throws SQLException {
        this.open = false;
        ArrayList<SQLException> list = new ArrayList<SQLException>();
        try {
            this.flushStatements();
        }
        catch (SQLException e) {
            list.add(e);
        }
        try {
            this.flushPreparedStatements();
        }
        catch (SQLException e) {
            list.add(e);
        }
        try {
            this.flushCallableStatements();
        }
        catch (SQLException e) {
            list.add(e);
        }
        try {
            this.con.close();
        }
        catch (SQLException e) {
            list.add(e);
        }
        if (!list.isEmpty()) {
            SQLException sqle = new SQLException("Problem releasing connection resources");
            sqle.setNextException((SQLException)list.get(0));
            throw sqle;
        }
    }

    public boolean isClosed() throws SQLException {
        return this.con.isClosed();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.con.getMetaData();
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.con.setReadOnly(readOnly);
    }

    public boolean isReadOnly() throws SQLException {
        return this.con.isReadOnly();
    }

    public void setCatalog(String catalog) throws SQLException {
        this.con.setCatalog(catalog);
    }

    public String getCatalog() throws SQLException {
        return this.con.getCatalog();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.con.setTransactionIsolation(level);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.con.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.con.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.con.clearWarnings();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.con.createStatement(resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public Map getTypeMap() throws SQLException {
        return this.con.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.con.setTypeMap(map);
    }

    public void setHoldability(int holdability) throws SQLException {
        this.con.setHoldability(holdability);
    }

    public int getHoldability() throws SQLException {
        return this.con.getHoldability();
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.con.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return this.con.setSavepoint(name);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.con.rollback(savepoint);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.con.releaseSavepoint(savepoint);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.con.prepareStatement(sql, autoGeneratedKeys);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.con.prepareStatement(sql, columnIndexes);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.con.prepareStatement(sql, columnNames);
    }
}

