/* This notice must be untouched at all times.

wz_dragdrop.js	v. 4.12
The latest version is available at
http://www.walterzorn.com
or http://www.devira.com
or http://www.walterzorn.de

Copyright (c) 2002-2003 Walter Zorn. All rights reserved.
Created 26. 8. 2002 by Walter Zorn <walter@kreuzotter.de>
Last modified: 21. 3. 2003

This Drag & Drop Library adds Drag & drop functionality
to the following types of html-elements,
provided their names/IDs are passed to SET_DRAGGABLE():
- images, even if not positioned via layers,
  nor via stylesheets or any other kind of "hard-coding"
- relatively and absolutely positioned layers (DIV elements).

This program is free software;
you can redistribute it and/or modify it under the terms of the
GNU General Public License as published by the Free Software Foundation;
either version 2 of the License, or (at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License
at http://www.gnu.org/copyleft/gpl.html for more details.
*/


// PATH TO THE TRANSPARENT 1*1 PX IMAGE (required by NS 4 as spacer)
var spacer = 'transparentpixel.gif';








function ERR(d_e)
{
	return true;
}
//window.onerror = ERR;








// Optional commands on the html-page (g: may be used globally, i: may be used individually)
var CLONE            = 'C10nE';        // i  img      clone image
var DETACH_CHILDREN  = 'd37aCH';       // i  lyr      detach images
var HORIZONTAL       = 'H0r1Z';        // i  img,lyr  only horizontally draggable
var NO_ALT           = 'no81T';        // gi img      disable alt and title attributes
var NOALT            = NO_ALT;
var NO_SCROLL        = 'nAU7O5cR';     // gi img,lyr  disable auto scroll functionality
var NOSCROLL         = NO_SCROLL;
var NO_DRAG          = 'N0d4Ag';       // i  img,lyr  disable draggability
var NODRAG           = NO_DRAG;
var KEYDOWN_RESIZE   = 'mSre5Z';       // gi img,lyr  resizable if <ctrl> or <shift> pressed
var RESET_Z          = 'r35E7z';       // gi img,lyr  reset z-index when dropped
var VERTICAL         = 'V3Rt1C';       // i  img,lyr  only vertically draggable

var MULTIPLY         = 'MUl71';        // i  img      create copies
for (var dd_i = 0; dd_i <  0x97; dd_i++)
	eval('var MULTIPLY' + dd_i + ' = "' + MULTIPLY + '' + dd_i + '";');


var dd_cursors = new Array(
	'c:move',
	'c:crosshair',
	'c:pointer',
	'c:wait',
	'c:help',
	'c:n-resize',
	'c:ne-resize',
	'c:e-resize',
	'c:se-resize',
	'c:s-resize',
	'c:sw-resize',
	'c:w-resize',
	'c:nw-resize'
);
for (dd_i = 0; dd_i < dd_cursors.length; dd_i++)
	eval('var CURSOR_' + (dd_cursors[dd_i].substring(2).toUpperCase().replace('-', '_')) + ' = "' + dd_cursors[dd_i] + '";');








function DDClass()
{
	var d_n = navigator.userAgent.toLowerCase(), d_i;

	this.db = (document.compatMode && document.compatMode.toLowerCase() != "backcompat")?
		document.documentElement
		: (document.body || null);
	this.op = (window.opera && document.getElementById);
	this.op6 = (this.op && !(this.db && this.db.innerHTML));
	if (this.op && !this.op6) document.onmousedown = new Function('e',
		'if (((e = e || window.event).target || e.srcElement).tagName == "IMAGE") return false;'
	);
	this.ie = d_n.indexOf("msie") != -1 && document.all && this.db && !this.op;
	this.iemac = this.ie && d_n.indexOf("mac")!=-1;
	this.ie4 = this.ie && !document.getElementById;
	this.n4 = (document.layers && typeof document.classes != "undefined");
	this.kq = (d_i = d_n.indexOf("konqueror")) > -1 && parseInt(d_n.substring(d_i+0x0a)) > 0x02;
		this.kq_new = this.kq && d_n.substring(d_i+0x0a, d_i+0x0d) != "3.0";
	this.n6 = !this.op && !this.kq && !this.ie && document.defaultView && typeof document.defaultView.getComputedStyle != "undefined";
	this.n7 = this.n6 && parseInt(d_n.substring((d_i = d_n.indexOf('gecko'))+6, d_i+0x0c)) > 200209;
	this.ce = document.captureEvents && document.releaseEvents;
	this.px = (this.n4 || this.op6)? '' : 'px';
	this.elements = new Array();
}
var dd = new DDClass();




dd.Int = function(d_x, d_y)
{
	return isNaN(d_y = parseInt(d_x))? 0 : d_y;
}




dd.getWndW = function()
{
	return dd.Int(
		(dd.db && dd.db.clientWidth)? dd.db.clientWidth
		: (window.innerWidth || document.getElementsByTagName('body')[0].offsetWidth || 770)
	);
}




dd.getWndH = function()
{
	return dd.Int(
		(dd.db && dd.db.clientHeight)? dd.db.clientHeight
		: (window.innerHeight || document.getElementsByTagName('body')[0].offsetHeight || 500)
	);
}




dd.getScrollX = function()
{
	return dd.Int(
		(dd.db && dd.db.scrollLeft)? dd.db.scrollLeft
		: (window.pageXOffset || 0)
	);
}




dd.getScrollY = function()
{
	return dd.Int(
		(dd.db && dd.db.scrollTop)? dd.db.scrollTop
		: (window.pageYOffset  || 0)
	);
}




dd.getPageX = function(d_o)
{
	if (dd.n4) return dd.Int(d_o.pageX);
	var d_y = 0;
	while (d_o)
	{
		d_y += dd.Int(d_o.offsetLeft);
		d_o = d_o.offsetParent;
	}
	if (dd.iemac) d_y += dd.Int(dd.db.currentStyle.marginLeft) + dd.Int(dd.db.currentStyle.paddingLeft);
	return d_y;
}




dd.getPageY = function(d_o)
{
	if (dd.n4) return dd.Int(d_o.pageY);
	var d_y = 0;
	while (d_o)
	{
		d_y += dd.Int(d_o.offsetTop);
		d_o = d_o.offsetParent;
	}
	if (dd.iemac) d_y += dd.Int(dd.db.currentStyle.marginTop) + dd.Int(dd.db.currentStyle.paddingTop);
	return d_y;
}




dd.getCssX = function(d_o)
{
	if (dd.n4) return d_o.div.x;
	if (dd.ie4) return d_o.css.pixelLeft;
	d_o.css.left = 0 + dd.px;
	var d_y = d_o.x - dd.getPageX(d_o.div);
	d_o.css.left = d_y + dd.px;
	return d_y;
}




dd.getCssY = function(d_o)
{
	if (dd.n4) return d_o.div.y;
	if (dd.ie4) return d_o.css.pixelTop;
	d_o.css.top = 0 + dd.px;
	var d_y = d_o.y - dd.getPageY(d_o.div);
	d_o.css.top = d_y + dd.px;
	return d_y;
}




dd.getImgW = function(d_o)
{
	return dd.Int(
		d_o.width ||
		(dd.n6? document.defaultView.getComputedStyle(d_o, "").getPropertyValue("width") : 0)
	);
}




dd.getImgH = function(d_o)
{
	return dd.Int(
		d_o.height ||
		(dd.n6? document.defaultView.getComputedStyle(d_o, "").getPropertyValue("height") : 0)
	);
}



dd.getDivW = function(d_o)
{
	return dd.Int(
		dd.n4? (d_o.div.clip? d_o.div.clip.width : 0)
		: d_o.css.pixelWidth? d_o.css.pixelWidth
		: (d_o.div.offsetWidth || 0)
	);
}




dd.getDivH = function(d_o)
{
	return dd.Int(
		dd.n4? (d_o.div.clip? d_o.div.clip.height : 0)
		: d_o.css.pixelHeight? d_o.css.pixelHeight
		: (d_o.div.offsetHeight || 0)
	);
}




dd.getWH = function(d_o)
{
	d_o.w = dd.getDivW(d_o);
	d_o.h = dd.getDivH(d_o);

	if (d_o.css)
	{
		d_o.css.width = d_o.w + dd.px;
		d_o.dw = dd.getDivW(d_o)-d_o.w;
		d_o.css.width = (d_o.w-d_o.dw) + dd.px;

		d_o.css.height = d_o.h + dd.px;
		d_o.dh = dd.getDivH(d_o)-d_o.h;
		d_o.css.height = (d_o.h-d_o.dh) + dd.px;
	}
	else d_o.dw = d_o.dh = 0;
}




dd.getDiv = function(d_x)
{
	if (dd.n4) return document[d_x] || null;
	if (dd.ie) return document.all[d_x] || null;
	else return document.getElementById(d_x) || null;
}




dd.getChildren = function(d_o)
{
	d_o.children = new Array();
	for (var d_i = 0; d_i < dd.elements.length; d_i++)
	{
		var d_p = dd.elements[d_i].oimg;
		if (d_p)
		{
			if (dd.n4)
			{
				if (d_o.div.document)
				{
					for (var d_j = 0; d_j < d_o.div.document.images.length; d_j++)
					{
						if (d_o.div.document.images[d_j] == d_p)
						{
							if (d_o.detach) dd.elements[d_i].detached = true;
							else d_o.addChild(dd.elements[d_i]);
							break;
						}
					}
				}
			}
			else while (d_p.parentNode || d_p.offsetParent)
			{
				if ((d_p.parentNode || d_p.offsetParent) == d_o.div)
				{
					if (d_o.detach) dd.elements[d_i].detached = true;
					else d_o.addChild(dd.elements[d_i]);
					break;
				}
				d_p = d_p.parentNode || d_p.offsetParent || null;
			}
		}
	}
}




dd.addProps = function(d_o)
{
	if (!d_o.oimg)
	{
		if (document.defaultView && typeof document.defaultView.getComputedStyle != "undefined")
			d_o.defz = dd.Int(document.defaultView.getComputedStyle(d_o.div, '').getPropertyValue('z-index'));
		else if (d_o.div.currentStyle) d_o.defz = dd.Int(d_o.div.currentStyle.zIndex);
		else d_o.defz = dd.Int((d_o.css || d_o.div).zIndex);
		d_o.setZ(d_o.defz, true);
	}
	d_o.keydown_resize = d_o.keydown_resize || dd.keydown_resize;
	d_o.cursor = d_o.nodrag? 'auto' : (dd.cursor || 'auto');
	if (d_o.css) d_o.css.cursor = d_o.cursor;
	d_o.visible = true;
}




dd.setEvtHdl = function()
{
	if (dd.op6) WINSZ(0x02);
	if (dd.kq) setTimeout("dd.recalc(true)", 0x32);
	else if (dd.n6 || dd.ie || dd.op && !dd.op6) dd.recalc(true);
	if (dd.loadFunc) dd.loadFunc();
	dd.downFunc = document.onmousedown || null;
	if (dd.ce) document.captureEvents(Event.MOUSEDOWN);
	document.onmousedown = PICK;
}




dd.evt = function(d_e)
{
	this.button = ((d_e =  d_e || window.event).type == 'mousedown')? (d_e.which || d_e.button || 0)
		: (dd.e && dd.e.button)? dd.e.button
		: 0;
	this.type = d_e.type;
	this.src = d_e.target || d_e.srcElement;
	this.x = dd.Int(d_e.pageX || d_e.clientX || 0);
	this.y = dd.Int(d_e.pageY || d_e.clientY || 0);
	if (dd.ie || dd.kq_new)
	{
		this.x += dd.getScrollX();
		this.y += dd.getScrollY();
	}
	this.shiftKey = d_e.modifiers? (d_e.modifiers & Event.SHIFT_MASK || d_e.modifiers & Event.CONTROL_MASK)
		: (d_e.shiftKey || d_e.ctrlKey || false);
}




// re-integrate items after page reflow
dd.recalc = function(d_x)
{
	var d_o, d_i = 0;
	while (d_i < dd.elements.length)
	{
		if ((d_o = dd.elements[d_i++]).oimg)
		{
			var d_defx = d_o.defx, d_defy = d_o.defy;
			d_o.getImg(d_o.oimg.name);
			if (dd.n6 && d_x) d_o.resizeTo(d_o.defw = dd.getImgW(d_o.oimg), d_o.defh = dd.getImgH(d_o.oimg));
			if ((d_x || !d_o.detached) && Math.abs(d_o.x-d_defx) <= 0x0a && Math.abs(d_o.y-d_defy) <= 0x0a)
			{
				d_o.moveTo(d_o.defx, d_o.defy);
			}
			else
			{
				if (d_o.horizontal) d_o.moveTo(d_o.x, d_o.defy);
				if (d_o.vertical) d_o.moveTo(d_o.defx, d_o.y);
			}
		}
		else
		{
			dd.getWH(d_o);
			if (d_o.div.pos_rel)
			{
				if (dd.kq)
				{
					var d_mx = d_o.defx-d_o.x,
					d_my = d_o.defy-d_o.y;
					d_o.moveBy(d_mx, d_my);
				}
				var d_dx = dd.getPageX(d_o.div) - (dd.kq? d_o.defx : d_o.x);
				var d_dy = dd.getPageY(d_o.div) - (dd.kq? d_o.defy : d_o.y);
				d_o.defx += d_dx;
				d_o.x += d_dx;
				d_o.defy += d_dy;
				d_o.y += d_dy;
				if (dd.kq) d_o.moveBy(-d_mx, -d_my);
			}
		}
	}
}




dd.n4RectVis = function(vis)
{
	for (var d_i = 0; !(d_i&0x04); d_i++)
	{
		dd.rectI[d_i].visibility = dd.rectA[d_i].visibility = vis? 'show' : 'hide';
		if (vis) dd.rectI[d_i].zIndex = dd.rectA[d_i].zIndex = dd.obj.z + 1;
	}
}




dd.n4RectPos = function(d_o, d_x, d_y, d_w, d_h)
{
	d_o.x = d_x;
	d_o.y = d_y;
	d_o.clip.width = d_w;
	d_o.clip.height = d_h;
}



// NN4: draw img resize rectangle
dd.n4Rect = function(d_dx, d_dy)
{
	if (!dd.rectI)
	{
		dd.rectI = new Array();
		dd.rectA = new Array();
	}
	if (!dd.rectI[0])
	{
		for (var d_i = 0; !(d_i&0x04); d_i++)
		{
			dd.rectI[d_i] = new Layer(1);
			dd.rectA[d_i] = new Layer(1);
			dd.rectI[d_i].bgColor = '#000000';
			dd.rectA[d_i].bgColor = '#ffffff';
		}
	}
	if (!dd.rectI[0].visibility || dd.rectI[0].visibility == 'hide') dd.n4RectVis(true);
	dd.n4RectPos(dd.rectI[0], dd.obj.x-1, dd.obj.y-1, (dd.obj.w = Math.max(dd.obj.w + d_dx, 1))+0x02, 1);
	dd.n4RectPos(dd.rectA[0], dd.obj.x-0x02, dd.obj.y-0x02, dd.obj.w+0x04, 1);
	dd.n4RectPos(dd.rectI[1], dd.obj.x + dd.obj.w, dd.obj.y-1, 1, (dd.obj.h = Math.max(dd.obj.h + d_dy, 1))+0x02);
	dd.n4RectPos(dd.rectA[1], dd.rectI[1].x+1, dd.obj.y-0x02, 1, dd.obj.h+0x04);
	dd.n4RectPos(dd.rectI[2], dd.obj.x-1, dd.obj.y + dd.obj.h, dd.obj.w+0x02, 1);
	dd.n4RectPos(dd.rectA[2], dd.obj.x-0x02, dd.rectI[2].y+1, dd.obj.w+0x04, 1);
	dd.n4RectPos(dd.rectI[3], dd.obj.x-1, dd.obj.y-1, 1, dd.obj.h+0x02);
	dd.n4RectPos(dd.rectA[3], dd.obj.x-0x02, dd.obj.y-0x02, 1, dd.obj.h+0x04);
}




dd.resizeBy = function(d_dx, d_dy)
{
	if (dd.n4 && dd.obj.oimg) dd.n4Rect(d_dx, d_dy);
	else dd.obj.resizeBy(d_dx, d_dy);
}







function DDObj(d_o, d_i)
{
	this.id = d_o;
	this.clone = this.getCmd(CLONE);
	this.detach = this.getCmd(DETACH_CHILDREN);
	this.horizontal = this.getCmd(HORIZONTAL);
	this.noalt = this.getCmd(NOALT);
	this.nodrag = this.getCmd(NODRAG);
	this.noscroll = this.getCmd(NO_SCROLL);
	this.keydown_resize = this.getCmd(KEYDOWN_RESIZE);
	this.re_z = this.getCmd(RESET_Z);
	this.vertical = this.getCmd(VERTICAL);
	this.multi = (d_o.indexOf(MULTIPLY) > -1)? dd.Int(d_o.substring(d_o.indexOf(MULTIPLY)+MULTIPLY.length)) : 0;
	this.getCmd(MULTIPLY);

	this.name = this.id + (d_i || '');
	this.oimg = this.getImg(this.id);


	if (this.oimg)
	{
		this.id += 'div' + (d_i || '');
		this.w = dd.getImgW(this.oimg);
		this.h = dd.getImgH(this.oimg);
		this.dw = this.dh = 0;
		(this.cach = new Image()).src = this.defsrc = this.oimg.src;
		this.htm = '<div id="' + this.id +
			'" style="position:absolute;'+
			'left:' + (this.cssx = this.x = this.defx) + 'px;'+
			'top:' + (this.cssy = this.y = this.defy) + 'px;'+
			'width:' + this.w + 'px;'+
			'height:' + this.h + 'px;">'+
			'<img name="' + (this.id+'img') + '"'+
			' src="' + this.oimg.src + '" '+
			'width="' + this.w + '" height="' + this.h + '"><\/div>';
	}
	else if (!!(this.div = dd.getDiv(this.id)))
	{
		if (this.div.style)	this.css = this.div.style;
		dd.getWH(this);
		this.div.pos_rel = ((this.div.parentNode? this.div.parentNode.tagName : this.div.parentElement? this.div.parentElement.tagName : '').toString().toLowerCase().indexOf('body') == -1)
		this.defx = this.x = dd.getPageX(this.div);
		this.defy = this.y = dd.getPageY(this.div);
		this.cssx = dd.getCssX(this);
		this.cssy = dd.getCssY(this);
	}


	this.defw = this.w;
	this.defh = this.h;
}




DDObj.prototype.moveBy = function(d_x, d_y, d_o)
{
	if (this.div)
	{
		(d_o = this.css || this.div).left = (this.cssx += d_x) + dd.px;
		d_o.top = (this.cssy += d_y) + dd.px;
		this.x += d_x;
		this.y += d_y;
		if (this.children)
		{
			for (var d_i = 0; d_i < this.children.length; d_i++)
			{
				(d_o = this.children[d_i]).moveBy(d_x, d_y);
				d_o.defx += d_x;
				d_o.defy += d_y;
			}
		}
		
	}
}




DDObj.prototype.moveTo = function(d_x, d_y)
{
	this.moveBy(dd.Int(d_x)-this.x, dd.Int(d_y)-this.y);
}




DDObj.prototype.setZ = function(d_x, d_ddz)
{
	(this.css || this.div).zIndex = this.z = d_x;
	if (d_ddz) dd.z = Math.max(dd.z, d_x);
}




DDObj.prototype.hide = function()
{
	if (!this.div) return;
	(this.css || this.div).visibility = "hidden";
	this.visible = false;
	if (dd.obj && dd.obj == this) DROP();
	if (this.children)
		for (var d_i = 0; d_i < this.children.length; d_i++)
			this.children[d_i].hide();
}




DDObj.prototype.show = function()
{
	if (!this.div) return;
	(this.css ||  this.div).visibility = "visible";
	this.visible = true;
	if (this.children)
		for (var d_i = 0; d_i < this.children.length; d_i++)
			this.children[d_i].show();
}




DDObj.prototype.resizeTo = function(d_w, d_h, d_o)
{
	if (!this.div) return;
	d_w = (((d_w = dd.Int(d_w)) > 0)? d_w : 1) - this.dw;
	d_h = (((d_h = dd.Int(d_h)) > 0)? d_h : 1) - this.dh;
	if (dd.n4)
	{
		this.div.resizeTo(d_w, d_h);
		if (this.oimg)
		{
			(d_o = this.div.document).open();
			d_o.write('<img src="' + this.cach.src + '" width="' + d_w + '" height="' + d_h + '">');
			d_o.close();
			(this.nimg = d_o.images[0]).src = this.cach.src;
		}
	}
	else if (typeof this.css.pixelWidth != "undefined")
	{
		this.css.pixelWidth = d_w;
		this.css.pixelHeight = d_h;
		if (this.oimg)
		{
			(d_o = this.nimg.style).pixelWidth = d_w;
			d_o.pixelHeight = d_h;
		}
	}
	else
	{
		this.css.width = d_w + dd.px;
		this.css.height = d_h + dd.px;
		if (this.oimg)
		{
			(d_o = this.nimg).width = d_w;
			d_o.height = d_h;
			if (!d_o.complete) d_o.src = this.cach.src;
		}
	}
	if (this.css) this.css.overflow = this.css.overflow || "hidden";
	if (this.div.pos_rel) this.div.resized = true;
	dd.getWH(this);
}




DDObj.prototype.resizeBy = function(d_dw, d_dh)
{
	this.resizeTo(this.w+d_dw, this.h+d_dh);
}




DDObj.prototype.swapImage = function(d_x, d_cp)
{
	if (!(this.oimg && this.div)) return;
	if (this.cach.src != d_x) (this.cach = new Image()).src = d_x;
	this.nimg.src = this.cach.src;
	if (d_cp && this.copies)
		for (var d_i = 0; d_i < this.copies.length; d_i++)
			this.copies[d_i].swapImage(d_x);
}




DDObj.prototype.activate = function()
{
	var d_o, d_dz = dd.z-this.z;
	if (this.children)
		for (var d_i = 0; d_i < this.children.length; d_i++)
			(d_o = this.children[d_i]).setZ(d_o.z+d_dz+1, true);
	this.setZ(this.z+d_dz+1, true);
}




DDObj.prototype.deactivate = function(d_o)
{
	if (this.re_z || dd.re_z)
	{
		this.setZ(this.defz, true);
		if (this.children)
			for (var d_i = 0; d_i < this.children.length; d_i++)
				(d_o = this.children[d_i]).setZ(d_o.defz, true);
	}
}




DDObj.prototype.getCmd = function(d_cmd)
{
	var d_i = this.id.indexOf(d_cmd),
	d_y = (d_i > -1);
	if (d_y) this.id = this.id.substring(0, d_i) + ((d_cmd==MULTIPLY)? "" : this.id.substring(d_i+d_cmd.length));
	return d_y;
}




DDObj.prototype.getImg = function(d_o, d_d)
{
	this.defx = 0;
	this.defy = 0;
	d_d = d_d || window.document;
	if (dd.n4)
	{
		if (d_d.images[d_o])
		{
			this.defx += d_d.images[d_o].x;
			this.defy += d_d.images[d_o].y;
			return d_d.images[d_o];
		}
		for (var d_i = 0; d_i < d_d.layers.length; d_i++)
		{
			var d_y = this.getImg(d_o, d_d.layers[d_i].document);
			if (d_y)
			{
				this.defx += d_d.layers[d_i].x;
				this.defy += d_d.layers[d_i].y;
				return d_y;
			}
		}
		return null;
	}
	else
	{
		var d_y;
		d_y = ((d_y = d_d.images[d_o]) && d_y.name == d_o)? d_y : null;
		if (d_y)
		{
			this.defx += dd.getPageX(d_y);
			this.defy += dd.getPageY(d_y);
		}
		return d_y;
	}
}




DDObj.prototype.setCurs = function(d_x)
{
	if (this.css) this.css.cursor = d_x;
}




DDObj.prototype.addChild = function(d_kd)
{
	this.children[this.children.length] = this.children[d_kd.name] = d_kd;
	d_kd.setZ(d_kd.defz = d_kd.z-0x02+this.z, true);
	d_kd.parent = this;
}








function WINSZ(d_x)
{
	if (d_x == 1 || d_x == 0x02)
	{
		if (dd.n4 || dd.op6 && d_x == 0x02)
		{
			dd.iW = innerWidth;
			dd.iH = innerHeight;
			if (dd.op6) setTimeout("WINSZ()", 0x1ff);
		}
		window.onresize = WINSZ;
	}
	else if ((dd.n4 || dd.op6) && (innerWidth != dd.iW || innerHeight != dd.iH))
		location.reload();
	else if (dd.op6) setTimeout("WINSZ()", 0x1ff);
	else setTimeout('dd.recalc()', 0x0a);
}
WINSZ(1);








// Page auto-scrolling functionality. Idea for this feature courtesy Cedric Savarese.
function DDScroll()
{
	if (!dd.obj || dd.obj.noscroll || dd.noscroll || dd.op)
	{
		dd.scrx = dd.scry = 0;
		return;
	}
	var d_bnd = 0x19,
	d_sft = 0x02,
	d_ww = dd.getWndW(),
	d_wh = dd.getWndH(),
	d_wx = dd.getScrollX(),
	d_wy = dd.getScrollY();


	if (!dd.mousemoved)
	{
		if (dd.scrx || dd.scry)
		{
			if (!d_wx && dd.scrx < 0 || dd.obj.vertical) dd.scrx = 0;
			if (!d_wy && dd.scry < 0 || dd.obj.horizontal) dd.scry = 0;
			if (dd.obj.drag) dd.obj.moveBy(dd.scrx, dd.scry);
			else dd.resizeBy(dd.scrx, dd.scry);
			dd.prex += dd.scrx;
			dd.prey += dd.scry;
		}
	}
	else
	{
		dd.scrx = dd.obj.vertical? 0
			: (dd.e.x > d_ww + d_wx - d_bnd)? Math.pow((dd.e.x - d_ww - d_wx + d_bnd) >>d_sft, 0x02)
			: (dd.e.x < d_wx + d_bnd)? -Math.pow((d_wx + d_bnd - dd.e.x) >>d_sft, 0x02)
			: 0,
		dd.scry = dd.obj.horizontal? 0
			: (dd.e.y > d_wh + d_wy - d_bnd)? Math.pow((dd.e.y - dd.getWndH() - d_wy + d_bnd) >>d_sft, 0x02)
			: (dd.e.y < d_wy + d_bnd)? -Math.pow((d_wy + d_bnd - dd.e.y) >>d_sft, 0x02)
			: 0;
	}
	dd.mousemoved = false;


	if (dd.scrx || dd.scry)  window.scrollTo(d_wx+dd.scrx, d_wy+dd.scry);
	window.setTimeout('DDScroll()', 0x33);
}








function PICK(d_ev)
{
	dd.e = new dd.evt(d_ev);
	var d_o, d_cmp = -1;
	// return if target is scrollbar
	if (dd.e.x >= dd.getWndW()+dd.getScrollX() || dd.e.y >= dd.getWndH()+dd.getScrollY()) return true;
	for (var d_i = 0; d_i < dd.elements.length; d_i++)
	{
		d_o = dd.elements[d_i];
		if (dd.n4 && dd.e.button > 1 && dd.e.src == d_o.oimg && !d_o.clone) return false;
		if (d_o.visible && dd.e.button <= 1 && (!d_o.nodrag || dd.e.shiftKey && d_o.keydown_resize) && dd.e.x >= d_o.x && dd.e.x <= d_o.x+d_o.w && dd.e.y >= d_o.y && dd.e.y <= d_o.y+d_o.h)
		{
			if (d_o.z > d_cmp)
			{
				d_cmp = d_o.z;
				dd.obj = d_o;
			}
		}
	}
	if (dd.obj)
	{
		(d_ev || event).cancelBubble = true;
		if (dd.op && !dd.op6)
		{
			var d_blr;
			(d_blr = document.getElementById('OpBlUr')).style.pixelLeft = dd.e.x;
			d_blr.style.pixelTop = dd.e.y;
			(d_blr = d_blr.children[0].children[0]).focus();
			d_blr.blur();
		}
		dd.moveFunc = document.onmousemove || null;
		dd.upFunc = document.onmouseup || null;
		document.onmouseup = DROP;
		if (dd.ce) document.captureEvents(Event.MOUSEMOVE|Event.MOUSEUP);
		dd.prex = dd.e.x;
		dd.prey = dd.e.y;
		dd.obj.activate();


		if (dd.e.shiftKey && dd.obj.keydown_resize)
		{
			dd.obj.setCurs('se-resize');
			dd.obj.resize = true;
			document.onmousemove = RESIZE;
			setTimeout(
				'if (dd.obj && document.selection && document.selection.empty) document.selection.empty();',
				1
			);
		}
		else if (!dd.obj.nodrag)
		{
			dd.obj.drag = true;
			document.onmousemove = DRAG;
			if (window.my_PickFunc) my_PickFunc();
		}
		DDScroll();

		return !(
			dd.obj.resize
			||
			dd.n4 &&
			dd.obj.oimg
			||
			(dd.n6 || dd.kq) &&
			(d_o = dd.e.src.toString().toLowerCase()).indexOf('inputelement')==-1 &&
			d_o.indexOf('textarea')==-1
		);
	}
	if (dd.downFunc) dd.downFunc(d_ev);
	return true;
}




function DRAG(d_ev)
{
	if (!dd.obj) return true;
	dd.mousemoved = true;
	if (dd.ie4 || dd.kq || dd.n6 && !dd.n7)
	{
		if (dd.wait) return false;
		dd.wait = true;
		setTimeout('dd.wait = false;', 0x05);
	}
	dd.e = new dd.evt(d_ev);
	if (dd.obj.horizontal) dd.e.y = dd.prey;
	if (dd.obj.vertical) dd.e.x = dd.prex;
	
	// Added By Aaron
	var mx = dd.e.x - dd.prex;
	var moveX=true;
	var my = dd.e.y - dd.prey;
	var moveY=true;
	if (dd.obj.x+mx<10 || dd.obj.x+mx>700) {
		moveX=false
	}
	//    || dd.obj.y+my>2100
	if (dd.obj.y+my<80 || dd.obj.y+my - dd.getScrollY() > dd.getWndH() - 20 || dd.obj.y+my - dd.getScrollY() < 9) {
		moveY=false;
		//return false;
		if (dd.obj.y+my - dd.getScrollY() > dd.getWndH() - 20) {
			window.status = "Please use the Scrollbars to scroll -- you can't drag it down.";
			dd.elements["dragWarning"].moveTo(dd.getScrollX()+dd.getWndH()/2-150,dd.getScrollY()+dd.getWndH()/2-150);
			dd.elements["dragWarning"].show();
			//DROP(d_ev);
			//alert("Please use the Scrollbars to scroll -- you can't drag it down.");
		}
		if (dd.obj.y+my - dd.getScrollY() < 9) {
			window.status = "Please use the Scrollbars to scroll -- you can't drag it up.";
			dd.elements["dragWarning"].moveTo(dd.getScrollX()+dd.getWndH()/2-150,dd.getScrollY()+dd.getWndH()/2-150);
			dd.elements["dragWarning"].show();
		}
	
	}
	if (moveX && moveY)
		dd.obj.moveBy(mx, my);
	else if (moveX)
		dd.obj.moveBy(mx, 0);
	else if (moveY)
		dd.obj.moveBy(0, my);
	
	
	//dd.obj.moveBy(dd.e.x - dd.prex, dd.e.y - dd.prey); // former line

	
//	if (window.my_DragFunc) my_DragFunc();

	/*d_ww = dd.getWndW();
	d_wh = dd.getWndH();
	d_wx = dd.getScrollX();
	d_wy = dd.getScrollY();*/	
	
	
	if (moveX)
		dd.prex = dd.e.x;
	if (moveY)
		dd.prey = dd.e.y;
	return false;
}




function RESIZE(d_ev)
{
	if (!dd.obj) return true;
	dd.mousemoved = true;

	if (dd.wait) return false;
	dd.wait = true;
	setTimeout('dd.wait = false;', 0x05);

	dd.e = new dd.evt(d_ev);
	dd.resizeBy(dd.e.x-dd.prex, dd.e.y-dd.prey);
	dd.prex = dd.e.x;
	dd.prey = dd.e.y;
	return false;
}




function DROP(d_ev)
{
	if (dd.obj)
	{
		if (dd.obj.drag)
		{
			if (!dd.obj.oimg) dd.getWH(dd.obj);
		}
		else if (dd.n4)
		{
			if (dd.obj.oimg)
			{
				dd.n4RectVis(false);
				dd.obj.resizeTo(dd.obj.w, dd.obj.h);
			}
		}
		if (!dd.n4 && !dd.op6 && (dd.obj.div.pos_rel || dd.obj.resize)) dd.recalc();
		if (dd.ce)
		{
			 if (!dd.moveFunc) document.releaseEvents(Event.MOUSEMOVE);
			 if (!dd.upFunc) document.releaseEvents(Event.MOUSEUP);
		}
		document.onmousemove = dd.moveFunc;
		document.onmouseup = dd.upFunc;
		dd.obj.setCurs(dd.obj.cursor);
		dd.obj.deactivate();
		if (window.my_DropFunc)
		{
			dd.e = new dd.evt(d_ev);
			my_DropFunc();
		}
		dd.mousemoved = dd.obj.drag = dd.obj.resize = false;
		dd.obj = null;
	}
	dd.elements["dragWarning"].hide();
}








function SET_DRAGGABLE()
{
	if (!(dd && (dd.n4 || dd.n6 || dd.ie || dd.op || dd.kq))) return;

	var d_a = SET_DRAGGABLE.arguments,
	d_htm = '',
	d_o;
	for (var d_i = d_a.length-1; d_i >= 0; d_i--)
	{
		// intra-loop delay for opera < 7
		if (dd.op6)
		{
			var d_t0 = (new Date()).getTime();
			while ((new Date()).getTime()-d_t0 < 0x78);
		}
		// get global cmds
		if (d_a[d_i].indexOf('c:') == 0) dd.cursor = d_a[d_i].substring(2);
		else if (d_a[d_i] == NO_ALT) dd.noalt = true;
		else if (d_a[d_i] == NO_SCROLL) dd.noscroll = true;
		else if (d_a[d_i] == KEYDOWN_RESIZE) dd.keydown_resize = true;
		else if (d_a[d_i] == RESET_Z) dd.re_z = true;


		else
		{
			d_o = new DDObj(d_a[d_i]);
			if (d_o.oimg || d_o.div)
			{
				dd.elements[dd.elements.length] = dd.elements[d_o.name] = d_o;
				d_o.z = 0x03;
				d_htm += d_o.htm || '';
				if (d_o.oimg && d_o.multi)
				{
					d_o.copies = new Array();
					for (var d_j = 1; d_j <= d_o.multi; d_j++)
					{
						var d_p = new DDObj(
							d_o.name +
							(d_o.clone? CLONE : '') +
							(d_o.noalt? NOALT : '') +
							(d_o.noscroll? NOSCROLL : '') +
							(d_o.keydown_resize? KEYDOWN_RESIZE : '') +
							(d_o.re_z? RESET_Z : ''),
							d_j
						);
						dd.elements[dd.elements.length] = d_o.copies[d_o.copies.length] = dd.elements[d_p.name] = d_p;
						d_p.z = d_o.z+d_j;
						d_p.copy = true;
						d_htm += d_p.htm;
					}
				}
			}
		}
	}


	if (dd.elements.length)
	{
		document.write(
			(dd.n4? '<div style="position:absolute;"><\/div>\n'
			: (dd.op && !dd.op6)? '<div id="OpBlUr" style="position:absolute;visibility:hidden;width:0px;height:0px;"><form><input type="text" style="width:0px;height:0px;"><\/form><\/div>'
			: '') + d_htm
		);
		dd.z = 0x32;


		for (d_i = 0; d_i < dd.elements.length; d_i++)
		{
			if ((d_o = dd.elements[d_i]).oimg)
			{
				d_o.div = dd.getDiv(d_o.id);
				if (d_o.div.style) d_o.css = d_o.div.style;
				d_o.setZ(d_o.defz = d_o.z, true);
				d_o.nimg = dd.n4? d_o.div.document.images[0] : document.images[d_o.id+'img'];
				if (!d_o.noalt && !dd.noalt)
				{
					d_o.nimg.alt = d_o.oimg.alt || '';
					if (d_o.oimg.title) d_o.nimg.title = d_o.oimg.title;
				}
				if (!d_o.copy)
				{
					if (!d_o.clone)
					{
						if (dd.n4) d_o.oimg.src = spacer;
						else d_o.oimg.style.visibility = 'hidden';
					}
				}
			}
			dd.addProps(d_o);
		}


		for (d_i = 0; d_i < dd.elements.length; d_i++)
		{
			if (!(d_o = dd.elements[d_i]).oimg) dd.getChildren(d_o);
		}


		if (window.onload) dd.loadFunc = window.onload;
		window.onload = dd.setEvtHdl;
	}
}




function ADD_ITEM(d_o)
{
	// layers only!
	d_o = new DDObj(d_o);
	dd.elements[dd.elements.length] = dd.elements[d_o.name] = d_o;

	dd.addProps(d_o);
	if (!d_o.oimg) dd.getChildren(d_o);
}










////////////////////////////////////////////////////////////////////////////////
// If not needed, all code below this line may be removed
////////////////////////////////////////////////////////////////////////////////


// For backward compatibility only
dd.d = document;			// < v. 2.72
var RESET_ZINDEX = RESET_Z; // < 3.44








////////////////////////////////////////////////////////////////////////////////
// FUNCTIONS FOR EXTENDED SCRIPTING
// Use these for your own extensions,
// or to call functions defined elsewhere
////////////////////////////////////////////////////////////////////////////////


/* my_PickFunc IS AUTOMATICALLY CALLED WHEN AN ITEM STARTS TO BE DRAGGED.
The following objects/properties are accessible from here:

- dd.e: current mouse event
- dd.e.property: access to a property of the current mouse event.
  Mostly requested properties:
  - dd.e.x: document-related x co-ordinate
  - dd.e.y: document-related y co-ord
  - dd.e.src: target of mouse event (not identical with the drag drop object itself).
  - dd.e.button: currently pressed mouse button. Left button: dd.e.button <= 1

- dd.obj: reference to currently dragged item.
- dd.obj.property: access to any property of that item.
- dd.obj.method(): for example dd.obj.resizeTo() or dd.obj.swapImage() .
  Mostly requested properties:
	- dd.obj.name: image name or layer ID passed to SET_DRAGGABLE();
	- dd.obj.x and dd.obj.y: co-ordinates;
	- dd.obj.w and dd.obj.h: size.

For more properties and details, visit the API documentation
at http://www.walterzorn.com/dragdrop/api_e.htm (english) or
http://www.walterzorn.de/dragdrop/api.htm (german)    */
function my_PickFunc()
{
	window.status = 'dd.elements.' + dd.obj.name + '.x = ' + dd.obj.x + '      dd.elements.' + dd.obj.name + '.y = ' + dd.obj.y;
}






/* my_DragFunc IS CALLED DURING AN ITEM IS DRAGGED.
See the description of my_PickFunc above for what's accessible from here. */
function my_DragFunc()
{
	window.status = 'dd.elements.' + dd.obj.name + '.x  = ' + dd.obj.x + '     dd.elements.' + dd.obj.name + '.y = ' + dd.obj.y;
}






/* THIS ONE IS CALLED ONCE AN ITEM IS DROPPED
See the description of my_PickFunc for what's accessible from here.
Here may be investigated, for example, what's the name (dd.obj.name)
of the dropped item, and where (dd.obj.x, dd.obj.y) it has been dropped... */
function my_DropFunc()
{
	window.status = 'dd.elements.' + dd.obj.name + '    dropped at x = ' + dd.obj.x + '      y = ' + dd.obj.y;
	// Added by Aaron Powers for grouping
	//addToAGroup(3, dd.obj.name);
	checkIfDroppedInAGroup(dd.obj);
	// End added by Aaron Powers
}


