/*
 * Decompiled with CFR 0.152.
 */
package cmu.survey;

import cmu.survey.Maintenance;
import cmu.survey.RadioButtonQuestion;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class TimeZoneQuestion
extends RadioButtonQuestion {
    public static Vector timeZones;
    public static Vector timeZoneIDStrings;

    public static final String getTimeOf(Calendar cal) {
        String minute;
        String hour = cal.get(10) + "";
        if (hour.equals("0")) {
            hour = "12";
        }
        if ((minute = cal.get(12) + "").length() < 2) {
            minute = minute.length() < 1 ? "0" + minute : "00";
        }
        return hour + ":" + minute + (cal.get(9) == 0 ? " am" : " pm");
    }

    public static final String getTimeOf(String id, Calendar cal) {
        return id + " (" + TimeZoneQuestion.getTimeOf(cal) + ")";
    }

    public static final String getTimeOf(String id) {
        TimeZone timeZone = TimeZone.getTimeZone(id);
        Calendar cal = Calendar.getInstance(timeZone);
        Calendar nowCalendar = Calendar.getInstance();
        cal.setTime(nowCalendar.getTime());
        return TimeZoneQuestion.getTimeOf(id, cal);
    }

    public static final Date getDateOf(String zoneId) {
        TimeZone timeZone = TimeZone.getTimeZone(zoneId);
        Calendar cal = Calendar.getInstance(timeZone);
        Calendar nowCalendar = Calendar.getInstance();
        cal.setTime(nowCalendar.getTime());
        return cal.getTime();
    }

    public String getValueFromDB() {
        String value = super.getValueFromDB();
        if (value == null || value.length() < 1) {
            TimeZone current = TimeZone.getDefault();
            int i = 0;
            while (i < timeZones.size()) {
                if (current.hasSameRules((TimeZone)timeZones.get(i))) {
                    return i + 1 + "";
                }
                ++i;
            }
            return "";
        }
        int i = 0;
        while (i < timeZoneIDStrings.size()) {
            if (((String)timeZoneIDStrings.get(i)).startsWith(value)) {
                return i + 1 + "";
            }
            ++i;
        }
        return "1";
    }

    public static String convertHTTPRequestStringToSQL(String requestString) {
        int index = Integer.parseInt(requestString);
        String zone = (String)timeZoneIDStrings.get(index);
        zone = zone.substring(0, zone.indexOf("(") - 1);
        return zone;
    }

    public static Vector getTimeZoneStrings() {
        if (timeZones == null) {
            timeZones = new Vector();
            timeZoneIDStrings = new Vector();
            String[] timeZoneIDs = TimeZone.getAvailableIDs();
            String[] americanTimeZones = new String[]{"EST", "CST", "MST", "PST"};
            int i = 0;
            while (i < americanTimeZones.length) {
                TimeZone timeZone = TimeZone.getTimeZone(americanTimeZones[i]);
                timeZones.add(timeZone);
                timeZoneIDStrings.add(americanTimeZones[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < timeZoneIDs.length) {
                block6: {
                    TimeZone timeZone = TimeZone.getTimeZone(timeZoneIDs[i2]);
                    int rawOffset = timeZone.getRawOffset();
                    int z = 0;
                    while (z < timeZones.size()) {
                        if (((TimeZone)timeZones.get(z)).getRawOffset() != rawOffset) {
                            ++z;
                            continue;
                        }
                        break block6;
                    }
                    timeZones.add(timeZone);
                    timeZoneIDStrings.add(timeZoneIDs[i2]);
                }
                ++i2;
            }
        }
        Vector<String> timeStrings = new Vector<String>();
        int i = 0;
        while (i < timeZoneIDStrings.size()) {
            timeStrings.add(TimeZoneQuestion.getTimeOf((String)timeZoneIDStrings.get(i)));
            ++i;
        }
        return timeStrings;
    }

    public int doStartTag() {
        try {
            if (this.getType() != null && this.getType().indexOf("Key") > 0) {
                this.setType("timezoneKey");
            } else {
                this.setType("timezone");
            }
            Vector timeStrings = TimeZoneQuestion.getTimeZoneStrings();
            String[] theChoices = new String[timeStrings.size()];
            int i = 0;
            while (i < timeStrings.size()) {
                theChoices[i] = (String)timeStrings.get(i);
                ++i;
            }
            this.setChoices(theChoices);
            this.setShowTitles(true);
            super.doStartTag();
        }
        catch (Throwable e) {
            Maintenance.sendBug(e);
        }
        return 0;
    }

    public static final void main(String[] args) {
        Vector timeStrings = TimeZoneQuestion.getTimeZoneStrings();
        int i = 0;
        while (i < timeStrings.size()) {
            System.out.println(timeStrings.get(i));
            ++i;
        }
    }
}

