/*
 * Decompiled with CFR 0.152.
 */
package cmu.survey;

import cmu.survey.DatabaseConnection;
import cmu.survey.DatabaseList;
import cmu.survey.GenericUpdate;
import cmu.survey.HiddenQuestion;
import cmu.survey.Maintenance;
import cmu.survey.QuestionInfo;
import java.util.Date;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class Survey
extends DatabaseConnection {
    String table;
    String where;
    boolean whereWasSetByUser = false;
    boolean retrieveValuesFromDB = true;
    boolean userHasSetRetrieveValuesFromDB = false;
    boolean isLoginPage = false;
    String tableToVerifyLoginTo;
    String pageToLoginTo = null;
    String userIDField;
    String nextPage;
    boolean timeResponses = false;
    String timeResponsesAppendix = "_timeSpent";
    String countTimesVisitingPageField;
    String emailResultsTo;
    String emailResultsSubjectLine;
    boolean neverMakeNewRecord = false;
    boolean createUsersAtLogin = false;
    boolean showSubmitButton = true;
    boolean showSubmitButtonOnlyIfNoJavaScript = false;
    boolean showDeleteButton = false;
    boolean userHasSetShowDeleteButton = false;
    String submitImage;
    String submitImageRollover;
    String submitImageDown;
    String deleteImage;
    String deleteImageRollover;
    String deleteImageDown;
    static int pageWidthDefault = 600;
    int pageWidth = pageWidthDefault;
    int percentQuestion = -1;
    static int fontSizeDefault = 3;
    int fontSize = fontSizeDefault;
    static String backgroundColor1Default = "#eeeeee";
    static String headerBackgroundColorDefault = "#6699ff";
    String headerBackgroundColor = headerBackgroundColorDefault;
    String backgroundColor1 = backgroundColor1Default;
    static String backgroundColor2Default = "#dcdcdc";
    String backgroundColor2 = backgroundColor2Default;
    static String clearBackgroundColorDefault = "#FFFFFF";
    String clearBackgroundColor;
    String currentBackgroundColor = this.clearBackgroundColor = clearBackgroundColorDefault;
    String submitButtonText = "Submit";
    boolean showAMessageAboutSubmission = false;
    String userIDValue;
    Vector questionsAndInfo = new Vector();

    public String getTable() {
        return this.table;
    }

    public void setTable(String tableName) {
        this.table = tableName;
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String newWhere) {
        this.where = newWhere;
        this.whereWasSetByUser = true;
        if (this.where != null && this.where.length() == 0) {
            this.where = null;
        }
    }

    public boolean getRetrieveValuesFromDB() {
        return this.retrieveValuesFromDB;
    }

    public void setRetrieveValuesFromDB(boolean retrieveBoolean) {
        this.retrieveValuesFromDB = retrieveBoolean;
        this.userHasSetRetrieveValuesFromDB = true;
    }

    public boolean getIsLoginPage() {
        return this.isLoginPage;
    }

    public void setIsLoginPage(boolean thisPageIsALogin) {
        this.isLoginPage = thisPageIsALogin;
    }

    public String getTableToVerifyLoginTo() {
        return this.tableToVerifyLoginTo;
    }

    public void setTableToVerifyLoginTo(String tableWithLogins) {
        this.tableToVerifyLoginTo = tableWithLogins;
    }

    public String getPageToLoginTo() {
        return this.pageToLoginTo;
    }

    public void setUserIDField(String userID) {
        this.userIDField = userID;
    }

    public String getUserIDField() {
        return this.userIDField;
    }

    void adjustWhereClause() {
        String possibleWhere;
        if (this.getIsLoginPage() && this.where != null && this.where.length() > 0) {
            this.pageContext.getSession().setAttribute(this.getLoginPageString("LoginWhere"), (Object)this.where);
        }
        if ((possibleWhere = (String)this.pageContext.getSession().getAttribute(this.getLoginPageString("LoginWhere"))) != null && possibleWhere.length() > 0 && this.where == null && !this.whereWasSetByUser) {
            this.where = possibleWhere;
        }
    }

    void verifyLoginVarsAreConsistentlySet() {
        if (this.isLoginPage) {
            if (this.pageToLoginTo != null) {
                throw new RuntimeException("This page cannot both be a login page (isLoginPage=true) and have another page to login to (pageToLoginTo=" + this.pageToLoginTo + ")");
            }
        } else {
            if (this.createUsersAtLogin) {
                throw new RuntimeException("You're setting createUsersAtLogin but we're not logging in on this page!  Thus, users cannot be created when they log in as they never log in here. (isLoginPage=false and createUsersAtLogin=true)");
            }
            if (this.pageToLoginTo == null) {
                if (this.tableToVerifyLoginTo != null) {
                    throw new RuntimeException("You're setting a tableToVerifyLoginTo, but we're not logging in on this page!  Thus, you shouldn't set a table to log in to when they log in as they never log in here. (isLoginPage=false and tableToVerifyLoginTo=" + this.tableToVerifyLoginTo + " and tableToVerifyLoginTo=" + this.tableToVerifyLoginTo + ")");
                }
                if (this.userIDField != null) {
                    throw new RuntimeException("You're setting a userIDField, but we're not logging in on this page!  Thus, you shouldn't set a field in the database that is the UserID, if no one ever logs in here. (isLoginPage=false, pageToLoginTo=null, and userIDField=" + this.userIDField + ")");
                }
            }
        }
    }

    public void setPageToLoginTo(String pageToRedirectToWhenUserIsNotLoggedIn) {
        this.pageToLoginTo = pageToRedirectToWhenUserIsNotLoggedIn;
    }

    public String getNextPage() {
        return this.nextPage;
    }

    public void setNextPage(String nextPageInSurvey) {
        this.nextPage = nextPageInSurvey;
    }

    public boolean getTimeResponses() {
        return this.timeResponses;
    }

    public void setCountTimesVisitingPageField(String fieldToCountIn) {
        this.checkSQLFieldValid(fieldToCountIn);
        this.countTimesVisitingPageField = fieldToCountIn;
    }

    public void setEmailResultsTo(String emailAddress) {
        this.emailResultsTo = emailAddress;
    }

    public String getEmailResultsTo() {
        return this.emailResultsTo;
    }

    public void setEmailResultsSubjectLine(String subj) {
        this.emailResultsSubjectLine = subj;
    }

    public String getEmailResultsSubjectLine() {
        return this.emailResultsSubjectLine;
    }

    public void setTimeResponses(boolean timeResponsesBoolean) {
        this.timeResponses = timeResponsesBoolean;
    }

    public boolean getCreateUsersAtLogin() {
        return this.createUsersAtLogin;
    }

    public void setCreateUsersAtLogin(boolean bool) {
        this.createUsersAtLogin = bool;
    }

    public boolean getNeverMakeNewRecord() {
        return this.neverMakeNewRecord;
    }

    public void setNeverMakeNewRecord(boolean updateDatabase) {
        this.neverMakeNewRecord = updateDatabase;
    }

    public boolean getShowSubmitButton() {
        return this.showSubmitButton;
    }

    public void setShowSubmitButton(boolean showButtonAtBottom) {
        this.showSubmitButton = showButtonAtBottom;
    }

    public boolean getShowSubmitButtonOnlyIfNoJavaScript() {
        return this.showSubmitButtonOnlyIfNoJavaScript;
    }

    public void setShowSubmitButtonOnlyIfNoJavaScript(boolean showButtonAtBottom) {
        this.showSubmitButtonOnlyIfNoJavaScript = showButtonAtBottom;
    }

    public boolean getShowDeleteButton() {
        return this.showDeleteButton;
    }

    public void setShowDeleteButton(boolean showADeleteButtonAtBottom) {
        this.showDeleteButton = showADeleteButtonAtBottom;
        this.userHasSetShowDeleteButton = true;
    }

    public String getSubmitImage() {
        return this.submitImage;
    }

    public void setSubmitImage(String submitImageName) {
        this.submitImage = submitImageName;
    }

    public String getSubmitImageRollover() {
        return this.submitImageRollover;
    }

    public void setSubmitImageRollover(String submitImageRolloverName) {
        this.submitImageRollover = submitImageRolloverName;
    }

    public String getSubmitImageDown() {
        return this.submitImageDown;
    }

    public void setSubmitImageDown(String submitImageDownName) {
        this.submitImageDown = submitImageDownName;
    }

    public String getDeleteImage() {
        return this.deleteImage;
    }

    public void setDeleteImage(String deleteImageName) {
        this.deleteImage = deleteImageName;
        if (!this.userHasSetShowDeleteButton) {
            this.setShowDeleteButton(true);
        }
    }

    public String getDeleteImageRollover() {
        return this.deleteImageRollover;
    }

    public void setDeleteImageRollover(String deleteImageRolloverName) {
        this.deleteImageRollover = deleteImageRolloverName;
    }

    public String getDeleteImageDown() {
        return this.deleteImageDown;
    }

    public void setDeleteImageDown(String deleteImageDownName) {
        this.deleteImageDown = deleteImageDownName;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(int width) {
        this.pageWidth = width;
    }

    public int getPercentQuestion() {
        return this.percentQuestion;
    }

    public void setPercentQuestion(int percentOfWidthForQuestion) {
        this.percentQuestion = percentOfWidthForQuestion;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setShowAMessageAboutSubmission(boolean showTheOutputGenericUpdateGenerates) {
        this.showAMessageAboutSubmission = showTheOutputGenericUpdateGenerates;
    }

    public boolean getShowAMessageAboutSubmission() {
        return this.showAMessageAboutSubmission;
    }

    public static final String cleanStringValueForApostrophesOnly(String sqlString) {
        String newSQL = "";
        if (sqlString == null) {
            return newSQL;
        }
        int i = 0;
        while (i < sqlString.length()) {
            String character = sqlString.substring(i, i + 1);
            if (character.equals("'")) {
                character = "\\'";
            }
            newSQL = newSQL + character;
            ++i;
        }
        return newSQL;
    }

    public String getSubmitInJavaScript() {
        String javaScript = "";
        if (this.getTimeResponses()) {
            javaScript = javaScript + "set_elapsed_time(\\'document.form1.number_timeSpent\\');";
        }
        javaScript = javaScript + "doSubmit();";
        return javaScript;
    }

    public String getDeleteInJavaScript() {
        String javaScript = "";
        if (this.getTimeResponses()) {
            javaScript = javaScript + "set_elapsed_time(\\'document.form1.number_timeSpent\\');";
        }
        javaScript = javaScript + "confirmDeleteAndSubmit();";
        return javaScript;
    }

    public static String getSessionPageString(PageContext pageContext, String attributeName) {
        String pageString = null;
        ServletRequest request = pageContext.getRequest();
        if (request != null && request instanceof HttpServletRequest) {
            pageString = ((HttpServletRequest)request).getRequestURI();
        }
        if (pageString != null) {
            pageString = pageString + ": " + attributeName;
        }
        return pageString;
    }

    public String getSessionPageString(String attributeName) {
        return Survey.getSessionPageString(this.pageContext, attributeName);
    }

    boolean isWhereEmpty() {
        return this.where == null || this.where.length() == 0 || this.where.equals("EMPTY");
    }

    public String getLoginPageString(String attributeName) {
        String pageString = null;
        ServletRequest request = this.pageContext.getRequest();
        if (request != null && request instanceof HttpServletRequest) {
            pageString = ((HttpServletRequest)request).getRequestURI();
        }
        if (!this.isLoginPage) {
            if (this.pageToLoginTo != null) {
                pageString = pageString.substring(0, pageString.lastIndexOf("/") + 1) + this.pageToLoginTo;
            } else {
                Maintenance.sendBug("Survey.getLoginPageString is getting called when this isn't a login page and there is no page to log in to.  Programmer, be more carefull when calling getLoginPageString()!");
                return null;
            }
        }
        if (pageString != null) {
            pageString = pageString + ": Login" + attributeName;
        }
        return pageString;
    }

    boolean verifyLogin() {
        String loginWhere = (String)this.pageContext.getSession().getAttribute(this.getLoginPageString("LoginWhere"));
        if (loginWhere == null) {
            return false;
        }
        boolean loginRight = false;
        String loginTable = this.tableToVerifyLoginTo;
        if (loginTable == null) {
            loginTable = this.table;
        }
        DatabaseList databaseList = new DatabaseList();
        databaseList.setParent((Tag)this);
        databaseList.setPageContext(this.pageContext);
        databaseList.setupConnection(this);
        try {
            databaseList.doQuery("SELECT * FROM " + loginTable + " WHERE " + loginWhere);
            if (databaseList.moveToNextRecord()) {
                loginRight = true;
                if (this.userIDField != null) {
                    this.userIDValue = databaseList.getField(this.userIDField);
                    this.pageContext.getSession().setAttribute(this.getLoginPageString("UserID"), (Object)this.userIDValue);
                }
            }
        }
        catch (Exception ex) {
            Maintenance.sendBug(ex);
        }
        return loginRight;
    }

    public void addQuestionInfoToHistory(QuestionInfo questionInfo) {
        this.questionsAndInfo.add(questionInfo);
    }

    public QuestionInfo getLastQuestionInHistory() {
        if (this.questionsAndInfo.size() > 0) {
            return (QuestionInfo)this.questionsAndInfo.get(this.questionsAndInfo.size() - 1);
        }
        return null;
    }

    public int doStartTag() {
        super.doStartTag();
        try {
            String loginRedir = null;
            this.verifyLoginVarsAreConsistentlySet();
            if (this.databaseName == null || this.databaseName.length() == 0) {
                this.setRetrieveValuesFromDB(false);
            }
            if (this.pageContext == null) {
                Maintenance.sendBug("Survey.doStartTag() was somehow called from a place where pageContext is not automatically set -- outside of a JSP tag, probably.  It shouldnt' be called from here, we can't do much like this.  (If you want to call it, you'll have to modify Survey to support this).");
                return 1;
            }
            GenericUpdate saveResults = this.saveFormToDatabase();
            if (this.isLoginPage) {
                if (saveResults.getWhereOfKeys() != null) {
                    this.where = this.where != null ? this.where + " AND " + saveResults.getWhereOfKeys() : saveResults.getWhereOfKeys();
                }
                if (this.where == null || this.where.length() < 1) {
                    this.where = null;
                }
            }
            if (saveResults.getChangedDBLastUpdate() && this.nextPage != null) {
                if (DatabaseList.debug) {
                    Maintenance.debugOutput("Survey: data saved.  Next Page: " + this.nextPage);
                }
                if (this.getIsLoginPage() && this.where != null && this.where.length() > 0) {
                    this.pageContext.getSession().setAttribute(this.getLoginPageString("LoginWhere"), (Object)this.where);
                }
                ((HttpServletResponse)this.pageContext.getResponse()).sendRedirect(this.nextPage);
                return 0;
            }
            String resultFromGenericUpdate = saveResults.getLastMessage();
            if (resultFromGenericUpdate != null && resultFromGenericUpdate.length() > 0 && this.showAMessageAboutSubmission) {
                this.out.print("<table><tr><td colspan=\"2\" bgcolor=\"#FFFF80\">" + resultFromGenericUpdate + "</td></tr></table>");
            }
            if (this.getIsLoginPage() || this.pageToLoginTo != null) {
                boolean loginRight = false;
                this.adjustWhereClause();
                loginRedir = ((HttpServletRequest)this.pageContext.getRequest()).getParameter("redir");
                if (!(loginRedir != null && loginRedir.length() >= 1 || (loginRedir = (String)this.pageContext.getSession().getAttribute("LoginRedir")) != null && loginRedir.length() >= 1)) {
                    loginRedir = this.nextPage;
                }
                if (!(loginRight = this.verifyLogin()) && this.pageToLoginTo != null && this.pageToLoginTo.length() > 0) {
                    String redir = "";
                    if (this.pageToLoginTo.indexOf("://") > -1) {
                        redir = this.pageToLoginTo + "?redir=" + DatabaseConnection.getThisFullURL(this.pageContext);
                    } else {
                        System.out.println("folderurl " + DatabaseConnection.getThisFolderURL(this.pageContext));
                        redir = DatabaseConnection.getThisFolderURL(this.pageContext) + this.pageToLoginTo + "?redir=" + DatabaseConnection.getThisFullURL(this.pageContext);
                    }
                    ((HttpServletResponse)this.pageContext.getResponse()).sendRedirect(redir);
                    return 0;
                }
                if (this.getIsLoginPage() && loginRight && loginRedir != null && loginRedir.length() > 0) {
                    ((HttpServletResponse)this.pageContext.getResponse()).sendRedirect(loginRedir);
                    this.pageContext.getSession().setAttribute("LoginRedir", null);
                    return 0;
                }
                if (!loginRight) {
                    this.pageContext.setAttribute("dbMessage", (Object)"That login is incorrect.");
                    if (this.where != null) {
                        boolean first;
                        String loginAttempts = (String)this.pageContext.getSession().getAttribute("LoginAttempts");
                        boolean bl = first = loginAttempts == null;
                        if (first) {
                            loginAttempts = "";
                        }
                        loginAttempts = loginAttempts + "\n  " + new Date() + "   Where=" + this.where;
                        if (!first && loginAttempts != null && loginAttempts.length() > 300) {
                            Maintenance.sendHackerError("Possible hacking attempt!  The user has tried many, many times to get in:\n" + loginAttempts, this.pageContext);
                        }
                        this.pageContext.getSession().setAttribute("LoginAttempts", (Object)loginAttempts);
                    }
                    if (loginRedir != null) {
                        this.pageContext.getSession().setAttribute("LoginRedir", (Object)loginRedir);
                    }
                }
                if (!(this.userHasSetRetrieveValuesFromDB || this.where != null && this.where.length() >= 1)) {
                    this.retrieveValuesFromDB = false;
                }
            }
            this.saveNumberOfTimesUserHasVisitedPage();
            this.printStartForm(loginRedir);
        }
        catch (Throwable e) {
            Maintenance.sendBug(e);
        }
        return 1;
    }

    void saveNumberOfTimesUserHasVisitedPage() {
        if (this.countTimesVisitingPageField != null && this.countTimesVisitingPageField.length() > 0) {
            DatabaseList query = new DatabaseList();
            query.setParent((Tag)this);
            query.setPageContext(this.pageContext);
            query.setupConnection(this);
            if (!this.isWhereEmpty()) {
                query.doQuery("UPDATE " + this.table + " SET " + this.countTimesVisitingPageField + "=" + this.countTimesVisitingPageField + "+1" + " WHERE " + this.where);
            }
        }
    }

    GenericUpdate saveFormToDatabase() {
        GenericUpdate genericUpdate = new GenericUpdate();
        genericUpdate.setParent((Tag)this);
        genericUpdate.setPageContext(this.pageContext);
        genericUpdate.setupConnection(this);
        if (this.getIsLoginPage() && !this.createUsersAtLogin) {
            genericUpdate.setSaveChangesToDB(false);
        }
        genericUpdate.doStartTag();
        return genericUpdate;
    }

    void printStartForm(String loginRedir) {
        block8: {
            try {
                String output = "\n<form name=\"form1\" action=\"";
                output = output + DatabaseConnection.getURLFileName(this.pageContext);
                output = output + "\" method=\"post\">\n";
                if (this.timeResponses) {
                    output = output + "<input type=\"hidden\" name=\"number" + this.timeResponsesAppendix + "\" value=\"0\">";
                }
                if (loginRedir != this.nextPage && loginRedir != null) {
                    output = output + "<input type=\"hidden\" name=\"redir\" value=\"" + loginRedir + "\">";
                }
                this.out.print(output);
                this.out.print("<table border=\"0\" width=\"" + this.pageWidth + "\" cellpadding=\"0\"><tr><td>");
                if (this.userIDField == null || this.userIDValue == null) break block8;
                HiddenQuestion hidden = new HiddenQuestion(this);
                hidden.setDbField(this.userIDField);
                hidden.setValue(this.userIDValue);
                boolean isStr = false;
                try {
                    Double.parseDouble(this.userIDValue);
                }
                catch (NumberFormatException e) {
                    isStr = true;
                }
                if (isStr) {
                    hidden.setType("stringKey");
                } else {
                    hidden.setType("numberKey");
                }
                hidden.doStartTag();
            }
            catch (Throwable e) {
                Maintenance.sendBug(e);
            }
        }
    }

    public int doEndTag() {
        try {
            if (this.pageContext != null) {
                if (this.showSubmitButton) {
                    if (this.submitImage != null) {
                        String submitImageHTML = "<img name=\"submitImage\" src=\"" + this.submitImage + "\" alt=\"" + this.submitButtonText + "\" border=\"0\"" + (this.submitImageRollover == null ? "" : " onMouseOver=\"flipTo(\\'submitImage\\', \\'" + this.submitImageRollover + "\\');\" onMouseOut=\"flipTo(\\'submitImage\\', \\'" + this.submitImage + "\\');\"") + (this.submitImageDown == null ? "" : " onMouseDown=\"flipTo(\\'submitImage\\', \\'" + this.submitImageDown + "\\');\" onMouseUp=\"flipTo(\\'submitImage\\', \\'" + (this.submitImageRollover == null ? this.submitImage : this.submitImageRollover) + "\\');\"") + ">";
                        if (this.submitImageRollover != null || this.submitImageDown != null) {
                            this.out.print("\n<script language=\"javascript\">\n<!--\n" + (this.submitImageRollover == null ? "" : "var submitRollover = new Image();\nsubmitRollover.src = \"" + this.submitImageRollover + "\";\n") + (this.submitImageDown == null ? "" : "var submitImageDown = new Image();\nsubmitImageDown.src = \"" + this.submitImageDown + "\";\n") + "// -->\n" + "</script>\n");
                        }
                        if (!this.showSubmitButtonOnlyIfNoJavaScript) {
                            this.out.print("\n<script language=\"JavaScript\">\n<!-- \ndocument.write('<a href=\"javascript:" + this.getSubmitInJavaScript() + "\">" + submitImageHTML + "</a>");
                            this.out.print("');\n// -->\n</script>\n");
                        }
                    } else if (!this.showSubmitButtonOnlyIfNoJavaScript) {
                        this.out.print("\n<script language=\"JavaScript\">\n<!-- \ndocument.write('<input type=\"button\" value=\"" + this.submitButtonText + "\" id=submit1 name=submit1 onClick=\"" + this.getSubmitInJavaScript() + "\">');\n" + "// -->\n" + "</script>\n");
                    }
                    this.out.print("<NOSCRIPT>\n<input type=\"submit\" value=\"" + this.submitButtonText + "\" id=submit1 name=submit1>\n" + "</NOSCRIPT>\n");
                }
                if (this.showDeleteButton && this.where != null) {
                    if (this.deleteImage != null) {
                        String deleteImageHTML = "<img name=\"deleteImage\" src=\"" + this.deleteImage + "\" alt=\"" + "Delete" + "\" border=\"0\"" + (this.deleteImageRollover == null ? "" : " onMouseOver=\"flipTo(\\'deleteImage\\', \\'" + this.deleteImageRollover + "\\');\" onMouseOut=\"flipTo(\\'deleteImage\\', \\'" + this.deleteImage + "\\');\"") + (this.deleteImageDown == null ? "" : " onMouseDown=\"flipTo(\\'deleteImage\\', \\'" + this.deleteImageDown + "\\');\" onMouseUp=\"flipTo(\\'deleteImage\\', \\'" + (this.deleteImageRollover == null ? this.deleteImage : this.deleteImageRollover) + "\\');\"") + ">";
                        if (this.deleteImageRollover != null || this.deleteImageDown != null) {
                            this.out.print("\n<script language=\"javascript\">\n<!--\n" + (this.deleteImageRollover == null ? "" : "var deleteRollover = new Image();\ndeleteRollover.src = \"" + this.deleteImageRollover + "\";\n") + (this.deleteImageDown == null ? "" : "var deleteImageDown = new Image();\ndeleteImageDown.src = \"" + this.deleteImageDown + "\";\n") + "// -->\n" + "</script>\n");
                        }
                        this.out.print("\n<script language=\"JavaScript\">\n<!-- \ndocument.write('<a onClick=\"" + this.getDeleteInJavaScript() + "\">" + deleteImageHTML + "</a>");
                        this.out.print("');\n// -->\n</script>\n");
                    } else {
                        this.out.print("\n<script language=\"JavaScript\">\n<!-- \ndocument.write('");
                        this.out.print("<input type=\"button\" value=\"Delete\" id=\"submitDelete\" name=\"submitDelete\" onClick=\"" + this.getDeleteInJavaScript() + "\">");
                        this.out.print("');\n// -->\n</script>\n");
                    }
                    this.out.print("<NOSCRIPT>\n  <input type=\"submit\" value=\"Delete\" id=\"submitDelete\" name=\"submitDelete\">\n</NOSCRIPT>\n");
                }
                this.out.print("<input type=\"hidden\" name=\"Action\" value=\"\">");
                QuestionInfo lastQuestion = this.getLastQuestionInHistory();
                if (lastQuestion != null && lastQuestion.unclosedTable) {
                    this.out.print("</td></tr></table>");
                }
                this.out.print("</td></tr></table>");
                this.out.print("\n</form>\n");
                this.pageContext.getSession().setAttribute(this.getSessionPageString("DBFields"), (Object)this.questionsAndInfo);
            }
        }
        catch (Throwable e) {
            Maintenance.sendBug(e);
        }
        return super.doEndTag();
    }

    public void reinit() {
        super.reinit();
        this.table = null;
        this.where = null;
        this.whereWasSetByUser = false;
        this.nextPage = null;
        this.emailResultsTo = null;
        this.emailResultsSubjectLine = null;
        this.tableToVerifyLoginTo = null;
        this.pageToLoginTo = null;
        this.isLoginPage = false;
        this.createUsersAtLogin = false;
        this.userIDField = null;
        this.userIDValue = null;
        this.retrieveValuesFromDB = true;
        this.timeResponses = false;
        this.timeResponsesAppendix = "_timeSpent";
        this.countTimesVisitingPageField = null;
        this.neverMakeNewRecord = false;
        this.userHasSetRetrieveValuesFromDB = false;
        this.submitButtonText = "Submit";
        this.submitImageDown = null;
        this.submitImageRollover = null;
        this.submitImage = null;
        this.deleteImageDown = null;
        this.deleteImageRollover = null;
        this.deleteImage = null;
        this.showSubmitButton = true;
        this.showSubmitButtonOnlyIfNoJavaScript = false;
        this.showDeleteButton = false;
        this.userHasSetShowDeleteButton = false;
        this.showAMessageAboutSubmission = false;
        this.fontSize = fontSizeDefault;
        this.percentQuestion = -1;
        this.pageWidth = pageWidthDefault;
        this.headerBackgroundColor = headerBackgroundColorDefault;
        this.backgroundColor1 = backgroundColor1Default;
        this.backgroundColor2 = backgroundColor2Default;
        this.currentBackgroundColor = this.clearBackgroundColor = clearBackgroundColorDefault;
        this.questionsAndInfo = new Vector();
    }

    public String getHeaderBackgroundColor() {
        return this.headerBackgroundColor;
    }

    public String getBackgroundColor1() {
        return this.backgroundColor1;
    }

    public String getBackgroundColor2() {
        return this.backgroundColor2;
    }

    public String getClearBackgroundColor() {
        return this.clearBackgroundColor;
    }

    public String getCurrentBackgroundColor() {
        return this.currentBackgroundColor;
    }

    public void setHeaderBackgroundColor(String color) {
        this.headerBackgroundColor = color;
    }

    public void setBackgroundColor1(String color) {
        this.backgroundColor1 = color;
    }

    public void setBackgroundColor2(String color) {
        this.backgroundColor2 = color;
    }

    public void setClearBackgroundColor(String color) {
        this.clearBackgroundColor = color;
    }

    public void setCurrentBackgroundColor(String color) {
        this.currentBackgroundColor = color;
    }

    public String getSubmitButtonText() {
        return this.submitButtonText;
    }

    public void setSubmitButtonText(String submitText) {
        this.submitButtonText = submitText;
    }
}

