/*
 * Decompiled with CFR 0.152.
 */
package cmu.survey;

import cmu.survey.DatabaseList;
import cmu.survey.Maintenance;
import cmu.survey.QuestionInfo;
import cmu.survey.Survey;
import java.io.IOException;

public abstract class Question
extends DatabaseList {
    public static String imageDirectory = "images/";
    public static String blankImageLocation = imageDirectory + "blank.gif";
    protected String dbField;
    protected String question;
    protected String endQuestion;
    protected String helpText;
    boolean autoSubmitWhenFinishedWithThisQuestion = false;
    protected String type;
    public static final String[] FieldTypes = new String[]{"string", "number", "stringKey", "numberKey", "timezone", "timezoneKey", "datetime", "password", "passwordKey"};
    public static final boolean[] FieldTypeIsNumeric = new boolean[]{false, true, false, true, false, false, false, false, false};
    String defaultValue = "";
    Survey survey;
    int predictedNumberOfColumns = 0;
    int actualNumberOfColumns = 0;
    String bufferedOutput = "";
    String beginningOfTableBufferedOutput = "";
    public final String TIME_SPENT_JAVASCRIPT_1 = "set_elapsed_time(\\'document.form1.number_";
    public final String TIME_SPENT_JAVASCRIPT_2 = "_timeSpent\\');";

    public Question() {
    }

    public Question(Survey survey) {
        this.survey = survey;
        this.theConnection = survey;
        if (this.out == null) {
            this.out = survey.out;
        }
    }

    public void setDbField(String newDbField) {
        this.dbField = newDbField;
    }

    public String getDbField() {
        return this.dbField;
    }

    public void setQuestion(String questionText) {
        this.question = questionText;
    }

    public String getQuestion() {
        return this.question;
    }

    public void setEndQuestion(String endQ) {
        this.endQuestion = endQ;
    }

    public String getEndQuestion() {
        return this.endQuestion;
    }

    public void setHelpText(String theHelpHTML) {
        this.helpText = theHelpHTML;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public void setAutoSubmitWhenFinishedWithThisQuestion(boolean autoSubmit) {
        this.autoSubmitWhenFinishedWithThisQuestion = autoSubmit;
    }

    public boolean getAutoSubmitWhenFinishedWithThisQuestion() {
        return this.autoSubmitWhenFinishedWithThisQuestion;
    }

    public void setType(String newType) {
        boolean isValidType = false;
        if (newType != null) {
            int i = 0;
            while (i < FieldTypes.length) {
                if (newType.equalsIgnoreCase(FieldTypes[i])) {
                    isValidType = true;
                    break;
                }
                ++i;
            }
        }
        if (isValidType) {
            this.type = newType;
        } else {
            Maintenance.sendBug("In cmu.survey.Question.setType(), the type '" + newType + "' was not a valid type.\n" + "It was not one of the following types: \n" + "    number   (used for numbers in the database field '[fieldName]')\n" + "    string   (used for strings in the database field '[fieldName]')\n" + "    numberKey   (used for numbers that are keys/unique IDs in the database field '[fieldName]')\n" + "    stringKey   (used for strings that are keys/unique IDs in the database field '[fieldName]')\n" + "    timezone   (used for time zones)\n" + "    timezoneKey   (used for time zones that are keys/unique IDs)\n" + "    datetime   (used for date/time)\n");
        }
    }

    public String getType() {
        return this.type;
    }

    public boolean getTypeIsNumeric() {
        int i = 0;
        while (i < FieldTypes.length) {
            if (this.type.equalsIgnoreCase(FieldTypes[i])) {
                return FieldTypeIsNumeric[i];
            }
            ++i;
        }
        return false;
    }

    public String getFieldAndType() {
        return this.type + "_" + this.dbField;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValueInDB) {
        this.defaultValue = defaultValueInDB;
    }

    protected void setNumberOfColumns(int numColumns) {
        this.predictedNumberOfColumns = numColumns;
        if (this.endQuestion != null) {
            ++this.predictedNumberOfColumns;
        }
    }

    public String getExtraJavaScripts(boolean thisIsWrittenInJavaScript) {
        if (this.survey.getTimeResponses()) {
            String numberChecker;
            String string = numberChecker = this.getTypeIsNumeric() ? "return checkInputForNumbersOnly('document.form1.number_" + this.dbField + ";')" : "";
            if (numberChecker.length() > 0 && thisIsWrittenInJavaScript) {
                numberChecker = Survey.cleanStringValueForApostrophesOnly(numberChecker);
            }
            String inside = this.getTimeSpentInOnClickOrPressed(thisIsWrittenInJavaScript);
            return " onClick=\"" + inside + "\" onKeyPress=\"" + inside + numberChecker + "\"";
        }
        return "";
    }

    public String getTimeSpentInOnClickOrPressed(boolean thisIsWrittenInJavaScript) {
        if (this.survey.getTimeResponses()) {
            String barg = "set_elapsed_time('document.form1.number_" + this.dbField + "_timeSpent');";
            if (thisIsWrittenInJavaScript) {
                barg = Survey.cleanStringValueForApostrophesOnly(barg);
            }
            return barg;
        }
        return "";
    }

    public void initSurvey() {
        if (this.theConnection == null && this.survey != null) {
            this.theConnection = this.survey;
        }
        this.setupConnection();
        if (this.survey == null && this.theConnection instanceof Survey) {
            this.survey = (Survey)this.theConnection;
        }
    }

    public void print(String toPrint) {
        this.bufferedOutput = this.bufferedOutput + toPrint;
    }

    public void print(Object toPrint) {
        this.bufferedOutput = this.bufferedOutput + toPrint.toString();
    }

    public void flushBufferedPrint() {
        try {
            if (this.predictedNumberOfColumns != 0) {
                this.actualNumberOfColumns = this.predictedNumberOfColumns;
            }
            QuestionInfo lastQuestionInfo = this.survey.getLastQuestionInHistory();
            String addToFront = "";
            if (lastQuestionInfo != null) {
                addToFront = "</td></tr>\n";
                if (lastQuestionInfo.numberOfColumns != this.actualNumberOfColumns) {
                    addToFront = addToFront + "</table>\n" + this.beginningOfTableBufferedOutput;
                }
                addToFront = "<!--lastQuestionInfo.numberOfColumns=" + lastQuestionInfo.numberOfColumns + "  actualNumberOfColumns=" + this.actualNumberOfColumns + "-->" + addToFront;
            } else {
                addToFront = this.beginningOfTableBufferedOutput;
            }
            QuestionInfo questionInfo = new QuestionInfo(this.question, this.dbField, this.type, this.actualNumberOfColumns, this);
            this.survey.addQuestionInfoToHistory(questionInfo);
            this.out.print(addToFront + this.bufferedOutput + "<tr><td colspan=" + this.actualNumberOfColumns + ">\n");
            this.bufferedOutput = "";
        }
        catch (Throwable t) {
            Maintenance.sendBug(t);
        }
    }

    public int doStartTag() {
        try {
            this.initSurvey();
            this.doStartOfQuestion();
        }
        catch (Throwable e) {
            Maintenance.sendBug(e);
        }
        return 0;
    }

    public String getValueFromDB() {
        if (this.dbField == null || this.dbField.length() == 0) {
            return this.defaultValue;
        }
        String query = null;
        try {
            if (this.survey != null) {
                if (this.survey.getRetrieveValuesFromDB()) {
                    query = "SELECT " + this.dbField + " FROM " + this.survey.getTable();
                    if (this.survey.getWhere() != null) {
                        query = query + " WHERE " + this.survey.getWhere();
                    }
                    this.doQuery(query);
                    if (this.resultSet == null || this.resultSet.wasNull()) {
                        return this.defaultValue;
                    }
                    String result = null;
                    if (this.moveToNextRecord()) {
                        result = this.getField(this.dbField);
                    }
                    if (result == null || result.length() < 1) {
                        return this.defaultValue;
                    }
                    return result;
                }
                return this.defaultValue;
            }
            Maintenance.sendBug("In Question.getValueFromDB(), we couldn't find the survey!!  The databaseConnection we have is: " + this.databaseConnection);
        }
        catch (Throwable e) {
            Maintenance.sendBug("In Question.getValueFromDB():\nQuery=" + query + "\ndbField=" + this.dbField + "\nWe got an error.", e);
        }
        return this.defaultValue;
    }

    public void printTimeSpentField() {
        if (this.survey.getTimeResponses()) {
            try {
                this.print("<input type=\"hidden\" name=\"number_" + this.dbField + "_timeSpent\" value=\"0\">");
            }
            catch (Throwable e) {
                Maintenance.sendBug(e);
            }
        }
    }

    protected void doStartOfQuestion() throws IOException {
        if (this.survey.getCurrentBackgroundColor().equals(this.survey.getClearBackgroundColor()) || this.survey.getCurrentBackgroundColor().equals(this.survey.getBackgroundColor2())) {
            this.doStartOfQuestion(this.survey.getBackgroundColor1());
        } else {
            this.doStartOfQuestion(this.survey.getBackgroundColor2());
        }
    }

    protected void doStartOfQuestion(String backgroundColor) throws IOException {
        this.beginningOfTableBufferedOutput = "<table border=\"0\" width=\"100%\" cellpadding=\"4\">";
        this.print("<tr><td bgcolor=\"" + backgroundColor + "\"" + (this.survey.getPercentQuestion() > -1 ? " width=\"" + this.survey.getPercentQuestion() + "%\"" : "") + "><font size=\"" + this.survey.getFontSize() + "\" face=\"Arial\">");
        this.survey.setCurrentBackgroundColor(backgroundColor);
        ++this.actualNumberOfColumns;
    }

    protected void doMiddleOfQuestion() {
        try {
            this.print("</font></td><td bgcolor=\"" + this.survey.getCurrentBackgroundColor() + "\"><font size=\"" + this.survey.getFontSize() + "\" face=\"Arial\">");
            ++this.actualNumberOfColumns;
        }
        catch (Throwable e) {
            Maintenance.sendBug(e);
        }
    }

    protected void doEndOfQuestion() {
        try {
            if (this.endQuestion != null) {
                this.doMiddleOfQuestion();
                this.print(this.endQuestion);
            }
            if (this.helpText != null && this.helpText.length() > 0) {
                this.doMiddleOfQuestion();
                this.print("<a href=\"javascript:void(0);\" onClick=\"overlib('" + Survey.cleanStringValueForApostrophesOnly(this.helpText) + "', STICKY, CAPTION, 'Help', CLOSECLICK, LEFT, OFFSETX, -25, OFFSETY, -25, SNAPX, 5, SNAPY, 5);return false;\">?</a>");
            }
            this.print("</font></td></tr>");
        }
        catch (Throwable e) {
            Maintenance.sendBug(e);
        }
        this.flushBufferedPrint();
    }

    public void reinit() {
        super.reinit();
        this.defaultValue = "";
        this.dbField = null;
        this.endQuestion = null;
        this.question = null;
        this.type = null;
        this.actualNumberOfColumns = 0;
        this.predictedNumberOfColumns = 0;
        this.bufferedOutput = "";
        this.beginningOfTableBufferedOutput = "";
        this.helpText = null;
        this.autoSubmitWhenFinishedWithThisQuestion = false;
    }
}

