/*
 * Decompiled with CFR 0.152.
 */
package cmu.survey;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class Maintenance {
    protected static String[] EmailsToSendBugsTo;
    protected static String labelOfProgram;
    protected static String emailToSendBugFrom;
    protected static String smtpServer;
    protected static String debuggingOutputFileName;
    protected static File debuggingOutputFile;
    public static boolean SHOW_ERROR_MESSAGES;
    public static boolean EMAIL_ERROR_MESSAGES;
    public static boolean PRINT_ERROR_MESSAGES;
    public static boolean SAVE_ERROR_MESSAGES_TO_FILE;
    public static PrintStream errorOutputStream;
    static int numberOfCharactersToSave;
    static String latestOutput;

    public static void setLabelOfProgram(String label) {
        labelOfProgram = label;
    }

    public static void setEmailToSendBugsTo(String email) {
        EmailsToSendBugsTo = email == null ? null : new String[]{email};
    }

    public static void setDebuggingOutputFile(String fileName) {
        debuggingOutputFile = null;
        errorOutputStream = null;
        debuggingOutputFileName = fileName;
    }

    public static void setDebuggingOutputFile(File file) {
        debuggingOutputFileName = null;
        errorOutputStream = null;
        debuggingOutputFile = file;
    }

    public static void setSmtpServer(String server) {
        smtpServer = server;
    }

    public static Exception sendMail(String from, String[] to, String subject, String body) {
        Properties properties = new Properties();
        properties.put("mail.smtp.host", smtpServer);
        Session session = Session.getDefaultInstance((Properties)properties, null);
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(from));
            InternetAddress[] address = new InternetAddress[to.length];
            int i = 0;
            while (i < to.length) {
                address[i] = new InternetAddress(to[i]);
                ++i;
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])address);
            message.setSubject(subject);
            message.setSentDate(new Date());
            message.setText(body);
            Transport.send((Message)message);
            return null;
        }
        catch (MessagingException ex) {
            return ex;
        }
    }

    public static Exception sendBug(String errorMessage, Throwable exception) {
        return Maintenance.sendBug(errorMessage, "Bug!", exception);
    }

    public static String exceptionToString(Throwable exception) {
        String errorMessage = "";
        errorMessage = errorMessage + "Throwable: '" + exception + "'\n";
        errorMessage = errorMessage + "-------------------\n";
        if (exception == null) {
            exception = new Throwable("[NOTE: This is a fake exception to get the stack trace]");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(outputStream);
        exception.printStackTrace(printStream);
        ByteArrayInputStream byteInputStream = new ByteArrayInputStream(outputStream.toByteArray());
        InputStreamReader inputReader = new InputStreamReader(byteInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputReader);
        errorMessage = errorMessage + "### Throwable trail: ###\n";
        try {
            String blub = bufferedReader.readLine();
            while (blub != null) {
                errorMessage = errorMessage + blub + "\n";
                blub = bufferedReader.readLine();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        errorMessage = errorMessage + "### End exception trail ###\n";
        if (exception instanceof SQLException) {
            SQLException sqlE = (SQLException)exception;
            errorMessage = errorMessage + "ErrorCode: " + sqlE.getErrorCode() + "\n";
            errorMessage = errorMessage + "SQLState: " + sqlE.getSQLState() + "\n";
            if (sqlE.getNextException() != null) {
                errorMessage = errorMessage + "\n" + Maintenance.exceptionToString(sqlE.getNextException());
            }
        }
        return errorMessage;
    }

    public static String printSaveErrorMessageString(String errorMessage, Throwable exception) {
        String toReturn = ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n";
        toReturn = toReturn + "DATE: " + new Date() + "   [sendBug(message, exception)]" + "\n";
        toReturn = toReturn + errorMessage + "\n";
        toReturn = toReturn + Maintenance.exceptionToString(exception);
        toReturn = toReturn + "-------------------\nLast " + numberOfCharactersToSave + " characters of debugging output:\n";
        toReturn = toReturn + latestOutput + "\n";
        latestOutput = "";
        toReturn = toReturn + "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n";
        if (PRINT_ERROR_MESSAGES) {
            System.err.println(toReturn);
        }
        if (SAVE_ERROR_MESSAGES_TO_FILE) {
            Maintenance.saveDebugOutputToFile(toReturn);
        }
        return toReturn;
    }

    public static Exception sendBug(String errorMessage, String subject, Throwable exception) {
        errorMessage = labelOfProgram != null ? "Program: " + labelOfProgram + "\n" + errorMessage : "Program: unknown\n" + errorMessage;
        errorMessage = Maintenance.printSaveErrorMessageString(errorMessage, exception);
        if (EmailsToSendBugsTo == null || EmailsToSendBugsTo.length == 0) {
            Maintenance.printSaveErrorMessageString("The bug is not getting emailed, because there is no email set for sending bug reports to.  To set it, call cmu.survey.Maintenance.setEmailToSendBugsTo(String email).", null);
            return null;
        }
        if (EMAIL_ERROR_MESSAGES) {
            Exception e;
            if (emailToSendBugFrom == null) {
                try {
                    String hostName = InetAddress.getLocalHost().getHostName();
                    emailToSendBugFrom = hostName.indexOf(".") > 0 && hostName.length() - hostName.indexOf(".") > 1 ? "A_Bug@" + hostName : "A_Bug_" + hostName + "@VersionableStore.com";
                }
                catch (UnknownHostException e2) {
                    // empty catch block
                }
                if (emailToSendBugFrom == null) {
                    emailToSendBugFrom = "A_Bug@" + smtpServer;
                    System.out.println("!!! We could not send mail from the regular address. :(");
                }
                System.out.println("Registered email as: " + emailToSendBugFrom);
            }
            if ((e = Maintenance.sendMail(emailToSendBugFrom, EmailsToSendBugsTo, subject, errorMessage)) != null) {
                System.out.println("We got an exception in sending: " + e);
            }
            return e;
        }
        return null;
    }

    public static Exception sendBug(Object errorMessage) {
        if (errorMessage instanceof Throwable) {
            return Maintenance.sendBug(errorMessage.toString(), (Throwable)errorMessage);
        }
        Throwable exception = new Throwable("[NOTE: This is a fake exception to get the stack trace]");
        return Maintenance.sendBug(errorMessage.toString(), exception);
    }

    public static Exception sendBug(Throwable exception) {
        return Maintenance.sendBug("", exception);
    }

    public static Exception sendHackerError(String message, PageContext pageContext) {
        HttpServletRequest theRequest = null;
        if (pageContext != null) {
            theRequest = (HttpServletRequest)pageContext.getRequest();
        }
        String error = "Possible hacking attempt!\n";
        error = theRequest != null ? error + "Host: " + theRequest.getRemoteHost() + "\n" : error + "Host: unknown.\n";
        error = error + message + "\n";
        return Maintenance.sendBug(error + "\nBug! Hack attempt.");
    }

    public static void debugOutput(String output) {
        if (PRINT_ERROR_MESSAGES) {
            System.out.println(output);
        }
        if (SAVE_ERROR_MESSAGES_TO_FILE) {
            Maintenance.saveDebugOutputToFile(output);
        }
        if ((latestOutput = latestOutput + output + "\n").length() > numberOfCharactersToSave) {
            latestOutput = latestOutput.substring(latestOutput.length() - numberOfCharactersToSave);
        }
    }

    public static void saveDebugOutputToFile(String output) {
        if (errorOutputStream == null) {
            try {
                if (debuggingOutputFile != null) {
                    errorOutputStream = new PrintStream(new FileOutputStream(debuggingOutputFile, true));
                } else if (debuggingOutputFileName != null) {
                    errorOutputStream = new PrintStream(new FileOutputStream(debuggingOutputFileName, true));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (errorOutputStream != null) {
            errorOutputStream.println(output);
        }
    }

    public static String sendBugGetMessage(String errorMessage, Throwable exception) {
        Exception ex = null;
        if (EMAIL_ERROR_MESSAGES) {
            ex = Maintenance.sendBug(errorMessage, exception);
        }
        String toReturn = "";
        toReturn = ex == null && !SHOW_ERROR_MESSAGES ? "An error has occurred, and it was reported to the system administrator in an urgent email.  It will be fixed as soon as possible." : (ex != null ? (SHOW_ERROR_MESSAGES ? "[This error could not be sent because we got an error in emailing: " + ex.toString() + "]\n The error was: " + errorMessage.toString() : "An error occurred, which could not be automatically sent to the administrator (sorry!).  The error was: " + errorMessage.toString()) : "[SHOWING ERROR MESSAGES (change this in cmu.survey.Maintenance)]<br>\n" + errorMessage.toString());
        System.err.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        System.err.println("DATE: " + new Date() + "   [sendBugGetMessage()]");
        System.err.println(toReturn);
        System.err.println("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return toReturn;
    }

    public static String sendBugGetMessage(Object errorMessage) {
        if (errorMessage instanceof Throwable) {
            return Maintenance.sendBugGetMessage(errorMessage.toString(), (Throwable)errorMessage);
        }
        Throwable exception = new Throwable("[NOTE: This is a fake exception to get the stack trace]");
        return Maintenance.sendBugGetMessage(errorMessage.toString(), exception);
    }

    public static void setEmailToSendBugFrom(String email) {
        emailToSendBugFrom = email;
    }

    public static String getEmailToSendBugFrom() {
        return emailToSendBugFrom;
    }

    static {
        smtpServer = "smtp.andrew.cmu.edu";
        debuggingOutputFileName = "DebuggingOutputForWebapp.txt";
        debuggingOutputFile = null;
        SHOW_ERROR_MESSAGES = false;
        EMAIL_ERROR_MESSAGES = true;
        PRINT_ERROR_MESSAGES = true;
        SAVE_ERROR_MESSAGES_TO_FILE = true;
        numberOfCharactersToSave = 6000;
        latestOutput = "";
    }
}

