/*
 * Decompiled with CFR 0.152.
 */
package cmu.survey;

import cmu.survey.DatabaseConnection;
import cmu.survey.Maintenance;
import java.io.IOException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;

public class DatabaseList
extends TagSupport
implements TryCatchFinally {
    public ResultSet resultSet;
    public ResultSet auxResultSet;
    public JspWriter out = null;
    protected Connection databaseConnection;
    public String returnMessage = null;
    public Statement select;
    public static final SimpleDateFormat mysqlTF = new SimpleDateFormat("HH:mm:ss");
    public static final SimpleDateFormat mysqlDF = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat mysqlDTF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat msAccessDTF = new SimpleDateFormat("M/d/yyyy h:mm:ss a");
    public static final SimpleDateFormat msAccessDF = new SimpleDateFormat("M/d/yyyy");
    public static final SimpleDateFormat userViewableDTF = new SimpleDateFormat("M/d/yyyy h:mm:ss a");
    boolean sendErrorMessagesOnQueries = true;
    Throwable lastExceptionThrown = null;
    protected DatabaseConnection theConnection;
    boolean auxillaryQueryHasBeenCalled = false;
    String currentAuxRecord;
    protected String[] fieldsToShowArray;
    boolean saveAsSession = false;
    String startWith;
    String endWith;
    String linkTo;
    String fieldToPassInLink;
    private String[] fieldsToPass = null;
    String databaseQuery;
    String auxDatabaseQuery;
    public String field;
    public String queryObjectName;
    Hashtable recordFields;
    String optionTag;
    public static final SimpleDateFormat timeFormatAmerican = new SimpleDateFormat("h:mm a");
    public static final SimpleDateFormat dateFormatAmerican = new SimpleDateFormat("MM/dd/yyyy");
    public static final SimpleDateFormat dateTimeFormatAmerican = new SimpleDateFormat("MM/dd/yyyy h:mm a");
    String emailDomain = null;
    TimeZone thisTimeZone;
    public static boolean debug = true;
    static /* synthetic */ Class class$cmu$survey$DatabaseConnection;

    public void setSendErrorMessages(boolean emailTheErrorMessages) {
        this.sendErrorMessagesOnQueries = emailTheErrorMessages;
    }

    public boolean getSendErrorMessages() {
        return this.sendErrorMessagesOnQueries;
    }

    public Throwable getLastExceptionThrown() {
        return this.lastExceptionThrown;
    }

    public String formatDateSQL(Date theDate) {
        String returnDate = new String();
        try {
            if (this.theConnection.getDatabaseType() == this.theConnection.MYSQL) {
                returnDate = "'" + mysqlDF.format(theDate) + "'";
            } else if (this.theConnection.getDatabaseType() == this.theConnection.MS_ACCESS) {
                returnDate = "CDate('" + msAccessDF.format(theDate) + "')";
            }
        }
        catch (Throwable e) {
            this.returnMessage = "An error has occured when processing the DateTime " + theDate;
            this.saveErrorMessage(this.returnMessage, e);
        }
        return returnDate;
    }

    public String formatDateMySQL(String currentString, DateFormat currentFormat) {
        String returnDate = new String();
        try {
            SimpleDateFormat newFormat;
            Date theDate = currentFormat.parse(currentString);
            if (theDate.getYear() < 1000 && theDate.getYear() != 0 && currentFormat instanceof SimpleDateFormat && (newFormat = (SimpleDateFormat)currentFormat).toPattern().equals("MM/dd/yyyy")) {
                newFormat.applyPattern("MM/dd/yy");
                theDate = newFormat.parse(currentString);
            }
            returnDate = mysqlDF.format(theDate);
        }
        catch (ParseException pe) {
            this.returnMessage = "There was an error parsing the time: " + currentString;
            this.saveErrorMessage(this.returnMessage, pe);
            System.out.println(this.returnMessage);
        }
        catch (Throwable e) {
            this.returnMessage = "An error has occured when processing the time " + currentString;
            this.saveErrorMessage(this.returnMessage, e);
            System.out.println(this.returnMessage);
        }
        if (returnDate != null) {
            returnDate = returnDate.substring(returnDate.indexOf(" ") + 1);
            return returnDate;
        }
        return null;
    }

    public String formatTimeMySQL(String currentString, DateFormat currentFormat) {
        String returnDate = new String();
        try {
            SimpleDateFormat newFormat;
            Date theDate = currentFormat.parse(currentString);
            if (theDate.getYear() < 1000 && theDate.getYear() != 0 && currentFormat instanceof SimpleDateFormat && (newFormat = (SimpleDateFormat)currentFormat).toPattern().equals("MM/dd/yyyy")) {
                newFormat.applyPattern("MM/dd/yy");
                theDate = newFormat.parse(currentString);
                this.saveErrorMessage("Don't delete this section in DatabaseUpdate.formatTimeMySQL (part 2) -- it still gets used!");
            }
            returnDate = mysqlTF.format(theDate);
        }
        catch (ParseException pe) {
            this.returnMessage = "There was an error parsing the time: " + currentString;
            this.saveErrorMessage(this.returnMessage, pe);
            System.out.println(this.returnMessage);
        }
        catch (Throwable e) {
            this.returnMessage = "An error has occured when processing the time " + currentString;
            this.saveErrorMessage(this.returnMessage, e);
            System.out.println(this.returnMessage);
        }
        if (returnDate != null) {
            returnDate = returnDate.substring(returnDate.indexOf(" ") + 1);
            return returnDate;
        }
        return null;
    }

    public String formatDateTimeSQL(Date theDate) {
        String returnDate = new String();
        try {
            if (this.theConnection.getDatabaseType() == this.theConnection.MYSQL) {
                returnDate = "'" + mysqlDTF.format(theDate) + "'";
            } else if (this.theConnection.getDatabaseType() == this.theConnection.MS_ACCESS) {
                returnDate = "CDate('" + msAccessDTF.format(theDate) + "')";
            }
        }
        catch (Throwable e) {
            this.returnMessage = "An error has occured when processing the DateTime " + theDate;
            this.saveErrorMessage(this.returnMessage, e);
        }
        return returnDate;
    }

    public String formatDateTimeSQL(String currentString, DateFormat currentFormat) {
        String returnDate = new String();
        try {
            SimpleDateFormat newFormat;
            Date theDate = currentFormat.parse(currentString);
            if (theDate.getYear() < 1000 && theDate.getYear() != 0 && currentFormat instanceof SimpleDateFormat && (newFormat = (SimpleDateFormat)currentFormat).toPattern().equals("MM/dd/yyyy")) {
                newFormat.applyPattern("MM/dd/yy");
                theDate = newFormat.parse(currentString);
            }
            returnDate = this.formatDateTimeSQL(theDate);
        }
        catch (ParseException pe) {
            this.returnMessage = "There was an error parsing the time: " + currentString;
            this.saveErrorMessage(this.returnMessage, pe);
            System.out.println(this.returnMessage);
        }
        catch (Throwable e) {
            this.returnMessage = "An error has occured when processing the time " + currentString;
            this.saveErrorMessage(this.returnMessage, e);
            System.out.println(this.returnMessage);
        }
        return returnDate;
    }

    public String formatDateSQLFromHTML(String currentString) {
        return this.formatDateMySQL(currentString, dateFormatAmerican);
    }

    public void setupConnection(DatabaseConnection theNewConnection) {
        this.theConnection = theNewConnection;
        try {
            if (this.pageContext != null) {
                this.out = this.pageContext.getOut();
            }
            this.databaseConnection = theNewConnection.getConnect();
        }
        catch (Exception ex) {
            String errorMessage = "Exception thrown getting list from database: " + ex;
            System.out.println(errorMessage);
            ex.printStackTrace();
            this.saveErrorMessage(errorMessage, ex);
        }
    }

    public void setupConnection() {
        try {
            if (this.pageContext != null) {
                this.out = this.pageContext.getOut();
            }
            if (this.theConnection == null || this.databaseConnection == null) {
                if (this.theConnection == null) {
                    this.theConnection = (DatabaseConnection)TagSupport.findAncestorWithClass((Tag)this, (Class)(class$cmu$survey$DatabaseConnection == null ? (class$cmu$survey$DatabaseConnection = DatabaseList.class$("cmu.survey.DatabaseConnection")) : class$cmu$survey$DatabaseConnection));
                }
                if (this.theConnection == null) {
                    this.saveErrorMessage("When using a database tag, you must put it inside a <court:DatabaseConnection> tag or inside a <survey:Survey> tag to connect to the database and specify which database to connect to!");
                    return;
                }
                this.databaseConnection = this.theConnection.getConnect();
            }
        }
        catch (Exception ex) {
            String errorMessage = "Exception thrown getting list from database: " + ex;
            ex.printStackTrace();
            this.saveErrorMessage(errorMessage, ex);
        }
    }

    public void doQuery() {
        this.doQuery(this.databaseQuery);
    }

    public void doQuery(String aDatabaseQuery) {
        try {
            if (debug) {
                Maintenance.debugOutput("DatabaseList.doQuery(" + aDatabaseQuery + "):");
            }
            this.databaseQuery = aDatabaseQuery;
            Statement statement = this.theConnection.getConnect().createStatement();
            boolean hasResultSet = statement.execute(this.databaseQuery);
            SQLWarning warn = statement.getWarnings();
            if (warn != null) {
                Maintenance.sendBug(warn);
            }
            if (!hasResultSet) {
                this.resultSet = null;
                Maintenance.debugOutput("DatabaseList.doQuery(): Number of records updated: " + statement.getUpdateCount());
                statement.close();
                return;
            }
            this.resultSet = statement.getResultSet();
            this.close();
            this.select = statement;
        }
        catch (SQLException sqle) {
            String errorMessageAux = "<br>There has been a database error.  Please report the following error to the system administrator to have it fixed:<br>SQL error code \"" + sqle.getErrorCode() + "\"\n" + "databaseConnection=" + this.databaseConnection + "\n" + "select=" + this.select + "\n" + "databaseConnection.isClosed()=";
            try {
                errorMessageAux = errorMessageAux + this.databaseConnection.isClosed();
            }
            catch (SQLException sqle2) {
                errorMessageAux = errorMessageAux + "Error on call: " + sqle2;
            }
            this.saveErrorMessage("In cmu.survey.DatabaseList.doQuery(\"" + aDatabaseQuery + "\") [part A], \n" + errorMessageAux, sqle);
        }
        catch (Exception ex) {
            String errorMessage = "<br>There has been a database error.  Please report the following error to the system administrator to have it fixed:<br>Error excecuting the database Query of \"" + this.databaseQuery + "\"" + ex;
            this.saveErrorMessage("In cmu.survey.DatabaseList.doQuery(\"" + aDatabaseQuery + "\") [part B], \nStep 1b\n" + errorMessage, ex);
        }
    }

    public void doAuxillaryQuery(String auxillaryDatabaseQuery) {
        try {
            this.auxDatabaseQuery = auxillaryDatabaseQuery;
            this.currentAuxRecord = null;
            Statement statement = this.databaseConnection.createStatement();
            this.auxResultSet = statement.executeQuery(auxillaryDatabaseQuery);
        }
        catch (Exception ex) {
            String errorMessage = "Error excecuting the database Query of \"" + auxillaryDatabaseQuery + "\"" + ex;
            this.saveErrorMessage("In cmu.survey.DatabaseList.doAuxillaryQuery(\"" + auxillaryDatabaseQuery + "\"), \n" + errorMessage, ex);
        }
    }

    public boolean isCurrentItemInAuxQuery(String identifierField) {
        if (this.auxDatabaseQuery == null || this.auxDatabaseQuery.equalsIgnoreCase("null") || this.auxDatabaseQuery.length() == 0) {
            return false;
        }
        if (!this.auxillaryQueryHasBeenCalled && this.auxDatabaseQuery != null && !this.auxDatabaseQuery.equalsIgnoreCase("null")) {
            this.doAuxillaryQuery(this.auxDatabaseQuery);
            this.auxillaryQueryHasBeenCalled = true;
        }
        try {
            if (this.auxResultSet != null) {
                if (this.currentAuxRecord == null) {
                    if (this.auxResultSet.next()) {
                        this.currentAuxRecord = this.auxResultSet.getString(identifierField);
                    } else {
                        return false;
                    }
                }
                if (this.currentAuxRecord.equals(this.getField(identifierField))) {
                    this.currentAuxRecord = null;
                    return true;
                }
                return false;
            }
            String errorMessage = "Programmer error: Option set cannot be printed without an auxillary query string -- it is needed to determine what is selected and what isn't!\ndatabaseQuery = " + this.databaseQuery + "\n" + "auxDatabaseQuery = " + this.auxDatabaseQuery + "\n" + "(auxDatabaseQuery == null) = " + (this.auxDatabaseQuery == null) + "\n" + "(Error in DatabaseList.isCurrentStringInAuxQuery())";
            this.saveErrorMessage("In cmu.survey.DatabaseList.isCurrentItemInAuxQuery(\"" + identifierField + "\"), \n" + errorMessage);
        }
        catch (Throwable ex) {
            String errorMessage = "Programmer error in DatabseList.isCurrentItemInAuxQuery() with the identifierField of  " + identifierField;
            this.saveErrorMessage("In cmu.survey.DatabaseList.isCurrentItemInAuxQuery(\"" + identifierField + "\"), \n" + errorMessage, ex);
        }
        return false;
    }

    public String getField(String fieldName) {
        String fieldValue = null;
        if (this.recordFields == null) {
            this.recordFields = new Hashtable();
        } else {
            fieldValue = (String)this.recordFields.get(fieldName);
        }
        if (fieldValue != null) {
            return fieldValue;
        }
        try {
            if (this.resultSet == null) {
                String errorMessage = "Programmer error:  cmu.survey.DatabaseList.getField(\"" + fieldName + "\") was called before the query was executed on the database.";
                this.saveErrorMessage("In cmu.survey.DatabaseList.getField(\"" + fieldName + "\"), \n\ndatabaseQuery=" + this.databaseQuery + "\nqueryObjectName=" + this.queryObjectName + "\n" + errorMessage);
            } else {
                fieldValue = this.resultSet.getString(fieldName);
            }
            if (fieldValue != null) {
                this.recordFields.put(fieldName, fieldValue);
            }
        }
        catch (Exception ex) {
            String errorMessage = "Error with the SQL Query for getting the value of " + fieldName + ": " + ex;
            this.saveErrorMessage("In cmu.survey.DatabaseList.getField(\"" + fieldName + "\"), \n\ndatabaseQuery=" + this.databaseQuery + "\nqueryObjectName=" + this.queryObjectName + "\n" + errorMessage, ex);
        }
        if (fieldValue != null) {
            return fieldValue;
        }
        return "";
    }

    public void resetFieldsForNextRecord() {
        this.recordFields = null;
    }

    public boolean moveToNextRecord() {
        try {
            this.resetFieldsForNextRecord();
            if (this.resultSet == null) {
                return false;
            }
            return this.resultSet.next();
        }
        catch (Exception e) {
            this.saveErrorMessage("Could not move to next reccord: resultSet=" + this.resultSet, e);
            return false;
        }
    }

    public boolean moveToNextAuxillaryRecord() {
        try {
            if (this.auxResultSet == null || this.auxResultSet.wasNull()) {
                return false;
            }
            return this.auxResultSet.next();
        }
        catch (Exception e) {
            this.saveErrorMessage("Could not move to next reccord: resultSet=" + this.resultSet, e);
            return false;
        }
    }

    public void printField(String fieldToShow) {
        try {
            this.doQuery();
            if (this.resultSet.next()) {
                this.out.print(this.getField(fieldToShow));
            }
        }
        catch (Exception ex) {
            try {
                String errorMessage = "In cmu.survey.DatabaseList.printField(\"" + fieldToShow + "\"), \n" + "Error printing the value of " + fieldToShow + ": " + ex;
                this.saveErrorMessage(errorMessage, ex);
                this.out.print(Maintenance.sendBugGetMessage(errorMessage, ex));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Vector getFields() {
        Vector<String> returnStrings = new Vector<String>();
        try {
            ResultSetMetaData metaData = this.resultSet.getMetaData();
            int columns = metaData.getColumnCount();
            if (debug) {
                Maintenance.debugOutput("-DatabaseList.getFields(): columns to print: " + columns);
            }
            int i = 1;
            while (i <= columns) {
                String field = metaData.getColumnLabel(i);
                String theFieldData = this.getField(field);
                returnStrings.add(theFieldData);
                if (debug) {
                    Maintenance.debugOutput("--DatabaseList.getFields(): theFieldData[" + i + "]: " + theFieldData);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            String errorMessage = "Error in DatabaseList.getFields(): " + ex;
            errorMessage = errorMessage + "\nreturnStrings so far: " + returnStrings;
            this.saveErrorMessage(errorMessage, ex);
        }
        return returnStrings;
    }

    protected static String[] breakDownToArray(String fieldsToShow) {
        StringTokenizer st = new StringTokenizer(fieldsToShow, ",");
        String[] fieldsToShowArray = new String[st.countTokens()];
        int i = 0;
        while (i < fieldsToShowArray.length) {
            fieldsToShowArray[i] = st.nextToken();
            while (fieldsToShowArray[i].startsWith(" ")) {
                fieldsToShowArray[i] = fieldsToShowArray[i].substring(1);
            }
            while (fieldsToShowArray[i].endsWith(" ")) {
                fieldsToShowArray[i] = fieldsToShowArray[i].substring(0, fieldsToShowArray[i].length() - 1);
            }
            ++i;
        }
        return fieldsToShowArray;
    }

    public Vector getFields(String fieldsToShow) {
        if (this.fieldsToShowArray == null) {
            this.fieldsToShowArray = DatabaseList.breakDownToArray(fieldsToShow);
        }
        Vector<String> returnStrings = new Vector<String>();
        try {
            ResultSetMetaData metaData = this.resultSet.getMetaData();
            int columns = metaData.getColumnCount();
            int i = 1;
            while (i <= columns) {
                boolean isInPrintList = false;
                int f = 0;
                while (f < this.fieldsToShowArray.length && !isInPrintList) {
                    if (this.fieldsToShowArray[f].equalsIgnoreCase(metaData.getColumnLabel(i)) || this.fieldsToShowArray[f].equalsIgnoreCase(metaData.getColumnName(i)) || this.fieldsToShowArray[f].equals("*")) {
                        isInPrintList = true;
                    }
                    ++f;
                }
                if (!isInPrintList) {
                    int f2 = 0;
                    while (f2 < this.fieldsToShowArray.length && !isInPrintList) {
                        int asLoc = 1;
                        while (asLoc >= 0 && !isInPrintList) {
                            String asColumnName;
                            asLoc = this.fieldsToShowArray[f2].toUpperCase().indexOf("AS ", asLoc + 1);
                            if (asLoc == -1 || !(asColumnName = this.fieldsToShowArray[f2].substring(asLoc + 3)).equalsIgnoreCase(metaData.getColumnLabel(i)) && !asColumnName.equalsIgnoreCase(metaData.getColumnName(i))) continue;
                            isInPrintList = true;
                        }
                        int periodLoc = 1;
                        while (periodLoc >= 0 && !isInPrintList) {
                            String asColumnName;
                            periodLoc = this.fieldsToShowArray[f2].toUpperCase().indexOf(".", periodLoc + 1);
                            if (periodLoc == -1 || !(asColumnName = this.fieldsToShowArray[f2].substring(periodLoc + 1)).equalsIgnoreCase(metaData.getColumnLabel(i)) && !asColumnName.equalsIgnoreCase(metaData.getColumnName(i))) continue;
                            isInPrintList = true;
                        }
                        ++f2;
                    }
                }
                if (isInPrintList) {
                    String theFieldData = this.getField(metaData.getColumnLabel(i));
                    returnStrings.add(theFieldData);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            String errorMessage = "Error in DatabaseList.getFields(" + fieldsToShow + "): " + ex;
            errorMessage = errorMessage + "\nreturnStrings so far: " + returnStrings;
            this.saveErrorMessage(errorMessage, ex);
        }
        return returnStrings;
    }

    public String returnOneLine(String fieldsToShow) {
        String returnString = "";
        try {
            if (this.linkTo != null) {
                returnString = returnString + "<a href=\"" + this.linkTo;
                if (this.fieldToPassInLink != null) {
                    returnString = returnString + "?";
                    if (this.fieldsToPass != null) {
                        int i = 0;
                        while (i < this.fieldsToPass.length) {
                            if (i != 0) {
                                returnString = returnString + "&";
                            }
                            returnString = returnString + this.fieldsToPass[i] + "=" + URLEncoder.encode(this.getField(this.fieldsToPass[i]));
                            ++i;
                        }
                    } else {
                        returnString = returnString + this.fieldToPassInLink + "=" + this.getField(this.fieldToPassInLink);
                    }
                }
                returnString = returnString + " \">";
            }
            if (this.optionTag != null) {
                returnString = returnString + "<option value=\"" + this.getField(this.fieldToPassInLink) + "\"";
                if (this.isCurrentItemInAuxQuery(this.fieldToPassInLink)) {
                    returnString = returnString + " selected ";
                }
                returnString = returnString + ">";
            }
            Vector strings = this.getFields(fieldsToShow);
            int i = 0;
            while (i < strings.size()) {
                returnString = returnString + strings.get(i).toString() + ", ";
                ++i;
            }
            returnString = returnString.substring(0, returnString.length() - 2);
            if (this.optionTag != null) {
                returnString = returnString + "</option>";
            }
            if (this.linkTo != null) {
                returnString = returnString + "</a>";
            }
        }
        catch (Exception ex) {
            String errorMessage = "Error in DatabaseList.returnOneLine(), printing " + fieldsToShow + ": " + ex;
            this.saveErrorMessage(errorMessage, ex);
        }
        return returnString;
    }

    public String getOneLine(String fieldToShow) {
        String oneLine = "";
        if (this.startWith != null) {
            oneLine = oneLine + this.startWith;
        }
        String theValue = this.returnOneLine(fieldToShow);
        oneLine = oneLine + theValue;
        if (this.saveAsSession) {
            String attribute = (String)this.theConnection.getSession().getAttribute(fieldToShow);
            if (attribute == null || attribute.length() == 0) {
                this.theConnection.getSession().setAttribute(fieldToShow, (Object)theValue);
            } else {
                this.theConnection.getSession().setAttribute(fieldToShow, (Object)(attribute + ", " + theValue));
            }
        }
        if (this.endWith != null) {
            oneLine = oneLine + this.endWith;
        }
        return oneLine;
    }

    public void printOneLine(String fieldToShow) {
        try {
            this.out.print(this.getOneLine(fieldToShow));
        }
        catch (Exception ex) {
            String errorMessage = "Error in DatabaseList.printOneLine(), printing " + fieldToShow + ": " + ex;
            this.saveErrorMessage(errorMessage);
        }
    }

    public void setSaveAsSession(boolean saveIntoSessionVariable) {
        this.saveAsSession = saveIntoSessionVariable;
    }

    public boolean getSaveAsSession() {
        return this.saveAsSession;
    }

    public String getList(String fieldToShow) {
        String list = "";
        try {
            if (this.saveAsSession) {
                this.theConnection.getSession().setAttribute(fieldToShow, (Object)"");
            }
            int numPrinted = 0;
            while (this.resultSet.next()) {
                this.resetFieldsForNextRecord();
                ++numPrinted;
                list = list + this.getOneLine(fieldToShow);
            }
        }
        catch (SQLException sqle) {
            String errorMessage = "In cmu.survey.DatabaseList.printList(\"" + fieldToShow + "\"), error with the SQL Query for getting the list of " + fieldToShow + ": " + sqle;
            this.saveErrorMessage(errorMessage);
        }
        return list;
    }

    public void printList(String fieldToShow) {
        try {
            this.out.print(this.getList(fieldToShow));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int doStartTag() {
        this.setupConnection();
        if (this.databaseQuery != null && this.field != null) {
            this.doQuery(this.databaseQuery);
            this.printList(this.field);
        }
        return 0;
    }

    public int doEndTag() {
        this.reinit();
        return 6;
    }

    public void setStartWith(String value) {
        this.startWith = value;
    }

    public void setEndWith(String value) {
        this.endWith = value;
    }

    public void setLinkTo(String value) {
        this.linkTo = value;
    }

    public String getLinkTo() {
        return this.linkTo;
    }

    public void setFieldToPassInLink(String value) {
        this.fieldToPassInLink = value;
        StringTokenizer st = new StringTokenizer(value, ", ");
        if (st.hasMoreTokens()) {
            this.fieldsToPass = new String[st.countTokens()];
            int arr_count = 0;
            while (st.hasMoreTokens()) {
                this.fieldsToPass[arr_count] = st.nextToken();
                ++arr_count;
            }
        }
    }

    public String getFieldToPassInLink() {
        return this.fieldToPassInLink;
    }

    public String getStartWith() {
        return this.startWith;
    }

    public String getEndWith() {
        return this.endWith;
    }

    public void setDatabaseQuery(String value) {
        this.databaseQuery = value;
    }

    public String getDatabaseQuery() {
        return this.databaseQuery;
    }

    public void setAuxDatabaseQuery(String value) {
        this.auxDatabaseQuery = value;
    }

    public String getAuxDatabaseQuery() {
        return this.auxDatabaseQuery;
    }

    public void setField(String value) {
        this.field = value;
    }

    public String getField() {
        return this.field;
    }

    public void setQueryObjectName(String value) {
        this.queryObjectName = value;
    }

    public String getQueryObjectName() {
        return this.queryObjectName;
    }

    public void setOptionTag(String value) {
        this.optionTag = value;
    }

    public String getOptionTag() {
        return this.optionTag;
    }

    public void close() {
        if (this.select != null) {
            try {
                this.select.close();
            }
            catch (SQLException e) {
                Maintenance.sendBug(e);
            }
            this.select = null;
        }
    }

    public void doCatch(Throwable throwable) {
        Maintenance.sendBug("In DatabaseList.doCatch() ***Note: doCatch is getting called!", throwable);
    }

    public void doFinally() {
        Maintenance.debugOutput("******** DatabaseList.doFinally() called **************");
        this.reinit();
    }

    public void reinit() {
        this.auxResultSet = null;
        this.resultSet = null;
        this.fieldToPassInLink = null;
        this.linkTo = null;
        this.endWith = null;
        this.startWith = null;
        this.field = null;
        this.auxDatabaseQuery = null;
        this.databaseQuery = null;
        this.optionTag = null;
        this.databaseConnection = null;
        this.auxillaryQueryHasBeenCalled = false;
        this.emailDomain = null;
        this.resetFieldsForNextRecord();
        this.saveAsSession = false;
        this.thisTimeZone = null;
        this.returnMessage = null;
        this.fieldsToShowArray = null;
        this.close();
    }

    public String getUsersEmail(String userID) {
        try {
            if (this.emailDomain == null) {
                this.doQuery("SELECT * FROM tbladmin");
                if (this.moveToNextRecord()) {
                    this.emailDomain = this.getField("DefaultEmailDomain");
                }
            }
            return this.getUsersEmail(userID, this.emailDomain);
        }
        catch (Throwable e) {
            this.saveErrorMessage("resultSet=" + this.resultSet, e);
            return null;
        }
    }

    public String getUsersEmail(String userID, String emailDomain) {
        try {
            if (userID.indexOf("@") == -1) {
                String auxillaryQuery = "SELECT tblguestuser.Email FROM tblguestuser WHERE tblguestuser.UserID=\"" + userID + "\"";
                this.doAuxillaryQuery(auxillaryQuery);
                if (this.auxResultSet.next()) {
                    userID = this.auxResultSet.getString("Email");
                    if (userID == null || userID.equals("")) {
                        return null;
                    }
                    if (userID.indexOf("@") == -1 && emailDomain != null) {
                        userID = userID + "@" + emailDomain;
                    }
                } else {
                    userID = userID + (emailDomain == null ? "" : "@" + emailDomain);
                }
            }
        }
        catch (Exception e) {
            userID = userID + (emailDomain == null ? "" : "@" + emailDomain);
        }
        return userID;
    }

    public Calendar getCalendar() {
        if (this.thisTimeZone == null) {
            TimeZone timeZone = null;
            try {
                String timeZoneID;
                String auxillaryQuery = "SELECT TimeZone FROM tbladmin";
                this.doAuxillaryQuery(auxillaryQuery);
                if (this.auxResultSet.next() && (timeZoneID = this.auxResultSet.getString("TimeZone")) != null && timeZoneID.length() > 0) {
                    timeZone = TimeZone.getTimeZone(timeZoneID);
                    TimeZone.setDefault(timeZone);
                    mysqlDF.setTimeZone(timeZone);
                    mysqlTF.setTimeZone(timeZone);
                    mysqlDTF.setTimeZone(timeZone);
                    msAccessDF.setTimeZone(timeZone);
                    msAccessDTF.setTimeZone(timeZone);
                    timeFormatAmerican.setTimeZone(timeZone);
                    dateFormatAmerican.setTimeZone(timeZone);
                    dateTimeFormatAmerican.setTimeZone(timeZone);
                }
            }
            catch (Exception e) {
                this.saveErrorMessage("Couldn't create new calendar.", e);
            }
            this.thisTimeZone = timeZone != null ? timeZone : TimeZone.getDefault();
        }
        Calendar nowCalendar = Calendar.getInstance();
        if (debug) {
            Maintenance.debugOutput("DatabaseList.getCalendar(): Current time: " + nowCalendar.getTime());
        }
        return nowCalendar;
    }

    public Date getDate(Calendar calendar) {
        return calendar.getTime();
    }

    public Date getDate() {
        Date date = this.getDate(this.getCalendar());
        if (debug) {
            Maintenance.debugOutput("DatabaseList.getDate(): " + date);
        }
        return date;
    }

    protected void saveErrorMessage(String error, Throwable e) {
        this.lastExceptionThrown = e;
        if (this.sendErrorMessagesOnQueries) {
            Maintenance.sendBug(error, e);
        } else {
            Maintenance.printSaveErrorMessageString(error, e);
            Maintenance.debugOutput("*****************");
            Maintenance.debugOutput(error);
            Maintenance.debugOutput("*****************");
        }
    }

    protected void saveErrorMessage(String error) {
        if (this.sendErrorMessagesOnQueries) {
            Maintenance.sendBug(error);
        } else {
            Maintenance.printSaveErrorMessageString(error, null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

