/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.ui.about;

import com.jrefinery.ui.SortableTableModel;
import com.jrefinery.ui.about.SystemProperty;
import com.jrefinery.ui.about.SystemPropertyComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

public class SystemPropertiesTableModel
extends SortableTableModel {
    protected List properties = new ArrayList();
    protected String nameColumnLabel;
    protected String valueColumnLabel;

    public SystemPropertiesTableModel() {
        Properties p = System.getProperties();
        Iterator<Object> iterator = p.keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            String value = System.getProperty(name);
            SystemProperty sp = new SystemProperty(name, value);
            this.properties.add(sp);
        }
        Collections.sort(this.properties, new SystemPropertyComparator(true));
        String baseName = "com.jrefinery.ui.about.resources.AboutResources";
        ResourceBundle resources = ResourceBundle.getBundle(baseName);
        this.nameColumnLabel = resources.getString("system-properties-table.column.name");
        this.valueColumnLabel = resources.getString("system-properties-table.column.value");
    }

    public boolean isSortable(int columnIndex) {
        return columnIndex == 0;
    }

    public int getRowCount() {
        return this.properties.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return this.nameColumnLabel;
        }
        return this.valueColumnLabel;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        SystemProperty sp = (SystemProperty)this.properties.get(rowIndex);
        if (columnIndex == 0) {
            return sp.getName();
        }
        if (columnIndex == 1) {
            return sp.getValue();
        }
        return null;
    }

    public void sortByColumn(int column, boolean ascending) {
        if (this.isSortable(column)) {
            this.sortingColumn = column;
            Collections.sort(this.properties, new SystemPropertyComparator(ascending));
        }
    }
}

