/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.ui.about;

import com.jrefinery.ui.about.Library;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;

public class LibraryTableModel
extends AbstractTableModel {
    protected List libraries;
    protected String nameColumnLabel;
    protected String versionColumnLabel;
    protected String licenceColumnLabel;
    protected String infoColumnLabel;

    public LibraryTableModel(List libraries) {
        this.libraries = libraries;
        String baseName = "com.jrefinery.ui.about.resources.AboutResources";
        ResourceBundle resources = ResourceBundle.getBundle(baseName);
        this.nameColumnLabel = resources.getString("libraries-table.column.name");
        this.versionColumnLabel = resources.getString("libraries-table.column.version");
        this.licenceColumnLabel = resources.getString("libraries-table.column.licence");
        this.infoColumnLabel = resources.getString("libraries-table.column.info");
    }

    public int getRowCount() {
        return this.libraries.size();
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int column) {
        String result = null;
        switch (column) {
            case 0: {
                result = this.nameColumnLabel;
                break;
            }
            case 1: {
                result = this.versionColumnLabel;
                break;
            }
            case 2: {
                result = this.licenceColumnLabel;
                break;
            }
            case 3: {
                result = this.infoColumnLabel;
            }
        }
        return result;
    }

    public Object getValueAt(int row, int column) {
        String result = null;
        Library library = (Library)this.libraries.get(row);
        if (column == 0) {
            result = library.getName();
        } else if (column == 1) {
            result = library.getVersion();
        } else if (column == 2) {
            result = library.getLicence();
        } else if (column == 3) {
            result = library.getInfo();
        }
        return result;
    }
}

