/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.ui;

import com.jrefinery.ui.BevelArrowIcon;
import com.jrefinery.ui.SortableTableModel;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class SortButtonRenderer
implements TableCellRenderer {
    public static final int NONE = 0;
    public static final int DOWN = 1;
    public static final int UP = 2;
    protected int pressedColumn = -1;
    JButton normalButton = new JButton();
    JButton ascendingButton;
    JButton descendingButton;

    public SortButtonRenderer() {
        this.normalButton.setMargin(new Insets(0, 0, 0, 0));
        this.normalButton.setHorizontalAlignment(10);
        this.ascendingButton = new JButton();
        this.ascendingButton.setMargin(new Insets(0, 0, 0, 0));
        this.ascendingButton.setHorizontalAlignment(10);
        this.ascendingButton.setHorizontalTextPosition(2);
        this.ascendingButton.setIcon(new BevelArrowIcon(1, false, false));
        this.ascendingButton.setPressedIcon(new BevelArrowIcon(1, false, true));
        this.descendingButton = new JButton();
        this.descendingButton.setMargin(new Insets(0, 0, 0, 0));
        this.descendingButton.setHorizontalAlignment(10);
        this.descendingButton.setHorizontalTextPosition(2);
        this.descendingButton.setIcon(new BevelArrowIcon(0, false, false));
        this.descendingButton.setPressedIcon(new BevelArrowIcon(0, false, true));
        Border border = UIManager.getBorder("TableHeader.cellBorder");
        this.normalButton.setBorder(border);
        this.ascendingButton.setBorder(border);
        this.descendingButton.setBorder(border);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader header;
        SortableTableModel model;
        JButton button = this.normalButton;
        int cc = table.convertColumnIndexToModel(column);
        if (table != null && (model = (SortableTableModel)table.getModel()).getSortingColumn() == cc) {
            button = model.getAscending() ? this.ascendingButton : this.descendingButton;
        }
        if ((header = table.getTableHeader()) != null) {
            button.setForeground(header.getForeground());
            button.setBackground(header.getBackground());
            button.setFont(header.getFont());
        }
        button.setText(value == null ? "" : value.toString());
        boolean isPressed = cc == this.pressedColumn;
        button.getModel().setPressed(isPressed);
        button.getModel().setArmed(isPressed);
        return button;
    }

    public void setPressedColumn(int column) {
        this.pressedColumn = column;
    }

    static {
        NONE = 0;
        DOWN = 1;
        UP = 2;
    }
}

