/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data.junit;

import com.jrefinery.data.TimePeriodFormatException;
import com.jrefinery.data.Year;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class YearTests
extends TestCase {
    static /* synthetic */ Class class$com$jrefinery$data$junit$YearTests;

    public static Test suite() {
        return new TestSuite(class$com$jrefinery$data$junit$YearTests == null ? (class$com$jrefinery$data$junit$YearTests = YearTests.class$("com.jrefinery.data.junit.YearTests")) : class$com$jrefinery$data$junit$YearTests);
    }

    public YearTests(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testEqualsSelf() {
        Year year = new Year();
        YearTests.assertTrue((boolean)year.equals(year));
    }

    public void testEquals() {
        Year year1 = new Year(2002);
        Year year2 = new Year(2002);
        YearTests.assertTrue((boolean)year1.equals(year2));
    }

    public void testDateConstructor1() {
        TimeZone zone = TimeZone.getTimeZone("GMT");
        Year y1 = new Year(new Date(1009843199999L), zone);
        Year y2 = new Year(new Date(1009843200000L), zone);
        YearTests.assertEquals((int)2001, (int)y1.getYear());
        YearTests.assertEquals((long)1009843199999L, (long)y1.getEnd(zone));
        YearTests.assertEquals((int)2002, (int)y2.getYear());
        YearTests.assertEquals((long)1009843200000L, (long)y2.getStart(zone));
    }

    public void testDateConstructor2() {
        TimeZone zone = TimeZone.getTimeZone("America/Los_Angeles");
        Year y1 = new Year(new Date(1009871999999L), zone);
        Year y2 = new Year(new Date(1009872000000L), zone);
        YearTests.assertEquals((int)2001, (int)y1.getYear());
        YearTests.assertEquals((long)1009871999999L, (long)y1.getEnd(zone));
        YearTests.assertEquals((int)2002, (int)y2.getYear());
        YearTests.assertEquals((long)1009872000000L, (long)y2.getStart(zone));
    }

    public void test1900_previous() {
        Year current = new Year(1900);
        Year previous = (Year)current.previous();
        YearTests.assertNull((Object)previous);
    }

    public void test1900_next() {
        Year current = new Year(1900);
        Year next = (Year)current.next();
        YearTests.assertEquals((int)1901, (int)next.getYear());
    }

    public void test9999_previous() {
        Year current = new Year(9999);
        Year previous = (Year)current.previous();
        YearTests.assertEquals((int)9998, (int)previous.getYear());
    }

    public void test9999_next() {
        Year current = new Year(9999);
        Year next = (Year)current.next();
        YearTests.assertNull((Object)next);
    }

    public void testParseYear() {
        Year year = null;
        try {
            year = Year.parseYear("2000");
        }
        catch (TimePeriodFormatException e) {
            year = new Year(1900);
        }
        YearTests.assertEquals((int)2000, (int)year.getYear());
        try {
            year = Year.parseYear(" 2001 ");
        }
        catch (TimePeriodFormatException e) {
            year = new Year(1900);
        }
        YearTests.assertEquals((int)2001, (int)year.getYear());
        try {
            year = Year.parseYear("99");
        }
        catch (TimePeriodFormatException e) {
            year = new Year(1900);
        }
        YearTests.assertEquals((int)1900, (int)year.getYear());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

