/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data.junit;

import com.jrefinery.data.BasicTimeSeries;
import com.jrefinery.data.Day;
import com.jrefinery.data.SeriesException;
import com.jrefinery.data.TimePeriod;
import com.jrefinery.data.Year;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class BasicTimeSeriesTests
extends TestCase {
    protected BasicTimeSeries seriesA;
    protected BasicTimeSeries seriesB;
    protected BasicTimeSeries seriesC;
    static /* synthetic */ Class class$com$jrefinery$data$junit$BasicTimeSeriesTests;
    static /* synthetic */ Class class$com$jrefinery$data$Year;

    public static Test suite() {
        return new TestSuite(class$com$jrefinery$data$junit$BasicTimeSeriesTests == null ? (class$com$jrefinery$data$junit$BasicTimeSeriesTests = BasicTimeSeriesTests.class$("com.jrefinery.data.junit.BasicTimeSeriesTests")) : class$com$jrefinery$data$junit$BasicTimeSeriesTests);
    }

    public BasicTimeSeriesTests(String name) {
        super(name);
    }

    protected void setUp() {
        this.seriesA = new BasicTimeSeries("Series A", class$com$jrefinery$data$Year == null ? (class$com$jrefinery$data$Year = BasicTimeSeriesTests.class$("com.jrefinery.data.Year")) : class$com$jrefinery$data$Year);
        try {
            this.seriesA.add((TimePeriod)new Year(2000), new Integer(102000));
            this.seriesA.add((TimePeriod)new Year(2001), new Integer(102001));
            this.seriesA.add((TimePeriod)new Year(2002), new Integer(102002));
            this.seriesA.add((TimePeriod)new Year(2003), new Integer(102003));
            this.seriesA.add((TimePeriod)new Year(2004), new Integer(102004));
            this.seriesA.add((TimePeriod)new Year(2005), new Integer(102005));
        }
        catch (SeriesException e) {
            System.err.println("TimeSeriesTests.setUp(): problem creating series.");
        }
        this.seriesB = new BasicTimeSeries("Series B", class$com$jrefinery$data$Year == null ? (class$com$jrefinery$data$Year = BasicTimeSeriesTests.class$("com.jrefinery.data.Year")) : class$com$jrefinery$data$Year);
        try {
            this.seriesB.add((TimePeriod)new Year(2006), new Integer(202006));
            this.seriesB.add((TimePeriod)new Year(2007), new Integer(202007));
            this.seriesB.add((TimePeriod)new Year(2008), new Integer(202008));
        }
        catch (SeriesException e) {
            System.err.println("TimeSeriesTests.setUp(): problem creating series.");
        }
        this.seriesC = new BasicTimeSeries("Series C", class$com$jrefinery$data$Year == null ? (class$com$jrefinery$data$Year = BasicTimeSeriesTests.class$("com.jrefinery.data.Year")) : class$com$jrefinery$data$Year);
        try {
            this.seriesC.add((TimePeriod)new Year(1999), new Integer(301999));
            this.seriesC.add((TimePeriod)new Year(2000), new Integer(302000));
            this.seriesC.add((TimePeriod)new Year(2002), new Integer(302002));
        }
        catch (SeriesException e) {
            System.err.println("TimeSeriesTests.setUp(): problem creating series.");
        }
    }

    public void testClone() {
        BasicTimeSeries series = new BasicTimeSeries("Test Series");
        Day Jan1_2002 = new Day(1, 1, 2002);
        try {
            series.add((TimePeriod)Jan1_2002, new Integer(42));
        }
        catch (SeriesException e) {
            System.err.println("TimeSeriesTests.testClone: problem adding to series.");
        }
        BasicTimeSeries clone = (BasicTimeSeries)series.clone();
        clone.setName("Clone Series");
        try {
            clone.update(Jan1_2002, (Number)new Integer(10));
        }
        catch (SeriesException e) {
            System.err.println("TimeSeriesTests.testClone: problem updating series.");
        }
        int seriesValue = series.getValue(Jan1_2002).intValue();
        int cloneValue = clone.getValue(Jan1_2002).intValue();
        BasicTimeSeriesTests.assertEquals((int)42, (int)seriesValue);
        BasicTimeSeriesTests.assertEquals((int)10, (int)cloneValue);
        BasicTimeSeriesTests.assertEquals((Object)"Test Series", (Object)series.getName());
        BasicTimeSeriesTests.assertEquals((Object)"Clone Series", (Object)clone.getName());
    }

    public void testAddValue() {
        try {
            this.seriesA.add((TimePeriod)new Year(1999), new Integer(1));
        }
        catch (SeriesException e) {
            System.err.println("TimeSeriesTests.testAddValue: problem adding to series.");
        }
        int value = this.seriesA.getValue(0).intValue();
        BasicTimeSeriesTests.assertEquals((int)1, (int)value);
    }

    public void testGetValue() {
        Number value1 = this.seriesA.getValue(new Year(1999));
        BasicTimeSeriesTests.assertNull((Object)value1);
        int value2 = this.seriesA.getValue(new Year(2000)).intValue();
        BasicTimeSeriesTests.assertEquals((int)102000, (int)value2);
    }

    public void testDelete() {
        BasicTimeSeries deleted = this.seriesA.delete(0, 0);
        BasicTimeSeriesTests.assertEquals((int)5, (int)this.seriesA.getItemCount());
        BasicTimeSeriesTests.assertEquals((int)1, (int)deleted.getItemCount());
        Number value = this.seriesA.getValue(new Year(2000));
        BasicTimeSeriesTests.assertNull((Object)value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

