/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.Day;
import com.jrefinery.data.TimePeriod;
import com.jrefinery.data.TimePeriodFormatException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Year
extends TimePeriod {
    protected int year;

    public Year() {
        this(new Date());
    }

    public Year(int year) {
        if (year < 1900 || year > 9999) {
            throw new IllegalArgumentException("Year constructor: year (" + year + ") outside valid range.");
        }
        this.year = year;
    }

    public Year(Date time) {
        this(time, TimePeriod.DEFAULT_TIME_ZONE);
    }

    public Year(Date time, TimeZone zone) {
        Calendar calendar = Calendar.getInstance(zone);
        calendar.setTime(time);
        this.year = calendar.get(1);
    }

    public int getYear() {
        return this.year;
    }

    public TimePeriod previous() {
        if (this.year > 1900) {
            return new Year(this.year - 1);
        }
        return null;
    }

    public TimePeriod next() {
        if (this.year < 9999) {
            return new Year(this.year + 1);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object != null) {
            if (object instanceof Year) {
                Year target = (Year)object;
                return this.year == target.getYear();
            }
            return false;
        }
        return false;
    }

    public int compareTo(Object o1) {
        int result;
        if (o1 instanceof Year) {
            Year y = (Year)o1;
            result = this.year - y.getYear();
        } else {
            result = o1 instanceof TimePeriod ? 0 : 1;
        }
        return result;
    }

    public String toString() {
        return Integer.toString(this.year);
    }

    public static Year parseYear(String s) throws TimePeriodFormatException {
        int y;
        try {
            y = Integer.parseInt(s.trim());
        }
        catch (NumberFormatException e) {
            throw new TimePeriodFormatException("Year.parseYear(string): cannot parse string.");
        }
        Year result = null;
        try {
            result = new Year(y);
        }
        catch (IllegalArgumentException e) {
            throw new TimePeriodFormatException("Year.parseYear(string): year outside valid range.");
        }
        return result;
    }

    public long getStart(Calendar calendar) {
        Day jan1 = new Day(1, 1, this.year);
        return jan1.getStart(calendar);
    }

    public long getEnd(Calendar calendar) {
        Day dec31 = new Day(31, 12, this.year);
        return dec31.getEnd(calendar);
    }
}

