/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.XYDataPair;
import com.jrefinery.data.XYDataset;
import com.jrefinery.data.XYSeries;
import java.util.ArrayList;
import java.util.List;

public class XYSeriesCollection
extends AbstractSeriesDataset
implements XYDataset {
    protected List data = new ArrayList();

    public XYSeriesCollection() {
    }

    public XYSeriesCollection(XYSeries series) {
        if (series != null) {
            this.data.add(series);
            series.addChangeListener(this);
        }
    }

    public void addSeries(XYSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("XYSeriesCollection.addSeries(...): cannot add null series.");
        }
        this.data.add(series);
        series.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public XYSeries getSeries(int series) {
        if (series < 0 || series > this.getSeriesCount()) {
            throw new IllegalArgumentException("XYSeriesCollection.getSeries(...): index outside valid range.");
        }
        XYSeries ts = (XYSeries)this.data.get(series);
        return ts;
    }

    public String getSeriesName(int series) {
        return this.getSeries(series).getName();
    }

    public int getItemCount(int series) {
        return this.getSeries(series).getItemCount();
    }

    public Number getXValue(int series, int item) {
        XYSeries ts = (XYSeries)this.data.get(series);
        XYDataPair dp = ts.getDataPair(item);
        return dp.getX();
    }

    public Number getYValue(int series, int item) {
        XYSeries ts = (XYSeries)this.data.get(series);
        XYDataPair dp = ts.getDataPair(item);
        return dp.getY();
    }

    public void removeAllSeries() {
        int i = 0;
        while (i < this.data.size()) {
            XYSeries series = (XYSeries)this.data.get(i);
            series.removeChangeListener(this);
            ++i;
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    public void removeSeries(XYSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("XYSeriesCollection.removeSeries(...): cannot remove null series.");
        }
        if (this.data.contains(series)) {
            series.removeChangeListener(this);
            this.data.remove(series);
            this.fireDatasetChanged();
        }
    }

    public void removeSeries(int series) {
        if (series < 0 || series > this.getSeriesCount()) {
            throw new IllegalArgumentException("XYSeriesCollection.getSeries(...): index outside valid range.");
        }
        XYSeries ts = (XYSeries)this.data.get(series);
        ts.removeChangeListener(this);
        this.data.remove(series);
        this.fireDatasetChanged();
    }
}

