/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.Series;
import com.jrefinery.data.SeriesException;
import com.jrefinery.data.XYDataPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class XYSeries
extends Series {
    protected List data = new ArrayList();

    public XYSeries(String name) {
        super(name);
    }

    public int getItemCount() {
        return this.data.size();
    }

    public void add(XYDataPair pair) throws SeriesException {
        if (pair == null) {
            throw new IllegalArgumentException("XYSeries.add(...): null item not allowed.");
        }
        int index = Collections.binarySearch(this.data, pair);
        if (index >= 0) {
            throw new SeriesException("XYSeries.add(...): x-value already exists.");
        }
        this.data.add(-index - 1, pair);
        this.fireSeriesChanged();
    }

    public void add(double x, double y) throws SeriesException {
        this.add(new Double(x), new Double(y));
    }

    public void add(Number x, Number y) throws SeriesException {
        XYDataPair pair = new XYDataPair(x, y);
        this.add(pair);
    }

    public void clear() {
        if (this.data.size() > 0) {
            this.data.clear();
            this.fireSeriesChanged();
        }
    }

    public XYDataPair getDataPair(int index) {
        return (XYDataPair)this.data.get(index);
    }

    public Number getXValue(int index) {
        return this.getDataPair(index).getX();
    }

    public Number getYValue(int index) {
        return this.getDataPair(index).getY();
    }

    public void update(int item, Number y) {
        XYDataPair pair = this.getDataPair(item);
        pair.setY(y);
        this.fireSeriesChanged();
    }
}

