/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.Day;
import com.jrefinery.data.TimePeriod;
import com.jrefinery.data.TimePeriodFormatException;
import com.jrefinery.data.Year;
import com.jrefinery.date.SerialDate;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Week
extends TimePeriod {
    public static int FIRST_WEEK_IN_YEAR = 1;
    public static int LAST_WEEK_IN_YEAR = 52;
    protected Year year;
    protected int week;

    public Week() {
        this(new Date());
    }

    public Week(int week, int year) {
        this(week, new Year(year));
    }

    public Week(int week, Year year) {
        if (week < 1 && week > 52) {
            throw new IllegalArgumentException("Week(...): week outside valid range.");
        }
        this.week = week;
        this.year = year;
    }

    public Week(Date time) {
        this(time, TimePeriod.DEFAULT_TIME_ZONE);
    }

    public Week(Date time, TimeZone zone) {
        Calendar calendar = Calendar.getInstance(zone);
        calendar.setTime(time);
        this.week = Math.min(calendar.get(3), 52);
        this.year = new Year(calendar.get(1));
    }

    public Year getYear() {
        return this.year;
    }

    public int getYearValue() {
        return this.year.getYear();
    }

    public int getWeek() {
        return this.week;
    }

    public TimePeriod previous() {
        Year prevYear;
        Week result = this.week != FIRST_WEEK_IN_YEAR ? new Week(this.week - 1, this.year) : ((prevYear = (Year)this.year.previous()) != null ? new Week(LAST_WEEK_IN_YEAR, prevYear) : null);
        return result;
    }

    public TimePeriod next() {
        Year nextYear;
        Week result = this.week != LAST_WEEK_IN_YEAR ? new Week(this.week + 1, this.year) : ((nextYear = (Year)this.year.next()) != null ? new Week(FIRST_WEEK_IN_YEAR, nextYear) : null);
        return result;
    }

    public String toString() {
        return "Week " + this.week + ", " + this.year;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof Week) {
                Week target = (Week)obj;
                return this.week == target.getWeek() && this.year.equals(target.getYear());
            }
            return false;
        }
        return false;
    }

    public int compareTo(Object o1) {
        int result;
        if (o1 instanceof Week) {
            Week w = (Week)o1;
            result = this.year.getYear() - w.getYear().getYear();
            if (result == 0) {
                result = this.week - w.getWeek();
            }
        } else {
            result = o1 instanceof TimePeriod ? 0 : 1;
        }
        return result;
    }

    public long getStart(Calendar calendar) {
        SerialDate jan1 = SerialDate.createInstance(1, 1, this.year.getYear());
        SerialDate startOfWeek = SerialDate.addDays((this.week - 1) * 7, jan1);
        Day first = new Day(startOfWeek);
        return first.getStart(calendar);
    }

    public long getEnd(Calendar calendar) {
        if (this.week == LAST_WEEK_IN_YEAR) {
            return this.year.getEnd(calendar);
        }
        SerialDate jan1 = SerialDate.createInstance(1, 1, this.year.getYear());
        SerialDate endOfWeek = SerialDate.addDays(this.week * 7 - 1, jan1);
        Day last = new Day(endOfWeek);
        return last.getEnd(calendar);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Week parseWeek(String s) throws TimePeriodFormatException {
        Week result = null;
        if (s == null) return result;
        int i = Week.findSeparator(s = s.trim());
        if (i == -1) throw new TimePeriodFormatException("Week.parseWeek(String): could not find separator.");
        String s1 = s.substring(0, i).trim();
        String s2 = s.substring(i + 1, s.length()).trim();
        Year year = Week.evaluateAsYear(s1);
        if (year != null) {
            int week = Week.stringToWeek(s2);
            if (week != -1) return new Week(week, year);
            throw new TimePeriodFormatException("Week.parseWeek(String): can't evaluate the week.");
        }
        year = Week.evaluateAsYear(s2);
        if (year == null) throw new TimePeriodFormatException("Week.parseWeek(String): can't evaluate the year.");
        int week = Week.stringToWeek(s1);
        if (week != -1) return new Week(week, year);
        throw new TimePeriodFormatException("Week.parseWeek(String): can't evaluate the week.");
    }

    private static int findSeparator(String s) {
        int result = -1;
        result = s.indexOf(45);
        if (result == -1) {
            result = s.indexOf(44);
        }
        if (result == -1) {
            result = s.indexOf(32);
        }
        if (result == -1) {
            result = s.indexOf(46);
        }
        return result;
    }

    private static Year evaluateAsYear(String s) {
        Year result = null;
        try {
            result = Year.parseYear(s);
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            // empty catch block
        }
        return result;
    }

    private static int stringToWeek(String s) {
        int result = -1;
        s = s.replace('W', ' ');
        s = s.trim();
        try {
            result = Integer.parseInt(s);
            if (result < 1 || result > 52) {
                result = -1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }
}

