/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.SeriesChangeEvent;
import com.jrefinery.data.SeriesChangeListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Series
implements Cloneable {
    protected String name;
    protected String description;
    protected List listeners;
    protected PropertyChangeSupport propertyChangeSupport;

    protected Series(String name) {
        this(name, null);
    }

    protected Series(String name, String description) {
        this.name = name;
        this.description = description;
        this.listeners = new ArrayList();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("Name", old, name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        String old = this.description;
        this.description = description;
        this.propertyChangeSupport.firePropertyChange("Description", old, description);
    }

    public Object clone() {
        Object obj = null;
        try {
            obj = super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Series.clone(): unexpected exception.");
        }
        Series clone = (Series)obj;
        clone.listeners = new ArrayList();
        clone.propertyChangeSupport = new PropertyChangeSupport(clone);
        return clone;
    }

    public void addChangeListener(SeriesChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(SeriesChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void fireSeriesChanged() {
        this.notifyListeners(new SeriesChangeEvent(this));
    }

    protected void notifyListeners(SeriesChangeEvent event) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            SeriesChangeListener listener = (SeriesChangeListener)iterator.next();
            listener.seriesChanged(event);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

