/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractDataset;
import com.jrefinery.data.Range;
import com.jrefinery.data.RangeInfo;
import com.jrefinery.data.XYDataset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;

public class JdbcXYDataset
extends AbstractDataset
implements XYDataset,
RangeInfo {
    Connection connection;
    Statement statement;
    ResultSet resultSet;
    ResultSetMetaData metaData;
    String[] columnNames = new String[0];
    Vector rows = new Vector(0);
    protected double maxValue = 0.0;
    protected double minValue = 0.0;
    public boolean isTimeSeries = false;

    public JdbcXYDataset(String url, String driverName, String user, String passwd) {
        try {
            Class.forName(driverName);
            System.out.println("Opening db connection");
            this.connection = DriverManager.getConnection(url, user, passwd);
            this.statement = this.connection.createStatement();
        }
        catch (ClassNotFoundException ex) {
            System.err.println("Cannot find the database driver classes.");
            System.err.println(ex);
        }
        catch (SQLException ex) {
            System.err.println("Cannot connect to this database.");
            System.err.println(ex);
        }
    }

    public JdbcXYDataset(Connection con) {
        try {
            this.connection = con;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JdbcXYDataset(Connection con, String query) {
        this(con);
        this.executeQuery(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void executeQuery(String query) {
        block49: {
            Exception e322;
            block47: {
                Object xObject = null;
                int column = 0;
                int currentColumn = 0;
                int numberOfColumns = 0;
                int numberOfValidColumns = 0;
                int[] columnTypes = null;
                if (this.connection == null) {
                    System.err.println("There is no database to execute the query.");
                    return;
                }
                this.statement = this.connection.createStatement();
                this.resultSet = this.statement.executeQuery(query);
                this.metaData = this.resultSet.getMetaData();
                numberOfColumns = this.metaData.getColumnCount();
                columnTypes = new int[numberOfColumns];
                column = 0;
                while (column < numberOfColumns) {
                    try {
                        int type = this.metaData.getColumnType(column + 1);
                        switch (type) {
                            case -7: 
                            case 2: 
                            case 4: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 91: 
                            case 92: 
                            case 93: {
                                ++numberOfValidColumns;
                                columnTypes[column] = type;
                                break;
                            }
                            default: {
                                System.err.println("Unable to load column " + column + " (" + type + "," + this.metaData.getColumnClassName(column + 1) + ")");
                                columnTypes[column] = 0;
                                break;
                            }
                        }
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                        columnTypes[column] = 0;
                    }
                    ++column;
                }
                this.columnNames = new String[numberOfValidColumns - 1];
                System.out.println("Starting column names");
                currentColumn = 0;
                column = 1;
                while (column < numberOfColumns) {
                    if (columnTypes[column] != 0) {
                        this.columnNames[currentColumn] = this.metaData.getColumnLabel(column + 1);
                        ++currentColumn;
                    }
                    ++column;
                }
                System.out.println("Finished column names");
                if (this.rows != null) {
                    column = 0;
                    while (column < this.rows.size()) {
                        Vector row = (Vector)this.rows.get(column);
                        row.removeAllElements();
                        ++column;
                    }
                    this.rows.removeAllElements();
                }
                switch (columnTypes[0]) {
                    case 91: 
                    case 92: 
                    case 93: {
                        this.isTimeSeries = true;
                        break;
                    }
                    default: {
                        this.isTimeSeries = false;
                    }
                }
                System.out.println("Starting to get all data for rows");
                this.rows = new Vector();
                while (this.resultSet.next()) {
                    Vector<Number> newRow = new Vector<Number>();
                    column = 0;
                    while (column < numberOfColumns) {
                        xObject = this.resultSet.getObject(column + 1);
                        switch (columnTypes[column]) {
                            case -7: 
                            case 2: 
                            case 4: 
                            case 6: 
                            case 7: 
                            case 8: {
                                newRow.addElement((Number)xObject);
                                break;
                            }
                            case 91: 
                            case 92: 
                            case 93: {
                                newRow.addElement(new Long(((Date)xObject).getTime()));
                                break;
                            }
                            case 0: {
                                break;
                            }
                            default: {
                                System.err.println("UnKnown Data");
                                columnTypes[column] = 0;
                            }
                        }
                        ++column;
                    }
                    this.rows.addElement(newRow);
                }
                if (this.rows.size() == 0) {
                    Vector<Integer> newRow = new Vector<Integer>();
                    column = 0;
                    while (column < numberOfColumns) {
                        if (columnTypes[column] != 0) {
                            newRow.addElement(new Integer(0));
                        }
                        ++column;
                    }
                    this.rows.addElement(newRow);
                }
                System.out.println("Determining range max and min ");
                if (this.rows.size() < 1) {
                    this.maxValue = 0.0;
                    this.minValue = 0.0;
                } else {
                    Vector row = (Vector)this.rows.elementAt(0);
                    this.minValue = this.maxValue = ((Number)row.get(1)).doubleValue();
                    int rowNum = 0;
                    while (rowNum < this.rows.size()) {
                        row = (Vector)this.rows.elementAt(rowNum);
                        column = 1;
                        while (column < numberOfColumns) {
                            double test = ((Number)row.get(column)).doubleValue();
                            if (test < this.minValue) {
                                this.minValue = test;
                            }
                            if (test > this.maxValue) {
                                this.maxValue = test;
                            }
                            ++column;
                        }
                        ++rowNum;
                    }
                }
                this.fireDatasetChanged();
                Object var13_17 = null;
                if (this.resultSet == null) break block47;
                try {
                    this.resultSet.close();
                }
                catch (Exception e322) {
                    // empty catch block
                }
            }
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception e322) {}
            }
            break block49;
            {
                catch (SQLException ex) {
                    Exception e322;
                    System.err.println(ex);
                    ex.printStackTrace();
                    Object var13_18 = null;
                    if (this.resultSet != null) {
                        try {
                            this.resultSet.close();
                        }
                        catch (Exception e322) {
                            // empty catch block
                        }
                    }
                    if (this.statement != null) {
                        try {
                            this.statement.close();
                        }
                        catch (Exception e322) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Exception e322;
                Object var13_19 = null;
                if (this.resultSet != null) {
                    try {
                        this.resultSet.close();
                    }
                    catch (Exception e322) {
                        // empty catch block
                    }
                }
                if (this.statement != null) {
                    try {
                        this.statement.close();
                    }
                    catch (Exception e322) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public Number getXValue(int seriesIndex, int itemIndex) {
        Vector row = (Vector)this.rows.elementAt(itemIndex);
        return (Number)row.elementAt(0);
    }

    public Number getYValue(int seriesIndex, int itemIndex) {
        Vector row = (Vector)this.rows.elementAt(itemIndex);
        return (Number)row.elementAt(seriesIndex + 1);
    }

    public int getItemCount(int seriesIndex) {
        return this.rows.size();
    }

    public int getSeriesCount() {
        return this.columnNames.length;
    }

    public String getSeriesName(int seriesIndex) {
        if (seriesIndex < this.columnNames.length && this.columnNames[seriesIndex] != null) {
            return this.columnNames[seriesIndex];
        }
        return "";
    }

    public int getLegendItemCount() {
        return this.getSeriesCount();
    }

    public String[] getLegendItemLabels() {
        return this.columnNames;
    }

    public Number getMinimumRangeValue() {
        return new Double(this.minValue);
    }

    public Number getMaximumRangeValue() {
        return new Double(this.maxValue);
    }

    public void close() {
        System.out.println("Closing db connection");
        try {
            this.resultSet.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.statement.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Range getValueRange() {
        return new Range(this.minValue, this.maxValue);
    }
}

