/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.DefaultPieDataset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

public class JdbcPieDataset
extends DefaultPieDataset {
    Connection connection;
    Statement statement;
    ResultSet resultSet;
    ResultSetMetaData metaData;

    public JdbcPieDataset() {
    }

    public JdbcPieDataset(String url, String driverName, String user, String passwd) {
        try {
            Class.forName(driverName);
            System.out.println("Opening db connection");
            this.connection = DriverManager.getConnection(url, user, passwd);
            this.statement = this.connection.createStatement();
        }
        catch (ClassNotFoundException ex) {
            System.err.println("Cannot find the database driver classes.");
            System.err.println(ex);
        }
        catch (SQLException ex) {
            System.err.println("Cannot connect to this database.");
            System.err.println(ex);
        }
    }

    public JdbcPieDataset(Connection con) {
        try {
            this.connection = con;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JdbcPieDataset(Connection con, String query) {
        this(con);
        this.executeQuery(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void executeQuery(String query) {
        block34: {
            Exception e322;
            block32: {
                Object xObject = null;
                int column = 0;
                int numberOfColumns = 0;
                int numberOfValidColumns = 0;
                int[] columnTypes = null;
                if (this.connection == null) {
                    System.err.println("There is no database to execute the query.");
                    return;
                }
                this.statement = this.connection.createStatement();
                this.resultSet = this.statement.executeQuery(query);
                this.metaData = this.resultSet.getMetaData();
                numberOfColumns = this.metaData.getColumnCount();
                if (numberOfColumns != 2) {
                    System.err.println("Invalid sql generated.  PieDataSet requires 2 columns only");
                } else {
                    columnTypes = new int[numberOfColumns];
                    columnTypes[0] = 12;
                    column = 1;
                    while (column < numberOfColumns) {
                        try {
                            int type = this.metaData.getColumnType(column + 1);
                            switch (type) {
                                case -7: 
                                case 2: 
                                case 4: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 91: 
                                case 93: {
                                    ++numberOfValidColumns;
                                    columnTypes[column] = type;
                                    break;
                                }
                                default: {
                                    System.err.println("Unable to load column " + column + "(" + type + ")");
                                    columnTypes[column] = 0;
                                    break;
                                }
                            }
                        }
                        catch (SQLException e2) {
                            e2.printStackTrace();
                            columnTypes[column] = 0;
                        }
                        ++column;
                    }
                    this.keys.clear();
                    this.vals.clear();
                    while (this.resultSet.next()) {
                        String category = this.resultSet.getString(1);
                        Number value = null;
                        xObject = this.resultSet.getObject(2);
                        switch (columnTypes[1]) {
                            case -7: 
                            case 2: 
                            case 4: 
                            case 6: 
                            case 7: 
                            case 8: {
                                value = (Number)xObject;
                                break;
                            }
                            case 91: 
                            case 93: {
                                value = new Long(((Date)xObject).getTime());
                                break;
                            }
                            case 0: {
                                break;
                            }
                            default: {
                                System.err.println("UnKnown Data");
                                columnTypes[1] = 0;
                            }
                        }
                        this.keys.add(category);
                        this.vals.add(value);
                    }
                }
                this.fireDatasetChanged();
                Object var10_12 = null;
                if (this.resultSet == null) break block32;
                try {
                    this.resultSet.close();
                }
                catch (Exception e322) {
                    // empty catch block
                }
            }
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception e322) {}
            }
            break block34;
            {
                catch (SQLException ex) {
                    Exception e322;
                    System.err.println(ex);
                    Object var10_13 = null;
                    if (this.resultSet != null) {
                        try {
                            this.resultSet.close();
                        }
                        catch (Exception e322) {
                            // empty catch block
                        }
                    }
                    if (this.statement != null) {
                        try {
                            this.statement.close();
                        }
                        catch (Exception e322) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Exception e322;
                Object var10_14 = null;
                if (this.resultSet != null) {
                    try {
                        this.resultSet.close();
                    }
                    catch (Exception e322) {
                        // empty catch block
                    }
                }
                if (this.statement != null) {
                    try {
                        this.statement.close();
                    }
                    catch (Exception e322) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }
}

